<?php
/*
 * Este arquivo é responsável por atualizar a página de "Dados Gerais" do sistema.
 * Para isso, ele faz uma pesquisa dos dados gerais do adwords usando a API, retornando
 * ao final um JSON contendo esses dados.
 */

use Win7\Ads\Repository\CampaignRepository;
use Win7\App;

require_once(__DIR__ . "/../classes/Sistema.php");
require_once(__DIR__ . "/../classes/Sistema_Win7Fone.php");
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às campanhas do google
if ($sistema->usuario->permissao_google == Usuario::PERM_NENHUMA) {
    echo "-2Permissão insuficiente para ver esta página!";
    exit;
}
if ($sistema->usuario->permissao_dados_gerais == Usuario::PERM_NENHUMA) {
    echo "-2Permissão insuficiente para ver esta página!";
    exit;
}

// // Validamos aqui se o filtro de pesquisa está correto
// if (!Filtro::validar('CUSTOM_DATE', $datasArray[$i][0], $datasArray[$i][1])) {
// 	echo "-2Filtro de pesquisa inválido";
// 	exit;
// }

// // Bloqueamos o filtro de ALL_TIME
// if ('CUSTOM_DATE' == "ALL_TIME") {
// 	echo "-2Filtro de pesquisa bloqueado";
// 	exit;
// }

/* Esvazia-se as datas customizadas caso o filtro não seja personalizado */
// if ('CUSTOM_DATE' != "CUSTOM_DATE") {
// 	$datasArray[$i][0] = "";
// 	$datasArray[$i][1] = "";
// }

// PEGAS AS DATAS INFORMADAS
$datasArray = [];

$periodosEmBranco = 0;

// Verifica se as variáveis existem
if ($_POST['datainicial1'] != '' || $_POST['datafinal1'] != '') {
    // Verifica se as variáveis estão no tamanto certo
    if (strlen($_POST['datainicial1']) == '10' && strlen($_POST['datafinal1']) == '10') {
        $dtInicial    = (new DateTime(str_replace(['/'], '-', $_POST['datainicial1'])))->format('Y-m-d');
        $dtFinal      = (new DateTime(str_replace(['/'], '-', $_POST['datafinal1'])))->format('Y-m-d');
        $datasArray[] = [$dtInicial, $dtFinal];
    } else {
        echo "-2Período 1 incorreto, verifique as datas";
        exit;
    }
} else {
    $periodosEmBranco++;
}
// Verifica se as variáveis existem
if ($_POST['datainicial2'] != '' || $_POST['datafinal2'] != '') {
    // Verifica se as variáveis estão no tamanto certo
    if (strlen($_POST['datainicial2']) == '10' && strlen($_POST['datafinal2']) == '10') {
        $dtInicial    = (new DateTime(str_replace(['/'], '-', $_POST['datainicial2'])))->format('Y-m-d');
        $dtFinal      = (new DateTime(str_replace(['/'], '-', $_POST['datafinal2'])))->format('Y-m-d');
        $datasArray[] = [$dtInicial, $dtFinal];
    } else {
        echo "-2Período 2 incorreto, verifique as datas";
        exit;
    }
} else {
    $periodosEmBranco++;
}
// Verifica se as variáveis existem
if ($_POST['datainicial3'] != '' || $_POST['datafinal3'] != '') {
    if (strlen($_POST['datainicial3']) == '10' && strlen($_POST['datafinal3']) == '10') {
        $dtInicial    = (new DateTime(str_replace(['/'], '-', $_POST['datainicial3'])))->format('Y-m-d');
        $dtFinal      = (new DateTime(str_replace(['/'], '-', $_POST['datafinal3'])))->format('Y-m-d');
        $datasArray[] = [$dtInicial, $dtFinal];
    } else {
        echo "-2Período 3 incorreto, verifique as datas";
        exit;
    }
} else {
    $periodosEmBranco++;
}
// Verifica se as variáveis existem
if ($_POST['datainicial4'] != '' || $_POST['datafinal4'] != '') {
    // Verifica se as variáveis estão no tamanto certo
    if (strlen($_POST['datainicial4']) == '10' && strlen($_POST['datafinal4']) == '10') {
        $dtInicial    = (new DateTime(str_replace(['/'], '-', $_POST['datainicial4'])))->format('Y-m-d');
        $dtFinal      = (new DateTime(str_replace(['/'], '-', $_POST['datafinal4'])))->format('Y-m-d');
        $datasArray[] = [$dtInicial, $dtFinal];
    } else {
        echo "-2Período 4 incorreto, verifique as datas";
        exit;
    }
} else {
    $periodosEmBranco++;
}

// Se passou pelos 4 erros de campo em branco acima, informa que é preciso selecionar pelo menos um período
if ($periodosEmBranco == 4) {
    echo "-2Informe pelo menos um período";
    exit;
}

// Variável que vai conter as respostas dos períodos e a de baixo, a média
$resultado[] = [];

// Variaveis para armazenas as respectivas médias
$resultadoMedia["forms"]                        = 0;
$resultadoMedia["whatsapp"]                     = 0;
$resultadoMedia["ligacoes"]                     = 0;
$resultadoMedia["ads_cliques"]                  = 0;
$resultadoMedia["ads_conversions"]              = 0;
$resultadoMedia["real_total_contatos"]          = 0;
$resultadoMedia["real_total_contatos_por_dias"] = 0;
$resultadoMedia["real_impressoes_por_contato"]  = 0;
$resultadoMedia["ads_media_conversao_valor"]    = 0;
$resultadoMedia["ads_custo_total"]              = 0;
$resultadoMedia["ads_media_cpc"]                = 0;
$resultadoMedia["real_custo_por_lead"]          = 0;
$resultadoMedia["ads_ctr"]                      = 0;
$resultadoMedia["ads_taxa_conversao"]           = 0;
$resultadoMedia["real_taxa_conversao"]          = 0;
$resultadoMedia["ads_impressoes_topo"]          = 0;
$resultadoMedia["ads_impressoes_4_primeiros"]   = 0;
$resultadoMedia["real_cliques_por_contato"]     = 0;

for ($i = 0; $i < count($datasArray); $i++) {
    // echo json_encode_alt($datasArray[$i][0]);
    // echo json_encode_alt($datasArray[$i][1]);

    try {
        /* Obtém a quantidade de formulários preenchidos */
        $sistema->iniciar_bd_leads();
        $filtro     = Filtro::filtrar_data('CUSTOM_DATE', "DT_ATUAL", $datasArray[$i][0],
            $datasArray[$i][1]); // Montamos o filtro SQL de data
        $id_usuario = $sistema->usuario->id;

        if (empty($filtro)) {
            $sql = "SELECT
				(SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = $id_usuario AND TXT_LEADTIPO = :form AND NU_LIXEIRA = 0) as forms,
				(SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = $id_usuario AND TXT_LEADTIPO = :whatsapp AND NU_LIXEIRA = 0) as whatsapp";
        } else {
            $sql = "SELECT
				(SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = $id_usuario AND TXT_LEADTIPO = :form AND $filtro AND NU_LIXEIRA = 0) as forms,
				(SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = $id_usuario AND TXT_LEADTIPO = :whatsapp AND $filtro AND NU_LIXEIRA = 0) as whatsapp";
        }
        $quant_ligacoes = "0";
        $quant_forms    = "0";
        $quant_whatsapp = "0";
        $quantidade     = $sistema->bd_leads->executar($sql, [":form" => "Formulário", ":whatsapp" => "WhatsApp"],
            Banco_Dados::FETCH);

        $quant_forms    = isset($quantidade["forms"]) ? $quantidade["forms"] : 0;
        $quant_whatsapp = isset($quantidade["whatsapp"]) ? $quantidade["whatsapp"] : 0;

        try {
            $sistema_win7fone = new Sistema_Win7Fone($sistema->usuario->id, $sistema->bd);
            $quant            = $sistema_win7fone->contar_ligacoes('CUSTOM_DATE', $datasArray[$i][0],
                $datasArray[$i][1], $sistema->usuario->agrupar_ligacoes,
                $sistema->usuario->mostrar_total_real_ligacoes)[0];
            $quant_ligacoes   = $quant;
        } catch (Exception $e) {
            $quant_ligacoes = 0;
        }

        $total_leads = intval($quant_ligacoes) + intval($quant_forms) + intval($quant_whatsapp);

        if ($sistema->usuario->tem_adwords()) { // Verifica se o cliente possui adwords configurado
            $filtro = $sistema->get_filtro_ads();
            $filtro->setDateFilter('CUSTOM_DATE');
            $filtro->setStartDate($datasArray[$i][0]);
            $filtro->setEndDate($datasArray[$i][1]);

            // Retorna a quantidade de dias entre as datas
            $filtrar_data_qtd_dias = Filtro::filtrar_data_qtd_dias(CUSTOM_DATE, "DT_ATUAL", $datasArray[$i][0], $datasArray[$i][1]);

            App::initialize();
            $rows = App::getContainer()->get(CampaignRepository::class)->getCustomerMetrics($filtro);

            if (!empty($rows) & count($rows) > 0) {
                $impressoes                = 0;
                $cliques                   = 0;
                $conversoes                = 0;
                $invalidos                 = 0;
                $ctr                       = 0;
                $taxaconversao             = 0;
                $custo                     = 0;
                $cpc                       = 0;
                $impressoes_topo           = 0;
                $impressoes_4_primeiros    = 0;
                $ads_taxaconversao         = 0;
                $ads_media_conversao_valor = 0;
                $total_rows                = count($rows);

                for ($k = 0; $k <= count($rows) - 1; $k++) {
                    $dados                     = $rows[$k]['metrics'];
                    $impressoes                += (float)$dados['impressions'];
                    $cliques                   += (float)$dados['clicks'];
                    $conversoes                += (float)$dados['conversions'];
                    $invalidos                 += (float)$dados['invalidClicks'];
                    $ctr                       += (float)$dados['ctr'];
                    $ads_taxaconversao         += (float)$dados['conversionsFromInteractionsRate'];
                    $ads_media_conversao_valor += (float)$dados['costPerConversion'];
                    $custo                     += (float)$dados['costMicros'];
                    $cpc                       += (float)$dados['averageCpc'];
                    $impressoes_topo           += (float)$dados['absoluteTopImpressionPercentage'];
                    $impressoes_4_primeiros    += (float)$dados['topImpressionPercentage'];
                }

                $resultado[$i] = [
                    "datainicial" => (new DateTime($datasArray[$i][0]))->format('d/m/Y'),
                    "datafinal"   => (new DateTime($datasArray[$i][1]))->format('d/m/Y'),

                    "ads_ctr"                   => number_format(($cliques / $impressoes) * 100, 2, '.', ','),
                    "ads_invalidos"             => $invalidos,
                    "ads_impressoes"            => $impressoes,
                    "ads_cliques"               => $cliques,
                    "ads_taxa_conversao"        => number_format($ads_taxaconversao * 100 / $total_rows, 2, '.',
                        ','),
                    "ads_conversions"           => $conversoes,
                    "ads_media_conversao_valor" => ($ads_media_conversao_valor / 1000000) / $total_rows,
                    "ads_custo_total"           => $custo / 1000000,
                    "ads_media_cpc"             => number_format(($custo / 1000000) / $cliques, 2, '.', ','),
                    "ads_impressoes_topo"        => number_format($impressoes_topo * 100 / $total_rows),
                    "ads_impressoes_4_primeiros" => number_format($impressoes_4_primeiros * 100 / $total_rows),

                    "forms"    => $quant_forms,
                    "whatsapp" => $quant_whatsapp,
                    "ligacoes" => $quant_ligacoes,

                    "real_cliques_por_contato"     => $total_leads == 0 ? 0 : number_format($cliques / $total_leads,
                        1),
                    "real_impressoes_por_contato"  => $total_leads == 0 ? 0 : number_format($impressoes / $total_leads,
                        1),
                    "real_taxa_conversao"          => $total_leads == 0 ? 0 : number_format($total_leads * 100 / $cliques,
                        2),
                    "real_total_contatos"          => $total_leads,
                    "real_total_contatos_por_dias" => number_format($total_leads / $filtrar_data_qtd_dias, 1),
                    "real_custo_por_lead"          => $total_leads == 0 ? 0 : ($custo / 1000000) / $total_leads,
                ];
            } else { // se não tiver nada no adswords
                $resultado[$i] = [
                    "datainicial"                  => (new DateTime($datasArray[$i][0]))->format('d/m/Y'),
                    "datafinal"                    => (new DateTime($datasArray[$i][1]))->format('d/m/Y'),
                    "ads_ctr"                      => 0,
                    "ads_invalidos"                => 0,
                    "ads_impressoes"               => 0,
                    "ads_cliques"                  => 0,
                    "ads_taxa_conversao"           => 0,
                    "ads_conversions"              => 0,
                    "ads_media_conversao_valor"    => 0,
                    "ads_impressoes_topo"          => 0,
                    "ads_impressoes_4_primeiros"   => 0,
                    "forms"                        => 0,
                    "whatsapp"                     => 0,
                    "ligacoes"                     => 0,
                    "real_cliques_por_contato"     => 0,
                    "real_impressoes_por_contato"  => 0,
                    "real_total_contatos"          => 0,
                    "real_total_contatos_por_dias" => 0,
                    "ads_custo_total"              => 0,
                    "ads_media_cpc"                => 0,
                    "real_custo_por_lead"          => 0,
                    "real_taxa_conversao"          => 0,
                ];

            }
        } else { // O cliente não possui adwords configurado, então montamos um JSON com valores padrão
            $resultado[$i] = [
                "datainicial"                  => (new DateTime($datasArray[$i][0]))->format('d/m/Y'),
                "datafinal"                    => (new DateTime($datasArray[$i][1]))->format('d/m/Y'),
                "ads_ctr"                      => 0,
                "ads_invalidos"                => 0,
                "ads_impressoes"               => 0,
                "ads_cliques"                  => 0,
                "ads_taxa_conversao"           => 0,
                "ads_conversions"              => 0,
                "ads_media_conversao_valor"    => 0,
                "ads_impressoes_topo"          => 0,
                "ads_impressoes_4_primeiros"   => 0,
                "forms"                        => 0,
                "whatsapp"                     => 0,
                "ligacoes"                     => 0,
                "real_cliques_por_contato"     => 0,
                "real_impressoes_por_contato"  => 0,
                "real_total_contatos"          => 0,
                "real_total_contatos_por_dias" => 0,
                "ads_custo_total"              => 0,
                "ads_media_cpc"                => 0,
                "real_custo_por_lead"          => 0,
                "real_taxa_conversao"          => 0,
            ];
        }

        // echo json_encode_alt($resultado[$i]);
    } catch (Exception $e) {
        $sistema->adwords->tratar_excecao($e);
    }
}

// Formatações
function formatarDoisDecimais($val)
{
    return number_format($val, 2);
}

function formatarValorReais($val)
{
    return 'R$ ' . number_format($val, 2, ',', '.');
}

function formatarValorPorcentagem($val)
{
    return $val == 0 ? "0%" : retirarDoisZerosDoFinal($val) . "%";
}

function formatarMilhar($val)
{
    return number_format($val, 0, ",", ".");
}

function arredondarValor($val)
{
    return round($val);
}

function retirarDoisZerosDoFinal($val)
{
    return substr($val, -3) == ".00" ? substr($val, 0, -3) : $val;
}

function retirarDecimaisDoComeco($val)
{
    return substr($val, 0, -2) == "0." ? substr($val, -2) : $val;
}

function tratarDadosImpressoesTopo($val)
{
    return $val == "0"
        ? "0%"
        : ($val < 0
            ? "-" . formatarValorPorcentagem(ltrim(intval(retirarDecimaisDoComeco(retirarDoisZerosDoFinal(formatarDoisDecimais($val,
                2))))))
            : formatarValorPorcentagem(ltrim(intval(retirarDecimaisDoComeco(retirarDoisZerosDoFinal(formatarDoisDecimais($val,
                2)))))));
}

// FAZ O CÁLCULO DOS VALORES RELATIVOS AO PERÍODO SELECIONADO
// Se nenhum destaque for setado, seta para 0, que é o primeiro período
$destaque = isset($_POST['destaque']) ? $_POST['destaque'] : 0;

// Função para calcular os valores
function calcularResultado(
    $kpi,
    $valorLoop,
    $valorDestaque,
    $reverterSimbolo = 0,
    $formatarPorcentagem = 0,
    $formatarReais = 0,
    $arredondar = 0,
    $formatarMilhar = 0
) {

    // Verifica se é para formatar com o icone de %
    $formatarPorcentagem
        ? $calcSub = formatarValorPorcentagem($valorLoop - $valorDestaque)
        : $calcSub = $valorLoop - $valorDestaque;

    // Verifica se alguns do valores é zero e evita o cálculo e já seta o valor de 0%
    if ($valorLoop == "0" || $valorDestaque == "0") {
        $calculoPorcentagem = "ထ%";
    } else {
        $calculoPorcentagem = retirarDoisZerosDoFinal(number_format((($valorLoop / $valorDestaque) - 1) * 100,
                2)) . "%";
    }

    // Configura o simbolo
    $simbolo = $calcSub <= 0 ? ($valorLoop == $valorDestaque ? "●" : "⬇") : "⬆";

    // Verifica se é para inverter os sinais de positivo e negativo
    $reverterSimbolo
        ? $cor = $calcSub <= 0 ? ($valorLoop == $valorDestaque ? 'cinza' : 'verde') : 'vermelho'
        : $cor = $calcSub <= 0 ? ($valorLoop == $valorDestaque ? 'cinza' : 'vermelho') : 'verde';

    // TRATA ALGUMAS KPIs de forma individual
    if ($kpi == "real_taxa_conversao" || $kpi == "ads_ctr") {
        $valorLoop = formatarValorPorcentagem($valorLoop);
        $calcSub   = formatarValorPorcentagem($calcSub);
    }
    if ($kpi == "ads_impressoes_topo" || $kpi == "ads_impressoes_4_primeiros") {
        $valorLoop = tratarDadosImpressoesTopo($valorLoop);
        $calcSub   = tratarDadosImpressoesTopo($calcSub);
    }
    if ($kpi == "ads_taxa_conversao") {
        $calcSub   = formatarValorPorcentagem(formatarDoisDecimais($calcSub, 2));
        $valorLoop = formatarValorPorcentagem($valorLoop);
    }
    if ($kpi == "real_cliques_por_contato") {
        // $valorLoop = arredondarValor($valorLoop);
        // $calcSub = arredondarValor($calcSub);
    }

    // Retorna o array calculado
    return [
        $formatarPorcentagem ? formatarValorPorcentagem($valorLoop)
            : ($formatarReais ? formatarValorReais($valorLoop)
            : ($arredondar ? arredondarValor($valorLoop)
                : ($formatarMilhar ? formatarMilhar($valorLoop) : $valorLoop))),

        $formatarPorcentagem ? formatarValorPorcentagem($calcSub)
            : ($formatarReais ? formatarValorReais($calcSub)
            : ($formatarMilhar ? formatarMilhar($calcSub)
                : (strlen($calcSub) > 12 ? formatarDoisDecimais($calcSub, 2) : $calcSub))),

        $calculoPorcentagem,
        $simbolo,
        $cor,
    ];
}

// Quantidade de loops é baseado na quantidade de resultados pesquisados
$qtdResultados = count($resultado);

try {

    for ($i = 0; $i < $qtdResultados; $i++) {

        if ($i != $destaque) {

            if ($i <= $destaque) {

                // VARIAVEIS PARA GUARDAR AS MEDIAS
                $resultadoMedia["forms"]                        += floatval($resultado[$i]["forms"]);
                $resultadoMedia["whatsapp"]                     += floatval($resultado[$i]["whatsapp"]);
                $resultadoMedia["ligacoes"]                     += floatval($resultado[$i]["ligacoes"]);
                $resultadoMedia["ads_cliques"]                  += floatval($resultado[$i]["ads_cliques"]);
                $resultadoMedia["ads_conversions"]              += floatval($resultado[$i]["ads_conversions"]);
                $resultadoMedia["real_total_contatos"]          += floatval($resultado[$i]["real_total_contatos"]);
                $resultadoMedia["real_total_contatos_por_dias"] += floatval($resultado[$i]["real_total_contatos_por_dias"]);
                $resultadoMedia["real_impressoes_por_contato"]  += floatval($resultado[$i]["real_impressoes_por_contato"]);
                $resultadoMedia["ads_media_conversao_valor"]    += floatval($resultado[$i]["ads_media_conversao_valor"]);
                $resultadoMedia["ads_custo_total"]              += floatval($resultado[$i]["ads_custo_total"]);
                $resultadoMedia["ads_media_cpc"]                += floatval($resultado[$i]["ads_media_cpc"]);
                $resultadoMedia["real_custo_por_lead"]          += floatval($resultado[$i]["real_custo_por_lead"]);
                $resultadoMedia["ads_ctr"]                      += floatval($resultado[$i]["ads_ctr"]);
                $resultadoMedia["ads_taxa_conversao"]           += floatval($resultado[$i]["ads_taxa_conversao"]);
                $resultadoMedia["real_taxa_conversao"]          += floatval($resultado[$i]["real_taxa_conversao"]);
                $resultadoMedia["ads_impressoes_topo"]          += floatval($resultado[$i]["ads_impressoes_topo"]);
                $resultadoMedia["ads_impressoes_4_primeiros"]   += floatval($resultado[$i]["ads_impressoes_4_primeiros"]);
                $resultadoMedia["real_cliques_por_contato"]     += floatval($resultado[$i]["real_cliques_por_contato"]);

                // VARIAVEIS PARA GUARDAR OS VALORES DE CADA PERIODO
                $resultado[$i]["forms"]                       = calcularResultado("", $resultado[$i]["forms"],
                    $resultado[$destaque]["forms"], 0, 0, 0, 0, 1);
                $resultado[$i]["whatsapp"]                    = calcularResultado("", $resultado[$i]["whatsapp"],
                    $resultado[$destaque]["whatsapp"], 0, 0, 0, 0, 1);
                $resultado[$i]["ligacoes"]                    = calcularResultado("", $resultado[$i]["ligacoes"],
                    $resultado[$destaque]["ligacoes"], 0, 0, 0, 0, 1);
                $resultado[$i]["real_total_contatos"]         = calcularResultado("",
                    $resultado[$i]["real_total_contatos"], $resultado[$destaque]["real_total_contatos"], 0, 0, 0, 0, 1);
                $resultado[$i]["real_total_contatos_por_dias"] = calcularResultado("",
                    $resultado[$i]["real_total_contatos_por_dias"], $resultado[$destaque]["real_total_contatos_por_dias"], 0, 0, 0, 0, 1);
                $resultado[$i]["ads_cliques"]                 = calcularResultado("", $resultado[$i]["ads_cliques"],
                    $resultado[$destaque]["ads_cliques"], 0, 0, 0, 0, 1);
                $resultado[$i]["ads_conversions"]             = calcularResultado("", $resultado[$i]["ads_conversions"],
                    $resultado[$destaque]["ads_conversions"], 0, 0, 0, 1, 1);
                $resultado[$i]["real_impressoes_por_contato"] = calcularResultado("",
                    $resultado[$i]["real_impressoes_por_contato"], $resultado[$destaque]["real_impressoes_por_contato"],
                    1, 0, 0, 1, 0);
                $resultado[$i]["ads_media_conversao_valor"]   = calcularResultado("",
                    $resultado[$i]["ads_media_conversao_valor"], $resultado[$destaque]["ads_media_conversao_valor"], 1,
                    0, 1, 0, 0);
                $resultado[$i]["ads_custo_total"]             = calcularResultado("", $resultado[$i]["ads_custo_total"],
                    $resultado[$destaque]["ads_custo_total"], 0, 0, 1, 0, 0);
                $resultado[$i]["ads_media_cpc"]               = calcularResultado("", $resultado[$i]["ads_media_cpc"],
                    $resultado[$destaque]["ads_media_cpc"], 1, 0, 1, 0, 0);
                $resultado[$i]["real_custo_por_lead"]         = calcularResultado("",
                    $resultado[$i]["real_custo_por_lead"], $resultado[$destaque]["real_custo_por_lead"], 1, 0, 1, 0, 0);
                $resultado[$i]["real_taxa_conversao"]         = calcularResultado("real_taxa_conversao",
                    $resultado[$i]["real_taxa_conversao"], $resultado[$destaque]["real_taxa_conversao"], 0, 0, 0, 0, 0);
                $resultado[$i]["ads_ctr"]                     = calcularResultado("ads_ctr", $resultado[$i]["ads_ctr"],
                    $resultado[$destaque]["ads_ctr"], 0, 0, 0, 0, 0);
                $resultado[$i]["ads_taxa_conversao"]          = calcularResultado("ads_taxa_conversao",
                    $resultado[$i]["ads_taxa_conversao"], $resultado[$destaque]["ads_taxa_conversao"], 0, 0, 0, 0, 0);
                $resultado[$i]["checked"]                     = '';

                $resultado[$i]["ads_impressoes_topo"]        = calcularResultado("ads_impressoes_topo",
                    $resultado[$i]["ads_impressoes_topo"], $resultado[$destaque]["ads_impressoes_topo"], 0, 0, 0, 0, 0);
                $resultado[$i]["ads_impressoes_4_primeiros"] = calcularResultado("ads_impressoes_4_primeiros",
                    $resultado[$i]["ads_impressoes_4_primeiros"], $resultado[$destaque]["ads_impressoes_4_primeiros"],
                    0, 0, 0, 0, 0);
                $resultado[$i]["real_cliques_por_contato"]   = calcularResultado("real_cliques_por_contato",
                    $resultado[$i]["real_cliques_por_contato"], $resultado[$destaque]["real_cliques_por_contato"], 1, 0,
                    0, 0, 0);
                // Não usados
                // $resultado[$i]["ads_invalidos"] = [$resultado[$i]["ads_invalidos"], "-", "-", "●", "cinza"];
                // $resultado[$i]["ads_impressoes

            } else {

                // VARIAVEIS PARA GUARDAR AS MEDIAS
                $resultadoMedia["forms"]                        += floatval($resultado[$i]["forms"]);
                $resultadoMedia["whatsapp"]                     += floatval($resultado[$i]["whatsapp"]);
                $resultadoMedia["ligacoes"]                     += floatval($resultado[$i]["ligacoes"]);
                $resultadoMedia["ads_cliques"]                  += floatval($resultado[$i]["ads_cliques"]);
                $resultadoMedia["ads_conversions"]              += floatval($resultado[$i]["ads_conversions"]);
                $resultadoMedia["real_total_contatos"]          += floatval($resultado[$i]["real_total_contatos"]);
                $resultadoMedia["real_total_contatos_por_dias"] += floatval($resultado[$i]["real_total_contatos_por_dias"]);
                $resultadoMedia["real_impressoes_por_contato"]  += floatval($resultado[$i]["real_impressoes_por_contato"]);
                $resultadoMedia["ads_media_conversao_valor"]    += floatval($resultado[$i]["ads_media_conversao_valor"]);
                $resultadoMedia["ads_custo_total"]              += floatval($resultado[$i]["ads_custo_total"]);
                $resultadoMedia["ads_media_cpc"]                += floatval($resultado[$i]["ads_media_cpc"]);
                $resultadoMedia["real_custo_por_lead"]          += floatval($resultado[$i]["real_custo_por_lead"]);
                $resultadoMedia["ads_ctr"]                      += floatval($resultado[$i]["ads_ctr"]);
                $resultadoMedia["ads_taxa_conversao"]           += floatval($resultado[$i]["ads_taxa_conversao"]);
                $resultadoMedia["real_taxa_conversao"]          += floatval($resultado[$i]["real_taxa_conversao"]);
                $resultadoMedia["ads_impressoes_topo"]          += floatval($resultado[$i]["ads_impressoes_topo"]);
                $resultadoMedia["ads_impressoes_4_primeiros"]   += floatval($resultado[$i]["ads_impressoes_4_primeiros"]);
                $resultadoMedia["real_cliques_por_contato"]     += floatval($resultado[$i]["real_cliques_por_contato"]);

                // VARIAVEIS PARA GUARDAR OS VALORES DE CADA PERIODO
                $resultado[$i]["forms"]                       = calcularResultado("", $resultado[$i]["forms"],
                    $resultado[$destaque]["forms"][0], 0, 0, 0, 0, 1);
                $resultado[$i]["whatsapp"]                    = calcularResultado("", $resultado[$i]["whatsapp"],
                    $resultado[$destaque]["whatsapp"][0], 0, 0, 0, 0, 1);
                $resultado[$i]["ligacoes"]                    = calcularResultado("", $resultado[$i]["ligacoes"],
                    $resultado[$destaque]["ligacoes"][0], 0, 0, 0, 0, 1);
                $resultado[$i]["real_total_contatos"]         = calcularResultado("",
                    $resultado[$i]["real_total_contatos"], $resultado[$destaque]["real_total_contatos"][0], 0, 0, 0, 0,
                    1);
                $resultado[$i]["real_total_contatos_por_dias"] = calcularResultado("",
                    $resultado[$i]["real_total_contatos_por_dias"], $resultado[$destaque]["real_total_contatos_por_dias"][0], 0, 0, 0, 0,
                    1);
                $resultado[$i]["ads_cliques"]                 = calcularResultado("", $resultado[$i]["ads_cliques"],
                    $resultado[$destaque]["ads_cliques"][0], 0, 0, 0, 0, 1);
                $resultado[$i]["ads_conversions"]             = calcularResultado("", $resultado[$i]["ads_conversions"],
                    $resultado[$destaque]["ads_conversions"][0], 0, 0, 0, 1, 1);
                $resultado[$i]["real_impressoes_por_contato"] = calcularResultado("",
                    $resultado[$i]["real_impressoes_por_contato"],
                    $resultado[$destaque]["real_impressoes_por_contato"][0], 1, 0, 0, 1, 0);
                $resultado[$i]["ads_media_conversao_valor"]   = calcularResultado("",
                    $resultado[$i]["ads_media_conversao_valor"], $resultado[$destaque]["ads_media_conversao_valor"][0],
                    1, 0, 1, 0, 0);
                $resultado[$i]["ads_custo_total"]             = calcularResultado("", $resultado[$i]["ads_custo_total"],
                    $resultado[$destaque]["ads_custo_total"][0], 0, 0, 1, 0, 0);
                $resultado[$i]["ads_media_cpc"]               = calcularResultado("", $resultado[$i]["ads_media_cpc"],
                    $resultado[$destaque]["ads_media_cpc"][0], 1, 0, 1, 0, 0);
                $resultado[$i]["real_custo_por_lead"]         = calcularResultado("",
                    $resultado[$i]["real_custo_por_lead"], $resultado[$destaque]["real_custo_por_lead"][0], 1, 0, 1, 0,
                    0);
                $resultado[$i]["real_taxa_conversao"]         = calcularResultado("real_taxa_conversao",
                    $resultado[$i]["real_taxa_conversao"], $resultado[$destaque]["real_taxa_conversao"][0], 0, 0, 0, 0,
                    0);
                $resultado[$i]["ads_ctr"]                     = calcularResultado("ads_ctr", $resultado[$i]["ads_ctr"],
                    $resultado[$destaque]["ads_ctr"][0], 0, 0, 0, 0, 0);
                $resultado[$i]["ads_taxa_conversao"]          = calcularResultado("ads_taxa_conversao",
                    $resultado[$i]["ads_taxa_conversao"], $resultado[$destaque]["ads_taxa_conversao"][0], 0, 0, 0, 0,
                    0);
                $resultado[$i]["ads_impressoes_topo"]         = calcularResultado("ads_impressoes_topo",
                    $resultado[$i]["ads_impressoes_topo"], $resultado[$destaque]["ads_impressoes_topo"][0], 0, 0, 0, 0,
                    0);
                $resultado[$i]["ads_impressoes_4_primeiros"]  = calcularResultado("ads_impressoes_4_primeiros",
                    $resultado[$i]["ads_impressoes_4_primeiros"],
                    $resultado[$destaque]["ads_impressoes_4_primeiros"][0], 0, 0, 0, 0, 0);
                $resultado[$i]["real_cliques_por_contato"]    = calcularResultado("real_cliques_por_contato",
                    $resultado[$i]["real_cliques_por_contato"], $resultado[$destaque]["real_cliques_por_contato"][0], 1,
                    0, 0, 0, 0);
                $resultado[$i]["checked"]                     = '';

                // Não usados
                // $resultado[$i]["ads_invalidos"] = [$resultado[$i]["ads_invalidos"], "-", "-", "●", "cinza"];
                // $resultado[$i]["ads_impressoes"] = [$resultado[$i]["ads_impressoes"], "-", "-", "●", "cinza"];

            }

        } else {

            // PULAMOS O CALCULO DA MEDIA AQUI $resultadoMedia

            // RETORNO PADRÃO PARA O DESTAQUE ATUAL
            $resultado[$i]["forms"]                       = [$resultado[$i]["forms"], "-", "-", "●", "cinza"];
            $resultado[$i]["whatsapp"]                    = [$resultado[$i]["whatsapp"], "-", "-", "●", "cinza"];
            $resultado[$i]["ligacoes"]                    = [$resultado[$i]["ligacoes"], "-", "-", "●", "cinza"];
            $resultado[$i]["real_total_contatos"]         = [
                $resultado[$i]["real_total_contatos"],
                "-",
                "-",
                "●",
                "cinza",
            ];
            $resultado[$i]["real_total_contatos_por_dias"]         = [
                $resultado[$i]["real_total_contatos_por_dias"],
                "-",
                "-",
                "●",
                "cinza",
            ];
            $resultado[$i]["ads_cliques"]                 = [$resultado[$i]["ads_cliques"], "-", "-", "●", "cinza"];
            $resultado[$i]["ads_conversions"]             = [$resultado[$i]["ads_conversions"], "-", "-", "●", "cinza"];
            $resultado[$i]["ads_ctr"]                     = [$resultado[$i]["ads_ctr"], "-", "-", "●", "cinza"];
            $resultado[$i]["ads_taxa_conversao"]          = [
                $resultado[$i]["ads_taxa_conversao"],
                "-",
                "-",
                "●",
                "cinza",
            ];
            $resultado[$i]["ads_media_conversao_valor"]   = [
                $resultado[$i]["ads_media_conversao_valor"],
                "-",
                "-",
                "●",
                "cinza",
            ];
            $resultado[$i]["ads_custo_total"]             = [$resultado[$i]["ads_custo_total"], "-", "-", "●", "cinza"];
            $resultado[$i]["ads_media_cpc"]               = [$resultado[$i]["ads_media_cpc"], "-", "-", "●", "cinza"];
            $resultado[$i]["real_impressoes_por_contato"] = [
                $resultado[$i]["real_impressoes_por_contato"],
                "-",
                "-",
                "●",
                "cinza",
            ];
            $resultado[$i]["real_taxa_conversao"]         = [
                $resultado[$i]["real_taxa_conversao"],
                "-",
                "-",
                "●",
                "cinza",
            ];
            $resultado[$i]["real_custo_por_lead"]         = [
                $resultado[$i]["real_custo_por_lead"],
                "-",
                "-",
                "●",
                "cinza",
            ];
            $resultado[$i]["ads_impressoes_topo"]         = [
                $resultado[$i]["ads_impressoes_topo"],
                "-",
                "-",
                "●",
                "cinza",
            ];
            $resultado[$i]["ads_impressoes_4_primeiros"]  = [
                $resultado[$i]["ads_impressoes_4_primeiros"],
                "-",
                "-",
                "●",
                "cinza",
            ];
            $resultado[$i]["real_cliques_por_contato"]    = [
                $resultado[$i]["real_cliques_por_contato"],
                "-",
                "-",
                "●",
                "cinza",
            ];
            $resultado[$i]["checked"]                     = 'checked';

            // Não usados
            // $resultado[$i]["ads_invalidos"] = [$resultado[$i]["ads_invalidos"], "-", "-", "●", "cinza"];
            // $resultado[$i]["ads_impressoes"] = [$resultado[$i]["ads_impressoes"], "-", "-", "●", "cinza"];

        }

    } // end for
} catch (\Throwable $th) {
    echo "-2" . $th;
    // echo "-2Erro ao buscar os dados #1";
    exit;
}

try {

    // SETA O VALOR PAR A DIVISÃO
    $qtdResultados -= 1;

    // RETORNA OS VALORES COM SUAS RESPECTIVAS MÉDIAS PARA A FUNÇÃO ABAIXO
    $resultadoMedia["forms"]                        = floatval($resultadoMedia["forms"] / $qtdResultados);
    $resultadoMedia["whatsapp"]                     = floatval($resultadoMedia["whatsapp"] / $qtdResultados);
    $resultadoMedia["ligacoes"]                     = floatval($resultadoMedia["ligacoes"] / $qtdResultados);
    $resultadoMedia["ads_cliques"]                  = floatval($resultadoMedia["ads_cliques"] / $qtdResultados);
    $resultadoMedia["ads_conversions"]              = floatval($resultadoMedia["ads_conversions"] / $qtdResultados);
    $resultadoMedia["real_total_contatos"]          = floatval($resultadoMedia["real_total_contatos"] / $qtdResultados);
    $resultadoMedia["real_total_contatos_por_dias"] = floatval(formatarDoisDecimais($resultadoMedia["real_total_contatos_por_dias"] / $qtdResultados));
    $resultadoMedia["real_impressoes_por_contato"]  = floatval(formatarDoisDecimais($resultadoMedia["real_impressoes_por_contato"] / $qtdResultados));
    $resultadoMedia["ads_media_conversao_valor"]    = floatval($resultadoMedia["ads_media_conversao_valor"] / $qtdResultados);
    $resultadoMedia["ads_custo_total"]              = floatval($resultadoMedia["ads_custo_total"] / $qtdResultados);
    $resultadoMedia["ads_media_cpc"]                = floatval(formatarDoisDecimais($resultadoMedia["ads_media_cpc"] / $qtdResultados));
    $resultadoMedia["real_custo_por_lead"]          = floatval(formatarDoisDecimais($resultadoMedia["real_custo_por_lead"] / $qtdResultados));
    $resultadoMedia["ads_ctr"]                      = floatval(formatarDoisDecimais($resultadoMedia["ads_ctr"] / $qtdResultados));
    $resultadoMedia["ads_taxa_conversao"]           = floatval(formatarDoisDecimais($resultadoMedia["ads_taxa_conversao"] / $qtdResultados));
    $resultadoMedia["real_taxa_conversao"]          = floatval(formatarDoisDecimais($resultadoMedia["real_taxa_conversao"] / $qtdResultados));
    $resultadoMedia["ads_impressoes_topo"]          = floatval(formatarDoisDecimais($resultadoMedia["ads_impressoes_topo"] / $qtdResultados));
    $resultadoMedia["ads_impressoes_4_primeiros"]   = floatval(formatarDoisDecimais($resultadoMedia["ads_impressoes_4_primeiros"] / $qtdResultados));
    $resultadoMedia["real_cliques_por_contato"]     = floatval(formatarDoisDecimais($resultadoMedia["real_cliques_por_contato"] / $qtdResultados));

    // FUNCAÇÃO PARA CALCULAR A MÉDIA COM OUTROS PERIODOS
    function calculaMediaDoPeriodoSelecionado(
        $kpi,
        $valorPeriodoFormatado,
        $valorPeriodoSelecionadoLimpo,
        $mediaOutrasKPIs,
        $reverterSimbolo = 0,
        $formatarPorcentagem = 0,
        $formatarReais = 0,
        $arredondar = 0,
        $formatarMilhar = 0
    ) {

        // Faz a subtracao para ver qual sinal será utilizado
        $calcSub = $valorPeriodoSelecionadoLimpo - $mediaOutrasKPIs;

        // Configura o simbolo
        $simbolo = $calcSub <= 0 ? ($valorPeriodoSelecionadoLimpo == $mediaOutrasKPIs ? "●" : "⬇") : "⬆";

        // Verifica se é para inverter os sinais de positivo e negativo
        $reverterSimbolo
            ? $cor = $calcSub <= 0 ? ($valorPeriodoSelecionadoLimpo == $mediaOutrasKPIs ? 'cinza' : 'verde') : 'vermelho'
            : $cor = $calcSub <= 0 ? ($valorPeriodoSelecionadoLimpo == $mediaOutrasKPIs ? 'cinza' : 'vermelho') : 'verde';

        // Analizas algumas KPIs individualmente
        if ($kpi == "ads_impressoes_topo" || $kpi == "ads_impressoes_4_primeiros") {
            $mediaOutrasKPIs = tratarDadosImpressoesTopo($mediaOutrasKPIs);
        }

        // Retorna o array com os resultados
        return [
            $valorPeriodoFormatado,
            $formatarPorcentagem ? formatarValorPorcentagem($mediaOutrasKPIs)
                : ($formatarReais ? formatarValorReais($mediaOutrasKPIs)
                : ($arredondar ? arredondarValor($mediaOutrasKPIs)
                    : ($formatarMilhar ? formatarMilhar($mediaOutrasKPIs) : $mediaOutrasKPIs))),
            "-",
            $simbolo,
            $cor,
        ];
    }

    // Se só tiver um período selecionado, não calcula as medias
    if ($qtdResultados == 0) {

        // RETORNO PADRÃO PARA O DESTAQUE ATUAL
        $resultado[$destaque]["forms"]                       = [
            formatarMilhar($resultado[$destaque]["forms"][0]),
            "-",
            "-",
            "●",
            "cinza",
        ];
        $resultado[$destaque]["whatsapp"]                    = [
            formatarMilhar($resultado[$destaque]["whatsapp"][0]),
            "-",
            "-",
            "●",
            "cinza",
        ];
        $resultado[$destaque]["ligacoes"]                    = [
            formatarMilhar($resultado[$destaque]["ligacoes"][0]),
            "-",
            "-",
            "●",
            "cinza",
        ];
        $resultado[$destaque]["ads_cliques"]                 = [
            formatarMilhar($resultado[$destaque]["ads_cliques"][0]),
            "-",
            "-",
            "●",
            "cinza",
        ];
        $resultado[$destaque]["ads_conversions"]             = [
            formatarMilhar(arredondarValor($resultado[$destaque]["ads_conversions"][0])),
            "-",
            "-",
            "●",
            "cinza",
        ];
        $resultado[$destaque]["real_total_contatos"]         = [
            formatarMilhar($resultado[$destaque]["real_total_contatos"][0]),
            "-",
            "-",
            "●",
            "cinza",
        ];
        $resultado[$destaque]["real_total_contatos_por_dias"]         = [
            formatarMilhar($resultado[$destaque]["real_total_contatos_por_dias"][0]),
            "-",
            "-",
            "●",
            "cinza",
        ];
        $resultado[$destaque]["real_impressoes_por_contato"] = [
            arredondarValor($resultado[$destaque]["real_impressoes_por_contato"][0]),
            "-",
            "-",
            "●",
            "cinza",
        ];
        $resultado[$destaque]["ads_media_conversao_valor"]   = [
            formatarValorReais($resultado[$destaque]["ads_media_conversao_valor"][0]),
            "-",
            "-",
            "●",
            "cinza",
        ];
        $resultado[$destaque]["ads_custo_total"]             = [
            formatarValorReais($resultado[$destaque]["ads_custo_total"][0]),
            "-",
            "-",
            "●",
            "cinza",
        ];
        $resultado[$destaque]["ads_media_cpc"]               = [
            formatarValorReais($resultado[$destaque]["ads_media_cpc"][0]),
            "-",
            "-",
            "●",
            "cinza",
        ];
        $resultado[$destaque]["real_custo_por_lead"]         = [
            formatarValorReais($resultado[$destaque]["real_custo_por_lead"][0]),
            "-",
            "-",
            "●",
            "cinza",
        ];
        $resultado[$destaque]["ads_ctr"]                     = [
            formatarValorPorcentagem($resultado[$destaque]["ads_ctr"][0]),
            "-",
            "-",
            "●",
            "cinza",
        ];
        $resultado[$destaque]["ads_taxa_conversao"]          = [
            formatarValorPorcentagem($resultado[$destaque]["ads_taxa_conversao"][0]),
            "-",
            "-",
            "●",
            "cinza",
        ];
        $resultado[$destaque]["real_taxa_conversao"]         = [
            formatarValorPorcentagem($resultado[$destaque]["real_taxa_conversao"][0]),
            "-",
            "-",
            "●",
            "cinza",
        ];
        $resultado[$destaque]["ads_impressoes_topo"]         = [
            tratarDadosImpressoesTopo($resultado[$destaque]["ads_impressoes_topo"][0]),
            "-",
            "-",
            "●",
            "cinza",
        ];
        $resultado[$destaque]["ads_impressoes_4_primeiros"]  = [
            tratarDadosImpressoesTopo($resultado[$destaque]["ads_impressoes_4_primeiros"][0]),
            "-",
            "-",
            "●",
            "cinza",
        ];
        $resultado[$destaque]["real_cliques_por_contato"]    = [
            $resultado[$destaque]["real_cliques_por_contato"][0],
            "-",
            "-",
            "●",
            "cinza",
        ];

    } else {

        // RETORNO PADRÃO PARA O DESTAQUE ATUAL
        $resultado[$destaque]["forms"]                       = calculaMediaDoPeriodoSelecionado("",
            formatarMilhar($resultado[$destaque]["forms"][0]), $resultado[$destaque]["forms"][0],
            $resultadoMedia["forms"], 0, 0, 0, 0, 1);
        $resultado[$destaque]["whatsapp"]                    = calculaMediaDoPeriodoSelecionado("",
            formatarMilhar($resultado[$destaque]["whatsapp"][0]), $resultado[$destaque]["whatsapp"][0],
            $resultadoMedia["whatsapp"], 0, 0, 0, 0, 1);
        $resultado[$destaque]["ligacoes"]                    = calculaMediaDoPeriodoSelecionado("",
            formatarMilhar($resultado[$destaque]["ligacoes"][0]), $resultado[$destaque]["ligacoes"][0],
            $resultadoMedia["ligacoes"], 0, 0, 0, 0, 1);
        $resultado[$destaque]["ads_cliques"]                 = calculaMediaDoPeriodoSelecionado("",
            formatarMilhar($resultado[$destaque]["ads_cliques"][0]), $resultado[$destaque]["ads_cliques"][0],
            $resultadoMedia["ads_cliques"], 0, 0, 0, 0, 1);
        $resultado[$destaque]["ads_conversions"]             = calculaMediaDoPeriodoSelecionado("",
            formatarMilhar(arredondarValor($resultado[$destaque]["ads_conversions"][0])),
            $resultado[$destaque]["ads_conversions"][0], $resultadoMedia["ads_conversions"], 0, 0, 0, 1, 1);
        $resultado[$destaque]["real_total_contatos"]         = calculaMediaDoPeriodoSelecionado("",
            formatarMilhar($resultado[$destaque]["real_total_contatos"][0]),
            $resultado[$destaque]["real_total_contatos"][0], $resultadoMedia["real_total_contatos"], 0, 0, 0, 0, 1);
        $resultado[$destaque]["real_total_contatos_por_dias"]         = calculaMediaDoPeriodoSelecionado("",
            $resultado[$destaque]["real_total_contatos_por_dias"][0],
            $resultado[$destaque]["real_total_contatos_por_dias"][0], $resultadoMedia["real_total_contatos_por_dias"], 0, 0, 0, 0, 1);
        $resultado[$destaque]["real_impressoes_por_contato"] = calculaMediaDoPeriodoSelecionado("",
            arredondarValor($resultado[$destaque]["real_impressoes_por_contato"][0]),
            $resultado[$destaque]["real_impressoes_por_contato"][0], $resultadoMedia["real_impressoes_por_contato"], 1,
            0, 0, 1, 0);
        $resultado[$destaque]["ads_media_conversao_valor"]   = calculaMediaDoPeriodoSelecionado("",
            formatarValorReais($resultado[$destaque]["ads_media_conversao_valor"][0]),
            $resultado[$destaque]["ads_media_conversao_valor"][0], $resultadoMedia["ads_media_conversao_valor"], 1, 0,
            1, 0, 0);
        $resultado[$destaque]["ads_custo_total"]             = calculaMediaDoPeriodoSelecionado("",
            formatarValorReais($resultado[$destaque]["ads_custo_total"][0]),
            $resultado[$destaque]["ads_custo_total"][0], $resultadoMedia["ads_custo_total"], 0, 0, 1, 0, 0);
        $resultado[$destaque]["ads_media_cpc"]               = calculaMediaDoPeriodoSelecionado("",
            formatarValorReais($resultado[$destaque]["ads_media_cpc"][0]), $resultado[$destaque]["ads_media_cpc"][0],
            $resultadoMedia["ads_media_cpc"], 1, 0, 1, 0, 0);
        $resultado[$destaque]["real_custo_por_lead"]         = calculaMediaDoPeriodoSelecionado("",
            formatarValorReais($resultado[$destaque]["real_custo_por_lead"][0]),
            $resultado[$destaque]["real_custo_por_lead"][0], $resultadoMedia["real_custo_por_lead"], 1, 0, 1, 0, 0);
        $resultado[$destaque]["ads_ctr"]                     = calculaMediaDoPeriodoSelecionado("",
            formatarValorPorcentagem($resultado[$destaque]["ads_ctr"][0]), $resultado[$destaque]["ads_ctr"][0],
            $resultadoMedia["ads_ctr"], 0, 1, 0, 0, 0);
        $resultado[$destaque]["ads_taxa_conversao"]          = calculaMediaDoPeriodoSelecionado("",
            formatarValorPorcentagem($resultado[$destaque]["ads_taxa_conversao"][0]),
            $resultado[$destaque]["ads_taxa_conversao"][0], $resultadoMedia["ads_taxa_conversao"], 0, 1, 0, 0, 0);
        $resultado[$destaque]["real_taxa_conversao"]         = calculaMediaDoPeriodoSelecionado("",
            formatarValorPorcentagem($resultado[$destaque]["real_taxa_conversao"][0]),
            $resultado[$destaque]["real_taxa_conversao"][0], $resultadoMedia["real_taxa_conversao"], 0, 1, 0, 0, 0);
        $resultado[$destaque]["ads_impressoes_topo"]         = calculaMediaDoPeriodoSelecionado("ads_impressoes_topo",
            tratarDadosImpressoesTopo($resultado[$destaque]["ads_impressoes_topo"][0]),
            $resultado[$destaque]["ads_impressoes_topo"][0], $resultadoMedia["ads_impressoes_topo"], 0, 0, 0, 0, 0);
        $resultado[$destaque]["ads_impressoes_4_primeiros"]  = calculaMediaDoPeriodoSelecionado("ads_impressoes_4_primeiros",
            tratarDadosImpressoesTopo($resultado[$destaque]["ads_impressoes_4_primeiros"][0]),
            $resultado[$destaque]["ads_impressoes_4_primeiros"][0], $resultadoMedia["ads_impressoes_4_primeiros"], 0, 0,
            0, 0, 0);
        $resultado[$destaque]["real_cliques_por_contato"]    = calculaMediaDoPeriodoSelecionado("",
            $resultado[$destaque]["real_cliques_por_contato"][0], $resultado[$destaque]["real_cliques_por_contato"][0],
            $resultadoMedia["real_cliques_por_contato"], 1, 0, 0, 0, 0);
    }

    // Não usados
    // $resultado[$destaque]["ads_invalidos"] = [$resultado[$destaque]["ads_invalidos"][0], "-", "-", "●", "cinza"];
    // $resultado[$destaque]["ads_impressoes"] = [$resultado[$destaque]["ads_impressoes"][0], "-", "-", "●", "cinza"];

} catch (\Throwable $th) {
    // throw $th;
    // echo "-2Erro ao buscar os dados #2";
    echo "-2" . $th;
}

echo json_encode_alt($resultado);