<?php
/*
 * Este arquivo é responsável por atualizar a página de "Ver Contatos" do sistema.
 * Para isso, ele faz uma pesquisa de todos os leads de um certo período, e monta um
 * JSON contendo tais informações.
 */
 
require_once(__DIR__ . "/../classes/Sistema.php"); 
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if($sistema->usuario->permissao_log == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

// Validamos aqui se o filtro de pesquisa está correto
if(!Filtro::validar($_POST['data'], $_POST['datainicial'], $_POST['datafinal'])){
	echo "-2Filtro de pesquisa inválido";
	exit;
}

try{
	$resultado = $sistema->logs->obter_log($_POST['data'], $_POST['datainicial'], $_POST['datafinal']);
	
	echo json_encode_alt($resultado);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>