<?php
require_once(__DIR__ . "/../classes/Sistema.php"); 
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if($sistema->usuario->permissao_indicacoes != Usuario::PERM_ESCRITA || $sistema->indicacoes->usa_pontos != "1") {echo "-2Permissão insuficiente para ver esta página!"; exit;}

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

try{
	$sql = "SELECT * FROM TBL_INDICACOES_PRODUTOS WHERE NU_ID = :id AND ID_CLIENTE_FK = :id2 AND NU_DELETADO = 0";
	$params = array(
		':id' => $_POST['id'],
		':id2' => $sistema->usuario->id
	);
	$premio = $sistema->bd->executar($sql, $params, Banco_Dados::FETCH);

	if($sistema->bd->quantidade() == 0){ // Nenhum dado foi encontrado, ID é inválida
		echo "-2ID inválida!";
		exit;
	}

	$sistema->logs->adicionar_log_delecao_premio($premio);

	$sql = "UPDATE TBL_INDICACOES_PRODUTOS SET NU_DELETADO = 1 WHERE NU_ID = :id AND ID_CLIENTE_FK = :id2";
	$sistema->bd->executar($sql, $params);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>