<?php 
/*
 * Este arquivo salvar o usuário do sistema de arquivos.
 */

require_once(__DIR__ . "/../classes/Sistema.php"); 
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso ao drive
if($sistema->usuario->permissao_drive == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

if(empty($_POST['nome'])){
	echo "-2Nome inválido!";
	exit;
}

if(!empty($_POST['senha']) && strlen($_POST['senha']) > 64){
	echo "-2Senha inválida!";
	exit;
}

if(empty($_POST['login']) || strlen($_POST['login']) > 64 || preg_match('/[^A-Za-z0-9]/', $_POST['login'])){
	echo "-2Login inválido!";
	exit;
}

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

$url = $_POST['link'];
$query_str = parse_url($url, PHP_URL_QUERY);
parse_str($query_str, $query_params);

if(empty($url) || $query_str == FALSE || !isset($query_params['id'])){
	echo "-2Link inválido!";
	exit;
}

try{
	$usuario = $sistema->drive->obter_usuario($_POST['id']);

	if($usuario == -1){
		echo "-2ID Inválida!";
		exit;
	}

	// Salva o cliente
	$resultado = $sistema->drive->salvar_usuario($_POST['id'], $_POST['nome'], $_POST['login'], $_POST['link'], $_POST['senha']);

	if($resultado == -1){
		echo "-2O login informado já existe!";
		exit;
	}

	$dados = array(
		'TXT_NOME' => $usuario['nome'],
		'NU_ID' => $usuario['id']
	);

	$sistema->logs->adicionar_log_alteracao_usuario_arquivos($dados);

	echo json_encode_alt($resultado);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>