<?php
require_once(__DIR__ . "/../../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso
if($sistema->usuario->permissao_gsuite == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

try{
	$dados = $sistema->bd->executar("SELECT * FROM TBL_GOOGLEAPPS WHERE ID = :id", array(':id' => $_POST['id']), Banco_Dados::FETCH);

	if($sistema->bd->quantidade() == 0){
		echo "-2ID inválida!";
		exit;
	}
	
	$nome = $dados['TXT_NOME'];
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>
<div class="modal-header">
	<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
	<span aria-hidden="true">&times;</span></button>
	<h4 class="modal-title"><b>Confirmação</b></h4>
</div>

<div class="modal-body">
	Tem certeza de que deseja deletar o agendamento do cliente "<b><?php echo $nome;?></b>"? <br><br> <span class="text-red">Esta ação <b>NÃO PODE SER DESFEITA</b>.</span>
</div>
<div class="modal-footer">
	<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Não</button>
	<a class="btn btn-primary" href="javascript:void(0);" onclick="salvar_deletar_agendamento();">Sim</a>
</div>
<div class="overlay preloader">
	<i class="fa fa-refresh fa-spin"></i>
</div>

<script>
function salvar_deletar_agendamento(){
	var dados = "id=<?php echo $_POST['id']; ?>";
	jQuery.ajax({
		type: "POST",
		url: "action/salvar_modal_agendamento_deletar",
		data: dados,
		success: function(data){
			$('.preloader').css({display:"none"});
			if(data == '-1') {window.location.href = "./"; return;}
			if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
			fechar_modal_confirmacao();
			remover_agendamento(<?php echo $_POST['id']; ?>);
			toastr.clear(); toastr.success("Agendamento deletado com sucesso."); return;
		},
		beforeSend: function(){
			$('.preloader').css({display:"block"});
		},
		complete: function(){
			$('.preloader').css({display:"none"});
		},
		error: function(){
			$('.preloader').css({display:"none"});
			toastr.clear(); toastr.error("Houve um erro ao deletar agendamento."); return;
		}
	});
}
</script>