<?php
/*
 * Este arquivo cria a modal que possibilita a edição dos dados de
 * um cliente da agência.
 */

require_once(__DIR__ . "/../../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

if (!ctype_digit($_POST['id'])) { // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

try {

	// Faz a consulta dos seguimentos salvos
	$todosSeguimentos = $sistema->obter_seguimentos();

	// Faz a consulta dos dados gerais do cliente
	$dados_cliente = $sistema->obter_cliente($_POST['id']);

	if ($sistema->bd->quantidade() == 0) {
		echo "-2ID inválida!";
		exit;
	}

	$id_crypto = Sistema::criptografar($_POST['id']);

	// Obtém os principais dados do cliente
	$nome_inicial = $dados_cliente['TXT_NOME'];
	$telefone_inicial = $dados_cliente['NU_TELEFONE_1'];
	$consultoria = $dados_cliente['TXT_CONSULTORIA'] == "0" ? "" : "checked='checked'";
	$google = $dados_cliente['TXT_GOOGLE'] == "0" ? "" : "checked='checked'";
	$log_ativo = $dados_cliente['TXT_LOG'] == "0" ? "" : "checked='checked'";
	$whatsapp = $dados_cliente['NU_WHATSAPP'] == "0" ? "" : "checked='checked'";
	$sms = $dados_cliente['NU_SMS'] == "0" ? "" : "checked='checked'";
	$linkclique = $dados_cliente['NU_PERM_LINKCLIQUE'] == "0" ? "" : "checked='checked'";
	$home = $dados_cliente['TXT_HOME'];
	$seguimento_cliente = $dados_cliente['TXT_SEGUIMENTO'];
	$ligacoes = $dados_cliente['TXT_FONE'] == "0" ? "" : "checked='checked'";
	$notificacao = $dados_cliente['TXT_NOTIFICACAO_FECHAMENTO'] == "0" ? "" : "checked='checked'";
	$leads = $dados_cliente['TXT_LEADS'] == "0" ? "" : "checked='checked'";
	$comparacao = $dados_cliente['TXT_COMPARACAO'] == "0" ? "" : "checked='checked'";
	$btnaddlead = $dados_cliente['NU_PERM_BTN_ADICIONAR_LEAD'] == "1" ? "" : "checked='checked'";
	$cliente_ativo = $dados_cliente['NU_CLIENTE_ATIVO'] == "0" ? "" : "checked='checked'";
	$cliente_importante = $dados_cliente['NU_CLIENTE_IMPORTANTE'] == "0" ? "" : "checked='checked'";
	$win7phone_ativo = $dados_cliente['NU_POSSUI_WIN7FONE'] == "0" ? "" : "checked='checked'";
	$dadosgerais_ativo = $dados_cliente['NU_ATIVAR_DADOS_GERAIS'] == "0" ? "" : "checked='checked'";
	$acesso = $dados_cliente['NU_ACESSOS_SISTEMA_DATA'];
	$tag_forms = $dados_cliente['TXT_ID_TAG_FORMS'];
	$tag_whatsapp = $dados_cliente['TXT_ID_TAG_WHATSAPP'];
	$perm_pausar_campanhas = $dados_cliente['NU_PERM_PAUSAR_CAMPANHAS'] == "0" ? "" : "checked='checked'";
	$mostrar_total_ligacoes = $dados_cliente['NU_MOSTRAR_TOTAL_REAL_LIGACOES'] == "0" ? "" : "checked='checked'";
	$agrupar_ligacoes = $dados_cliente['NU_AGRUPAR_LIGACOES'] == "0" ? "" : "checked='checked'";
	$ligacoes_efetuadas = $dados_cliente['NU_ESCONDER_LIGACOES_EFETUADAS'] == "0" ? "" : "checked='checked'";
	// $mostrar_apenas_campanhas = $dados_cliente['NU_MOSTRAR_SOMENTE_CAMPANHAS'] == "0" ? "" : "checked='checked'";
	$mostrar_apenas_campanhas = $dados_cliente['NU_MOSTRAR_SOMENTE_CAMPANHAS'];
	$mascara_ddi = $dados_cliente['NU_DDI_MASCARA'] == "0" ? "" : "checked='checked'";
	$mostrar_cpl = $dados_cliente['NU_MOSTRAR_CPL'] == "0" ? "" : "checked='checked'";
	$moeda_adwords = $dados_cliente['NU_MOEDA_ADWORDS'];
	$limite_custo_lead = number_format(floatval($dados_cliente['TXT_LIMITE_CUSTO_LEAD'] / 100), 2, ',', '.');

	if (Utilitarios::data_padrao_valida($acesso)) {
		$acesso = strtotime($acesso);
		$acesso = date('d/m/Y H:i:s', $acesso);
	} else {
		$acesso = "Nunca";
	}
	$acessos = $dados_cliente['NU_ACESSOS_SISTEMA'];

	// Faz a consulta dos numeros de WhatsApps no banco
	$whatsapps_dados = $sistema->bd->executar("SELECT NU_WHATSAPPS,	TXT_WHATSAPP_LINK FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(":id" => $_POST['id']), Banco_Dados::FETCH_ALL);
	foreach ($whatsapps_dados as $row) {
		$whatsAppsNumerosString = $row['NU_WHATSAPPS'];
		$whatsAppBancoLink = $row['TXT_WHATSAPP_LINK'];
		$whatsAppsNumerosArray = explode("|%|", $whatsAppsNumerosString);
	}

	if ($whatsAppBancoLink == 1) {
		$linkAtivo = "checked";
	} else {
		$bancoAtivo = "checked";
	}

	// Faz a consulta dos SMSs no banco
	$sms_dados = $sistema->bd->executar("SELECT NU_SMSS, TXT_SMS_LINK FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(":id" => $_POST['id']), Banco_Dados::FETCH_ALL);
	foreach ($sms_dados as $row) {
		$smsNumerosString = $row['NU_SMSS'];
		$smsBancoLink = $row['TXT_SMS_LINK'];
		$smsNumerosArray = explode("|%|", $smsNumerosString);
	}

	if ($smsBancoLink == 1) {
		$smsLinkAtivo = "checked";
	} else {
		$smsBancoAtivo = "checked";
	}

	// Faz a consulta dos Formularios
	$forms_dados = $sistema->bd->executar("SELECT TXT_FORMS, NU_FORMS_ATIVADO FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(":id" => $_POST['id']), Banco_Dados::FETCH_ALL);

	$formAtivo = '';
	$quantidadeForms = '';
	// $formularios = [];

	foreach ($forms_dados as $row) {

		$formAtivo = $row['NU_FORMS_ATIVADO'];

		$forms = explode("|#|", $row['TXT_FORMS']);
		$quantidadeForms = count($forms);

		if ($forms[0] != "") {
			for ($i = 0; $i <= count($forms) - 1; $i++) {

				$formDados = explode("|@|", $forms[$i]);
				$formDadosTopo = explode("|$|", $formDados[0]);
				$formEmailsOcultos = explode("|$|", $formDados[1]);
				$formEmails = explode("|%|", $formDados[2]);
				$formIdentificador = explode("|$|", $formDados[3]);

				$formularios[$i]['nome'] = $formDadosTopo[0];
				$formularios[$i]['id'] = $formDadosTopo[1];
				$formularios[$i]['nomeempresa'] = $formDadosTopo[2];
				$formularios[$i]['assuntoemail'] = $formDadosTopo[3];
				$formularios[$i]['formorganico'] = $formDadosTopo[4];
				$formularios[$i]['emailsocultos'] = $formEmailsOcultos;
				$formularios[$i]['emails'] = [];
				$formularios[$i]['formidentificadortexto'] = $formIdentificador[0];
				$formularios[$i]['formidentificadorativo'] = $formIdentificador[1];

				for ($j = 0; $j <= count($formEmails) - 1; $j++) {
					array_push($formularios[$i]['emails'], explode("|$|", $formEmails[$j]));
				}
			}
		} else {
			$quantidadeForms = 0;
		}
	}

	// Lista de e-mails da Win7
	// A lista de e-mail para adição e remoção de e-mails estão na classe Layout_Sistema
	$emailsWin7 = $sistema->layout->lista_emails_ocultos_win7;

	// Faz a consulta das IDs do vono
	$vono_dados = $sistema->bd->executar("SELECT NU_VONOID, TXT_NOME FROM TBL_VONOIDS WHERE NU_IDCLIENTE = :id", array(":id" => $_POST['id']), Banco_Dados::FETCH_ALL);
	$vono_ids = array();
	foreach ($vono_dados as $row) {
		$vono_ids[] = array($row['NU_VONOID'], $row['TXT_NOME']);
	}

	// Faz a consulta dos sub usuários
	$subusuarios = $sistema->bd->executar("SELECT * FROM TBL_SUBUSUARIOS WHERE ID_CLIENTE_FK = :id", array(":id" => $_POST['id']), Banco_Dados::FETCH_ALL);

	$campanhas = $sistema->bd->executar("SELECT * FROM TBL_CAMPANHAS_CLIENTE WHERE ID_CLIENTE_FK = :id", array(":id" => $_POST['id']), Banco_Dados::FETCH_ALL);
} catch (Exception $e) {
	echo "-2Houve um erro com o servidor";
	exit;
}

?>

<script>
	function salvarDados() {

		// Checa se o select de seguimento foi marcado
		if (document.getElementById('sqlSeguimento').value == '') {
			toastr.clear();
			toastr.error("Selecione um seguimento!");
			return false;
		}

		// Checa se pelo meno o campo whats1 esta preechido
		if (document.getElementById('whatsapp').checked) {

			// Checa de o whatsapp esta marcado
			if ($('input[name="whatsBanco"]:checked').val() == "sim") {

				if ($('#whats1').val() == null || $('#whats1').val() == "") {

					$('ul.nav-tabs > li:nth-child(1)').removeClass('active');
					$('ul.nav-tabs > li:nth-child(2)').removeClass('active');
					$('ul.nav-tabs > li:nth-child(3)').removeClass('active');
					$('ul.nav-tabs > li:nth-child(4)').removeClass('active');
					$('ul.nav-tabs > li:nth-child(5)').removeClass('active');
					$('ul.nav-tabs > li:nth-child(6)').addClass('active');
					$('ul.nav-tabs > li:nth-child(7)').removeClass('active');
					$('ul.nav-tabs > li:nth-child(8)').removeClass('active');

					$('#tab_1').removeClass('active');
					$('#tab_2').removeClass('active');
					$('#tab_3').removeClass('active');
					$('#tab_4').removeClass('active');
					$('#tab_5').removeClass('active');
					$('#tab_6').addClass('active');
					$('#tab_7').removeClass('active');
					$('#tab_8').removeClass('active');

					$('#whats1').focus();

					toastr.clear();
					toastr.error("O usuário precisa ter pelo menos um WhatsApp configurado!");
					return false;

				} else {
					let contador = 0;
					$("input[name='whatsappInput[]']").each(function() {
						if ($(this).val() == "") {
							contador++;
						}
					});
					if (contador > 0) {
						toastr.clear();
						toastr.error("Preencha ou Exclua o(s) campo(s) de WhatsApp em branco!");
						return false;
					}
				}
			}
		}
		// Checa se pelo meno o campo sms1 esta preechido
		if (document.getElementById('sms').checked) {

			// Checa de o whatsapp esta marcado
			if ($('input[name="smsBanco"]:checked').val() == "sim") {

				if ($('#sms1').val() == null || $('#sms1').val() == "") {

					$('ul.nav-tabs > li:nth-child(1)').removeClass('active');
					$('ul.nav-tabs > li:nth-child(2)').removeClass('active');
					$('ul.nav-tabs > li:nth-child(3)').removeClass('active');
					$('ul.nav-tabs > li:nth-child(4)').removeClass('active');
					$('ul.nav-tabs > li:nth-child(5)').removeClass('active');
					$('ul.nav-tabs > li:nth-child(6)').removeClass('active');
					$('ul.nav-tabs > li:nth-child(7)').addClass('active');
					$('ul.nav-tabs > li:nth-child(8)').removeClass('active');

					$('#tab_1').removeClass('active');
					$('#tab_2').removeClass('active');
					$('#tab_3').removeClass('active');
					$('#tab_4').removeClass('active');
					$('#tab_5').removeClass('active');
					$('#tab_6').removeClass('active');
					$('#tab_7').addClass('active');
					$('#tab_8').removeClass('active');

					$('#sms1').focus();

					toastr.clear();
					toastr.error("O usuário precisa ter pelo menos um SMS configurado!");
					return false;

				} else {
					let contador = 0;
					$("input[name='smsInput[]']").each(function() {
						if ($(this).val() == "") {
							contador++;
						}
					});
					if (contador > 0) {
						toastr.clear();
						toastr.error("Preencha ou Exclua o(s) campo(s) de SMS em branco!");
						return false;
					}
				}
			}
		}

		var dados = jQuery('#formDados').serialize() + "&id=<?php echo $_POST['id']; ?>";
		$(document).ready(function() {
			jQuery.ajax({
				type: "POST",
				url: "action/salvar_modal_cliente_dados",
				data: dados,
				success: function(data) {

					// console.log(data);

					$('.preloader').css({
						display: "none"
					});
					if (data == '-1') {
						window.location.href = "./";
						return;
					}
					if (data.substring(0, 2) == "-2") {
						toastr.clear();
						toastr.error(data.substring(2));
						return;
					}
					fechar_modal();
					atualizar_linhas(JSON.parse(data));
					toastr.clear();
					toastr.success("Dados salvos com sucesso.");
					return;
				},
				beforeSend: function() {
					$('.preloader').css({
						display: "block"
					});
				},
				complete: function() {
					$('.preloader').css({
						display: "none"
					});
				},
				error: function() {
					$('.preloader').css({
						display: "none"
					});
					toastr.clear();
					toastr.error("Houve um erro ao salvar.");
					return;
				}
			});
		});
	}
	$(document).ready(function() {
		$('#formDados').submit(function() {
			salvarDados();
			return false;
		})
	});

	function adicionarSubusuario() {
		contadorUsuarios++;
		document.getElementById('qtdUsuarios').value = contadorUsuarios;
		$("#tab_2").append('\
		<input id="idUsuario' + contadorUsuarios + '" name="idUsuario' + contadorUsuarios + '" type="hidden" value="-1">\
		<div class="panel panel-default"><div class="panel-heading">Subusuário ' + contadorUsuarios + '</div><div class="panel-body"><div class="row">\
			<div class="col-xs-12"><div class="form-group">\
				<div class="checkbox">\
					<label>\
						<input type="checkbox" name="adwordsPerm' + contadorUsuarios + '" id="adwordsPerm' + contadorUsuarios + '" value="Sim" checked="checked" >\
						Permitir Acesso ao Adwords&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\
					</label>\
					<label>\
						<input type="checkbox" name="logPerm' + contadorUsuarios + '" id="logPerm' + contadorUsuarios + '" value="Sim">\
						Permitir Acesso ao Log&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\
					</label>\
					<label>\
						<input type="checkbox" name="win7fonePerm' + contadorUsuarios + '" id="win7fonePerm' + contadorUsuarios + '" value="Sim" checked="checked">\
						Permitir Acesso ao Win7 Fone&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\
					</label>\
					<label>\
						<input type="checkbox" name="dadosgerais' + contadorUsuarios + '" id="dadosgerais' + contadorUsuarios + '" value="Sim" checked="checked">\
						Permitir Acesso aos Dados Gerais&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\
					</label>\
				</div>\
			</div></div>\
			<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">\
				<label>Nome:</label>\
				<div class="input-group">\
					<div class="input-group-addon"><i class="fa fa-user"></i></div>\
					<input type="text" class="form-control pull-right" id="subusuarioNome' + contadorUsuarios + '" name="subusuarioNome' + contadorUsuarios + '" required/>\
				</div>\
			</div></div>\
			<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">\
				<label>Login:</label>\
				<div class="input-group">\
					<div class="input-group-addon"><i class="fa fa-user"></i></div>\
					<input type="text" class="form-control pull-right" id="subusuarioLogin' + contadorUsuarios + '" name="subusuarioLogin' + contadorUsuarios + '" required/>\
				</div>\
			</div></div>\
			<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">\
				<label>Senha:</label>\
				<div class="input-group">\
					<div class="input-group-addon"><i class="fa fa-lock"></i></div>\
					<input type="text" class="form-control pull-right" id="subusuarioSenha' + contadorUsuarios + '" name="subusuarioSenha' + contadorUsuarios + '"/>\
				</div>\
			</div></div>\
			<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">\
				<label>Indicações:</label>\
				<div class="input-group">\
					<div class="input-group-addon"><i class="fa fa-smile-o"></i></div>\
					<select name="indicacoesPerm' + contadorUsuarios + '" id="indicacoesPerm' + contadorUsuarios + '" class="form-control pull-right">\
						<option value="0" >Permitir Leitura</option>\
						<option value="1" >Permitir Modificação</option>\
						<option value="2" >Não Permitir</option>\
					</select>\
				</div>\
			</div></div>\
			<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">\
				<label>Contatos:</label>\
				<div class="input-group">\
					<div class="input-group-addon"><i class="fa fa-users"></i></div>\
					<select name="contatosPerm' + contadorUsuarios + '" id="contatosPerm' + contadorUsuarios + '" class="form-control pull-right">\
						<option value="0" >Permitir Leitura</option>\
						<option value="1" >Permitir Modificação</option>\
						<option value="2" >>Não Permitir</option>\
					</select>\
				</div>\
			</div></div>\
			<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">\
				<label>Página Inicial:</label>\
				<div class="input-group">\
					<div class="input-group-addon"><i class="fa fa-home"></i></div>\
					<select name="inicioSubusuario' + contadorUsuarios + '" id="inicioSubusuario' + contadorUsuarios + '" class="form-control pull-right">\
						<?php $sistema->layout->select_home("contatos"); ?>\
					</select>\
				</div>\
			</div></div>\
		</div></div></div>\
	');
	}

	function adicionarFormulario(option = null) {

		// Mostra os formulários
		$('#mostrarForms').show();

		qtdForms = document.getElementById('qtdForms').value;

		contadorForms = qtdForms;
		contadorForms++;
		document.getElementById('qtdForms').value = contadorForms;

		// Checa a opção de buscar no banco
		$('input[name="puxaEmailsBD"]').prop("checked", true);

		// Gera um id único para o formulário, o ID do cliente é concatenado para evitar erros na hora de conferir um códido
		let uniqid = '<?php echo $_POST['id']; ?>X' + (Math.floor(Math.random() * Math.floor(Math.random() * Date.now())));

		// Refaz a função do botão de adicionar e-mails para ter a quantidade correta
		// document.getElementById('btnAdicionarForm').setAttribute( "onClick", `adicionarFormulario(${contadorForms});` );

		$("#mostrarForms").append(`
			<div class="panel panel-default" id="form${contadorForms}">

				<div class="panel-heading">
					<input type="text" class="form-control pull-left input-nome-form" id="nomeform${contadorForms}" name="nomeform${contadorForms}" value="Grupo de e-mails ${contadorForms}" placeholder="Identifique esse grupo:" required />
					<b>ID Form:</b> <input type="text" class="input-form-id" name="formid${contadorForms}" id="formid${contadorForms}" value="${uniqid}" readonly></input>
					<small class="label bg-blue" style="cursor: pointer;margin-left:6px;" onclick="copiarCodigo('formid${contadorForms}');">copiar</small>
					<a href="https://tutoriais.win7.com.br/whatsapp.php?i=<?php echo $id_crypto; ?>&ie=${uniqid}" target="_blank"> <small class="label bg-green" style="cursor: pointer;font-size: 0.8em;">criar whats</small></a>
					<div class="btnExcluirForm">
						<a href="javascript:void(0);" onClick="removerForm('${contadorForms}')" ><i id="trashIcon${contadorForms}" class="fa fa-trash-o text-red"></i></a>
						<input type="hidden" name="excluirForm${contadorForms}" id="excluirForm${contadorForms}" value="0">
					</div>
				</div>

				<div class="panel-heading grid-form-top">
					<div class="form-group">
						<label title="Nome usado apenas nos e-mails enviados para os leads">Nome empresa:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-user"></i></div>
							<input type="text" class="form-control pull-right" id="formnomeempresa${contadorForms}" name="formnomeempresa${contadorForms}" value="XXXXXXX" required />
						</div>
					</div>
					<div class="form-group">
						<label>Assunto do e-mail enviado para o lead:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-envelope-o"></i></div>
							<input type="text" class="form-control pull-right" id="formemailassunto${contadorForms}" name="formemailassunto${contadorForms}" value="Novo contato do site: XXXXXXX" required />
						</div>
					</div>
					<div class="form-group">
						<label title="Se sim, retira a mensagem de 'Anúncios Google/Agência Win7' do assunto do e-mail">Orgânico?</label>
						<style>
						#switchSimNao #no${contadorForms}0:checked ~ .switch {background: #eb4f37;}
						#switchSimNao #no${contadorForms}0:checked ~ .switch span {background: #fff;margin-left: -8px;}
						#switchSimNao #no${contadorForms}0:checked ~ .switch span:after {background: #fff;height: 20px;margin-top: -8px;margin-left: 8px;}
						#switchSimNao label[for=yes${contadorForms}0] {position: absolute;left: 0px;height: 22px;border-radius: 15px 0px 0px 15px;padding: 0px 1px 0px 4px;width: 33px;}
						#switchSimNao label[for=no${contadorForms}0] {position: absolute;right: 0px;padding: 0px 0px 0px 0px;width: 33px;border-radius: 0px 15px 15px 0px;}
						#switchSimNao #yes${contadorForms}0:checked ~ .switch label[for=yes${contadorForms}0] {color: #fff;font-weight: bold;}
						#switchSimNao #no${contadorForms}0:checked ~ .switch label[for=no${contadorForms}0] {color: #fff;font-weight: bold;}
						</style>
						<div id="switchSimNao">
							<input type="radio" id="yes${contadorForms}0" name="formYesNo${contadorForms}0" value="Sim" onclick="setaValorFormOrganico('1', 'formorganico${contadorForms}0')">
							<input type="radio" id="no${contadorForms}0" name="formYesNo${contadorForms}0" value="Nao" onclick="setaValorFormOrganico('0', 'formorganico${contadorForms}0')" checked>
							<div class="switch">
								<label for="yes${contadorForms}0">Sim</label>
								<label for="no${contadorForms}0">Não</label>
							</div>
						</div>
						<input type="hidden" id="formorganico${contadorForms}0" name="formorganico${contadorForms}" value="0">
					</div>
				</div>

				<div class="panel-body">
					<div id="emailsContainer${contadorForms}">

						<div class="row bottom-line-dotted row${contadorForms}1">
							<div class="col-xs-12 col-sm-6 col-md-3">
								<div class="form-group">
									<label>Nome:</label>
									<div class="input-group">
										<div class="input-group-addon"><i class="fa fa-user"></i></div>
										<input type="text" class="form-control pull-right" id="formNome${contadorForms}" name="formNomeEmailAtivo${contadorForms}[]" value="<?php echo $dadosEmailsCliente[0] ?>" required />
									</div>
								</div>
							</div>
							<div class="col-xs-12 col-sm-6 col-md-5">
								<div class="form-group">
									<label>Email:</label>
									<div class="input-group">
										<div class="input-group-addon"><i class="fa fa-at"></i></div>
										<input type="email" class="form-control pull-right" id="formEmail${contadorForms}" name="formNomeEmailAtivo${contadorForms}[]" value="<?php echo $dadosEmailsCliente[1] ?>" required />
									</div>
								</div>
							</div>
							<div class="col-xs-6 col-sm-6 col-md-2">
								<div class="form-group">
									<label>Enviar e-mail?</label>
									<style>
										#switchSimNao #no${contadorForms}1:checked ~ .switch {background: #eb4f37;}
										#switchSimNao #no${contadorForms}1:checked ~ .switch span {background: #fff;margin-left: -8px;}
										#switchSimNao #no${contadorForms}1:checked ~ .switch span:after {background: #fff;height: 20px;margin-top: -8px;margin-left: 8px;}
										#switchSimNao label[for=yes${contadorForms}1] {position: absolute;left: 0px;height: 22px;border-radius: 15px 0px 0px 15px;padding: 0px 1px 0px 4px;width: 33px;}
										#switchSimNao label[for=no${contadorForms}1] {position: absolute;right: 0px;padding: 0px 0px 0px 0px;width: 33px;border-radius: 0px 15px 15px 0px;}
										#switchSimNao id${contadorForms}1:checked ~ .switch label[for=yes${contadorForms}1] {color: #fff;font-weight: bold;}
										#switchSimNao #no${contadorForms}1:checked ~ .switch label[for=no${contadorForms}1] {color: #fff;font-weight: bold;}
									</style>
									<div id="switchSimNao">
										<input type="radio" id="yes${contadorForms}1" name="formYesNo${contadorForms}" value="Sim" onclick="setaValorEnviarEmail('1', 'nomeEnviarEmail${contadorForms}1')" checked >
										<input type="radio" id="no${contadorForms}1" name="formYesNo${contadorForms}" value="Nao" onclick="setaValorEnviarEmail('0', 'nomeEnviarEmail${contadorForms}1')">
										<div class="switch">
											<label for="yes${contadorForms}1">Sim</label>
											<label for="no${contadorForms}1">Não</label>
										</div>
									</div>
									<input type="hidden" id="nomeEnviarEmail${contadorForms}1" name="formNomeEmailAtivo${contadorForms}[]" value="1">
								</div>
							</div>
							<div class="col-xs-6 col-sm-6 col-md-2">
								<div class="form-group">
									<label>Excluir:</label>
									<div class="input-group">
										<div class="checkbox">
											<a href="javascript:void(0);" onClick="removerDivRow('row${contadorForms}1','qtdEmails${contadorForms}')" title="Clique para deletar"><i class="fa fa-trash-o text-red btn-excluir-email"></i></a>
										</div>
									</div>
								</div>
							</div>
						</div>

					</div>
					<div class="row">
						<div class="col-xs-12">
							<div class="form-group">
								<input id="qtdEmails${contadorForms}" name="qtdEmails${contadorForms}" type="hidden" value="1">
								<a href="javascript:void(0);" id="qtdEmailsBtnFunc${contadorForms}" onclick="adicionarNovoEmail(1,'qtdEmails${contadorForms}', 'emailsContainer${contadorForms}', 'qtdEmailsBtnFunc${contadorForms}', ${contadorForms});" class="btn btn-primary">Adicionar e-mail</a>
							</div>
						</div>
					</div>

					<hr style="margin-top: 0px;margin-bottom: 10px;">
					<div class="row">
						<div class="col-xs-12">
							<h4 title="E-mails que vão receber os leads mas não aparecem nos e-mails enviados">E-mails ocultos: <i class="btn-add-email-oculto" onclick="mostrarInputNovoEmailOculto('divAddEmailOculto${contadorForms}')">+</i></h4>
							<div class="form-group">
								<input type="hidden" name="qtdEmailsWinSete${contadorForms}" id="qtdEmailsWinSete${contadorForms}" value="<?php echo count($emailsWin7); ?>">
								<div class="checkbox">

									<div style="display: flex;align-items: center;flex-flow: wrap;" id="boxEmailsOcultos${contadorForms}">
									
										<?php
										// LOOP DOS E-MAILS OCULTOS
										for ($j = 0; $j <= count($emailsWin7) - 1; $j++) {
											$counterEmailsOcultos++;
										?>
												<div style="display: flex;align-items: center;flex-flow: wrap;" id="divSpanEmailOculto${contadorForms}<?php echo $counterEmailsOcultos; ?>">
													<label class="span-bullet">
														<input type="checkbox" name="emailsocultos${contadorForms}[]" id="emailsocultos${contadorForms}<?php echo $counterEmailsOcultos; ?>" value="<?php echo $emailsWin7[$j]; ?>" <?php echo $emailsWin7[$j] == "desenvolvimento@grupolead.com.br" || $emailsWin7[$j] == "alan@grupolead.com.br" || $emailsWin7[$j] == "googleads@grupolead.com.br" || $emailsWin7[$j] == "googleads@win7.com.br" || $emailsWin7[$j] == "patricia.cantanhede@win7.com.br" ? "checked" : "" ?>/>
														<?php echo $emailsWin7[$j]; ?>
													</label>
													<div class="span-bullet-close" onclick="removerEmailOculto('divSpanEmailOculto${contadorForms}<?php echo $counterEmailsOcultos; ?>', 'qtdEmailsWinSete${contadorForms}')">×</div>
												</div>

											<?php
											// Fim loop emailsocultos
										}
										$counterEmailsOcultos = 0;
											?>

									</div>

								</div>
							</div>

							<div style="display:none;" id="divAddEmailOculto${contadorForms}" ><div class="box-novo-email-oculto"><input type="email" id="inputAddEmailOculto${contadorForms}" placeholder="Digite o e-mail:" class="form-control"/><div onclick="adicionarEmailOculto('boxEmailsOcultos${contadorForms}', 'qtdEmailsWinSete${contadorForms}', ${contadorForms}, 'inputAddEmailOculto${contadorForms}', 'divAddEmailOculto${contadorForms}')" ><p>Adicionar</p></div></div></div>
							
						</div>
					</div>

				</div>
				<div class="panel-heading grid-form-top-identificador">

					<div class="form-group">
						<label>Identificação:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-pencil"></i></div>
							<input type="text" class="form-control pull-right" id="formidentificadortexto${contadorForms}" name="formidentificadortexto${contadorForms}" value="" />
						</div>
					</div>

					<div class="form-group">
						<label title="Se marcado Não, deixa a identificação em branco na tabela">Ativo?</label>
						<style>
						#switchSimNao #noid${contadorForms}0:checked ~ .switch {background: #eb4f37;}
						#switchSimNao #noid${contadorForms}0:checked ~ .switch span {background: #fff;margin-left: -8px;}
						#switchSimNao #noid${contadorForms}0:checked ~ .switch span:after {background: #fff;height: 20px;margin-top: -8px;margin-left: 8px;}
						#switchSimNao label[for=yesid${contadorForms}0] {position: absolute;left: 0px;height: 22px;border-radius: 15px 0px 0px 15px;padding: 0px 1px 0px 4px;width: 33px;}
						#switchSimNao label[for=noid${contadorForms}0] {position: absolute;right: 0px;padding: 0px 0px 0px 0px;width: 33px;border-radius: 0px 15px 15px 0px;}
						#switchSimNao #yesid${contadorForms}0:checked ~ .switch label[for=yesid${contadorForms}0] {color: #fff;font-weight: bold;}
						#switchSimNao #noid${contadorForms}0:checked ~ .switch label[for=noid${contadorForms}0] {color: #fff;font-weight: bold;}
						</style>
						<div id="switchSimNao">
							<input type="radio" id="yesid${contadorForms}0" name="formYesNoIdentificador${contadorForms}0" value="Sim" onclick="setaValorFormIdentificador('1', 'formidentificadorativo${contadorForms}0')">
							<input type="radio" id="noid${contadorForms}0" name="formYesNoIdentificador${contadorForms}0" value="Nao" onclick="setaValorFormIdentificador('0', 'formidentificadorativo${contadorForms}0')" checked>
							<div class="switch">
								<label for="yesid${contadorForms}0">Sim</label>
								<label for="noid${contadorForms}0">Não</label>
							</div>
						</div>
						<input type="hidden" id="formidentificadorativo${contadorForms}0" name="formidentificadorativo${contadorForms}" value="0">
					</div>
				</div>
			</div>`);
	}




	function adicionarNovoEmail(qtd, inputQtdId, panelId, btnQtdEmailsBtnFunc, formNumber) {

		// Pega a quantidade do input hidden
		contadorQtdEmails = document.getElementById(inputQtdId).value;

		// Incrementa o valor
		contadorQtdEmails++;

		// Seta a quantidade no input hidden
		document.getElementById(inputQtdId).value = contadorQtdEmails;

		// Refaz a função do botão de adicionar e-mails para ter a quantidade correta
		document.getElementById(btnQtdEmailsBtnFunc).setAttribute("onClick", `adicionarNovoEmail(${contadorQtdEmails},'${inputQtdId}','${panelId}','${btnQtdEmailsBtnFunc}', ${formNumber});`);

		// Gera um id unico para a classe da row, para ser excluida posteriormente
		let rowUniqId = Math.floor(Math.random() * Math.floor(Math.random() * Date.now()));

		// Anexa a nova row com os novos inputs
		$(`#${panelId}`).append(`
			<div class="row bottom-line-dotted row${formNumber}${contadorQtdEmails} ${rowUniqId}">
				<div class="col-xs-12 col-sm-6 col-md-3">
					<div class="form-group">
						<label>Nome:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-user"></i></div>
							<input type="text" class="form-control pull-right" id="formNome${formNumber}${contadorQtdEmails}" name="formNomeEmailAtivo${formNumber}[]" value="<?php echo $dadosEmailsCliente[0] ?>" required />
						</div>
					</div>
				</div>
				<div class="col-xs-12 col-sm-6 col-md-5">
					<div class="form-group">
						<label>Email:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-at"></i></div>
							<input type="email" class="form-control pull-right" id="formEmail${formNumber}${contadorQtdEmails}" name="formNomeEmailAtivo${formNumber}[]" value="<?php echo $dadosEmailsCliente[1] ?>" required />
						</div>
					</div>
				</div>
				<div class="col-xs-6 col-sm-6 col-md-2">
					<div class="form-group">
						<label>Enviar e-mail?</label>
						<style>
							#switchSimNao #no${rowUniqId}:checked ~ .switch {background: #eb4f37;}
							#switchSimNao #no${rowUniqId}:checked ~ .switch span {background: #fff;margin-left: -8px;}
							#switchSimNao #no${rowUniqId}:checked ~ .switch span:after {background: #fff;height: 20px;margin-top: -8px;margin-left: 8px;}
							#switchSimNao label[for=yes${rowUniqId}] {position: absolute;left: 0px;height: 22px;border-radius: 15px 0px 0px 15px;padding: 0px 1px 0px 4px;width: 33px;}
							#switchSimNao label[for=no${rowUniqId}] {position: absolute;right: 0px;padding: 0px 0px 0px 0px;width: 33px;border-radius: 0px 15px 15px 0px;}
							#switchSimNao #yes${rowUniqId}:checked ~ .switch label[for=yes${rowUniqId}] {color: #fff;font-weight: bold;}
							#switchSimNao #no${rowUniqId}:checked ~ .switch label[for=no${rowUniqId}] {color: #fff;font-weight: bold;}
						</style>
						<div id="switchSimNao">
							<input type="radio" id="yes${rowUniqId}" name="formYesNo${rowUniqId}" value="Sim" onclick="setaValorEnviarEmail('1', 'nomeEnviarEmail${rowUniqId}')" checked >
							<input type="radio" id="no${rowUniqId}" name="formYesNo${rowUniqId}" value="Nao" onclick="setaValorEnviarEmail('0', 'nomeEnviarEmail${rowUniqId}')">
							<div class="switch">
								<label for="yes${rowUniqId}">Sim</label>
								<label for="no${rowUniqId}">Não</label>
							</div>
						</div>
						<input type="hidden" id="nomeEnviarEmail${rowUniqId}" name="formNomeEmailAtivo${formNumber}[]" value="1">
					</div>
				</div>
				<div class="col-xs-6 col-sm-6 col-md-2">
					<div class="form-group">
						<label>Excluir:</label>
						<div class="input-group">
							<div class="checkbox">
								<a href="javascript:void(0);" onClick="removerDivRow('${rowUniqId}', 'qtdEmails${formNumber}')" title="Clique para deletar"><i class="fa fa-trash-o text-red btn-excluir-email"></i></a>
							</div>
						</div>
					</div>
				</div>
			</div>
		`);
	}

	function adicionarNumeroWhatsApp() {
		contadorNumerosWhatsApp++;
		document.getElementById('qtdWhatApps').value = contadorNumerosWhatsApp;
		$("#whatsapp-tab").append('<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group"><label>WhatsApp ' + contadorNumerosWhatsApp + ':</label><div class="input-group"><div class="input-group-addon"><a href="javascript:void(0);" onClick="recriarWhats(' + contadorNumerosWhatsApp + ')" title="Clique para deletar"><i class="fa fa-trash-o text-red"></i></a></div><input type="text" class="form-control pull-right maskMulti" id="whats' + contadorNumerosWhatsApp + '" name="whatsappInput[]" /></div></div></div>');

		$('#whats' + contadorNumerosWhatsApp).inputmasks(maskOpts);
	}

	function recriarWhats(index) {
		let strHTML = "";
		let counter = 0;
		for (let i = 1; i <= contadorNumerosWhatsApp; i++) {
			if (i == index) {
				continue;
			}
			counter++;
			let campo1 = document.getElementById('whats' + i).value;
			strHTML += '<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group"><label>WhatsApp ' + counter + ':</label><div class="input-group"><div class="input-group-addon"><a href="javascript:void(0);" onClick="recriarWhats(' + counter + ')" title="Clique para deletar"><i class="fa fa-trash-o text-red"></i></a></div><input type="text" class="form-control pull-right maskMulti" id="whats' + counter + '" name="whatsappInput[]" value="' + campo1 + '" /></div></div></div>';
		}
		contadorNumerosWhatsApp--;
		document.getElementById('qtdWhatApps').value = contadorNumerosWhatsApp;
		document.getElementById('whatsapp-tab').innerHTML = strHTML;

		// seta novamente as mascaras
		for (let i = 1; i <= contadorNumerosWhatsApp; i++) {
			$('#whats' + i).inputmasks(maskOpts);
		}
	}

	function adicionarNumeroSMS() {
		contadorNumerosSMS++;
		document.getElementById('qtdSMS').value = contadorNumerosSMS;
		$("#sms-tab").append('<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group"><label>SMS ' + contadorNumerosSMS + ':</label><div class="input-group"><div class="input-group-addon"><a href="javascript:void(0);" onClick="recriarSMS(' + contadorNumerosSMS + ')" title="Clique para deletar"><i class="fa fa-trash-o text-red"></i></a></div><input type="text" class="form-control pull-right maskMulti" id="sms' + contadorNumerosSMS + '" name="smsInput[]" /></div></div></div>');

		$('#sms' + contadorNumerosSMS).inputmasks(maskOpts);
	}

	function recriarSMS(index) {
		let strHTML = "";
		let counter = 0;
		for (let i = 1; i <= contadorNumerosSMS; i++) {
			if (i == index) {
				continue;
			}
			counter++;
			let campo1 = document.getElementById('sms' + i).value;
			strHTML += '<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group"><label>SMS ' + counter + ':</label><div class="input-group"><div class="input-group-addon"><a href="javascript:void(0);" onClick="recriarSMS(' + counter + ')" title="Clique para deletar"><i class="fa fa-trash-o text-red"></i></a></div><input type="text" class="form-control pull-right maskMulti" id="sms' + counter + '" name="smsInput[]" value="' + campo1 + '" /></div></div></div>';
		}
		contadorNumerosSMS--;
		document.getElementById('qtdSMS').value = contadorNumerosSMS;
		document.getElementById('sms-tab').innerHTML = strHTML;

		// seta novamente as mascaras
		for (let i = 1; i <= contadorNumerosSMS; i++) {
			$('#sms' + i).inputmasks(maskOpts);
		}
	}

	function adicionarID() {
		contadorVono++;
		document.getElementById('qtdVono').value = contadorVono;
		$("#vono-tab").append('<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group"><label>Ramal ' + contadorVono + ':</label><div class="input-group"><div class="input-group-addon"><a href="javascript:void(0);" onClick="recriar(' + contadorVono + ')" title="Clique para deletar"><i class="fa fa-trash-o text-red"></i></a></div><input type="text" class="form-control pull-right" id="vono' + contadorVono + '" name="vono' + contadorVono + '" required/></div></div></div><div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group"><label>Nome ' + contadorVono + ':</label><div class="input-group"><div class="input-group-addon"><i class="fa fa-phone"></i></div><input type="text" class="form-control pull-right" id="vonoNome' + contadorVono + '" name="vonoNome' + contadorVono + '" required/></div></div></div>');
	}

	function recriar(index) {
		var strHTML = "";
		var counter = 0;
		for (var i = 1; i <= contadorVono; i++) {
			if (i == index) {
				continue;
			}
			counter++;
			var campo1 = document.getElementById('vono' + i).value;
			var campo2 = document.getElementById('vonoNome' + i).value;
			strHTML += '<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group"><label>Ramal ' + counter + ':</label><div class="input-group"><div class="input-group-addon"><a href="javascript:void(0);" onClick="recriar(' + counter + ')" title="Clique para deletar"><i class="fa fa-trash-o text-red"></i></a></div><input type="text" class="form-control pull-right" id="vono' + counter + '" name="vono' + counter + '" value="' + campo1 + '" required/></div></div></div><div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group"><label>Nome ' + counter + ':</label><div class="input-group"><div class="input-group-addon"><i class="fa fa-phone"></i></div><input type="text" class="form-control pull-right" id="vonoNome' + counter + '" name="vonoNome' + counter + '" value="' + campo2 + '" required/></div></div></div>';
		}
		contadorVono--;
		document.getElementById('qtdVono').value = contadorVono;
		document.getElementById('vono-tab').innerHTML = strHTML;
	}

	function adicionarCampanha() {
		contadorCampanhas++;
		document.getElementById('qtdCampanhas').value = contadorCampanhas;
		$("#lista-campanhas").append(stringCampanha(contadorCampanhas, "-1"));

		// Marca a opção de mostrar apenas as campanhas listadas
		checkMCP1();
	}

	function checkMCP0() {
		$("input[name=mostrarapenascampanhas][value='0']").prop("checked", true);
		$("#mcp0").attr('checked', true);
		$("#mcp1").attr('checked', false);
		$("#mcp2").attr('checked', false);
	}

	function checkMCP1() {
		$("input[name=mostrarapenascampanhas][value='1']").prop("checked", true);
		$("#mcp0").attr('checked', false);
		$("#mcp1").attr('checked', true);
		$("#mcp2").attr('checked', false);
	}

	function checkMCP2() {
		$("input[name=mostrarapenascampanhas][value='2']").prop("checked", true);
		$("#mcp0").attr('checked', false);
		$("#mcp1").attr('checked', false);
		$("#mcp2").attr('checked', true);
	}

	function recriarCampanhas(index) {
		var strHTML = "";
		var counter = 0;
		for (var i = 1; i <= contadorCampanhas; i++) {
			if (i == index) {
				continue;
			}
			counter++;
			var id = document.getElementById('idCampanha' + i).value;
			var idReal = document.getElementById('idCampanhaReal' + i).value;
			var nomeCampanha = document.getElementById('nomeCampanha' + i).value;
			strHTML += stringCampanha(counter, id, idReal, nomeCampanha);
		}
		contadorCampanhas--;
		document.getElementById('qtdCampanhas').value = contadorCampanhas;
		document.getElementById('lista-campanhas').innerHTML = strHTML;

		// Se não tiver nenhuma campanha a ser listada, marca a primeira opção
		if (contadorCampanhas == "0") {
			checkMCP0();
		}
	}

	function stringCampanha(numero, id = "-1", idReal = "", nomeCampanha = "Exemplo") {
		return '\
	<input id="idCampanha' + numero + '" name="idCampanha' + numero + '" type="hidden" value="' + id + '">\
	<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">\
		<label>ID da Campanha ' + numero + ':</label>\
		<div class="input-group">\
			<div class="input-group-addon"><a href="javascript:void(0);" onClick="recriarCampanhas(' + numero + ')" title="Clique para deletar"><i class="fa fa-trash text-red"></i></a></div>\
			<input type="text" class="form-control pull-right"  id="idCampanhaReal' + numero + '" name="idCampanhaReal' + numero + '" alt="ID da Campanha" value="' + idReal + '" maxlength="40" required />\
		</div>\
	</div></div>\
	<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">\
		<label>Nome da Campanha <?php echo $counter; ?>:</label>\
		<div class="input-group">\
			<div class="input-group-addon"><i class="fa fa-google"></i></div>\
			<input type="text" class="form-control pull-right"  id="nomeCampanha' + numero + '" name="nomeCampanha' + numero + '" alt="Nome da Campanha" value="' + nomeCampanha + '" required />\
		</div>\
	</div></div>';
	}
</script>


<form name="formDados" action="" method="POST" id="formDados">
	<div class="modal-header">
		<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
			<span aria-hidden="true">&times;</span></button>
		<h4 class="modal-title"><b>Editar cliente:</b> <?php echo $dados_cliente['TXT_NOME']; ?></h4>
		<h6><b>Último Acesso:</b> <?php echo $acesso; ?> / <b>Número de Acessos:</b> <?php echo $acessos; ?> <br><b>ID Criptografada:</b> <input id="idCrypto" style="width: 220px;outline: none;border: none;" type="text" readonly value="<?php echo $id_crypto; ?>" /> <small class="label bg-blue" style="cursor: pointer;font-size: 0.8em;" onclick="copiarCodigo('idCrypto');">copiar id</small><a href="https://tutoriais.win7.com.br/whatsapp.php?i=<?php echo $id_crypto; ?>" target="_blank"> <small class="label bg-green" style="cursor: pointer;font-size: 0.8em;">criar whats</small><a href="https://tutoriais.win7.com.br/sms.php?i=<?php echo $id_crypto; ?>" target="_blank"> <small class="label bg-navy" style="cursor: pointer;font-size: 0.8em;">criar sms</small></a></h6>
	</div>
	<div class="modal-body">
		<div class="nav-tabs-custom">
			<ul class="nav nav-tabs">
				<li class="active"><a href="#tab_1" data-toggle="tab">Geral</a></li>
				<li><a href="#tab_2" data-toggle="tab">Subusuários</a></li>
				<li><a href="#tab_3" data-toggle="tab">Google Ads</a></li>
				<li><a href="#tab_5" data-toggle="tab">Win7 Fone</a></li>
				<li><a href="#tab_4" data-toggle="tab">Permissões</a></li>
				<li><a href="#tab_6" data-toggle="tab">LP WhatsApps</a></li>
				<li><a href="#tab_7" data-toggle="tab">LP SMSs</a></li>
				<li><a href="#tab_8" data-toggle="tab">LP Emails</a></li>
			</ul>
			<div class="tab-content">
				<div class="tab-pane active" id="tab_1">
					<div class="row">
						<div class="col-xs-12">
							<div class="form-group">
								<div class="checkbox">
									<label>
										<input type="checkbox" name="clienteativo" id="clienteativo" value="Sim" <?php echo $cliente_ativo; ?>>
										Cliente Ativo&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="clienteimportante" id="clienteimportante" value="Sim" <?php echo $cliente_importante; ?>>
										Cliente Importante&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="win7phoneativo" id="win7phoneativo" value="Sim" <?php echo $win7phone_ativo; ?>>
										Win7 Fone Ativo&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="mascaraddi" id="mascaraddi" value="Sim" <?php echo $mascara_ddi; ?>>
										Máscara Telefone DDI&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="linkclique" id="linkclique" value="Sim" <?php echo $linkclique; ?>>
										Cliques Personalizados LP&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-xs-12 col-sm-6 col-md-3">
							<div class="form-group">
								<label>Nome:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-user"></i></div>
									<input type="text" class="form-control pull-right" id="nome" name="nome" alt="Nome" value="<?php echo $dados_cliente['TXT_NOME']; ?>" required />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-3">
							<div class="form-group">
								<label>Login:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-user"></i></div>
									<input type="text" class="form-control pull-right" id="login" name="login" alt="Login" value="<?php echo $dados_cliente['TXT_LOGIN']; ?>" required />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-3">
							<div class="form-group">
								<label>Empresa:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-building"></i></div>
									<input type="text" class="form-control pull-right" id="empresa" name="empresa" alt="Empresa" value="<?php echo $dados_cliente['TXT_NOME_EMPRESA']; ?>" required />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-3">
							<div class="form-group">
								<label>Senha:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-lock"></i></div>
									<input type="text" class="form-control pull-right" id="senha" name="senha" alt="Senha" />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Atendente 1:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-envelope"></i></div>
									<input type="text" class="form-control pull-right" id="email1" name="email1" alt="Atendente 1" value="<?php echo $dados_cliente['TXT_EMAIL']; ?>" />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Atendente 2:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-envelope"></i></div>
									<input type="text" class="form-control pull-right" id="email2" name="email2" alt="Atendente 2" value="<?php echo $dados_cliente['TXT_EMAIL_2']; ?>" />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-12 col-md-4">
							<div class="form-group">
								<label>Tags:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-tag"></i></div>
									<input type="text" class="form-control pull-right" id="tags" name="tags" alt="Tags" value="<?php echo $dados_cliente['TXT_RAMO']; ?>" />
								</div>
							</div>
						</div>
					</div>

					<div class="row">
						<div class="col-xs-12 col-sm-12 col-md-5">
							<div class="form-group">
								<div style="display: flex; justify-content: space-between; align-items: center;">
									<label>Seguimento: </label>
									<small class="label bg-blue" style="cursor: pointer;" onclick="modalAdicionarSeguimentos()">adicionar</small>
								</div>
								<div class="input-group" style="width: 100%;">
									<!-- <div class="input-group-addon"><i class="fa fa-edit"></i></div> -->
									<select name="sqlSeguimento" for="slct" id="sqlSeguimento" class="js-example-basic-multiple">
										<!-- <option value="" selected disabled>Selecione:</option> -->
										<?php
										if (empty($seguimento_cliente)) {
											echo '<option value="" selected disabled>Selecione:</option>';
										}

										foreach ($todosSeguimentos as $seguimento) {
											if ($seguimento['ID'] == $seguimento_cliente) {
												echo '<option value="' . $seguimento['ID'] . '" selected >' . $seguimento['TXT_SEGUIMENTO'] . '</option>';
											} else {
												echo '<option value="' . $seguimento['ID'] . '">' . $seguimento['TXT_SEGUIMENTO'] . '</option>';
											}
										}
										?>
									</select>
								</div>
							</div>
						</div>

						<div class="col-xs-12 col-sm-12 col-md-7">
							<div class="form-group">
								<label title="A string #TELEFONE# será substituída pelo telefone">URL Botão Contato: </label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-edit"></i></div>
									<input type="text" class="form-control pull-right" id="txturlbtncontato" name="txturlbtncontato" alt="Url botão contato" value="<?php echo $dados_cliente['TXT_URL_BTN_CONTATO']; ?>" />
								</div>
							</div>
						</div>
					</div>

					<div class="row">
						<div class="col-xs-12 col-md-5">
							<div class="row">
								<div class="col-xs-12 col-sm-6 col-md-6">
									<div class="form-group">
										<label>Telefone 1:</label>
										<div class="input-group">
											<div class="input-group-addon"><i class="fa fa-phone"></i></div>
											<input type="text" class="form-control pull-right" id="telefone1" name="telefone1" alt="Telefone 1" value="<?php echo $dados_cliente['NU_TELEFONE_1']; ?>" />
										</div>
									</div>
								</div>
								<div class="col-xs-12 col-sm-6 col-md-6">
									<div class="form-group">
										<label>Telefone 2:</label>
										<div class="input-group">
											<div class="input-group-addon"><i class="fa fa-phone"></i></div>
											<input type="text" class="form-control pull-right" id="telefone2" name="telefone2" alt="Telefone 2" value="<?php echo $dados_cliente['NU_TELEFONE_2']; ?>" />
										</div>
									</div>
								</div>
								<div class="col-xs-12">
									<div class="form-group">
										<label>ID do Tag Manager:</label>
										<div class="input-group">
											<div class="input-group-addon"><i class="fa fa-edit"></i></div>
											<input type="text" class="form-control pull-right" id="tagforms" name="tagforms" value="<?php echo $tag_forms; ?>" />
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-md-7">
							<div class="row">
								<div class="col-xs-12">
									<div class="form-group">
										<label>Anotações:</label>
										<textarea name="anotacoes" id="anotacoes" class="form-control" rows="5"><?php echo $dados_cliente['TXT_ANOTACOES']; ?></textarea>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="tab-pane" id="tab_2">
					<div class="row">
						<div class="col-xs-12">
							<div class="form-group">
								<input id="qtdUsuarios" name="qtdUsuarios" type="hidden" value="<?php echo count($subusuarios); ?>">
								<a href="javascript:void(0);" onclick="adicionarSubusuario();" class="btn btn-primary">Adicionar Subusuário</a>
							</div>
						</div>
					</div>
					<?php
					$numero_de_ids = count($subusuarios);
					for ($index = 0; $index < $numero_de_ids; $index++) {
						$counter = $index + 1;
						$usuario_banco = $subusuarios[$index];
						$nome_usuario = $usuario_banco['TXT_NOME'];
						$id_usuario = $usuario_banco['NU_ID'];
						$login_usuario = $usuario_banco['TXT_LOGIN'];
						$perm_indicacoes = $usuario_banco['NU_PERM_INDICACOES'];
						$perm_contatos = $usuario_banco['NU_PERM_CONTATOS'];
						$perm_adwords = $usuario_banco['NU_PERM_ADWORDS'] == "2" ? "" : "checked='checked'";
						$perm_log = $usuario_banco['NU_PERM_LOG'] == "2" ? "" : "checked='checked'";
						$perm_win7fone = $usuario_banco['NU_PERM_WIN7FONE'] == "2" ? "" : "checked='checked'";
						$dados_gerais_sub = $usuario_banco['NU_ATIVAR_DADOS_GERAIS'] == "0" ? "" : "checked='checked'";
						$home_sub = $usuario_banco['TXT_HOME'] ?>
						<input id="idUsuario<?php echo $counter; ?>" name="idUsuario<?php echo $counter; ?>" type="hidden" value="<?php echo $id_usuario; ?>">
						<div class="panel panel-default">
							<div class="panel-heading">Subusuário <?php echo $counter; ?></div>
							<div class="panel-body">
								<div class="row">
									<div class="col-xs-12">
										<div class="form-group">
											<div class="checkbox">
												<label>
													<input type="checkbox" name="adwordsPerm<?php echo $counter; ?>" id="adwordsPerm<?php echo $counter; ?>" value="Sim" <?php echo $perm_adwords; ?>>
													Permitir Acesso ao Adwords&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
												</label>
												<label>
													<input type="checkbox" name="logPerm<?php echo $counter; ?>" id="logPerm<?php echo $counter; ?>" value="Sim" <?php echo $perm_log; ?>>
													Permitir Acesso ao Log&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
												</label>
												<label>
													<input type="checkbox" name="win7fonePerm<?php echo $counter; ?>" id="win7fonePerm<?php echo $counter; ?>" value="Sim" <?php echo $perm_win7fone; ?>>
													Permitir Acesso ao Win7 Fone&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
												</label>
												<label>
													<input type="checkbox" name="dadosgerais<?php echo $counter; ?>" id="dadosgerais<?php echo $counter; ?>" value="Sim" <?php echo $dados_gerais_sub; ?>>
													Permitir Acesso aos Dados Gerais&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
												</label>
											</div>
										</div>
									</div>
									<div class="col-xs-12 col-sm-6 col-md-4">
										<div class="form-group">
											<label>Nome:</label>
											<div class="input-group">
												<div class="input-group-addon"><i class="fa fa-user"></i></div>
												<input type="text" class="form-control pull-right" id="subusuarioNome<?php echo $counter; ?>" name="subusuarioNome<?php echo $counter; ?>" value="<?php echo $nome_usuario; ?>" required />
											</div>
										</div>
									</div>
									<div class="col-xs-12 col-sm-6 col-md-4">
										<div class="form-group">
											<label>Login:</label>
											<div class="input-group">
												<div class="input-group-addon"><i class="fa fa-user"></i></div>
												<input type="text" class="form-control pull-right" id="subusuarioLogin<?php echo $counter; ?>" name="subusuarioLogin<?php echo $counter; ?>" value="<?php echo $login_usuario; ?>" required />
											</div>
										</div>
									</div>
									<div class="col-xs-12 col-sm-6 col-md-4">
										<div class="form-group">
											<label>Senha:</label>
											<div class="input-group">
												<div class="input-group-addon"><i class="fa fa-lock"></i></div>
												<input type="text" class="form-control pull-right" id="subusuarioSenha<?php echo $counter; ?>" name="subusuarioSenha<?php echo $counter; ?>" />
											</div>
										</div>
									</div>
									<div class="col-xs-12 col-sm-6 col-md-4">
										<div class="form-group">
											<label>Indicações:</label>
											<div class="input-group">
												<div class="input-group-addon"><i class="fa fa-smile-o"></i></div>
												<select name="indicacoesPerm<?php echo $counter; ?>" id="indicacoesPerm<?php echo $counter; ?>" class="form-control pull-right">
													<option value="0" <?php if ($perm_indicacoes == "0") {
																							echo " selected";
																						} ?>>Permitir Leitura</option>
													<option value="1" <?php if ($perm_indicacoes == "1") {
																							echo " selected";
																						} ?>>Permitir Modificação</option>
													<option value="2" <?php if ($perm_indicacoes == "2") {
																							echo " selected";
																						} ?>>Não Permitir</option>
												</select>
											</div>
										</div>
									</div>
									<div class="col-xs-12 col-sm-6 col-md-4">
										<div class="form-group">
											<label>Contatos:</label>
											<div class="input-group">
												<div class="input-group-addon"><i class="fa fa-users"></i></div>
												<select name="contatosPerm<?php echo $counter; ?>" id="contatosPerm<?php echo $counter; ?>" class="form-control pull-right">
													<option value="0" <?php if ($perm_contatos == "0") {
																							echo " selected";
																						} ?>>Permitir Leitura</option>
													<option value="1" <?php if ($perm_contatos == "1") {
																							echo " selected";
																						} ?>>Permitir Modificação</option>
													<option value="2" <?php if ($perm_contatos == "2") {
																							echo " selected";
																						} ?>>Não Permitir</option>
												</select>
											</div>
										</div>
									</div>
									<div class="col-xs-12 col-sm-6 col-md-4">
										<div class="form-group">
											<label>Página Inicial:</label>
											<div class="input-group">
												<div class="input-group-addon"><i class="fa fa-home"></i></div>
												<select name="inicioSubusuario<?php echo $counter; ?>" id="inicioSubusuario<?php echo $counter; ?>" class="form-control pull-right">
													<?php $sistema->layout->select_home($home_sub); ?>
												</select>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					<?php } ?>
				</div>
				<div class="tab-pane" id="tab_3">
					<div class="row">
						<div class="col-xs-12">
							<div class="form-group">
								<div class="checkbox">
									<label>
										<input type="checkbox" name="permpausarcampanhas" id="permpausarcampanhas" value="Sim" <?php echo $perm_pausar_campanhas; ?>>
										Permitir Pausamento de Campanhas&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="consultoria" id="consultoria" value="Sim" <?php echo $consultoria; ?>>
										Ativar Consultoria&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<!-- <label>
										<input type="checkbox" name="mostrarapenascampanhas" id="mostrarapenascampanhas" value="Sim" <?php echo $mostrar_apenas_campanhas; ?>>
										Mostrar Apenas Campanhas Listadas&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label> -->
									<label>
										<input type="checkbox" name="mostrarcpl" id="mostrarcpl" value="Sim" <?php echo $mostrar_cpl; ?>>
										Permitir visualização do CPL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-xs-12 col-sm-4 col-md-3">
							<div class="form-group">
								<label>Google Ads:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-google"></i></div>
									<input type="text" class="form-control pull-right" id="adwords" name="adwords" alt="Adwords" value="<?php echo $dados_cliente['NU_ADWORDS']; ?>" />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-4 col-md-3">
							<div class="form-group">
								<label>Limite do CPL:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-google"></i></div>
									<input type="text" class="form-control pull-right dinheiro" id="limitecpl" name="limitecpl" alt="Limite do CPL" value="<?php echo $limite_custo_lead; ?>" />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-4 col-md-3">
							<div class="form-group">
								<label>Moeda do Ads:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-dollar"></i></div>
									<select name="moedaadwords" id="moedaadwords" class="form-control pull-right">
										<?php $sistema->layout->select_moedas($moeda_adwords); ?>
									</select>
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-4 col-md-3">
							<div class="form-group">
								<label>Data Inicial:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-calendar"></i></div>
									<input type="text" class="form-control pull-right datepicker" id="datainicialads" name="datainicialads" alt="Data Inicial" value="<?php echo $dados_cliente['DT_INICIOADS']; ?>" />
								</div>
							</div>
						</div>
					</div>
					<hr>
					<div class="row">
						<div class="col-xs-12">
							<div class="form-group">
								<input id="qtdCampanhas" name="qtdCampanhas" type="hidden" value="<?php echo count($campanhas); ?>">
								<button type="button" onClick='adicionarCampanha()' class="btn btn-primary" style="float: left; margin-right: 14px">Adicionar Campanha</button>
								<div class="switch-toggle">
									<input id="mcp0" name="mostrarapenascampanhas" value="0" type="radio" <?php echo $mostrar_apenas_campanhas == "0" ? "checked" : ""; ?> />
									<label for="mcp0" onclick="checkMCP0()" title="Ignora as campanhas abaixo e busca todas as campanhas.">Todas</label>
									<input id="mcp1" name="mostrarapenascampanhas" value="1" type="radio" <?php echo $mostrar_apenas_campanhas == "1" ? "checked" : ""; ?> />
									<label for="mcp1" onclick="checkMCP1()" title="Busca apenas as campanhas abaixo.">Apenas estas</label>
									<input id="mcp2" name="mostrarapenascampanhas" value="2" type="radio" <?php echo $mostrar_apenas_campanhas == "2" ? "checked" : ""; ?> />
									<label for="mcp2" onclick="checkMCP2()" title="Busca todas as campanhas, menos as de abaixo.">Todas menos estas</label>
								</div>
							</div>
						</div>
					</div>
					<div class="row lista-campanhas" id="lista-campanhas">
						<?php
						$counter = 1;
						foreach ($campanhas as $campanha) {
							$id_campanha1 = $campanha['NU_ID'];
							$id_campanha2 = $campanha['ID_CAMPANHA'];
							$nome_campanha = $campanha['TXT_NOME'];
						?>
							<input id="idCampanha<?php echo $counter; ?>" name="idCampanha<?php echo $counter; ?>" type="hidden" value="<?php echo $id_campanha1; ?>">
							<div class="col-xs-12 col-sm-6 col-md-3">
								<div class="form-group">
									<label>ID da Campanha <?php echo $counter; ?>:</label>
									<div class="input-group">
										<div class="input-group-addon"><a href="javascript:void(0);" onClick="recriarCampanhas(<?php echo $counter; ?>)" title="Clique para deletar"><i class="fa fa-trash text-red"></i></a></div>
										<input type="text" class="form-control pull-right" id="idCampanhaReal<?php echo $counter; ?>" name="idCampanhaReal<?php echo $counter; ?>" alt="ID da Campanha" value="<?php echo $id_campanha2; ?>" maxlength="40" required />
									</div>
								</div>
							</div>
							<div class="col-xs-12 col-sm-6 col-md-3">
								<div class="form-group">
									<label>Nome da Campanha <?php echo $counter; ?>:</label>
									<div class="input-group">
										<div class="input-group-addon"><i class="fa fa-google"></i></div>
										<input type="text" class="form-control pull-right" id="nomeCampanha<?php echo $counter; ?>" name="nomeCampanha<?php echo $counter; ?>" alt="Nome da Campanha" value="<?php echo $nome_campanha; ?>" required />
									</div>
								</div>
							</div>
						<?php
							$counter++;
						} ?>
					</div>
				</div>
				<div class="tab-pane" id="tab_4">
					<div class="row">
						<div class="col-xs-12">
							<div class="form-group">
								<div class="checkbox">
									<label>
										<input type="checkbox" name="logativo" id="logativo" value="Sim" <?php echo $log_ativo; ?>>
										Ativar Log&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="dadosgeraisativo" id="dadosgeraisativo" value="Sim" <?php echo $dadosgerais_ativo; ?>>
										Ativar Dados Gerais&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="google" id="google" value="Sim" <?php echo $google; ?>>
										Ativar Campanhas&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="ligacoes" id="ligacoes" value="Sim" <?php echo $ligacoes; ?>>
										Ativar Win7 Fone&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="leads" id="leads" value="Sim" <?php echo $leads; ?>>
										Ativar Leads&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="comparacao" id="comparacao" value="Sim" <?php echo $comparacao; ?>>
										Ativar Comparação Dados Gerais&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="btnaddlead" id="btnaddlead" value="Sim" <?php echo $btnaddlead; ?>>
										Ocultar botão "Adicionar Contato"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Página Inicial:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-home"></i></div>
									<select name="paginainicial" id="paginainicial" class="form-control pull-right">
										<?php $sistema->layout->select_home($home); ?>
									</select>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="tab-pane" id="tab_5">
					<div class="row">
						<div class="col-xs-12">
							<div class="form-group">
								<div class="checkbox">
									<label>
										<input type="checkbox" name="mostrartotalligacoes" id="mostrartotalligacoes" value="Sim" <?php echo $mostrar_total_ligacoes; ?>>
										Mostrar total real de ligações&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="agruparligacoes" id="agruparligacoes" value="Sim" <?php echo $agrupar_ligacoes; ?>>
										Agrupar ligações de mesma origem&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="esconderligacoesefetuadas" id="esconderligacoesefetuadas" value="Sim" <?php echo $ligacoes_efetuadas; ?>>
										Esconder ligações efetuadas&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-xs-12 col-md-4">
							<div class="form-group">
								<label>Valor das Ligações:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-dollar"></i></div>
									<input type="text" class="form-control pull-right" id="valor-ligacoes" name="valor-ligacoes" alt="Valor das Ligações" value="<?php echo $dados_cliente['NU_PRECO_LIGACAO']; ?>" />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-md-4">
							<div class="form-group">
								<label>Data Inicial:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-calendar"></i></div>
									<input type="text" class="form-control pull-right" id="datainicial" name="datainicial" alt="Data Inicial" value="<?php echo $dados_cliente['DT_VONOINICIO']; ?>" />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-md-4">
							<div class="form-group">
								<label>Data Final:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-calendar"></i></div>
									<input type="text" class="form-control pull-right" id="datafinal" name="datafinal" alt="Data Final" value="<?php echo $dados_cliente['DT_VONOFIM']; ?>" />
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-xs-12">
							<div class="form-group">
								<input id="qtdVono" name="qtdVono" type="hidden" value="<?php echo count($vono_ids); ?>">
								<a href="javascript:void(0);" onClick='adicionarID()' class="btn btn-primary">Adicionar Registro</a>
							</div>
						</div>
					</div>
					<div class="row" id="vono-tab">
						<?php
						$numero_de_ids = count($vono_ids);
						for ($index = 0; $index < $numero_de_ids; $index++) {
							$counter = $index + 1;
							$campo1 = $vono_ids[$index][0];
							$campo2 = $vono_ids[$index][1]; ?>
							<div class="col-xs-12 col-sm-6 col-md-3">
								<div class="form-group">
									<label>Ramal <?php echo $counter; ?>:</label>
									<div class="input-group">
										<div class="input-group-addon"><a href="javascript:void(0);" onClick="recriar(<?php echo $counter; ?>)" title="Clique para deletar"><i class="fa fa-trash-o text-red"></i></a></div>
										<input type="text" class="form-control pull-right" id="vono<?php echo $counter; ?>" name="vono<?php echo $counter; ?>" value="<?php echo $campo1; ?>" required />
									</div>
								</div>
							</div>
							<div class="col-xs-12 col-sm-6 col-md-3">
								<div class="form-group">
									<label>Nome <?php echo $counter; ?>:</label>
									<div class="input-group">
										<div class="input-group-addon"><i class="fa fa-phone"></i></div>
										<input type="text" class="form-control pull-right" id="vonoNome<?php echo $counter; ?>" name="vonoNome<?php echo $counter; ?>" value="<?php echo $campo2; ?>" required />
									</div>
								</div>
							</div>
						<?php } ?>
					</div>
				</div>

				<div class="tab-pane" id="tab_6">
					<div class="row">
						<div class="col-xs-12">
							<div class="form-group">
								<div class="checkbox">
									<label>
										<input type="checkbox" name="whatsapp" id="whatsapp" value="Sim" <?php echo $whatsapp; ?>>
										Ativar Whatsapp&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
								</div>
							</div>
						</div>
					</div>

					<div class="whatsAppContainerBanco">
						<div class="row">
							<div class="col-xs-12">
								<div class="form-group">
									<hr style="margin-top: 0px;margin-bottom: 10px;">
									<label>Buscar os números de WhatsApp no banco? </label>
									&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									<label>
										<input type="radio" name="whatsBanco" id="whatsRadioBanco1" value="sim" <?php echo $bancoAtivo ?>> Sim
									</label>
									&nbsp;&nbsp;&nbsp;&nbsp;
									<label>
										<input type="radio" name="whatsBanco" id="whatsRadioBanco2" value="nao" <?php echo $linkAtivo ?>> Não
									</label>
									<br>
									<span style="color:red;">Obs.: Se marcado o "Não" daí será usado o telefone que tem nos links de WhatsApp da página. (CONFIRA OS LINKS DA PÁGINA!) </span>
								</div>
							</div>
						</div>
					</div>

					<div class="whatsAppContainerNumbers">
						<div class="row">
							<div class="col-xs-12">
								<div class="form-group">
									<hr style="margin-top: 0px;margin-bottom: 10px;">
									<label>NÚMEROS DE WHATSAPP:</label><br>
									<span>* O primeiro número abaixo é o próximo a receber o contato do LEAD (no caso de 2 ou mais números)</span><br>
									<span style="color:red;">** Digitar os números respeitando as máscaras. Elas se adaptam inicialmente ao código do país.</span><br>
									<span style="color:red;">Exemplos: +55(61)90000-0000 ou +55(61)0000-0000 ou +1(000)000-0000</span><br>
									<input id="qtdWhatApps" name="qtdWhatApps" type="hidden" value="<?php echo count($whatsAppsNumerosArray); ?>">
								</div>
							</div>
						</div>

						<div class="row" id="whatsapp-tab">
							<?php
							$numero_de_ids = count($whatsAppsNumerosArray);
							for ($index = 0; $index < $numero_de_ids; $index++) {
								$counter = $index + 1;
								$campo1 = $whatsAppsNumerosArray[$index];
							?>

								<div class="col-xs-12 col-sm-6 col-md-3">
									<div class="form-group">
										<label>WhatsApp <?php echo $counter; ?>:</label>
										<div class="input-group">
											<div class="input-group-addon"><a href="javascript:void(0);" onClick="recriarWhats(<?php echo $counter; ?>)" title="Clique para deletar"><i class="fa fa-trash-o text-red"></i></a></div>
											<input type="text" class="form-control pull-right numerosWhatsApp" id="whats<?php echo $counter; ?>" name="whatsappInput[]" value="<?php echo $campo1; ?>" />
										</div>
									</div>
								</div>

							<?php } ?>
						</div>

						<div class="row">
							<div class="col-xs-12">
								<a href="javascript:void(0);" onClick='adicionarNumeroWhatsApp()' class="btn btn-primary">Adicionar WhatsApp</a>
							</div>
						</div>
					</div>

				</div>
				<div class="tab-pane" id="tab_7">
					<div class="row">
						<div class="col-xs-12">
							<div class="form-group">
								<div class="checkbox">
									<label>
										<input type="checkbox" name="sms" id="sms" value="Sim" <?php echo $sms; ?>>
										Ativar SMS&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
								</div>
							</div>
						</div>
					</div>

					<div class="smsAppContainerBanco">
						<div class="row">
							<div class="col-xs-12">
								<div class="form-group">
									<hr style="margin-top: 0px;margin-bottom: 10px;">
									<label>Buscar os números de SMS no banco? </label>
									&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									<label>
										<!-- <input type="radio" name="smsBanco" id="smsRadioBanco1" value="sim" <?php echo $smsBancoAtivo ?>> Sim -->
										<input type="radio" name="smsBanco" id="smsRadioBanco1" value="sim" checked> Sim
									</label>
									<!-- &nbsp;&nbsp;&nbsp;&nbsp;
									<label>
										<input type="radio" name="smsBanco" id="smsRadioBanco2" value="nao" <?php echo $smsLinkAtivo ?>> Não
									</label>
									<br>
									<span style="color:red;">Obs.: Se marcado o "Não" daí será usado o telefone que tem nos links de SMS da página. (CONFIRA OS LINKS DA PÁGINA!) </span> -->
								</div>
							</div>
						</div>
					</div>

					<div class="smsContainerNumbers">
						<div class="row">
							<div class="col-xs-12">
								<div class="form-group">
									<hr style="margin-top: 0px;margin-bottom: 10px;">
									<label>NÚMEROS DE SMS:</label><br>
									<span>* O primeiro número abaixo é o próximo a receber o contato do LEAD (no caso de 2 ou mais números)</span><br>
									<span style="color:red;">** Digitar os números respeitando as máscaras. Elas se adaptam inicialmente ao código do país.</span><br>
									<span style="color:red;">Exemplos: +55(61)90000-0000 ou +55(61)0000-0000 ou +1(000)000-0000</span><br>
									<input id="qtdSMS" name="qtdSMS" type="hidden" value="<?php echo count($smsNumerosArray); ?>">
								</div>
							</div>
						</div>

						<div class="row" id="sms-tab">
							<?php
							$sms_numero_de_ids = count($smsNumerosArray);
							for ($sms_index = 0; $sms_index < $sms_numero_de_ids; $sms_index++) {
								$sms_counter = $sms_index + 1;
								$sms_campo1 = $smsNumerosArray[$sms_index];
							?>

								<div class="col-xs-12 col-sm-6 col-md-3">
									<div class="form-group">
										<label>SMS <?php echo $sms_counter; ?>:</label>
										<div class="input-group">
											<div class="input-group-addon"><a href="javascript:void(0);" onClick="recriarSMS(<?php echo $sms_counter; ?>)" title="Clique para deletar"><i class="fa fa-trash-o text-red"></i></a></div>
											<input type="text" class="form-control pull-right numerosSMS" id="sms<?php echo $sms_counter; ?>" name="smsInput[]" value="<?php echo $sms_campo1; ?>" />
										</div>
									</div>
								</div>

							<?php } ?>
						</div>

						<div class="row">
							<div class="col-xs-12">
								<a href="javascript:void(0);" onClick='adicionarNumeroSMS()' class="btn btn-primary">Adicionar SMS</a>
							</div>
						</div>
					</div>

				</div>

				<div class="tab-pane" id="tab_8">

					<div class="row">
						<div class="col-xs-12">
							<div class="form-group">
								<div class="checkbox">
									<label>
										<input type="checkbox" name="puxaEmailsBD" id="puxaEmailsBD" value="Sim" <?php echo $formAtivo ? 'checked' : ''; ?>>
										Puxar e-mails do banco de dados <strong style="color:red">(DESMARCAR com formulários ativos IRÁ EXCLUIR TODOS ELES, sem volta.)</strong>
									</label>
								</div>
							</div>
						</div>
					</div>

					<div id="mostrarForms" <?php echo $formAtivo ? '' : 'style="display:none;"'; ?>>

						<div class="row">
							<div class="col-xs-12">
								<div class="form-group">
									<input id="qtdForms" name="qtdForms" type="hidden" value="<?php echo $quantidadeForms; ?>">
									<a href="javascript:void(0);" id="btnAdicionarForm" onclick="adicionarFormulario();" class="btn btn-primary">Adicionar Email(s)</a>
								</div>
							</div>
						</div>

						<?php
						// Verifica se tem o formulário configurado
						if ($quantidadeForms >= 1) {
						?>
							<?php
							// LOOP DOS FORMULÁRIOS VINDOS DO BANCO
							for ($i = 0; $i <= $quantidadeForms - 1; $i++) {
								$counterForms++;
							?>

								<div class="panel panel-default" id="form<?php echo $counterForms; ?>">
									<div class="panel-heading"><input type="text" class="form-control pull-left input-nome-form" id="nomeform<?php echo $counterForms; ?>" name="nomeform<?php echo $counterForms; ?>" value="<?php echo $formularios[$i]['nome']; ?>" placeholder="Identifique esse grupo:" required />
										<b>ID Form:</b> <input type="text" class="input-form-id" name="formid<?php echo $counterForms; ?>" id="formid<?php echo $counterForms; ?>" value="<?php echo $formularios[$i]['id'] ?>" readonly></input>
										<small class="label bg-blue" style="cursor: pointer;margin-left:6px;" onclick="copiarCodigo('formid<?php echo $counterForms; ?>');">copiar</small><a href="https://tutoriais.win7.com.br/whatsapp.php?i=<?php echo $id_crypto; ?>&ie=<?php echo $formularios[$i]['id']; ?>" target="_blank"> <small class="label bg-green" style="cursor: pointer;font-size: 0.8em;">criar whats</small></a><a href="https://tutoriais.win7.com.br/sms.php?i=<?php echo $id_crypto; ?>&ie=<?php echo $formularios[$i]['id']; ?>" target="_blank"> <small class="label bg-navy" style="cursor: pointer;font-size: 0.8em;">criar sms</small></a>
										<div class="btnExcluirForm">
											<a href="javascript:void(0);" onClick="removerForm('<?php echo $counterForms; ?>')"><i id="trashIcon<?php echo $counterForms; ?>" class="fa fa-trash-o text-red"></i></a>
											<input type="hidden" name="excluirForm<?php echo $counterForms; ?>" id="excluirForm<?php echo $counterForms; ?>" value="0">
										</div>
									</div>

									<div class="panel-heading grid-form-top">
										<div class="form-group">
											<label title="Nome usado apenas nos e-mails enviados para os leads">Nome empresa:</label>
											<div class="input-group">
												<div class="input-group-addon"><i class="fa fa-user"></i></div>
												<input type="text" class="form-control pull-right" id="formnomeempresa<?php echo $counterForms . $counterFormEmails; ?>" name="formnomeempresa<?php echo $counterForms; ?>" value="<?php echo $formularios[$i]['nomeempresa']; ?>" required />
											</div>
										</div>

										<div class="form-group">
											<label>Assunto do e-mail enviado para o lead:</label>
											<div class="input-group">
												<div class="input-group-addon"><i class="fa fa-envelope-o"></i></div>
												<input type="text" class="form-control pull-right" id="formemailassunto<?php echo $counterForms . $counterFormEmails; ?>" name="formemailassunto<?php echo $counterForms; ?>" value="<?php echo $formularios[$i]['assuntoemail']; ?>" required />
											</div>
										</div>

										<div class="form-group">
											<label title="Se sim, retira a mensagem de 'Anúncios Google/Agência Win7' do assunto do e-mail">Orgânico?</label>
											<style>
												#switchSimNao #no<?php echo $counterForms . $counterFormEmails; ?>:checked~.switch {
													background: #eb4f37;
												}

												#switchSimNao #no<?php echo $counterForms . $counterFormEmails; ?>:checked~.switch span {
													background: #fff;
													margin-left: -8px;
												}

												#switchSimNao #no<?php echo $counterForms . $counterFormEmails; ?>:checked~.switch span:after {
													background: #fff;
													height: 20px;
													margin-top: -8px;
													margin-left: 8px;
												}

												#switchSimNao label[for=yes<?php echo $counterForms . $counterFormEmails; ?>] {
													position: absolute;
													left: 0px;
													height: 22px;
													border-radius: 15px 0px 0px 15px;
													padding: 0px 1px 0px 4px;
													width: 33px;
												}

												#switchSimNao label[for=no<?php echo $counterForms . $counterFormEmails; ?>] {
													position: absolute;
													right: 0px;
													padding: 0px 0px 0px 0px;
													width: 33px;
													border-radius: 0px 15px 15px 0px;
												}

												#switchSimNao #yes<?php echo $counterForms . $counterFormEmails; ?>:checked~.switch label[for=yes<?php echo $counterForms . $counterFormEmails; ?>] {
													color: #fff;
													font-weight: bold;
												}

												#switchSimNao #no<?php echo $counterForms . $counterFormEmails; ?>:checked~.switch label[for=no<?php echo $counterForms . $counterFormEmails; ?>] {
													color: #fff;
													font-weight: bold;
												}
											</style>

											<div id="switchSimNao">
												<input type="radio" id="yes<?php echo $counterForms . $counterFormEmails; ?>" name="formYesNo<?php echo $counterForms . $counterFormEmails; ?>" value="Sim" <?php echo $formularios[$i]['formorganico'] == '1' ? 'checked' : ''; ?> onclick="setaValorFormOrganico('1', 'formorganico<?php echo $counterForms . $counterFormEmails; ?>')">
												<input type="radio" id="no<?php echo $counterForms . $counterFormEmails; ?>" name="formYesNo<?php echo $counterForms . $counterFormEmails; ?>" value="Nao" <?php echo $formularios[$i]['formorganico'] == '0' ? 'checked' : ''; ?> onclick="setaValorFormOrganico('0', 'formorganico<?php echo $counterForms . $counterFormEmails; ?>')">
												<div class="switch">
													<label for="yes<?php echo $counterForms . $counterFormEmails; ?>">Sim</label>
													<label for="no<?php echo $counterForms . $counterFormEmails; ?>">Não</label>
												</div>
											</div>
											<input type="hidden" id="formorganico<?php echo $counterForms . $counterFormEmails; ?>" name="formorganico<?php echo $counterForms; ?>" value="<?php echo $formularios[$i]['formorganico']; ?>">

										</div>
									</div>



									<div class="panel-body">
										<div id="emailsContainer<?php echo $counterForms; ?>">
											<?php
											// LOOP DOS E-MAILS DOS CLIENTES
											foreach ($formularios[$i]['emails'] as $dadosEmailsCliente) {
												$counterFormEmails++;
											?>

												<div class="row bottom-line-dotted row<?php echo $counterForms . $counterFormEmails; ?>">
													<div class="col-xs-12 col-sm-6 col-md-3">
														<div class="form-group">
															<label>Nome:</label>
															<div class="input-group">
																<div class="input-group-addon"><i class="fa fa-user"></i></div>
																<input type="text" class="form-control pull-right" id="formNome<?php echo $counterForms . $counterFormEmails; ?>" name="formNomeEmailAtivo<?php echo $counterForms; ?>[]" value="<?php echo $dadosEmailsCliente[0] ?>" required />
															</div>
														</div>
													</div>
													<div class="col-xs-12 col-sm-6 col-md-5">
														<div class="form-group">
															<label>Email:</label>
															<div class="input-group">
																<div class="input-group-addon"><i class="fa fa-at"></i></div>
																<input type="email" class="form-control pull-right" id="formEmail<?php echo $counterForms . $counterFormEmails; ?>" name="formNomeEmailAtivo<?php echo $counterForms; ?>[]" value="<?php echo $dadosEmailsCliente[1] ?>" required />
															</div>
														</div>
													</div>
													<div class="col-xs-6 col-sm-6 col-md-2">
														<div class="form-group">
															<label>Enviar e-mail?</label>
															<style>
																#switchSimNao #no<?php echo $counterForms . $counterFormEmails; ?>:checked~.switch {
																	background: #eb4f37;
																}

																#switchSimNao #no<?php echo $counterForms . $counterFormEmails; ?>:checked~.switch span {
																	background: #fff;
																	margin-left: -8px;
																}

																#switchSimNao #no<?php echo $counterForms . $counterFormEmails; ?>:checked~.switch span:after {
																	background: #fff;
																	height: 20px;
																	margin-top: -8px;
																	margin-left: 8px;
																}

																#switchSimNao label[for=yes<?php echo $counterForms . $counterFormEmails; ?>] {
																	position: absolute;
																	left: 0px;
																	height: 22px;
																	border-radius: 15px 0px 0px 15px;
																	padding: 0px 1px 0px 4px;
																	width: 33px;
																}

																#switchSimNao label[for=no<?php echo $counterForms . $counterFormEmails; ?>] {
																	position: absolute;
																	right: 0px;
																	padding: 0px 0px 0px 0px;
																	width: 33px;
																	border-radius: 0px 15px 15px 0px;
																}

																#switchSimNao #yes<?php echo $counterForms . $counterFormEmails; ?>:checked~.switch label[for=yes<?php echo $counterForms . $counterFormEmails; ?>] {
																	color: #fff;
																	font-weight: bold;
																}

																#switchSimNao #no<?php echo $counterForms . $counterFormEmails; ?>:checked~.switch label[for=no<?php echo $counterForms . $counterFormEmails; ?>] {
																	color: #fff;
																	font-weight: bold;
																}
															</style>

															<div id="switchSimNao">
																<input type="radio" id="yes<?php echo $counterForms . $counterFormEmails; ?>" name="formYesNo<?php echo $counterForms . $counterFormEmails; ?>" value="Sim" <?php echo $dadosEmailsCliente[2] == '1' ? 'checked' : ''; ?> onclick="setaValorEnviarEmail('1', 'nomeEnviarEmail<?php echo $counterForms . $counterFormEmails; ?>')">
																<input type="radio" id="no<?php echo $counterForms . $counterFormEmails; ?>" name="formYesNo<?php echo $counterForms . $counterFormEmails; ?>" value="Nao" <?php echo $dadosEmailsCliente[2] == '0' ? 'checked' : ''; ?> onclick="setaValorEnviarEmail('0', 'nomeEnviarEmail<?php echo $counterForms . $counterFormEmails; ?>')">
																<div class="switch">
																	<label for="yes<?php echo $counterForms . $counterFormEmails; ?>">Sim</label>
																	<label for="no<?php echo $counterForms . $counterFormEmails; ?>">Não</label>
																</div>
															</div>

															<input type="hidden" id="nomeEnviarEmail<?php echo $counterForms . $counterFormEmails; ?>" name="formNomeEmailAtivo<?php echo $counterForms; ?>[]" value="<?php echo $dadosEmailsCliente[2]; ?>">

														</div>
													</div>
													<div class="col-xs-6 col-sm-6 col-md-2">
														<div class="form-group">
															<label>Excluir:</label>
															<div class="input-group">
																<div class="checkbox">
																	<a href="javascript:void(0);" onClick="removerDivRow('row<?php echo $counterForms . $counterFormEmails; ?>','qtdEmails<?php echo $counterForms; ?>')" title="Clique para deletar"><i class="fa fa-trash-o text-red btn-excluir-email"></i></a>
																</div>
															</div>
														</div>
													</div>
												</div>

											<?php
												// Fim loop emails
											}
											?>
										</div>
										<div class="row">
											<div class="col-xs-12">
												<div class="form-group">
													<input id="qtdEmails<?php echo $counterForms; ?>" name="qtdEmails<?php echo $counterForms; ?>" type="hidden" value="<?php echo $counterFormEmails; ?>">
													<a href="javascript:void(0);" id="qtdEmailsBtnFunc<?php echo $counterForms; ?>" onclick="adicionarNovoEmail(<?php echo $counterFormEmails; ?>,'qtdEmails<?php echo $counterForms; ?>', 'emailsContainer<?php echo $counterForms; ?>', 'qtdEmailsBtnFunc<?php echo $counterForms; ?>', <?php echo $counterForms; ?>);" class="btn btn-primary">Adicionar e-mail</a>
												</div>
											</div>
										</div>

										<?php $counterFormEmails = 0; ?>

										<hr style="margin-top: 0px;margin-bottom: 10px;">
										<div class="row">
											<div class="col-xs-12">
												<h4 title="E-mails que vão receber os leads mas não aparecem nos e-mails enviados">E-mails ocultos: <i class="btn-add-email-oculto" onclick="mostrarInputNovoEmailOculto('divAddEmailOculto<?php echo $counterForms; ?>')">+</i></h4>
												<div class="form-group">
													<div class="checkbox">

														<div style="display: flex;align-items: center;flex-flow: wrap;" id="boxEmailsOcultos<?php echo $counterForms; ?>">

															<?php

															$qtdEmailsOcultosWin7 = count($emailsWin7);

															// LOOP DOS E-MAILS OCULTOS
															for ($j = 0; $j <= count($emailsWin7) - 1; $j++) {
																$counterEmailsOcultos++;
															?>

																<div style="display: flex;align-items: center;flex-flow: wrap;" id="divSpanEmailOculto<?php echo $counterForms . $counterEmailsOcultos; ?>">
																	<label class="span-bullet">
																		<input type="checkbox" name="emailsocultos<?php echo $counterForms; ?>[]" id="emailsocultos<?php echo $counterForms . $counterEmailsOcultos; ?>" value="<?php echo $emailsWin7[$j]; ?>" <?php
																																																																																																														for ($k = 0; $k <= count($formularios[$i]['emailsocultos']) - 1; $k++) {
																																																																																																															if ($formularios[$i]['emailsocultos'][$k] == $emailsWin7[$j]) {
																																																																																																																echo 'checked';
																																																																																																															}
																																																																																																														}
																																																																																																														?> />
																		<?php echo $emailsWin7[$j]; ?>
																	</label>
																	<div class="span-bullet-close" onclick="removerEmailOculto('divSpanEmailOculto<?php echo $counterForms . $counterEmailsOcultos; ?>', 'qtdEmailsWinSete<?php echo $counterForms; ?>')">×</div>
																</div>

															<?php

															} // FIM LOOP DOS E-MAILS OCULTOS

															// Checa se existe algum email salvo no banco mas que não está mais na lista de e-mails da win7
															for ($k = 0; $k <= count($formularios[$i]['emailsocultos']) - 1; $k++) {

																// Verifica se tem os dois traços, se tem é por que não tem nenhum email oculto ativado, daí pula essa parte
																if ($formularios[$i]['emailsocultos'][$k] != '--') {

																	// Verifica se existe emails ocultos além da lista padrão
																	if (!in_array($formularios[$i]['emailsocultos'][$k], $emailsWin7)) {
																		$counterEmailsOcultos++;
																		$qtdEmailsOcultosWin7++;
																		echo '<div style="display: flex;align-items: center;flex-flow: wrap;" id="divSpanEmailOculto' . $counterForms . $counterEmailsOcultos . '"><label class="span-bullet"><input type="checkbox" name="emailsocultos' . $counterForms . '[]" id="emailsocultos' . $counterForms . $counterEmailsOcultos . '" value="' . $formularios[$i]['emailsocultos'][$k] . '" checked />' . $formularios[$i]['emailsocultos'][$k] . '</label><div class="span-bullet-close" onclick="removerEmailOculto(\'divSpanEmailOculto' . $counterForms . $counterEmailsOcultos . '\', \'qtdEmailsWinSete' . $counterForms . '\')">×</div></div>';
																	}
																}
															}

															$counterEmailsOcultos = 0;
															?>
														</div>

													</div>

													<input type="hidden" name="qtdEmailsWinSete<?php echo $counterForms; ?>" id="qtdEmailsWinSete<?php echo $counterForms; ?>" value="<?php echo $qtdEmailsOcultosWin7; ?>">
												</div>

												<div style="display:none;" id="divAddEmailOculto<?php echo $counterForms; ?>">
													<div class="box-novo-email-oculto"><input type="email" id="inputAddEmailOculto<?php echo $counterForms; ?>" placeholder="Digite o e-mail:" class="form-control" />
														<div onclick="adicionarEmailOculto('boxEmailsOcultos<?php echo $counterForms; ?>', 'qtdEmailsWinSete<?php echo $counterForms; ?>', <?php echo $counterForms; ?>, 'inputAddEmailOculto<?php echo $counterForms; ?>', 'divAddEmailOculto<?php echo $counterForms; ?>')">
															<p>Adicionar</p>
														</div>
													</div>
												</div>

											</div>
										</div>

									</div>
									<div class="panel-heading grid-form-top-identificador">

										<div class="form-group">
											<label>Identificação:</label>
											<div class="input-group">
												<div class="input-group-addon"><i class="fa fa-pencil"></i></div>
												<input type="text" class="form-control pull-right" id="formidentificadortexto<?php echo $counterForms . $counterFormEmails; ?>" name="formidentificadortexto<?php echo $counterForms; ?>" value="<?php echo $formularios[$i]['formidentificadortexto'] != "--" ? $formularios[$i]['formidentificadortexto'] : ""; ?>" />
											</div>
										</div>

										<div class="form-group">
											<label title="Se marcado Não, deixa a identificação em branco na tabela">Ativo?</label>
											<style>
												#switchSimNao #noid<?php echo $counterForms . $counterFormEmails; ?>:checked~.switch {
													background: #eb4f37;
												}

												#switchSimNao #noid<?php echo $counterForms . $counterFormEmails; ?>:checked~.switch span {
													background: #fff;
													margin-left: -8px;
												}

												#switchSimNao #noid<?php echo $counterForms . $counterFormEmails; ?>:checked~.switch span:after {
													background: #fff;
													height: 20px;
													margin-top: -8px;
													margin-left: 8px;
												}

												#switchSimNao label[for=yesid<?php echo $counterForms . $counterFormEmails; ?>] {
													position: absolute;
													left: 0px;
													height: 22px;
													border-radius: 15px 0px 0px 15px;
													padding: 0px 1px 0px 4px;
													width: 33px;
												}

												#switchSimNao label[for=noid<?php echo $counterForms . $counterFormEmails; ?>] {
													position: absolute;
													right: 0px;
													padding: 0px 0px 0px 0px;
													width: 33px;
													border-radius: 0px 15px 15px 0px;
												}

												#switchSimNao #yesid<?php echo $counterForms . $counterFormEmails; ?>:checked~.switch label[for=yesid<?php echo $counterForms . $counterFormEmails; ?>] {
													color: #fff;
													font-weight: bold;
												}

												#switchSimNao #noid<?php echo $counterForms . $counterFormEmails; ?>:checked~.switch label[for=noid<?php echo $counterForms . $counterFormEmails; ?>] {
													color: #fff;
													font-weight: bold;
												}
											</style>

											<div id="switchSimNao">
												<input type="radio" id="yesid<?php echo $counterForms . $counterFormEmails; ?>" name="formYesNoIdentificador<?php echo $counterForms . $counterFormEmails; ?>" value="Sim" <?php echo $formularios[$i]['formidentificadorativo'] == '1' ? 'checked' : ''; ?> onclick="setaValorFormIdentificador('1', 'formidentificadorativo<?php echo $counterForms . $counterFormEmails; ?>')">
												<input type="radio" id="noid<?php echo $counterForms . $counterFormEmails; ?>" name="formYesNoIdentificador<?php echo $counterForms . $counterFormEmails; ?>" value="Nao" <?php echo $formularios[$i]['formidentificadorativo'] == '0' ? 'checked' : ($formularios[$i]['formidentificadortexto'] == "--" || $formularios[$i]['formidentificadortexto'] == "" ? 'checked' : ''); ?> onclick="setaValorFormIdentificador('0', 'formidentificadorativo<?php echo $counterForms . $counterFormEmails; ?>')">
												<div class="switch">
													<label for="yesid<?php echo $counterForms . $counterFormEmails; ?>">Sim</label>
													<label for="noid<?php echo $counterForms . $counterFormEmails; ?>">Não</label>
												</div>
											</div>
											<input type="hidden" id="formidentificadorativo<?php echo $counterForms . $counterFormEmails; ?>" name="formidentificadorativo<?php echo $counterForms; ?>" value="<?php echo $formularios[$i]['formidentificadorativo']; ?>">

										</div>
									</div>
								</div>

							<?php
								// Fim dos loop dos $formularios
							} ?>


						<?php
							// Fim da verifica de form configurado
						} else {
						} ?>
					</div>
				</div>








			</div>
		</div>
	</div>
	<div class="modal-footer">
		<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Fechar</button>
		<button type="submit" name="action" class="btn btn-primary">Salvar Alterações</button>
	</div>
	<div class="overlay preloader">
		<i class="fa fa-refresh fa-spin"></i>
	</div>
</form>

<script>
	var maskBehavior = function(val) {
			return val.replace(/\D/g, '').length === 11 ? '(00) 00000-0000' : '(00) 0000-00009';
		},
		options = {
			onKeyPress: function(val, e, field, options) {
				field.mask(maskBehavior.apply({}, arguments), options);
			}
		};
	$(document).ready(function() {
		$('#telefone1').mask(maskBehavior, options);
		$('#telefone2').mask(maskBehavior, options);
		$('#datainicial').mask("00/00/0000");
		$('#datainicialads').mask("00/00/0000");
		$('#adwords').mask("000-000-0000");
		$('#datafinal').mask("00/00/0000");
		// $('.numerosWhatsApp').mask("00 (00) 00000-0000");
	});
	$('.dinheiro').mask('000.000.000.000.000,00', {
		reverse: true
	});
	var contadorVono = document.getElementById('qtdVono').value;
	var contadorNumerosWhatsApp = document.getElementById('qtdWhatApps').value;
	var contadorNumerosSMS = document.getElementById('qtdSMS').value;
	var contadorUsuarios = document.getElementById('qtdUsuarios').value;
	var contadorForms = document.getElementById('qtdForms').value;
	var contadorCampanhas = document.getElementById('qtdCampanhas').value;

	// Checa se o whatsapp esta marcado
	if (document.querySelector('input[name="whatsBanco"]').checked) {
		$('.whatsAppContainerNumbers').fadeIn('500');
	} else {
		$('.whatsAppContainerNumbers').hide();
	}

	$('input[name="whatsBanco"]').change(function() {
		if (document.getElementById('whatsRadioBanco1').checked) {
			$('.whatsAppContainerNumbers').fadeIn('500');
		} else {
			$('.whatsAppContainerNumbers').hide();
		}
	});

	// Checa se o whatsapp esta marcado
	if (document.getElementById('whatsapp').checked) {
		$('.whatsAppContainerBanco').fadeIn('500');
	} else {
		$('.whatsAppContainerBanco').hide();
		$('.whatsAppContainerNumbers').hide();
	}

	$('#whatsapp').click(function() {
		if (document.getElementById('whatsapp').checked) {
			$('.whatsAppContainerBanco').fadeIn('500');

			if (document.getElementById('whatsRadioBanco1').checked) {
				$('.whatsAppContainerNumbers').fadeIn('500');
			} else {
				$('.whatsAppContainerNumbers').hide();
			}

		} else {
			$('.whatsAppContainerBanco').hide();
			$('.whatsAppContainerNumbers').hide();
		}
	});

	// Checa se o sms esta marcado
	if (document.querySelector('input[name="smsBanco"]').checked) {
		$('.smsContainerNumbers').fadeIn('500');
	} else {
		$('.smsContainerNumbers').hide();
	}

	$('input[name="smsBanco"]').change(function() {
		if (document.getElementById('smsRadioBanco1').checked) {
			$('.smsContainerNumbers').fadeIn('500');
		} else {
			$('.smsContainerNumbers').hide();
		}
	});

	// Checa se o sms esta marcado
	if (document.getElementById('sms').checked) {
		$('.smsAppContainerBanco').fadeIn('500');
	} else {
		$('.smsAppContainerBanco').hide();
		$('.smsContainerNumbers').hide();
	}

	$('#sms').click(function() {
		if (document.getElementById('sms').checked) {
			$('.smsAppContainerBanco').fadeIn('500');

			if (document.getElementById('smsRadioBanco1').checked) {
				$('.smsContainerNumbers').fadeIn('500');
			} else {
				$('.smsContainerNumbers').hide();
			}

		} else {
			$('.smsAppContainerBanco').hide();
			$('.smsContainerNumbers').hide();
		}
	});
</script>
<script>
	var maskList = $.masksSort($.masksLoad("../js/country-masks/data/phone-codes.json"), ['#'], /[0-9]|#/, "mask");
	var maskOpts = {
		inputmask: {
			definitions: {
				'#': {
					validator: "[0-9]",
					cardinality: 1
				}
			},
			//clearIncomplete: true,
			showMaskOnHover: false,
			autoUnmask: true
		},
		match: /[0-9]/,
		replace: '#',
		list: maskList,
		listKey: "mask"
	};

	for (let i = 0; i <= $('#qtdWhatApps').val(); i++) {
		$('#whats' + i).inputmasks(maskOpts);
	}
	for (let i = 0; i <= $('#qtdSMS').val(); i++) {
		$('#sms' + i).inputmasks(maskOpts);
	}
</script>
<script type="text/javascript">
	$(document).ready(function() {
		$('.js-example-basic-multiple').select2({
			placeholder: "Selecione:"
		});
	});

	function copiarCodigo(selectorId) {
		document.getElementById(selectorId).select();
		document.execCommand("copy");
	}
</script>
<script>
	// Seta o valor para o input de enviar email ou nao
	function setaValorEnviarEmail(valor, inputId) {
		document.getElementById(inputId).value = valor;
	}

	// Seta o valor para identificar se o form é organico ou nao
	function setaValorFormOrganico(valor, inputId) {
		document.getElementById(inputId).value = valor;
	}

	// Seta o valor para identificar se o form tem idenficador ativo ou nao
	function setaValorFormIdentificador(valor, inputId) {
		document.getElementById(inputId).value = valor;
	}

	// Seta o valor para identificar se o form é organico ou nao
	function mostrarInputNovoEmailOculto(inputId) {
		if ($('#' + inputId).is(":visible")) {
			document.getElementById(inputId).style.display = "none";
			return;
		}
		document.getElementById(inputId).style.display = "block";
	}

	// Seta o valor para identificar se o form é organico ou nao
	function esconderInputNovoEmailOculto(inputId) {
		document.getElementById(inputId).style.display = "none";
	}

	// Funcao que remove a linha dos dados do emails
	function removerDivRow(rowId, qtdEmailsInputId) {

		// Subtrai 1 da quantidade de emails de cada form
		let qtdEmails = document.getElementById(qtdEmailsInputId).value;
		document.getElementById(qtdEmailsInputId).value = qtdEmails - 1;

		// Remove a row com os dados do email
		$('.' + rowId).remove();
	}

	/* Funcao pra validar Email */
	function validarEmail(emailVal) {
		var x = emailVal;
		var atpos = x.indexOf("@");
		var dotpos = x.lastIndexOf(".");
		if (atpos < 1 || dotpos < atpos + 2 || dotpos + 2 >= x.length) {
			alert("\"" + x + "\" Não é um endereço de e-mail válido");
			return false;
		}
		return true;
	}


	// Funcao que remove um email oculto
	function adicionarEmailOculto(divSpanId, qtdEmailsOcultosId, formIdentificador, emailInput, inputNovoId) {

		// Recebe o novo email
		let novoEmailOculto = document.getElementById(emailInput).value;

		// Valida o e-mail
		if (!validarEmail(novoEmailOculto)) {
			return;
		}

		// Soma 1 na quantidade de emails de cada form
		let qtdEmails = parseInt(document.getElementById(qtdEmailsOcultosId).value) + 1;
		document.getElementById(qtdEmailsOcultosId).value = qtdEmails;

		// Gera um id unico para o id
		let addDelUniqId = Math.floor(Math.random() * Math.floor(Math.random() * Date.now()));

		// Remove a row com os dados do email
		$('#' + divSpanId).append(`<div style="display: flex;align-items: center;flex-flow: wrap;" id="divSpanEmailOculto${addDelUniqId}">
													<label class="span-bullet">
														<input type="checkbox" name="emailsocultos${formIdentificador}[]" id="emailsocultos${addDelUniqId}" value="${novoEmailOculto}" checked>
														${novoEmailOculto}
													</label>
													<div class="span-bullet-close" onclick="removerEmailOculto('divSpanEmailOculto${addDelUniqId}', 'qtdEmailsWinSete${formIdentificador}')">×</div>
												</div>`);

		esconderInputNovoEmailOculto(inputNovoId);
	}

	// Funcao que remove um email oculto
	function removerEmailOculto(spanId, qtdEmailsOcultosId) {

		// Subtrai 1 da quantidade de emails de cada form
		let qtdEmails = document.getElementById(qtdEmailsOcultosId).value;
		document.getElementById(qtdEmailsOcultosId).value = qtdEmails - 1;

		// Remove a row com os dados do email
		$('#' + spanId).remove();
	}

	// Funcao que remove um formulario
	function removerForm(formId) {

		// Pega o valor do input
		const inputExcluir = $('#excluirForm' + formId).val();

		// Se não estiver marcado para exclusão (0) entra no if
		if (inputExcluir == '0') {

			// Janela de confirmacao
			const response = confirm(`Deseja realmente marcar para deletar o FORM${formId}?`);

			if (response == true) {

				$('#excluirForm' + formId).val(1);

				// // Subtrai 1 da quantidade de forms
				// let qtdForms = document.getElementById('qtdForms').value;
				// document.getElementById('qtdForms').value = qtdForms - 1;

				// Remove a row com os dados do email
				// $('#'+formId).remove();
				$('#form' + formId).fadeTo("slow", 0.33);
				$('#trashIcon' + formId).removeClass("fa-trash-o");
				$('#trashIcon' + formId).addClass("fa-reply");
			}

			// Se estiver marcado para exclusão
		} else {

			$('#excluirForm' + formId).val(0);

			$('#form' + formId).fadeTo("fast", 1);
			$('#trashIcon' + formId).removeClass("fa-reply");
			$('#trashIcon' + formId).addClass("fa-trash-o");
		}
	}

	$('input[name="puxaEmailsBD"]').change(function() {

		if ($('input[name="puxaEmailsBD"]:checked').length) {
			$('#mostrarForms').fadeIn('500');
		} else {
			$('#mostrarForms').hide();
		}

		// if ($('#qtdForms').val() == 0) {
		// 	adicionarFormulario();
		// }
	});
</script>