<?php

require_once(__DIR__ . "/../../classes/Sistema.php");
require_once(__DIR__ . "/../../classes/Mascara.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

if (!$sistema->usuario->super_adm_adm) {
    echo "-2Permissão Insuficiente";
    exit;
}

try {
    $resultado = $sistema->bd->executar("SELECT * FROM falso_lead", [], Banco_Dados::FETCH_ALL);
    if (count($resultado) == 0) {
        echo "-2Não há leads falsos registrados";
    }
    $falsos_leads_agrupados = array_reduce($resultado, function ($accumulator, $element) {
        $accumulator[$element['email']][] = $element['valor'];

        return $accumulator;
    }, []);

    $bd_voip = new Banco_Dados_Fone();

    $telefones = $falsos_leads_agrupados[0];
    $emails    = $falsos_leads_agrupados[1];

    // só exclui leads com até 2 meses no máximo
    $dataCorte = date('Y-m-d 00:00:00', strtotime('-1 month'));

    // EXCLUI OS E-MAILS SALVOS NOS PARAMETROS
    foreach ($emails as $email) {
        $sistema->bd->executar("DELETE FROM TBL_LEADS WHERE TXT_EMAIL LIKE '%$email%' AND DT_ATUAL >= '$dataCorte'");
    }

    // EXCLUI OS TELEFONES/LIGAÇÕES SALVOS NOS PARAMETROS
    foreach ($telefones as $telefone) {
        
        $mascara = Mascara::aplicar_mascara_telefone($telefone);

        // Verifica se o número existe ou não
        if(empty($mascara)){
            echo "-2Houve um erro com o número: ".$telefone.".".$mascara."--";
            exit;
        } else {
            $sistema->bd->executar("DELETE FROM TBL_LEADS WHERE NU_TELEFONE1 LIKE '%$mascara%' AND DT_ATUAL >= '$dataCorte'");

            // deleta as ligações do banco de dados local. No local, os números das ligações são gravados ao contrário.
            // exemplo: 61992315157 é gravado como 75151329916
            // isso é feito para simplificar a busca de forma performática pelo MySQL, usando o % apenas no final da string
            // e não no início
            $telefoneInverso = strrev($telefone); // inverte o número
            $sistema->bd->executar(
                "DELETE call_segment, `call`
     FROM `call`
     INNER JOIN call_segment ON `call`.id = call_segment.call_id
     WHERE (
         call_segment.source_filter LIKE '%$telefone%' OR 
         call_segment.destination_filter LIKE '%$telefone%' OR 
         call_segment.source_filter LIKE '$telefoneInverso%' OR 
         call_segment.destination_filter LIKE '$telefoneInverso%'
     )
     AND `call`.start_time >= '$dataCorte'",
                [],
                Banco_Dados::FETCH_ALL
            );

        //        $infos = $bd_voip->executar(
        //            "SELECT
        //                cl_calls.id as call_id, cl_calls.end_time
        //            FROM cl_calls
        //                join cl_segments segments on segments.call_id = cl_calls.id
        //                join cl_participants src_participants on src_participants.id = segments.src_part_id
        //                join cl_party_info src_info on src_info.id = src_participants.info_id
        //            WHERE src_info.dn like '%$telefone%' or src_info.caller_number like '%$telefone%' or src_info.display_name like '%$telefone%'
        //            GROUP BY cl_calls.id
        //            ORDER BY cl_calls.end_time DESC;",
        //            [], Banco_Dados::FETCH_ALL
        //        );
        //
        //        $calls = array_map(function ($val) {
        //            return $val['call_id'];
        //        }, $infos);
        //
        //        foreach ($calls as $call_id) {
        //            try {
        //                $bd_voip->iniciar_transacao();
        //                $segments     = $bd_voip->executar(
        //                    "SELECT id, src_part_id, dst_part_id, action_party_id FROM cl_segments WHERE call_id = $call_id",
        //                    [], Banco_Dados::FETCH_ALL
        //                );
        //                $participants = [];
        //                foreach ($segments as $segment) {
        //                    $segment_id = $segment['id'];
        //                    $bd_voip->executar("DELETE FROM cl_segments WHERE id = $segment_id");
        //                    if (!empty($segment['src_part_id'])) {
        //                        $participants[$segment['src_part_id']] = $segment['src_part_id'];
        //                    }
        //                    if (!empty($segment['dst_part_id'])) {
        //                        $participants[$segment['dst_part_id']] = $segment['dst_part_id'];
        //                    }
        //                    if (!empty($segment['action_party_id'])) {
        //                        $participants[$segment['action_party_id']] = $segment['action_party_id'];
        //                    }
        //                }
        //                foreach ($participants as $participant) {
        //                    $partyInfo = $bd_voip->executar("SELECT info_id FROM cl_participants WHERE id = $participant", [], Banco_Dados::FETCH);
        //                    $infoId = $partyInfo[0];
        //                    $bd_voip->executar("DELETE FROM cl_participants WHERE id = $participant");
        //                    $bd_voip->executar("DELETE FROM cl_party_info WHERE id = $infoId");
        //                }
        //                $bd_voip->executar("DELETE FROM cl_calls WHERE id = $call_id");
        //                $bd_voip->commit_transacao();
        //            } catch (\Exception $e) {
        //                echo "-2Houve um erro com o servidor. ".$e;
        //                $bd_voip->rollback_transacao();
        //                exit;
        //            }
        //        }
        }
    }
} catch (\Exception $e) {
    echo "-2Houve um erro com o servidor";
    exit;
}