<?php
/*
 * Este arquivo salva os dados do cliente da agência.
 */
 
require_once(__DIR__ . "/../../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

if(!ctype_digit($_POST['id'])){ // Verifica se a ID é um número
	echo "-2ID inválida!";
	exit;
}

/* Verifica se os dados básicos são válidos */
// if(empty($_POST['clienteativo']) || empty($_POST['clienteimportante'])){
// 	echo "-2Dados inválidos!";
// 	exit;
// }

/* Lê todos os dados do formulário */
$cliente_ativo = $_POST['clienteativo'] == "Sim" ? 1 : 0;
$cliente_importante = $_POST['clienteimportante'] == "Sim" ? 1 : 0;

/* Monta array com os parâmetros para salvar no banco */
$parametros = array(
	':id' => $_POST['id'],
	':clienteativo' => $cliente_ativo,
	':clienteimportante' => $cliente_importante,
);

try{
	/* Salva os dados no banco */
	$sql = 'UPDATE TBL_CLIENTE SET NU_CLIENTE_ATIVO = :clienteativo, NU_CLIENTE_IMPORTANTE = :clienteimportante WHERE ID_CLIENTE = :id';
	$sistema->bd->executar($sql, $parametros);
	
	
	// Monta os novos dados do cliente para atualizar a tabela
	$resultado = array();

	$cliente = $sistema->obter_cliente($_POST['id']);

	$sistema->logs->adicionar_log_salvar_dados_cliente($cliente['TXT_NOME_EMPRESA'], $cliente['ID_CLIENTE']);

	// Adiciona o cliente na array que será enviada por meio de JSON
	$resultado[] = array(
		"id" =>  $_POST['id'],
		"ativo" =>  $cliente['NU_CLIENTE_ATIVO'] == '0' ? "Não" : "Sim",
		"cli_importante" =>  $cliente['NU_CLIENTE_IMPORTANTE'] == '0' ? "Não" : "Sim",
	);

	echo json_encode_alt($resultado);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>