<?php
require_once(__DIR__ . "/../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, false, false);

if (!$sistema->usuario->super_adm_adm) {
	$sistema->redirecionar("home");
}

?>
<!DOCTYPE html>
<html>

<head>
	<!-- Google Tag Manager -->
	<script>
		(function(w, d, s, l, i) {
			w[l] = w[l] || [];
			w[l].push({
				'gtm.start': new Date().getTime(),
				event: 'gtm.js'
			});
			var f = d.getElementsByTagName(s)[0],
				j = d.createElement(s),
				dl = l != 'dataLayer' ? '&l=' + l : '';
			j.async = true;
			j.src =
				'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
			f.parentNode.insertBefore(j, f);
		})(window, document, 'script', 'dataLayer', 'GTM-MFFM5J3');
	</script>
	<!-- End Google Tag Manager -->
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<title>BI - Sistema Win7</title>
	<link rel="icon" type="image/ico" href="favicon.png" />
	<link rel="stylesheet" href="../css/bootstrap.min.css">
	<link rel="stylesheet" href="../css/datatables.min.css" />
	<link rel="stylesheet" href="../css/bootstrap-xl-xxl.css">
	<link rel="stylesheet" href="../css/font-awesome.min.css">
	<link rel="stylesheet" href="../css/ionicons.min.css">
	<link rel="stylesheet" href="../css/AdminLTE.min.css">
	<link rel="stylesheet" href="../css/skin-blue.min.css">
	<link rel="stylesheet" href="css/custom2.0.1.css">
	<link rel="stylesheet" href="../css/toastr.min.css">
	<link rel="stylesheet" href="../css/bootstrap-datepicker.min.css">
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
	<?php $sistema->layout->criar_meta_tags(); ?>
</head>

<body class="hold-transition skin-blue sidebar-mini <?php if ($sistema->usuario->sidebar) {
																											echo "sidebar-collapse";
																										} ?>">
	<!-- Google Tag Manager (noscript) -->
	<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-MFFM5J3" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
	<!-- End Google Tag Manager (noscript) -->

	<div class="modal fade" id="modal-sistema">
		<div class="modal-dialog modal-lg">
			<div class="modal-content" id="modal-sistema-conteudo"></div>
		</div>
	</div>
	<div class="wrapper">
		<?php $sistema->layout->exibir_cabecalho('bi'); ?>

		<div class="content-wrapper">
			<!-- Content Header (Page header) -->
			<section class="content-header">
				<h1>
					Dados para o Power BI
					<small>Veja e edite os dados para o BI</small>
				</h1>
				<ol class="breadcrumb">
					<li><a href="home"><i class="fa green-text fa-home"></i>Home</a></li>
				</ol>
			</section>

			<section class="content container-fluid">

				<div class="row">
					<div class="col-xs-12">
						<div class="box">
							<div class="box-body">
								<form action="" method="POST" id="formBi">
									<div class="row">
										<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
											<div class="checkbox">
												<label>
													<input type="checkbox" name="apenasAtivos" id="switch" class="buscarAPI" value="s" >
													Ativos
												</label>
											</div>
										</div>
										<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
											<div class="checkbox">
												<label>
													<input type="checkbox" name="apenasImportantes" id="switch" class="buscarAPI" value="s" >
													Importantes
												</label>
											</div>
										</div>
									</div>
								</form>
							</div>
							<div class="overlay preloader">
								<i class="fa fa-refresh fa-spin"></i>
							</div>
						</div>
					</div>
				</div>

				<div class="row">
					<div class="col-xs-12">
						<div class="box">
							<div class="box-header with-border">
								<h3 class="box-title">Clientes Ativos e Importantes</h3>
							</div>
							<div class="box-body">
								<div id="tabelaClientes" class="tabela">
									<table id="tblClientesImportantes" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>
								</div>
							</div>
							<div class="overlay preloader">
								<i class="fa fa-refresh fa-spin"></i>
							</div>
						</div>

					</div>
				</div>
			</section>
		</div>

		<?php $sistema->layout->exibir_rodape(); ?>
	</div>

	<script src="../js/jquery.min.js"></script>
	<script src="../js/datatables.min.js"></script>
	<script src="../js/bootstrap.min.js"></script>
	<script src="../js/adminlte.min.js"></script>
	<script src="../js/bootstrap-datepicker.min.js"></script>
	<script src="../js/bootstrap-datepicker.pt-BR.min.js"></script>
	<script src="../js/toastr.min.js"></script>
	<script src="../js/jquery.mask.min.js"></script>
	<script src="../js/moment.min.js"></script>
	<script src="../js/datetime-moment.js"></script>
	<script src="../js/date.js"></script>
	<script src="../js/country-masks/jquery.inputmask-multi.min.js"></script>
	<script src="../js/country-masks/jquery.inputmask.bundle.min.js"></script>
	<script src="js/bi1-0-0"></script>

</body>

</html>