<?php 
require_once (__DIR__ . "/Banco_Dados.php");
require_once (__DIR__ . "/Utilitarios.php");
require_once (__DIR__ . "/EcxServerException.php");

ini_set("default_socket_timeout", 2);

function empty_handler($errno, $errstr, $errfile, $errline){}

class Banco_Dados_Fone extends Banco_Dados{
	public $bd;
	public $consulta;

	public function __construct(){
//		if(!Utilitarios::host_disponivel("34.35.53.44","5432")){
//			throw new EcxServerException('Não foi possível conectar com o servidor. #1: IP e/ou porta do servidor inválido(s).');
//		}
//		$old_error_handler = set_error_handler("empty_handler");
//		$dbconn = pg_connect('host=34.35.53.44 port=5432 dbname=database_single user=phonesystem password=VYBFYHtNZ2rir connect_timeout=10'); //connect_timeout em segundos
//		restore_error_handler();
//
//		if($dbconn == false){
//			throw new EcxServerException('Não foi possível conectar com o servidor. #2: Erro ao conectar ao banco de dados de ligações.');
//		}

//		$this->bd = $dbconn;
	}

    /**
     * @throws \Exception
     */
	public function iniciar_transacao(){
	    if(!pg_query("BEGIN")){
            throw new EcxServerException("Não foi possível iniciar a transação");
        }
    }

    /**
     * @throws \Exception
     */
    public function commit_transacao(){
        if(!pg_query("COMMIT")){
            throw new EcxServerException("Não foi possível dar commit na transação");
        }
    }

    /**
     * @throws \Exception
     */
    public function rollback_transacao(){
        if(!pg_query("ROLLBACK")){
            throw new EcxServerException("Não foi possível dar rollback na transação");
        }
    }

	// Função que retorna a ID da última execução do banco
	public function ultima_id(){
		return pg_last_oid($this->consulta);
	}
	
	// Função que retorna a quantidade de dados encontrados
	public function quantidade(){
		return pg_num_rows($this->consulta);
	}

    /**
     * @param $sql
     * @param array $params
     * @param int $modo
     * @return array
     * @throws \EcxServerException
     */
	public function executar($sql, $params = array(), $modo = Banco_Dados::NORMAL){
		$old_error_handler = set_error_handler("empty_handler");
		$this->consulta = pg_query_params($this->bd, $sql, $params);
		restore_error_handler();
		if($this->consulta == false){
			throw new EcxServerException('Não foi possível fazer a consulta.'.pg_last_error());
		}
		
		if($modo == Banco_Dados::FETCH)
			return $this->get_resultado();
		else if($modo == Banco_Dados::FETCH_ALL)
			return $this->get_resultados();
	}

	// Retorna um único resultado da última consulta
	public function get_resultado(){
		return pg_fetch_row($this->consulta);
	}
	
	// Retorna todos os resultados da última consulta
	public function get_resultados(){
		return pg_fetch_all($this->consulta);
	}
}
?>