<?php
/***
	Esta classe é responsável por controlar o banco de dados dos leads.
***/
ini_set("default_socket_timeout", 2);

class Banco_Dados_Leads extends Banco_Dados{
	public $bd;
	public $consulta;
	
	public function __construct($modo_sandbox){
        $appEnv = getenv('APP_ENV');

        if ($appEnv) {
            $appEnv = strtolower($appEnv);
        }

        $host_banco = $appEnv === 'dev' ? 'mysql8' : 'localhost';

		$nome_banco = $modo_sandbox ? 'pages_sistema_teste' : 'pages_sistema';
		$this->bd = new PDO('mysql:host='.$host_banco.';dbname='.$nome_banco.";charset=utf8mb4", 'pages_admin', 'win7?admin');
		$this->bd->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
		$this->bd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	}
}
?>