<?php
/***
	Esta classe é responsável por trabalhar com máscaras de strings
***/
class Mascara{
	// Retorna a string com máscara de cpf ou cnpj
	static function mascara_cpf_cnpj($cpf_cnpj){
		return strlen($cpf_cnpj) == 11 ? self::aplicar_mascara($cpf_cnpj, "###.###.###-##") : self::aplicar_mascara($cpf_cnpj, "##.###.###/####-##");
	}

	// Retorna a máscara especificada
	static function aplicar_mascara($val, $mask){
		$maskared = '';
		$k = 0;
		for($i = 0; $i<=strlen($mask)-1; $i++){
			if($mask[$i] == '#'){
				if(isset($val[$k]))
					$maskared .= $val[$k++];
			}
			else{
				if(isset($mask[$i]))
				$maskared .= $mask[$i];
			}
		}
		return $maskared;
	}

	/* Cria uma máscara para telefones */
	static function aplicar_mascara_telefone($val)
	{
		$size = strlen($val);
		if($size == 8)
			return self::aplicar_mascara($val, "####-####");
		else if($size == 9)
			return self::aplicar_mascara($val, "#####-####");
		else if($size == 10)
			return self::aplicar_mascara($val, "(##) ####-####");
		else if($size == 11)
			return self::aplicar_mascara($val, "(##) #####-####");
	}

	/* Converte o valor para a pontuação do sistema de indicações */
	static function converter_para_pontos($valor, $inteiro = true){
		$vl = floatval(intval($valor));
		if($inteiro == true) $vl /= 100;
		$strvl = number_format($vl,2,'','.') . " pontos";
		return $strvl;
	}

	/* Converte o valor especificado para real.
	   A flag "inteiro" indica se o valor não é double, mas sim um inteiro que
	   possui os últimos dois valores como sendo os decimais */
	static function converter_para_real($valor, $inteiro = true){
		if($inteiro == true) {
			$vl = floatval(intval($valor));
			$vl /= 100;
		}
		else{
			$vl = floatval($valor);
		}
		$strvl = 'R$ ' . number_format($vl,2,',','.');
		return $strvl;
	}

	// Converte o valor para dolar
	static function converter_para_dolar($valor, $inteiro = true){
		if($inteiro == true) {
			$vl = floatval(intval($valor));
			$vl /= 100;
		}
		else{
			$vl = floatval($valor);
		}
		$vl = floatval(intval($valor)) / 100;
		$strvl = 'U$ ' . number_format($vl,2,',','.');
		return $strvl;
	}
}

?>