<?php
/***
	Esta classe guarda dados sobre o cliente da Win7 que está logado no sistema
***/

class Subusuario_Win7 extends Usuario_Win7{
	public $id_subusuario;
	public $nome_subusuario;

	function __construct($id){
		$this->id_subusuario = $id;
	}

	/* Método responsável por carregar os dados do usuário */
	function carregar(&$bd){
		// Seleciona o subusuário no banco
		$subusuario = $bd->executar("SELECT * FROM TBL_SUBUSUARIOS WHERE NU_ID = :ID", array(":ID" => $this->id_subusuario), Banco_Dados::FETCH);
		$id_fk = $subusuario['ID_CLIENTE_FK'];
		$this->nome_subusuario = $subusuario['TXT_NOME'];
		$this->sidebar = $subusuario['NU_SIDEBAR'] == "1";

		// Carrega os dados do cliente original
		$cliente = $bd->executar("SELECT * FROM TBL_CLIENTE WHERE ID_CLIENTE = :ID", array(":ID" => $id_fk), Banco_Dados::FETCH);
		$this->id = $cliente['ID_CLIENTE'];
		parent::carregar($bd);

		$this->permissao_indicacoes = $this->permissao_indicacoes != Usuario::PERM_NENHUMA ? intval($subusuario['NU_PERM_INDICACOES']) : Usuario::PERM_NENHUMA;
		$this->permissao_leads = $this->permissao_leads != Usuario::PERM_NENHUMA ? intval($subusuario['NU_PERM_CONTATOS']) : Usuario::PERM_NENHUMA;
		$this->permissao_google = $this->permissao_google != Usuario::PERM_NENHUMA ? intval($subusuario['NU_PERM_ADWORDS']) : Usuario::PERM_NENHUMA;
		$this->permissao_log = $this->permissao_log != Usuario::PERM_NENHUMA ? intval($subusuario['NU_PERM_LOG']) : Usuario::PERM_NENHUMA;
		$this->permissao_3cx = $this->permissao_3cx != Usuario::PERM_NENHUMA ? intval($subusuario['NU_PERM_WIN7FONE']) : Usuario::PERM_NENHUMA;
		$dados_gerais = intval($subusuario['NU_ATIVAR_DADOS_GERAIS']) == "1" ? Usuario::PERM_LEITURA : Usuario::PERM_NENHUMA;
		$this->permissao_dados_gerais = $this->permissao_dados_gerais != Usuario::PERM_NENHUMA ? $dados_gerais : Usuario::PERM_NENHUMA;
		$this->home = $subusuario['TXT_HOME'];

		$this->senha = $subusuario['TXT_SENHA_NOVA'];
		$this->senha_antiga = $subusuario['TXT_SENHA'];
	}

	/* Muda a senha do usuário */
	function mudar_senha($senha, $senha_antiga, $sistema){
		$antiga = empty($this->senha);
		$verificada = $antiga ? 
			($this->senha_antiga === md5($senha_antiga)) : // A senha é md5 e está correta?
			(crypt($senha_antiga, $this->senha) === $this->senha); // OU a senha é blowfish e está correta?

		if(!$verificada){ // A senha atual digitada está incorreta
			return "Senha incorreta.";
		}

		$sistema->bd->executar("UPDATE TBL_SUBUSUARIOS SET TXT_SENHA_NOVA = :senha, TXT_SENHA = '' WHERE NU_ID = :id", array( ':id' => $this->id_subusuario, ':senha' => Utilitarios::hash_str($senha)));

		try{
			foreach(Sistema::email_adm() as $email){
				Sistema::enviar_email_sistema("<p>O subusuário ".$this->nome_subusuario." acaba de modificar sua senha do Sistema Win7!</p>", "Aviso de Mudança de Senha", $email, "Agência Win7");
			}
		}
		catch(Exception $e){}

		return "-1";
	}

	/* Salva o estado atual da sidebar */
	function salvar_sidebar($opcao, $bd){
		$opcao == "0" ? $opcao = 0 : $opcao = 1;
		$params = array(
			':id' => $this->id_subusuario,
			':sidebar' => $opcao
		);
		$bd->executar("UPDATE TBL_SUBUSUARIOS SET NU_SIDEBAR = :sidebar WHERE NU_ID = :id", $params);
	}
}
?>