<?php 
require_once(__DIR__ . "/../Banco_Dados.php");

function criar_vocabulario_indicacoes($valor, $indice, $sandbox = true){
	$bd = new Banco_Dados($sandbox);

	$dados = $bd->executar("SELECT * FROM TBL_CLI_DADOS", array(), Banco_Dados::FETCH_ALL);

	foreach($dados as $cliente){
		$id = $cliente['ID_FK'];

		$dados = $bd->executar("SELECT * FROM TBL_INDICACOES_VOCAB WHERE NU_ORDEM = :indice AND ID_CLIENTE = :id", array(
			":indice" => $indice,
			":id" => $id
		), Banco_Dados::FETCH_ALL);

		if($bd->quantidade() > 0){
			$bd->executar("UPDATE TBL_INDICACOES_VOCAB SET TXT_CONTEUDO = :conteudo WHERE NU_ORDEM = :ordem AND ID_CLIENTE = :id", array(
				":id" => $id,
				":conteudo" => $valor,
				":ordem" => $indice
			));
		}
		else{
			$bd->executar("INSERT INTO TBL_INDICACOES_VOCAB (ID_CLIENTE, TXT_CONTEUDO, NU_ORDEM) VALUES (:id, :conteudo, :ordem)", array(
				":id" => $id,
				":conteudo" => $valor,
				":ordem" => $indice
			));
		}
	}
}

//criar_vocabulario_indicacoes('Link para novo indicador', 30, false);
?>