<?php
require_once(__DIR__ . "/classes/Sistema.php");
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às campanhas do google
if($sistema->usuario->permissao_google == Usuario::PERM_NENHUMA) $sistema->redirecionar("home");
if($sistema->usuario->permissao_dados_gerais == Usuario::PERM_NENHUMA) $sistema->redirecionar("home");
?>
<!DOCTYPE html>
<html>
<head>
<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-MFFM5J3');</script>
<!-- End Google Tag Manager -->
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<title>Dados Gerais - Sistema Win7</title>
	<link rel="icon" type="image/ico" href="favicon.png" />
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/bootstrap-xl-xxl.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/font-awesome.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/ionicons.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/AdminLTE.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/skin-blue.min.css">
	<link rel="stylesheet" href="css/custom2.0.1.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/toastr.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/bootstrap-datepicker.min.css">
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
	<?php $sistema->layout->criar_meta_tags();?>
</head>

<body class="hold-transition skin-blue sidebar-mini <?php if($sistema->usuario->sidebar) {echo "sidebar-collapse"; }?>">
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-MFFM5J3"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
<div class="wrapper">
	<?php $sistema->layout->exibir_cabecalho('geral');?>

	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
			Dados Gerais
			<small>Veja os dados mais importantes de suas campanhas</small>
			</h1>
			<ol class="breadcrumb">
				<li><a href="javascript:void(0)"><i class="fa green-text fa-google"></i> Anúncios Google</a></li>
				<li><a href="geral"><i class="fa fa-bar-chart"></i> Dados Gerais</a></li>
			</ol>
		</section>

		<section class="content container-fluid">
			<div class="row">
				<div class="col-xs-12">
          			<div class="box">
          				<div class="box-body">
          					<form action="" method="POST" id="formHome">
	          					<div class="row">
	          						<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
	          							<div class="form-group">
		          							<label>Período:</label>
											<select name="data" id="data" class="form-control" title="Selecione um perído">
												<?php $sistema->layout->select_periodo(); ?>
											</select>
										</div>
	          						</div>
	          						<div class="<?php if($sistema->filtro->valor() != "CUSTOM_DATE") { echo "hide"; } ?> datadiv">
	          							<div class="col-xl-2 col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
		          							<div class="form-group">
												<label>Data Inicial:</label>
												<div class="input-group date">
													<div class="input-group-addon">
														<i class="fa fa-calendar"></i>
													</div>
													<input type="text" class="form-control pull-right datepicker" name="datainicial" id="datainicial" value="<?php echo $sistema->filtro->data_inicio(); ?>">
												</div>
											</div>
										</div>
										<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
											<div class="form-group">
												<label>Data Final:</label>
												<div class="input-group date">
													<div class="input-group-addon">
														<i class="fa fa-calendar"></i>
													</div>
													<input type="text" class="form-control pull-right datepicker" class="datepicker" name="datafinal" id="datafinal" value="<?php echo $sistema->filtro->data_fim(); ?>">
												</div>
											</div>
										</div>
										<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
											<a id="datapersonalizada" class="btn btn-block btn-primary btn-flat">Pesquisar</a>
										</div>
									</div>
	          						<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
	          							<div class="checkbox">
											<label>
												<input type="checkbox" name="display" id="switch" class="buscarAPI" value="s" checked>
												Incluir Display
											</label>
										</div>
	          						</div>
	          					</div>
          					</form>
          				</div>
          				<div class="overlay preloader">
							<i class="fa fa-refresh fa-spin"></i>
						</div>
          			</div>
          		</div>
                <div class="col-xs-12">
                    <div class="box">
                        <div class="box-header with-border">
                            <h3 class="box-title">Dados de Resultado</h3>
                        </div>
                        <div class="box-body">
                            <div class="row">
                                <?php if($sistema->usuario->permissao_leads <= Usuario::PERM_ESCRITA) { ?>
                                    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
                                        <div class="info-box">
                                            <span class="info-box-icon bg-green"><i class="fa fa-envelope"></i></span>
                                            <div class="info-box-content">
                                                <span class="info-box-text">Formulários Preenchidos</span>
                                                <span class="info-box-number" id="forms"><div class="preloader"><i class="fa fa-refresh fa-spin"></i></div></span>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>

                                <?php if($sistema->usuario->permissao_whatsapp <= Usuario::PERM_ESCRITA) { ?>
                                    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
                                        <div class="info-box">
                                            <span class="info-box-icon bg-green"><i class="fa fa-whatsapp"></i></span>
                                            <div class="info-box-content">
                                                <span class="info-box-text">Contatos por WhatsApp</span>
                                                <span class="info-box-number" id="whatsapp"><div class="preloader"><i class="fa fa-refresh fa-spin"></i></div></span>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>

                                <?php if($sistema->usuario->permissao_3cx <= Usuario::PERM_ESCRITA) { ?>
                                    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
                                        <div class="info-box">
                                            <span class="info-box-icon bg-green"><i class="fa fa-phone"></i></span>
                                            <div class="info-box-content">
                                                <span class="info-box-text">Ligações</span>
                                                <span class="info-box-number" id="ligacoes"><div class="preloader"><i class="fa fa-refresh fa-spin"></i></div></span>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>

                                <?php if($sistema->usuario->permissao_leads <= Usuario::PERM_ESCRITA ||
                                    $sistema->usuario->permissao_3cx <= Usuario::PERM_ESCRITA ||
                                    $sistema->usuario->permissao_whatsapp <= Usuario::PERM_ESCRITA) { ?>
                                    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
                                        <div class="info-box">
                                            <span class="info-box-icon bg-olive"><i class="fa fa-th"></i></span>
                                            <div class="info-box-content">
                                                <span class="info-box-text">Total de Contatos</span>
                                                <span class="info-box-number" id="totalcontatos"><div class="preloader"><i class="fa fa-refresh fa-spin"></i></div></span>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>

                                <?php if($sistema->usuario->permissao_leads <= Usuario::PERM_ESCRITA ||
                                    $sistema->usuario->permissao_3cx <= Usuario::PERM_ESCRITA ||
                                    $sistema->usuario->permissao_whatsapp <= Usuario::PERM_ESCRITA) { ?>
                                    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
                                        <div class="info-box">
                                            <span class="info-box-icon bg-olive"><i class="fa fa-th"></i></span>
                                            <div class="info-box-content">
                                                <span class="info-box-text">Média Contatos por Dia</span>
                                                <span class="info-box-number" id="medialeads"><div class="preloader"><i class="fa fa-refresh fa-spin"></i></div></span>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>

                                <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-blue"><i class="fa fa-bars"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Anúncios / Contato</span>
                                            <span class="info-box-number" id="impressoeslead"><div class="preloader"><i class="fa fa-refresh fa-spin"></i></div></span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-blue"><i class="fa fa-mail-forward"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Cliques / Contato</span>
                                            <span class="info-box-number" id="cliqueslead"><div class="preloader"><i class="fa fa-refresh fa-spin"></i></div></span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-aqua"><i class="fa fa-bar-chart"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">% Contatos / Acessos</span>
                                            <span class="info-box-number" id="taxaconversao"><div class="preloader"><i class="fa fa-refresh fa-spin"></i></div></span>
                                        </div>
                                    </div>
                                </div>

                                <?php if($sistema->usuario->consultoria &&
                                    ($sistema->usuario->mostrar_cpl || $sistema->usuario instanceof Usuario_Adm)) {?>
                                    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12 custo-lead-container">
                                        <div class="info-box">
                                            <span class="info-box-icon bg-orange"><i class="fa fa-usd"></i></span>
                                            <div class="info-box-content">
                                                <span class="info-box-text">Custo Por Contato</span>
                                                <span class="info-box-number" id="cpl"><div class="preloader"><i class="fa fa-refresh fa-spin"></i></div></span>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                                
                                <?php if($sistema->usuario->permissao_linkclique <= Usuario::PERM_ESCRITA) { ?>
                                    <div class="col-xl-6 col-lg-6 col-md-8 col-sm-12 col-xs-12">
                                        <div class="info-box">
                                            <span class="info-box-icon bg-blue"><i class="fa fa-mouse-pointer"></i></span>
                                            <div class="info-box-content">
                                                <span class="info-box-text">Cliques Personalizados LP</span>
                                                <div style="display: flex;gap: 0px 10px;align-items: center;margin-top: 5px;">
                                                    <span class="info-box-number" id="linkclique"><div class="preloader"><i class="fa fa-refresh fa-spin"></i></div></span>
                                                    <div id="linkcliquebox"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xs-12">
                    <div class="box">
                        <div class="box-header with-border">
                            <h3 class="box-title">Dados Estatísticos</h3>
                        </div>
                        <div class="box-body">
                            <div class="row">
                                <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-blue"><i class="fa fa-bars"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Quantidade de Anúncios</span>
                                            <span class="info-box-number" id="impressoes"><div class="preloader"><i class="fa fa-refresh fa-spin"></i></div></span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-blue"><i class="fa fa-mail-forward"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Acessos ao site</span>
                                            <span class="info-box-number" id="cliques"><div class="preloader"><i class="fa fa-refresh fa-spin"></i></div></span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-red"><i class="fa fa-close"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Cliques Inválidos</span>
                                            <span class="info-box-number" id="invalidos"><div class="preloader"><i class="fa fa-refresh fa-spin"></i></div></span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-aqua"><i class="fa fa-bar-chart"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">% Acessos / Anúncios (CTR)</span>
                                            <span class="info-box-number" id="ctr"><div class="preloader"><i class="fa fa-refresh fa-spin"></i></div></span>
                                        </div>
                                    </div>
                                </div>

                                <!-- <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-blue"><i class="fa fa-bars"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Posição Média</span>
                                            <span class="info-box-number" id="posicaomedia"><div class="preloader"><i class="fa fa-refresh fa-spin"></i></div></span>
                                        </div>
                                    </div>
                                </div> -->

                                <?php if($sistema->usuario->mostrar_somente_campanhas >= '1') {?>
                                    <!-- <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
                                        <div class="info-box">
                                            <span class="info-box-icon bg-blue"><i class="fa fa-arrow-up"></i></span>
                                            <div class="info-box-content">
                                                <span class="info-box-text">% Apareceu no topo</span>
                                                <span class="info-box-number" id="topimpressions"><div class="preloader"><i class="fa fa-refresh fa-spin"></i></div></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
                                        <div class="info-box">
                                            <span class="info-box-icon bg-blue"><i class="fa fa-arrow-up"></i></span>
                                            <div class="info-box-content">
                                                <span class="info-box-text">% 1ª Posição</span>
                                                <span class="info-box-number" id="topimpressionsabsolute"><div class="preloader"><i class="fa fa-refresh fa-spin"></i></div></span>
                                            </div>
                                        </div>
                                    </div> -->
                                <?php } ?>

                                <?php if($sistema->usuario->consultoria) {?>
                                    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
                                        <div class="info-box">
                                            <span class="info-box-icon bg-orange"><i class="fa fa-usd"></i></span>
                                            <div class="info-box-content">
                                                <span class="info-box-text">Custo Total</span>
                                                <span class="info-box-number" id="custo"><div class="preloader"><i class="fa fa-refresh fa-spin"></i></div></span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
                                        <div class="info-box">
                                            <span class="info-box-icon bg-orange"><i class="fa fa-usd"></i></span>
                                            <div class="info-box-content">
                                                <span class="info-box-text">Custo Por Clique (CPC)</span>
                                                <span class="info-box-number" id="cpc"><div class="preloader"><i class="fa fa-refresh fa-spin"></i></div></span>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                        <div class="box-footer">
                            <div class="row">
                                <div class="col-xs-12">
                                    <a href="grupos" class="btn btn-primary btn-flat">Ver Mais Detalhes</button></a>
                                    <a href="grafico" class="btn btn-primary btn-flat">Ver Gráfico</button></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
			</div>
		</section>
	</div>



	<?php $sistema->layout->exibir_rodape();?>
</div>

<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/jquery.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/countUp.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/bootstrap.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/adminlte.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/bootstrap-datepicker.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/bootstrap-datepicker.pt-BR.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/toastr.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/jquery.mask.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/filtros.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/geral2.1.5.js"></script>

</body>
</html>