<?php
require_once(__DIR__ . "/classes/Sistema.php");
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if($sistema->usuario->permissao_google == Usuario::PERM_NENHUMA) $sistema->redirecionar("home");
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-MFFM5J3');</script>
<!-- End Google Tag Manager -->
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<title>Grupos de Anúncios - Sistema Win7</title>
	<link rel="icon" type="image/ico" href="favicon.png" />
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/datatables.min.css"/>
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/bootstrap-xl-xxl.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/font-awesome.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/ionicons.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/AdminLTE.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/skin-blue.min.css">
	<link rel="stylesheet" href="css/custom2.0.1.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/toastr.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/bootstrap-datepicker.min.css">

	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
	<?php $sistema->layout->criar_meta_tags();?>
</head>

<body class="hold-transition skin-blue sidebar-mini lte-fixed <?php if($sistema->usuario->sidebar) {echo "sidebar-collapse"; }?>">
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-MFFM5J3"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
<div class="modal fade" id="modal-sistema"><div class="modal-dialog modal-lg"><div class="modal-content" id="modal-sistema-conteudo"></div></div></div>
<div class="wrapper">
	<?php $sistema->layout->exibir_cabecalho('grupos');?>

	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
			<span class="tipopesquisa">Grupos de Anúncios</span>
			<small class="tipopesquisa2">Visualize os seus grupos de anúncios</small>
			</h1>
			<ol class="breadcrumb">
				<li><a href="javascript:void(0)"><i class="fa green-text fa-google"></i> Anúncios Google</a></li>
				<li><a href="grupos">Grupos de Anúncios</a></li>
			</ol>
		</section>

		<section class="content container-fluid">
			<div class="row">
				<div class="col-xs-12">
          			<div class="box">
          				<div class="box-body">
          					<form action="" method="POST" id="formGrupos">
          						<?php if(isset($_SESSION['erro-baixar-grupos'])) { ?>
								<div class="row"><div class="col-lg-6 col-sm-6 col-xs-12"><div class="alert alert-danger alert-dismissible">
									<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
									<?php
									switch($_SESSION['erro-baixar-grupos']){
										case 1:
											echo "Houve um erro com o servidor";
											break;
										case 2:
											echo "Há muitos registros a serem exibidos. Por favor, selecione um período menor.";
											break;
									}
									?>
								</div></div></div>
								<?php unset($_SESSION['erro-baixar-grupos']); } ?>
	          					<div class="row">
	          						<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
	          							<div class="form-group">
		          							<label>Período:</label>
											<select name="data" id="data" class="form-control" title="Selecione um perído">
												<?php $sistema->layout->select_periodo(); ?>
											</select>
										</div>
	          						</div>
	          						<div class="<?php if($sistema->filtro->valor() != "CUSTOM_DATE") { echo "hide"; } ?> datadiv">
	          							<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
		          							<div class="form-group">
												<label>Data Inicial:</label>
												<div class="input-group date">
													<div class="input-group-addon">
														<i class="fa fa-calendar"></i>
													</div>
													<input type="text" class="form-control pull-right datepicker" name="datainicial" id="datainicial" value="<?php echo $sistema->filtro->data_inicio(); ?>">
												</div>
											</div>
										</div>
										<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
											<div class="form-group">
												<label>Data Final:</label>
												<div class="input-group date">
													<div class="input-group-addon">
														<i class="fa fa-calendar"></i>
													</div>
													<input type="text" class="form-control pull-right datepicker" class="datepicker" name="datafinal" id="datafinal" value="<?php echo $sistema->filtro->data_fim(); ?>">
												</div>
											</div>
										</div>
										<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
											<a id="datapersonalizada" class="btn btn-block btn-primary btn-flat">Pesquisar</a>
										</div>
									</div>
									<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
	          							<div class="checkbox">
											<label>
												<input type="checkbox" name="display" id="switch" class="buscarAPI" value="s" checked>
												Incluir Display
											</label>
										</div>
	          						</div>
	          					</div>
          					</form>
          				</div>
          				<div class="overlay preloader">
							<i class="fa fa-refresh fa-spin"></i>
						</div>
          			</div>
          		</div>
			</div>
			<div class="row">
				<div class="col-xs-12">
					<div class="box">
						<div class="box-header with-border">
							<a href="javascript:void(0);" onclick="carregar_excel();" class="btn btn-primary" >Baixar Excel</a>
          				</div>
          				<div class="box-body">
          					<div id="tabelaGrupos" class="tabela">
          						<table id="tbGrupos" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>
          					</div>
          				</div>
          				<div class="overlay preloader">
							<i class="fa fa-refresh fa-spin"></i>
						</div>
          			</div>
				</div>
			</div>
		</section>
	</div>
	<?php $sistema->layout->exibir_rodape();?>
</div>

<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/jquery.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/datatables.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/bootstrap.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/adminlte.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/bootstrap-datepicker.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/bootstrap-datepicker.pt-BR.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/toastr.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/jquery.mask.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/moment-with-locales.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/datetime-moment.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/date.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/filtros.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/grupos2.0.3.js"></script>

</body>
</html>