<?php
require_once(__DIR__ . "/classes/Sistema.php");
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if($sistema->usuario->permissao_indicacoes != Usuario::PERM_ESCRITA) $sistema->redirecionar("home");

try{
	$sql = "SELECT 
		(SELECT count(*) FROM TBL_PAG_PENDENTES WHERE ID_CLIENTE = :ID AND ID_PRODUTO != -1) as produto,
		(SELECT count(*) FROM TBL_PAG_PENDENTES WHERE ID_CLIENTE = :ID2 AND ID_PRODUTO = -1) as dinheiro";
	$params = array(
		':ID' => $sistema->usuario->id,
		':ID2' => $sistema->usuario->id
	);
	$resultado = $sistema->bd->executar($sql, $params, Banco_Dados::FETCH);
}
catch(Exception $e){ echo $e; exit; }
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-MFFM5J3');</script>
<!-- End Google Tag Manager -->
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<title>Indicações - Sistema Win7</title>
	<link rel="icon" type="image/ico" href="favicon.png" />
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/datatables.min.css"/>
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/bootstrap-xl-xxl.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/font-awesome.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/ionicons.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/AdminLTE.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/skin-blue.min.css">
	<link rel="stylesheet" href="css/custom2.0.1.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/toastr.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/bootstrap-datepicker.min.css">

	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
	<?php $sistema->layout->criar_meta_tags();?>
</head>

<body class="hold-transition skin-blue sidebar-mini lte-fixed <?php if($sistema->usuario->sidebar) {echo "sidebar-collapse"; }?>">
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-MFFM5J3"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
<div class="modal fade" id="modal-confirmacao"><div class="modal-dialog"><div class="modal-content" id="modal-confirmacao-conteudo"></div></div></div>
<div class="modal fade" id="modal-sistema"><div class="modal-dialog modal-lg"><div class="modal-content" id="modal-sistema-conteudo"></div></div></div>
<div class="modal fade" id="modal-sistema-indicado"><div class="modal-dialog modal-lg"><div class="modal-content" id="modal-sistema-conteudo-indicado"></div></div></div>
<div class="wrapper">
	<?php $sistema->layout->exibir_cabecalho('indicacoes-financeiro');?>

	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
			<span class="tipopesquisa">Financeiro</span>
			<small class="tipopesquisa2">Visualize dados sobre pagamentos do sistema de indicações</small>
			</h1>
			<ol class="breadcrumb">
				<li><a href="javascript:void(0)"><i class="fa green-text fa-smile-o"></i> Indicações</a></li>
				<li><a href="indicacoes-financeiro">Financeiro</a></li>
			</ol>
		</section>

		<section class="content container-fluid">
			<div class="row">
				<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
					<div class="info-box">
						<span class="info-box-icon bg-green"><i class="fa fa-dollar"></i></span>
						<div class="info-box-content">
							<span class="info-box-text">Saldo Total dos Indicadores</span>
							<span class="info-box-number" id="saldoindicadores">--</span>
						</div>
					</div>
				</div>

				<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
					<div class="info-box">
						<span class="info-box-icon bg-green"><i class="fa fa-dollar"></i></span>
						<div class="info-box-content">
							<span class="info-box-text">Saldo de Cadastro Total</span>
							<span class="info-box-number" id="saldocadastro">--</span>
						</div>
					</div>
				</div>

				<?php if($sistema->indicacoes->usa_pontos == "0" || intval($resultado['dinheiro']) > 0){ ?>

				<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
					<div class="info-box">
						<span class="info-box-icon bg-green"><i class="fa fa-dollar"></i></span>
						<div class="info-box-content">
							<span class="info-box-text">Total de Bônus Pagos</span>
							<span class="info-box-number" id="bonuspagos">--</span>
						</div>
					</div>
				</div>

				<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
					<div class="info-box">
						<span class="info-box-icon bg-red"><i class="fa fa-dollar"></i></span>
						<div class="info-box-content">
							<span class="info-box-text">Total de Bônus Pendentes</span>
							<span class="info-box-number" id="bonuspendentes">--</span>
						</div>
					</div>
				</div>

				<?php } ?>

				<?php if($sistema->indicacoes->usa_pontos == "1" || intval($resultado['produto']) > 0){ ?>

				<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
					<div class="info-box">
						<span class="info-box-icon bg-green"><i class="fa fa-gift"></i></span>
						<div class="info-box-content">
							<span class="info-box-text">Total de Prêmios Entregues</span>
							<span class="info-box-number" id="premiosentregues">--</span>
						</div>
					</div>
				</div>

				<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
					<div class="info-box">
						<span class="info-box-icon bg-red"><i class="fa fa-gift"></i></span>
						<div class="info-box-content">
							<span class="info-box-text">Total de Prêmios Pendentes</span>
							<span class="info-box-number" id="premiospendentes">--</span>
						</div>
					</div>
				</div>

				<?php } ?>

				<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
					<div class="info-box">
						<span class="info-box-icon bg-blue"><i class="fa fa-dollar"></i></span>
						<div class="info-box-content">
							<span class="info-box-text">Saldo da Win7</span>
							<span class="info-box-number" id="saldowin">--</span>
						</div>
					</div>
				</div>

				<div class="col-xs-12">
          			<div class="box">
          				<div class="box-body">
          					<form action="" method="POST" id="formIndicacoes">
	          					<div class="row">
	          						<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
	          							<div class="form-group">
		          							<label>Período:</label>
											<select name="data" id="data" class="form-control" title="Selecione um perído">
												<?php $sistema->layout->select_periodo(false); ?>
											</select>
										</div>
	          						</div>
	          						<div class="hide datadiv">
	          							<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
		          							<div class="form-group">
												<label>Data Inicial:</label>
												<div class="input-group date">
													<div class="input-group-addon">
														<i class="fa fa-calendar"></i>
													</div>
													<input type="text" class="form-control pull-right datepicker" name="datainicial" id="datainicial">
												</div>
											</div>
										</div>
										<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
											<div class="form-group">
												<label>Data Final:</label>
												<div class="input-group date">
													<div class="input-group-addon">
														<i class="fa fa-calendar"></i>
													</div>
													<input type="text" class="form-control pull-right datepicker" class="datepicker" name="datafinal" id="datafinal">
												</div>
											</div>
										</div>
										<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
											<a id="datapersonalizada" class="btn btn-block btn-primary btn-flat">Pesquisar</a>
										</div>
									</div>
	          					</div>
          					</form>
          				</div>
          				<div class="overlay preloader">
							<i class="fa fa-refresh fa-spin"></i>
						</div>
          			</div>
          		</div>
			</div>
			<div class="row">
				<div class="col-xs-12">
					<?php if($sistema->indicacoes->usa_pontos == "1") { ?>
					<div class="box">
						<div class="box-header with-border">
							<h3 class="box-title">Resgates em Prêmios</h3>
          				</div>
          				<div class="box-body">
          					<div id="tabelaPremios" class="tabela">
          						<table id="tbPremios" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>
          					</div>
          				</div>
          				<div class="overlay preloader">
							<i class="fa fa-refresh fa-spin"></i>
						</div>
          			</div>
          			<?php if(intval($resultado['dinheiro']) > 0) { ?>
          			<div class="box">
						<div class="box-header with-border">
							<h3 class="box-title">Resgates em Dinheiro</h3>
          				</div>
          				<div class="box-body">
          					<div id="tabelaIndicacoes" class="tabela">
          						<table id="tbIndicacoes" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>
          					</div>
          				</div>
          				<div class="overlay preloader">
							<i class="fa fa-refresh fa-spin"></i>
						</div>
          			</div>
          			<?php } ?>
					<?php } else { ?>
					<div class="box">
						<div class="box-header with-border">
							<h3 class="box-title">Resgates em Dinheiro</h3>
          				</div>
          				<div class="box-body">
          					<div id="tabelaIndicacoes" class="tabela">
          						<table id="tbIndicacoes" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>
          					</div>
          				</div>
          				<div class="overlay preloader">
							<i class="fa fa-refresh fa-spin"></i>
						</div>
          			</div>
          			<?php if(intval($resultado['produto']) > 0) { ?>
          			<div class="box">
						<div class="box-header with-border">
							<h3 class="box-title">Resgates em Prêmios</h3>
          				</div>
          				<div class="box-body">
          					<div id="tabelaPremios" class="tabela">
          						<table id="tbPremios" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>
          					</div>
          				</div>
          				<div class="overlay preloader">
							<i class="fa fa-refresh fa-spin"></i>
						</div>
          			</div>
          			<?php } ?>
					<?php } ?>
				</div>
			</div>
		</section>
	</div>
	<?php $sistema->layout->exibir_rodape();?>
</div>

<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/jquery.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/datatables.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/bootstrap.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/adminlte.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/bootstrap-datepicker.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/bootstrap-datepicker.pt-BR.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/toastr.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/jquery.mask.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/moment.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/datetime-moment.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/date.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/filtros.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/indicacoes-financeiro2.1.4.js"></script>

</body>
</html>