<?php
require_once(__DIR__ . "/../classes/Sistema.php");
set_sistema(Sistema::INDICACOES);
$sistema = new Sistema(true);

if(empty($sistema->usuario->senha_transf)) $sistema->redirecionar("senha-transferencia");

$indicador = $sistema->indicacoes->obter_indicador($sistema->usuario->id);
$superior = $sistema->indicacoes->obter_superior($sistema->usuario->id);
?>
<!DOCTYPE html>
<html>
<head>
<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-T9DQW4X');</script>
<!-- End Google Tag Manager -->
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<meta name='theme-color' content="<?php echo $sistema->indicacoes->cor2; ?>">
	<title>Meus Dados - <?php echo $sistema->indicacoes->nome; ?></title>
	<link rel="icon" type="image/ico" href="<?php echo $sistema->indicacoes->favicon; ?>" />
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<link rel="stylesheet" href="css/datatables.min.css"/>
	<link rel="stylesheet" href="css/bootstrap-xl-xxl.css">
	<link rel="stylesheet" href="css/font-awesome.min.css">
	<link rel="stylesheet" href="css/ionicons.min.css">
	<link rel="stylesheet" href="css/AdminLTE.min.css">
	<link rel="stylesheet" href="css/skin-blue-light.min.css">
	<link rel="stylesheet" href="css/custom1.0.0.css">
	<link rel="stylesheet" href="css/toastr.min.css">
	<link rel="stylesheet" href="css/bootstrap-datepicker.min.css">
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
	<?php $sistema->layout->criar_meta_tags();?>
	<?php $sistema->layout->exibir_css_indicacao();?>
</head>

<body class="hold-transition skin-blue-light sidebar-mini <?php if($sistema->usuario->sidebar) {echo "sidebar-collapse"; }?>">
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-T9DQW4X"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
<div class="modal fade" id="modal-sistema"><div class="modal-dialog modal-lg"><div class="modal-content" id="modal-sistema-conteudo"></div></div></div>
<?php $sistema->layout->exibir_modal_adicionar_indicado();?>
<div class="wrapper">
	<?php $sistema->layout->exibir_cabecalho('dados');?>

	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
			Meus Dados
			<small>Visualize ou modifique seus dados</small>
			</h1>
			<ol class="breadcrumb">
				<li><a href="resgate"><i class="fa green-text fa-user"></i> Meus Dados </a></li>
			</ol>
		</section>

		<section class="content container-fluid">
			<div class="row">
				<div class="col-xs-12">
					<form id="formAtualizarDados" method="post" enctype="multipart/form-data">
					<div class="box">
						<div class="box-header with-border">
							Edite seus dados abaixo caso necessário e digite sua senha para aplicar as mudanças.<br>
							Ao solicitar a mudança de senha, será enviado um email com instruções.
          				</div>
          				<div class="box-body">
							<div class="row">
								<div class="col-xs-12 col-sm-6 col-lg-5 col-xl-3">
									<div class="form-group">
										<label>Nome:</label>
										<div class="input-group date">
											<div class="input-group-addon">
												<i class="fa fa-user"></i>
											</div>
											<input type="text" class="form-control pull-right" name="nome" id="nome" value="<?php echo $indicador['TXT_NOME']; ?>" required>
										</div>
									</div>
								</div>
								<div class="col-xs-12 col-sm-6 col-lg-4 col-xl-3">
									<div class="form-group">
										<label>Email:</label>
										<div class="input-group date">
											<div class="input-group-addon">
												<i class="fa fa-envelope"></i>
											</div>
											<input type="text" class="form-control pull-right" name="email" id="email" value="<?php echo $indicador['TXT_EMAIL']; ?>" disabled>
										</div>
									</div>
								</div>
								<div class="col-xs-12 col-sm-6 col-lg-3 col-xl-2">
									<div class="form-group">
										<label>Telefone:</label>
										<div class="input-group date">
											<div class="input-group-addon">
												<i class="fa fa-phone"></i>
											</div>
											<input type="text" class="form-control pull-right" name="telefone" id="telefone" value="<?php echo $indicador['TEL_CEL']; ?>" required>
										</div>
									</div>
								</div>
								<div class="col-xs-12 col-sm-6 col-lg-3 col-xl-2">
									<div class="form-group">
										<label>Senha:</label>
										<div class="input-group date">
											<div class="input-group-addon">
												<i class="fa fa-lock"></i>
											</div>
											<input type="password" class="form-control pull-right" name="senha" id="senha" required>
										</div>
									</div>
								</div>
								<div class="col-xs-12 col-sm-6 col-lg-3 col-xl-2">
									<div class="form-group">
										<label>
											<?php 
												if($sistema->indicacoes->text_cpf_cnpj_alternativo){echo $sistema->indicacoes->text_cpf_cnpj_alternativo.":";}
												else { if ($sistema->indicacoes->permissao_cnpj_indicador == "1") { echo "CPF ou CNPJ:"; } else { echo "CPF:"; }}
											?>
										</label>
										<div class="input-group date">
											<div class="input-group-addon">
												<i class="fa fa-user"></i>
											</div>
											<input type="text" class="form-control pull-right" name="cpf" id="cpf" value="<?php echo Mascara::mascara_cpf_cnpj($indicador['NU_CPF']); ?>" disabled>
										</div>
									</div>
								</div>
							</div>
          				</div>
          				<div class="box-footer">
  							<button type="submit" class="btn btn-primary text-center" style="margin-right: 6px; margin-bottom: 6px;">Salvar Mudanças</button><button type="button" class="btn btn-primary text-center" style="margin-right: 6px; margin-bottom: 6px;" onclick="mudar_acesso();">Mudar Senha de Acesso</button><button type="button" class="btn btn-primary text-center" onclick="mudar_transferencia();" style="margin-right: 6px; margin-bottom: 6px;">Mudar Senha de Transferência</button>
  						</div>
  						<div class="overlay preloader">
							<i class="fa fa-refresh fa-spin"></i>
						</div>
          			</div>
          			</form>
				</div>
				<?php if($superior != -1 && $sistema->indicacoes->upline == "1") { ?>
				<div class="col-xs-12">
					<div class="box">
						<div class="box-header with-border">
							Segue abaixo os dados da pessoa que te indicou.
          				</div>
          				<div class="box-body">
							<div class="row">
								<div class="col-xs-12 col-sm-6 col-lg-3">
									<div class="form-group">
										<label>Nome:</label>
										<div class="input-group date">
											<div class="input-group-addon">
												<i class="fa fa-user"></i>
											</div>
											<input type="text" class="form-control pull-right" name="nome-indicador2" id="nome-indicador2" value="<?php echo $superior['TXT_NOME']; ?>">
										</div>
									</div>
								</div>
								<div class="col-xs-12 col-sm-6 col-lg-3">
									<div class="form-group">
										<label>Email:</label>
										<div class="input-group date">
											<div class="input-group-addon">
												<i class="fa fa-envelope"></i>
											</div>
											<input type="text" class="form-control pull-right" name="email-indicador2" id="email-indicador2" value="<?php echo $superior['TXT_EMAIL']; ?>">
										</div>
									</div>
								</div>
								<div class="col-xs-12 col-sm-6 col-lg-3 col-xl-2">
									<div class="form-group">
										<label>Telefone:</label>
										<div class="input-group date">
											<div class="input-group-addon">
												<i class="fa fa-phone"></i>
											</div>
											<input type="text" class="form-control pull-right" name="telefone-indicador2" id="telefone-indicador2" value="<?php echo $superior['TEL_CEL']; ?>">
										</div>
									</div>
								</div>
							</div>
          				</div>
          			</div>
				</div>
				<?php } ?>
			</div>
		</section>
	</div>
	<?php $sistema->layout->exibir_rodape();?>
</div>

<script src="js/bootstrap.min.js"></script>
<script src="js/adminlte.min.js"></script>
<script src="js/toastr.min.js"></script>
<script src="js/dados1-0-1"></script>

</body>
</html>