<?php
/***
	Este arquivo exibe a tela de login padrão do sistema win7, 
	que é acessada por nossos clientes.
***/

require_once(__DIR__ . "/../classes/Sistema.php");
set_sistema(Sistema::INDICACOES);
$sistema = new Sistema();

// Se estiver setado o r ou o i, é link de indicado
if(isset($_GET['r']) || isset($_GET['i'])){
	if(isset($_GET['i']) && $sistema->indicacoes->cadastro_indicado == "1"){
		$_GET['r'] = $_GET['i'];
		unset($_GET['i']);
	}
	$sistema->sessao->deslogar();
	$_SESSION['indicadorID'] = isset($_GET['r']) ? $_GET['r'] : $_GET['i'];

	if(!ctype_digit($_SESSION['indicadorID'])){ // Se a ID não for um número, retorna para a página inicial
		unset($_SESSION['indicadorID']);
		$_SESSION['errologin'] = 5;
		$sistema->redirecionar('../');
	}

	// Procura o indicador com a ID especificada
	$indicador = $sistema->indicacoes->obter_indicador($_SESSION['indicadorID']);

	if($sistema->bd->quantidade() > 0) // Se o indicador existe, redireciona o usuário para a página de registro
		isset($_GET['i']) ? Layout_Sistema::redirecionar_indicado($sistema) : Layout_Sistema::redirecionar_indicador($sistema);
	else{ // Se o indicador não existe, retorna para a página de login
		unset($_SESSION['indicadorID']);
		$_SESSION['errologin'] = 5;
		$sistema->redirecionar('../');
	}
}

if (isset($_GET['t'])) {
	$sistema->sessao->deslogar();
	$resultado = $sistema->indicacoes->ativar_conta($_GET['t']);
	if($resultado == Sistema::FALHA)
		$_SESSION['errologin'] = 12;
	else if ($resultado == Sistema::SUCESSO)
		$_SESSION['loginsucesso'] = 2;
	else
		$_SESSION['errologin'] = 0;
}

// Caso o cliente já esteja logado, enviamos ele para a home
if($sistema->sessao->logado()) $sistema->redirecionar("home");

$login_nome = $sistema->indicacoes->vocabulario[18];
$login_nome = str_replace("#NOME-CLIENTE#", $sistema->indicacoes->nome, $login_nome);
$titulo = $sistema->indicacoes->vocabulario[20];
$titulo = str_replace("#NOME-CLIENTE#", $sistema->indicacoes->nome, $titulo);
$imagem_social = empty($sistema->indicacoes->imagem_social) ? $sistema->indicacoes->logo : $sistema->indicacoes->imagem_social;
$rodape1 = $sistema->indicacoes->vocabulario[2];
$rodape1 = str_replace("#NOME-CLIENTE#",$sistema->indicacoes->nome, $rodape1);
$rodape2 = $sistema->indicacoes->vocabulario[3];
$rodape2 = str_replace("#TELEFONE#", $sistema->indicacoes->telefone, $rodape2);
$rodape2 = str_replace("#SITE#", $sistema->indicacoes->contato, $rodape2);
?>
<!DOCTYPE html>
<html>
<head>
<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-T9DQW4X');</script>
<!-- End Google Tag Manager -->
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<meta name='theme-color' content="<?php echo $sistema->indicacoes->cor2; ?>">
	<meta name="description" content="<?php echo $sistema->indicacoes->vocabulario[22]; ?>" /> 
	<meta property="og:title" content="<?php echo $titulo;?>" />
	<meta property="og:type" content="website"/>
	<meta property="og:image" content="<?php echo $imagem_social;?>"/>
	<meta property="og:description" content="<?php echo $sistema->indicacoes->vocabulario[22];?>" />
	<title><?php echo $sistema->indicacoes->nome; ?></title>
	<link rel="icon" type="image/ico" href="<?php echo $sistema->indicacoes->favicon; ?>" />
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<link rel="stylesheet" href="css/font-awesome.min.css">
	<link rel="stylesheet" href="css/ionicons.min.css">
	<link rel="stylesheet" href="css/AdminLTE.min.css">
	<link rel="stylesheet" href="css/custom-not-logged.css">
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
	<?php $sistema->layout->exibir_css_indicacao_index();?>

</head>

<body class="hold-transition login-page" style="height: auto;">
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-T9DQW4X"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
	<div class="login-box">
		<div class="login-logo">
			<a href="./"><img src="<?php echo $sistema->indicacoes->logo; ?>" width="150"></a>
		</div>
		<div class="row" style="margin-bottom: 10px; margin-right: 0px; margin-left: 0px; background-color: #f5f7fb; padding: 10px; margin-top: 0px; text-align: center;">
			<div class="col-xs-12 ">
				<?php echo $rodape1; ?>
			</div>
		</div>
		<div class="login-box-body">
			<?php if(isset($_SESSION['errologin'])) { ?>
			<div class="alert alert-danger alert-dismissible">
				<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
				<?php
				switch($_SESSION['errologin']){
					case 0:
						echo "Houve um erro ao conectar com o servidor! Atualize a página e tente novamente.";
						break;
					case 1:
						if($sistema->indicacoes->text_cpf_cnpj_alternativo){echo $sistema->indicacoes->text_cpf_cnpj_alternativo." ou Senha incorretos! Tente novamente.";} else {echo 'CPF ou Senha incorretos! Tente novamente.';}
						break;
					case 2:
						echo "Sua conta não está ativada! Verifique seu email.";
						break;
					case 3:
						echo "Faça login para acessar o sistema!";
						break;
					case 4:
						echo "Houve um erro ao acessar o servidor!";
						break;
					case 5:
						echo "Link de indicado incorreto!";
						break;
					case 6:
						echo "Erro ao acessar link!";
						break;
					case 7:
						echo "Link inválido!";
						break;
					case 8:
						echo "Erro ao mudar senha!";
						break;
					case 9:
						echo "Erro ao enviar email!";
						break;
					case 10:
						echo "Cadastro não encontrado!";
						break;
					case 11:
						echo "Faça login para acessar o sistema!";
						break;
					case 12:
						echo "Link expirado!";
						break;
				}
				?>
			</div>
			<?php unset($_SESSION['errologin']); } ?>
			<?php if(isset($_SESSION['loginsucesso'])) { ?>
			<div class="alert alert-success alert-dismissible">
				<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
				<?php
				switch($_SESSION['loginsucesso']){
					case 0:
						echo "Senha modificada com sucesso!";
						break;
					case 1:
						echo "Email enviado com sucesso!";
						break;
					case 2:
						echo "Conta ativada com sucesso!";
						break;
				}
				?>
			</div>
			<?php unset($_SESSION['loginsucesso']); } ?>
			<p class="text-center"><b>Login</b></p>
			<form action="action/login" method="post">
				<div class="form-group has-feedback">
					<input id="usuario" name="usuario" type="text" class="form-control" alt="Usuário" placeholder="<?php 
					if($sistema->indicacoes->text_cpf_cnpj_alternativo){echo $sistema->indicacoes->text_cpf_cnpj_alternativo.":";}
					else { if ($sistema->indicacoes->permissao_cnpj_indicador == "1") { echo "CPF ou CNPJ:"; } else { echo "CPF:"; }}
					?>" onkeydown='mascaraMutuario(this,cpfCnpj)' onchange='mascaraMutuario(this,cpfCnpj)' autocomplete="off" autocorrect="off" autocapitalize="off" required>
        			<span class="glyphicon glyphicon-user form-control-feedback"></span>
				</div>
				<div class="form-group has-feedback">
					<input id="senha" name="senha" type="password" class="form-control" alt="Senha" placeholder="Senha" autocomplete="off" autocorrect="off" autocapitalize="off" required>
        			<span class="glyphicon glyphicon-lock form-control-feedback"></span>
        			<a href="esqueceu" style="vertical-align: sub;">Esqueceu a senha?</a>
				</div>
				<div class="row">
					<div class="col-xs-6">
						<a href="indicador" class="btn btn-default btn-block btn-flat"><b>Cadastrar</b></a>
					</div>
					<div class="col-xs-6">
						<button type="submit" class="btn btn-primary btn-block btn-flat">Entrar</button>
					</div>
				</div>
			</form>
		</div>
		<div class="row" style="margin-top: 10px; margin-right: 0px; margin-left: 0px; background-color: #f5f7fb; padding: 15px; margin-bottom: 0px;">
			<div class="col-xs-12 ">
				<div class="rodape"><?php echo $rodape2; ?></div>
			</div>
			<div class="col-xs-12 ">
				<div class="rodape">
				
					<?php if ($sistema->indicacoes->numero_whatsapp_contato_rodape != '') { ?>
						<p>Quer um sistema como este? Entre em contato pelo WhatsApp: <a href="https://wa.me/<?php echo $sistema->indicacoes->numero_whatsapp_contato_rodape; ?>" target="_blank" > <u>clique aqui</u></a></p>
					<?php } else { ?>
						<p>Quer um sistema como este? Acesse: <a href="https://www.win7.com.br" target="_blank"> win7.com.br</a></p>
					<?php } ?>

				</div>
			</div>
		</div>
	</div>
	<script src="js/jquery.min.js"></script>
	<script src="js/bootstrap.min.js"></script>
	<script src="js/pagina-index.js"></script>
</body>
</html>