<?php
require_once(__DIR__ . "/../classes/Sistema.php");
set_sistema(Sistema::INDICACOES);
$sistema = new Sistema(true);

if(empty($sistema->usuario->senha_transf)) $sistema->redirecionar("senha-transferencia");

if($sistema->indicacoes->usa_pontos == "1"){
	$saldo = number_format($sistema->usuario->saldo, 0,",",".");
	$saldo_cadastro = number_format($sistema->usuario->saldo_cadastro, 0,",",".");
}
else{
	$sistema->redirecionar("resgate");
}

try{
	$sql = "SELECT * FROM TBL_INDICACOES_PRODUTOS WHERE ID_CLIENTE_FK = :id AND NU_DELETADO = 0 AND (NU_ESTOQUE > 0 OR NU_ESTOQUE_INFINITO = 1) ORDER BY NU_PONTOS";
	$params = array(
		':id' => $sistema->indicacoes->id
	);
	$produtos = $sistema->bd->executar($sql, $params, Banco_Dados::FETCH_ALL);
}
catch(Exception $e){
	$produtos = array();
}
?>
<!DOCTYPE html>
<html>
<head>
<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-T9DQW4X');</script>
<!-- End Google Tag Manager -->
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<meta name='theme-color' content="<?php echo $sistema->indicacoes->cor2; ?>">
	<title>Resgate de Bônus - <?php echo $sistema->indicacoes->nome; ?></title>
	<link rel="icon" type="image/ico" href="<?php echo $sistema->indicacoes->favicon; ?>" />
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<link rel="stylesheet" href="css/datatables.min.css"/>
	<link rel="stylesheet" href="css/bootstrap-xl-xxl.css">
	<link rel="stylesheet" href="css/font-awesome.min.css">
	<link rel="stylesheet" href="css/ionicons.min.css">
	<link rel="stylesheet" href="css/AdminLTE.min.css">
	<link rel="stylesheet" href="css/skin-blue-light.min.css">
	<link rel="stylesheet" href="css/custom1.0.0.css">
	<link rel="stylesheet" href="css/toastr.min.css">
	<link rel="stylesheet" href="css/bootstrap-datepicker.min.css">
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
	<?php $sistema->layout->criar_meta_tags();?>
	<?php $sistema->layout->exibir_css_indicacao();?>
</head>

<body class="hold-transition skin-blue-light sidebar-mini <?php if($sistema->usuario->sidebar) {echo "sidebar-collapse"; }?>">
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-T9DQW4X"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
<div class="modal fade" id="modal-confirmacao"><div class="modal-dialog"><div class="modal-content" id="modal-confirmacao-conteudo"></div></div></div>
<div class="modal fade" id="modal-sistema"><div class="modal-dialog modal-lg"><div class="modal-content" id="modal-sistema-conteudo"></div></div></div>
<?php $sistema->layout->exibir_modal_adicionar_indicado();?>
<div class="wrapper">
	<?php $sistema->layout->exibir_cabecalho('resgate');?>

	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
			Resgate de Bônus
			<small>Realize o resgate dos bônus que possui</small>
			</h1>
			<ol class="breadcrumb">
				<li><a href="resgate"><i class="fa green-text fa-gift"></i> Resgatar Saldo </a></li>
			</ol>
		</section>

		<section class="content container-fluid">
			<div class="row">
				<?php if(isset($_SESSION['erroresgate'])) { ?>
				<div class="col-xs-12"><div class="alert alert-danger alert-dismissible">
					<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
					<?php
					switch($_SESSION['erroresgate']){
						case 0:
							echo 'A senha de transferência digitada está incorreta!';
							break;
						case 1:
							echo 'O resgate não foi completado devido a um erro no servidor!';
							break;
						case 2:
							echo 'O seu saldo não é suficiente para fazer o resgate solicitado!';
							break;
						case 3:
							if($sistema->indicacoes->text_cpf_cnpj_alternativo){
								echo $sistema->indicacoes->text_cpf_cnpj_alternativo.' Incorreto';
							} else {
								echo 'CPF Incorreto';
							}
							break;
						case 4:
							echo 'O valor não pode ser vazio!';
							break;
					}
					?>
				</div></div>
				<?php unset($_SESSION['erroresgate']); } ?>
				<?php if(isset($_SESSION['resgatesucesso'])) { ?>
				<div class="col-xs-12"><div class="alert alert-success alert-dismissible">
					<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
					<?php
					switch($_SESSION['resgatesucesso']){
						case 0:
							echo "Pedido de resgate realizado com sucesso!";
							break;
					}
					?>
				</div></div>
				<?php unset($_SESSION['resgatesucesso']); } ?>
				<?php if($sistema->usuario->saldo_cadastro > 0) { ?>
				<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
					<div class="info-box">
						<span class="info-box-icon text-green"><i class="fa fa-gift"></i></span>
						<div class="info-box-content">
							<span class="info-box-text"><?php echo $sistema->indicacoes->vocabulario[29]; ?></span>
							<span class="info-box-number" id="saldoCadastro"><?php echo $saldo_cadastro; ?></span>
						</div>
					</div>
				</div>
				<?php } ?>
				<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
					<div class="info-box">
						<span class="info-box-icon text-blue"><i class="fa fa-star"></i></span>
						<div class="info-box-content">
							<span class="info-box-text"><?php echo $sistema->indicacoes->vocabulario[5]; ?></span>
							<span class="info-box-number saldo-indicador"><?php echo $saldo; ?></span>
						</div>
					</div>
				</div>
			</div>
			<?php if(count($produtos) > 0){ ?>
			<p>Selecione abaixo os prêmios que deseja resgatar: </p>
			<?php } else { ?>
			<p>Não há prêmios disponíveis. </p>
			<?php } ?>

			<?php 
			foreach ($produtos as $produto) {
				$id = $produto['NU_ID'];
				$link = "https://" . $sistema->indicacoes->dominio . "/arquivos/". $produto['TXT_IMAGEM'];
				$nome = $produto['TXT_NOME'];
				$pontos = number_format(intval($produto['NU_PONTOS']), 0, ",", ".");
				if(intval($produto['NU_PONTOS']) > 1)
					$pontos = $pontos . " pontos";
				else
					$pontos = $pontos . " ponto";
				$descricao = $produto['TXT_DESCRICAO'];
			?>
			<div class="box box-produto" onclick="resgatarPremio(<?php echo $id; ?>);">
				<div class="box-body">
					<div class="row">
						<div class="col-xs-12 text-center">
							<img src="<?php echo $link; ?>" class="img-produto">
							<hr class="hr-produto">
							<span class="titulo-produto"><?php echo $nome; ?><?php if($sistema->usuario->saldo_cadastro > 0 && $produto['NU_RESGATE_NORMAL'] == "0") { ?> <i class="fa fa-gift text-green"></i><i class="fa fa-star text-blue"></i><?php } ?><?php if($sistema->usuario->saldo_cadastro > 0 && $produto['NU_RESGATE_NORMAL'] == "1") { ?> <i class="fa fa-star text-blue"></i><?php } ?></span>
							<span class="pontos-produto"><?php echo $pontos; ?></span>
						</div>
					</div>
				</div>
			</div>
			<?php } ?>
		</section>
	</div>
	<?php $sistema->layout->exibir_rodape();?>
</div>

<script src="js/bootstrap.min.js"></script>
<script src="js/adminlte.min.js"></script>
<script src="js/toastr.min.js"></script>
<script src="js/resgate-premios1.0.0.js"></script>


</body>
</html>