<?php
/***
	Este arquivo exibe a tela de login padrão do sistema win7, 
	que é acessada por nossos clientes.
***/

require_once(__DIR__ . "/../classes/Sistema.php");
set_sistema(Sistema::INDICACOES);
$sistema = new Sistema();
$sistema->sessao->deslogar();

if(isset($_GET['s']) || isset($_GET['t'])){
	$token = isset($_GET['s']) ? $_GET['s'] : $_GET['t'];
	$sql = isset($_GET['s']) ? "SELECT NU_ID FROM TBL_INDICACOES WHERE TOKEN_SENHA = :TOKEN_SENHA AND NU_CLIENTE = :ID" : "SELECT NU_ID FROM TBL_INDICACOES WHERE TOKEN_SENHA2 = :TOKEN_SENHA AND NU_CLIENTE = :ID";

	try{
		$dados = $sistema->bd->executar($sql, array(':TOKEN_SENHA' => $token, ':ID' => $sistema->indicacoes->id), Banco_Dados::FETCH);

		if($sistema->bd->quantidade() > 0){
			$id = $dados['NU_ID'];
			$_SESSION['tokenSenhaNova'] = $token;
			$_SESSION['tokenSenhaNovaId'] = $id;
			$_SESSION['tokenSenhaNovaTipo'] = isset($_GET['s']) ? 0 : 1;
		}
		else{
			$_SESSION['errologin'] = 7;
			$sistema->redirecionar("./");
		}
	}
	catch(Exception $e){
		$_SESSION['login'] = 7;
		header('Location: ./');
		exit;
	}
}
else{
	$_SESSION['errologin'] = 7;
	$sistema->redirecionar("./");
}
?>
<!DOCTYPE html>
<html>
<head>
<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-T9DQW4X');</script>
<!-- End Google Tag Manager -->
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<meta name='theme-color' content="<?php echo $sistema->indicacoes->cor2; ?>">
	<title>Trocar Senha -  <?php echo $sistema->indicacoes->nome; ?></title>
	<link rel="icon" type="image/ico" href="<?php echo $sistema->indicacoes->favicon; ?>" />
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<link rel="stylesheet" href="css/font-awesome.min.css">
	<link rel="stylesheet" href="css/ionicons.min.css">
	<link rel="stylesheet" href="css/AdminLTE.min.css">
	<link rel="stylesheet" href="css/toastr.min.css">
	<link rel="stylesheet" href="css/custom-not-logged.css">
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
	<?php $sistema->layout->exibir_css_indicacao_index();?>
</head>

<body class="hold-transition login-page" style="height: auto;">
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-T9DQW4X"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
	<div class="login-box">
		<div class="login-logo">
			<a href="./"><img src="<?php echo $sistema->indicacoes->logo; ?>" width="150"></a>
		</div>
		<div class="login-box-body">
			<p class="text-center">Digite abaixo a sua nova <?php if($_SESSION['tokenSenhaNovaTipo'] == 0){?>senha de acesso<?php } else{?>senha de transferência<?php }?>.</p>
			<form action="action/salvar_senha" method="post" onsubmit="return validarFormSenhaNova();">
				<div class="form-group has-feedback">
					<input id="senha1" name="senha1" type="password" class="form-control" alt="Senha" placeholder="Senha" required>
        			<span class="glyphicon glyphicon-lock form-control-feedback"></span>
				</div>
				<div class="form-group has-feedback">
					<input id="senha2" name="senha2" type="password" class="form-control" alt="Senha" placeholder="Redigite a Senha" required>
        			<span class="glyphicon glyphicon-lock form-control-feedback"></span>
				</div>
				<div class="row">
					<div class="col-xs-12">
						<button type="submit" class="btn btn-primary btn-block btn-flat">Enviar</button>
					</div>
				</div>
			</form>
		</div>
	</div>
	<script src="js/jquery.min.js"></script>
	<script src="js/bootstrap.min.js"></script>
	<script src="js/toastr.min.js"></script>
	<script src="js/basico-trocar-senha.js"></script>
</body>
</html>