$(".datepicker").datepicker({
  format: "dd/mm/yyyy",
  endDate: "0d",
  autoclose: true,
  language: "pt-BR",
});

$(".datepicker").mask("00/00/0000");

function carregar_dados() {
  $(document).ready(function () {
    var dados = jQuery("#formHome").serialize();
    jQuery.ajax({
      type: "POST",
      url: "action/atualizar_geral_comparacao",
      data: dados,
      success: function (data) {
        $(".preloader").css({ display: "none" });
        if (data == "-1") {
          window.location.href = "./";
          return;
        }
        if (data.substring(0, 2) == "-2") {
          toastr.clear();
          toastr.error(data.substring(2));
          return;
        }
        var json = JSON.parse(data);
        // console.log(json);

        let colunas = "";
        let contadorHover = 0;
        for (let i = 0; i < json.length; i++) {
          colunas += `
                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-12 col-xs-12">
                        <div class="box" style="${
                          json[i].checked
                            ? "box-shadow: 0px 0px 0px 6px #0d7ebb99;"
                            : ""
                        }">
                            <div class="box-header with-border">
                                <!--h3 class="box-title">Período ${i + 1}</h3-->
                                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                    <!--div class="checkbox">
                                        <label>
                                            <input type="radio" name="destaque" id="switch" class="buscarAPI" value="${i}" onclick="atualizar()" ${
            json[i].checked
          }>
                                            ${i + 1}
                                        </label>
                                    </div-->
                                </div>
                                <div class="checkbox-field">
                                    <input type="radio" name="destaque" id="switch${
                                      i + 1
                                    }" value="${i}" ${
            json[i].checked
          }><label for="switch${i + 1}">Período ${i + 1}</label>
                                </div>
                            </div>
                            <div class="datas sticky">${
                              json[i].datainicial === json[i].datafinal
                                ? json[i].datainicial
                                : json[i].datainicial +
                                  " ➜ " +
                                  json[i].datafinal
                            }</div>
                            <div class="box-body">
                                <div class="row">
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <div class="info-box hover${contadorHover++}">
                                            <div class="hover-item">
                                                <span class="tooltip-info" data-tip="Porcentagem de quantas vezes seu anúncio ficou no topo em 1º lugar na busca">
                                                    <div class="icone-info"><i class="fa fa-info-circle"></i></div>
                                                </span>
                                                <span class="info-box-icon bg-marsala"><img src="./../img/topo.svg" alt="Topo" width="32px"></span>
                                                <div class="info-box-content info-box-content-custom">
                                                    <span class="info-box-text">% no 1º lugar</span>
                                                    <div class="info-box-number">
                                                        <span id="ads_impressoes_topo0">
                                                            ${
                                                              json[i]
                                                                .ads_impressoes_topo[0]
                                                            }
                                                        </span>
                                                        <div class="grid-dados-calculados">
                                                            <div class="div0 ${
                                                              "txt-" +
                                                              json[i]
                                                                .ads_impressoes_topo[4]
                                                            }">${
            json[i].ads_impressoes_topo[1]
          }</div>
                                                            ${
                                                              json[i].checked
                                                                ? ``
                                                                : `<div class="div1 ${
                                                                    "txt-" +
                                                                    json[i]
                                                                      .ads_impressoes_topo[4]
                                                                  }">${
                                                                    json[i]
                                                                      .ads_impressoes_topo[2]
                                                                  }</div>`
                                                            }
                                                            <div class="div2 ${
                                                              "bg-" +
                                                              json[i]
                                                                .ads_impressoes_topo[4]
                                                            }">${
            json[i].ads_impressoes_topo[3]
          }</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <div class="info-box hover${contadorHover++}">
                                            <div class="hover-item">
                                                <span class="tooltip-info" data-tip="Porcentagem de quantas vezes seu anúncio ficou no topo entre os 4 primeiros lugares na busca">
                                                    <div class="icone-info"><i class="fa fa-info-circle"></i></div>
                                                </span>
                                                <span class="info-box-icon bg-marsala"><img src="./../img/topo4.svg" alt="Topo 4" width="40px"></span>
                                                <div class="info-box-content info-box-content-custom">
                                                    <span class="info-box-text">% entre os 4 primeiros</span>
                                                    <div class="info-box-number">
                                                        <span id="ads_impressoes_4_primeiros0">
                                                            ${
                                                              json[i]
                                                                .ads_impressoes_4_primeiros[0]
                                                            }
                                                        </span>
                                                        <div class="grid-dados-calculados">
                                                            <div class="div0 ${
                                                              "txt-" +
                                                              json[i]
                                                                .ads_impressoes_4_primeiros[4]
                                                            }">${
            json[i].ads_impressoes_4_primeiros[1]
          }</div>
                                                            ${
                                                              json[i].checked
                                                                ? ``
                                                                : `<div class="div1 ${
                                                                    "txt-" +
                                                                    json[i]
                                                                      .ads_impressoes_4_primeiros[4]
                                                                  }">${
                                                                    json[i]
                                                                      .ads_impressoes_4_primeiros[2]
                                                                  }</div>`
                                                            }
                                                            <div class="div2 ${
                                                              "bg-" +
                                                              json[i]
                                                                .ads_impressoes_4_primeiros[4]
                                                            }">${
            json[i].ads_impressoes_4_primeiros[3]
          }</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <div class="info-box hover${contadorHover++}">
                                            <div class="hover-item">
                                                <span class="info-box-icon bg-cinza-azulado"><i class="fa fa-bar-chart"></i></span>
                                                <div class="info-box-content info-box-content-custom">
                                                    <span class="info-box-text">% CONTATOS / ACESSOS</span>
                                                    <div class="info-box-number">
                                                        <span id="real_taxa_conversao0">
                                                            ${
                                                              json[i]
                                                                .real_taxa_conversao[0]
                                                            }
                                                        </span>
                                                        <div class="grid-dados-calculados">
                                                            <div class="div0 ${
                                                              "txt-" +
                                                              json[i]
                                                                .real_taxa_conversao[4]
                                                            }">${
            json[i].real_taxa_conversao[1]
          }</div>
                                                            ${
                                                              json[i].checked
                                                                ? ``
                                                                : `<div class="div1 ${
                                                                    "txt-" +
                                                                    json[i]
                                                                      .real_taxa_conversao[4]
                                                                  }">${
                                                                    json[i]
                                                                      .real_taxa_conversao[2]
                                                                  }</div>`
                                                            }
                                                            <div class="div2 ${
                                                              "bg-" +
                                                              json[i]
                                                                .real_taxa_conversao[4]
                                                            }">${
            json[i].real_taxa_conversao[3]
          }</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <div class="info-box hover${contadorHover++}">
                                            <div class="hover-item">
                                                <span class="tooltip-info" data-tip="Valores arredondados">
                                                    <div class="icone-info"><i class="fa fa-info-circle"></i></div>
                                                </span>
                                                <span class="info-box-icon bg-cinza-azulado"><i class="fa fa-bar-chart"></i></span>
                                                <div class="info-box-content info-box-content-custom">
                                                    <span class="info-box-text">ANÚNCIOS / CONTATO</span>
                                                    <div class="info-box-number">
                                                        <span id="real_impressoes_por_contato0">
                                                            ${
                                                              json[i]
                                                                .real_impressoes_por_contato[0]
                                                            }
                                                        </span>
                                                        <div class="grid-dados-calculados">
                                                            <div class="div0 ${
                                                              "txt-" +
                                                              json[i]
                                                                .real_impressoes_por_contato[4]
                                                            }">${
            json[i].real_impressoes_por_contato[1]
          }</div>
                                                            ${
                                                              json[i].checked
                                                                ? ``
                                                                : `<div class="div1 ${
                                                                    "txt-" +
                                                                    json[i]
                                                                      .real_impressoes_por_contato[4]
                                                                  }">${
                                                                    json[i]
                                                                      .real_impressoes_por_contato[2]
                                                                  }</div>`
                                                            }
                                                            <div class="div2 ${
                                                              "bg-" +
                                                              json[i]
                                                                .real_impressoes_por_contato[4]
                                                            }">${
            json[i].real_impressoes_por_contato[3]
          }</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <div class="info-box hover${contadorHover++}">
                                            <div class="hover-item">
                                                <span class="info-box-icon bg-cinza-azulado"><i class="fa fa-bar-chart"></i></span>
                                                <div class="info-box-content info-box-content-custom">
                                                    <span class="info-box-text">CLIQUES / CONTATO</span>
                                                    <div class="info-box-number">
                                                        <span id="real_cliques_por_contato0">
                                                            ${
                                                              json[i]
                                                                .real_cliques_por_contato[0]
                                                            }
                                                        </span>
                                                        <div class="grid-dados-calculados">
                                                            <div class="div0 ${
                                                              "txt-" +
                                                              json[i]
                                                                .real_cliques_por_contato[4]
                                                            }">${
            json[i].real_cliques_por_contato[1]
          }</div>
                                                            ${
                                                              json[i].checked
                                                                ? ``
                                                                : `<div class="div1 ${
                                                                    "txt-" +
                                                                    json[i]
                                                                      .real_cliques_por_contato[4]
                                                                  }">${
                                                                    json[i]
                                                                      .real_cliques_por_contato[2]
                                                                  }</div>`
                                                            }
                                                            <div class="div2 ${
                                                              "bg-" +
                                                              json[i]
                                                                .real_cliques_por_contato[4]
                                                            }">${
            json[i].real_cliques_por_contato[3]
          }</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <div class="info-box hover${contadorHover++}">
                                            <div class="hover-item">
                                                <span class="info-box-icon bg-orange"><i class="fa fa-usd"></i></span>
                                                <div class="info-box-content info-box-content-custom">
                                                    <span class="info-box-text">Custo Por Contato</span>
                                                    <div class="info-box-number">
                                                        <span id="real_custo_por_lead0">
                                                            ${
                                                              json[i]
                                                                .real_custo_por_lead[0]
                                                            }
                                                        </span>
                                                        <div class="grid-dados-calculados">
                                                            <div class="div0 ${
                                                              "txt-" +
                                                              json[i]
                                                                .real_custo_por_lead[4]
                                                            }">${
            json[i].real_custo_por_lead[1]
          }</div>
                                                            ${
                                                              json[i].checked
                                                                ? ``
                                                                : `<div class="div1 ${
                                                                    "txt-" +
                                                                    json[i]
                                                                      .real_custo_por_lead[4]
                                                                  }">${
                                                                    json[i]
                                                                      .real_custo_por_lead[2]
                                                                  }</div>`
                                                            }
                                                            <div class="div2 ${
                                                              "bg-" +
                                                              json[i]
                                                                .real_custo_por_lead[4]
                                                            }">${
            json[i].real_custo_por_lead[3]
          }</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <div class="info-box hover${contadorHover++}">
                                            <div class="hover-item">
                                                <span class="info-box-icon bg-green"><i class="fa fa-envelope"></i></span>
                                                <div class="info-box-content info-box-content-custom">
                                                    <span class="info-box-text">Formulários</span>
                                                    <div class="info-box-number">
                                                        <span id="forms0">
                                                            ${json[i].forms[0]}
                                                        </span>
                                                        <div class="grid-dados-calculados">
                                                            <div class="div0 ${
                                                              "txt-" +
                                                              json[i].forms[4]
                                                            }">${
            json[i].forms[1]
          }</div>
                                                            ${
                                                              json[i].checked
                                                                ? ``
                                                                : `<div class="div1 ${
                                                                    "txt-" +
                                                                    json[i]
                                                                      .forms[4]
                                                                  }">${
                                                                    json[i]
                                                                      .forms[2]
                                                                  }</div>`
                                                            }
                                                            <div class="div2 ${
                                                              "bg-" +
                                                              json[i].forms[4]
                                                            }">${
            json[i].forms[3]
          }</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <div class="info-box hover${contadorHover++}">
                                            <div class="hover-item">
                                                <span class="info-box-icon bg-green"><i class="fa fa-whatsapp"></i></span>
                                                <div class="info-box-content info-box-content-custom">
                                                    <span class="info-box-text">WhatsApps</span>
                                                    <div class="info-box-number">
                                                        <span id="whatsapp0">
                                                            ${
                                                              json[i]
                                                                .whatsapp[0]
                                                            }
                                                        </span>
                                                        <div class="grid-dados-calculados">
                                                            <div class="div0 ${
                                                              "txt-" +
                                                              json[i]
                                                                .whatsapp[4]
                                                            }">${
            json[i].whatsapp[1]
          }</div>
                                                            ${
                                                              json[i].checked
                                                                ? ``
                                                                : `<div class="div1 ${
                                                                    "txt-" +
                                                                    json[i]
                                                                      .whatsapp[4]
                                                                  }">${
                                                                    json[i]
                                                                      .whatsapp[2]
                                                                  }</div>`
                                                            }
                                                            <div class="div2 ${
                                                              "bg-" +
                                                              json[i]
                                                                .whatsapp[4]
                                                            }">${
            json[i].whatsapp[3]
          }</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <div class="info-box hover${contadorHover++}">
                                            <div class="hover-item">
                                                <span class="info-box-icon bg-green"><i class="fa fa-phone"></i></span>
                                                <div class="info-box-content info-box-content-custom">
                                                    <span class="info-box-text">Ligações</span>
                                                    <div class="info-box-number">
                                                        <span id="ligacoes0">
                                                            ${
                                                              json[i]
                                                                .ligacoes[0]
                                                            }
                                                        </span>
                                                        <div class="grid-dados-calculados">
                                                            <div class="div0 ${
                                                              "txt-" +
                                                              json[i]
                                                                .ligacoes[4]
                                                            }">${
            json[i].ligacoes[1]
          }</div>
                                                            ${
                                                              json[i].checked
                                                                ? ``
                                                                : `<div class="div1 ${
                                                                    "txt-" +
                                                                    json[i]
                                                                      .ligacoes[4]
                                                                  }">${
                                                                    json[i]
                                                                      .ligacoes[2]
                                                                  }</div>`
                                                            }
                                                            <div class="div2 ${
                                                              "bg-" +
                                                              json[i]
                                                                .ligacoes[4]
                                                            }">${
            json[i].ligacoes[3]
          }</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <div class="info-box hover${contadorHover++}">
                                            <div class="hover-item">
                                                <span class="info-box-icon bg-verde-escuro-fosco"><i class="fa fa-th"></i></span>
                                                <div class="info-box-content info-box-content-custom">
                                                    <span class="info-box-text">Total de Contatos</span>
                                                    <div class="info-box-number">
                                                        <span id="real_total_contatos0">
                                                            ${
                                                              json[i]
                                                                .real_total_contatos[0]
                                                            }
                                                        </span>
                                                        <div class="grid-dados-calculados">
                                                            <div class="div0 ${
                                                              "txt-" +
                                                              json[i]
                                                                .real_total_contatos[4]
                                                            }">${
            json[i].real_total_contatos[1]
          }</div>
                                                            ${
                                                              json[i].checked
                                                                ? ``
                                                                : `<div class="div1 ${
                                                                    "txt-" +
                                                                    json[i]
                                                                      .real_total_contatos[4]
                                                                  }">${
                                                                    json[i]
                                                                      .real_total_contatos[2]
                                                                  }</div>`
                                                            }
                                                            <div class="div2 ${
                                                              "bg-" +
                                                              json[i]
                                                                .real_total_contatos[4]
                                                            }">${
            json[i].real_total_contatos[3]
          }</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <div class="info-box hover${contadorHover++}">
                                            <div class="hover-item">
                                                <span class="info-box-icon bg-verde-escuro-fosco"><i class="fa fa-th"></i></span>
                                                <div class="info-box-content info-box-content-custom">
                                                    <span class="info-box-text">Média Contatos por Dia</span>
                                                    <div class="info-box-number">
                                                        <span id="real_total_contatos_por_dias0">
                                                            ${
                                                              json[i]
                                                                .real_total_contatos_por_dias[0]
                                                            }
                                                        </span>
                                                        <div class="grid-dados-calculados">
                                                            <div class="div0 ${
                                                              "txt-" +
                                                              json[i]
                                                                .real_total_contatos_por_dias[4]
                                                            }">${
            json[i].real_total_contatos_por_dias[1]
          }</div>
                                                            ${
                                                              json[i].checked
                                                                ? ``
                                                                : `<div class="div1 ${
                                                                    "txt-" +
                                                                    json[i]
                                                                      .real_total_contatos_por_dias[4]
                                                                  }">${
                                                                    json[i]
                                                                      .real_total_contatos_por_dias[2]
                                                                  }</div>`
                                                            }
                                                            <div class="div2 ${
                                                              "bg-" +
                                                              json[i]
                                                                .real_total_contatos_por_dias[4]
                                                            }">${
            json[i].real_total_contatos_por_dias[3]
          }</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <div class="info-box hover${contadorHover++}">
                                            <div class="hover-item">
                                                <span class="info-box-icon bg-azul-fosco"><i class="fa fa-mouse-pointer"></i></span>
                                                <div class="info-box-content info-box-content-custom">
                                                    <span class="info-box-text">ACESSOS AO SITE</span>
                                                    <div class="info-box-number">
                                                        <span id="ads_cliques0">
                                                            ${
                                                              json[i]
                                                                .ads_cliques[0]
                                                            }
                                                        </span>
                                                        <div class="grid-dados-calculados">
                                                            <div class="div0 ${
                                                              "txt-" +
                                                              json[i]
                                                                .ads_cliques[4]
                                                            }">${
            json[i].ads_cliques[1]
          }</div>
                                                            ${
                                                              json[i].checked
                                                                ? ``
                                                                : `<div class="div1 ${
                                                                    "txt-" +
                                                                    json[i]
                                                                      .ads_cliques[4]
                                                                  }">${
                                                                    json[i]
                                                                      .ads_cliques[2]
                                                                  }</div>`
                                                            }
                                                            <div class="div2 ${
                                                              "bg-" +
                                                              json[i]
                                                                .ads_cliques[4]
                                                            }">${
            json[i].ads_cliques[3]
          }</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <div class="info-box hover${contadorHover++}">
                                            <div class="hover-item">
                                                <span class="info-box-icon bg-azul-fosco"><img src="./../img/acessos-anuncios-ctr.svg" alt="% ACESSOS / ANÚNCIOS (CTR)" width="26px"></span>
                                                <div class="info-box-content info-box-content-custom">
                                                    <span class="info-box-text">% ACESSOS / ANÚNCIOS (CTR)</span>
                                                    <div class="info-box-number">
                                                        <span id="ads_ctr0">
                                                            ${
                                                              json[i].ads_ctr[0]
                                                            }
                                                        </span>
                                                        <div class="grid-dados-calculados">
                                                            <div class="div0 ${
                                                              "txt-" +
                                                              json[i].ads_ctr[4]
                                                            }">${
            json[i].ads_ctr[1]
          }</div>
                                                            ${
                                                              json[i].checked
                                                                ? ``
                                                                : `<div class="div1 ${
                                                                    "txt-" +
                                                                    json[i]
                                                                      .ads_ctr[4]
                                                                  }">${
                                                                    json[i]
                                                                      .ads_ctr[2]
                                                                  }</div>`
                                                            }
                                                            <div class="div2 ${
                                                              "bg-" +
                                                              json[i].ads_ctr[4]
                                                            }">${
            json[i].ads_ctr[3]
          }</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <div class="info-box hover${contadorHover++}">
                                            <div class="hover-item">
                                                <span class="info-box-icon bg-azul-fosco"><img src="./../img/cpc.svg" alt="CPC" width="30px"></span>
                                                <div class="info-box-content info-box-content-custom">
                                                    <span class="info-box-text">CUSTO POR CLIQUE (CPC)
                                                    </span>
                                                    <div class="info-box-number">
                                                        <span id="ads_media_cpc0">
                                                            ${
                                                              json[i]
                                                                .ads_media_cpc[0]
                                                            }
                                                        </span>
                                                        <div class="grid-dados-calculados">
                                                            <div class="div0 ${
                                                              "txt-" +
                                                              json[i]
                                                                .ads_media_cpc[4]
                                                            }">${
            json[i].ads_media_cpc[1]
          }</div>
                                                            ${
                                                              json[i].checked
                                                                ? ``
                                                                : `<div class="div1 ${
                                                                    "txt-" +
                                                                    json[i]
                                                                      .ads_media_cpc[4]
                                                                  }">${
                                                                    json[i]
                                                                      .ads_media_cpc[2]
                                                                  }</div>`
                                                            }
                                                            <div class="div2 ${
                                                              "bg-" +
                                                              json[i]
                                                                .ads_media_cpc[4]
                                                            }">${
            json[i].ads_media_cpc[3]
          }</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <div class="info-box hover${contadorHover++}">
                                            <div class="hover-item">
                                                <span class="tooltip-info" data-tip="Valores arredondados">
                                                    <div class="icone-info"><i class="fa fa-info-circle"></i></div>
                                                </span>
                                                <span class="info-box-icon bg-cinza-azulado-claro"><img src="./../img/conversao.svg" alt="Conv. Google" width="32px"></span>
                                                <div class="info-box-content info-box-content-custom">
                                                    <span class="info-box-text">Conv. Google</span>
                                                    <div class="info-box-number">
                                                        <span id="ads_conversions0">
                                                            ${
                                                              json[i]
                                                                .ads_conversions[0]
                                                            }
                                                        </span>
                                                        <div class="grid-dados-calculados">
                                                            <div class="div0 ${
                                                              "txt-" +
                                                              json[i]
                                                                .ads_conversions[4]
                                                            }">${
            json[i].ads_conversions[1]
          }</div>
                                                            ${
                                                              json[i].checked
                                                                ? ``
                                                                : `<div class="div1 ${
                                                                    "txt-" +
                                                                    json[i]
                                                                      .ads_conversions[4]
                                                                  }">${
                                                                    json[i]
                                                                      .ads_conversions[2]
                                                                  }</div>`
                                                            }
                                                            <div class="div2 ${
                                                              "bg-" +
                                                              json[i]
                                                                .ads_conversions[4]
                                                            }">${
            json[i].ads_conversions[3]
          }</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <div class="info-box hover${contadorHover++}">
                                            <div class="hover-item">
                                                <span class="info-box-icon bg-cinza-azulado-claro"><img src="./../img/conversao-porc.svg" alt="% Conv. Google" width="40px"></span>
                                                <div class="info-box-content info-box-content-custom">
                                                    <span class="info-box-text">% Conv. Google</span>
                                                    <div class="info-box-number">
                                                        <span id="ads_taxa_conversao0">
                                                            ${
                                                              json[i]
                                                                .ads_taxa_conversao[0]
                                                            }
                                                        </span>
                                                        <div class="grid-dados-calculados">
                                                            <div class="div0 ${
                                                              "txt-" +
                                                              json[i]
                                                                .ads_taxa_conversao[4]
                                                            }">${
            json[i].ads_taxa_conversao[1]
          }</div>
                                                            ${
                                                              json[i].checked
                                                                ? ``
                                                                : `<div class="div1 ${
                                                                    "txt-" +
                                                                    json[i]
                                                                      .ads_taxa_conversao[4]
                                                                  }">${
                                                                    json[i]
                                                                      .ads_taxa_conversao[2]
                                                                  }</div>`
                                                            }
                                                            <div class="div2 ${
                                                              "bg-" +
                                                              json[i]
                                                                .ads_taxa_conversao[4]
                                                            }">${
            json[i].ads_taxa_conversao[3]
          }</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <div class="info-box hover${contadorHover++}">
                                            <div class="hover-item">
                                                <span class="info-box-icon bg-cinza-azulado-claro"><i class="fa fa-usd"></i></span>
                                                <div class="info-box-content info-box-content-custom">
                                                    <span class="info-box-text">R$ Conv. Google</span>
                                                    <div class="info-box-number">
                                                        <span id="ads_media_conversao_valor0">
                                                            ${
                                                              json[i]
                                                                .ads_media_conversao_valor[0]
                                                            }
                                                        </span>
                                                        <div class="grid-dados-calculados">
                                                            <div class="div0 ${
                                                              "txt-" +
                                                              json[i]
                                                                .ads_media_conversao_valor[4]
                                                            }">${
            json[i].ads_media_conversao_valor[1]
          }</div>
                                                            ${
                                                              json[i].checked
                                                                ? ``
                                                                : `<div class="div1 ${
                                                                    "txt-" +
                                                                    json[i]
                                                                      .ads_media_conversao_valor[4]
                                                                  }">${
                                                                    json[i]
                                                                      .ads_media_conversao_valor[2]
                                                                  }</div>`
                                                            }
                                                            <div class="div2 ${
                                                              "bg-" +
                                                              json[i]
                                                                .ads_media_conversao_valor[4]
                                                            }">${
            json[i].ads_media_conversao_valor[3]
          }</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <div class="info-box hover${contadorHover++}">
                                            <div class="hover-item">
                                                <span class="info-box-icon bg-cinza-azulado-escuro"><img src="./../img/total.svg" alt="Total Investido Google" width="40px"></span>
                                                <div class="info-box-content info-box-content-custom">
                                                    <span class="info-box-text">Total Investido Google</span>
                                                    <div class="info-box-number">
                                                        <span id="ads_custo_total0">
                                                            ${
                                                              json[i]
                                                                .ads_custo_total[0]
                                                            }
                                                        </span>
                                                        <div class="grid-dados-calculados">
                                                            <div class="div0 ${
                                                              "txt-" +
                                                              json[i]
                                                                .ads_custo_total[4]
                                                            }">${
            json[i].ads_custo_total[1]
          }</div>
                                                            ${
                                                              json[i].checked
                                                                ? ``
                                                                : `<div class="div1 ${
                                                                    "txt-" +
                                                                    json[i]
                                                                      .ads_custo_total[4]
                                                                  }">${
                                                                    json[i]
                                                                      .ads_custo_total[2]
                                                                  }</div>`
                                                            }
                                                            <div class="div2 ${
                                                              "bg-" +
                                                              json[i]
                                                                .ads_custo_total[4]
                                                            }">${
            json[i].ads_custo_total[3]
          }</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    `;

          contadorHover = 0;
        }

        let scriptsHover = "<script>";
        for (let i = 0; i <= 20; i++) {
          scriptsHover += `$(".hover${i}")
                    .mouseenter(function() {$(".hover${i}").css({'box-shadow': '2px 4px 11px 4px rgb(0 0 0 / 35%)'});})
                    .mouseleave(function() {$(".hover${i}").css({'box-shadow': 'none'});});`;
        }
        scriptsHover += "</script>";

        let stickyDatas = `
                <script>
                    let stickyTop = $('.sticky').offset().top;
                    $(window).scroll(function() {
                        let windowTop = $(window).scrollTop();
                        if (stickyTop < windowTop && $('.referencia-fixar-datas').height() + $('.referencia-fixar-datas').offset().top - $(".sticky").height() > windowTop) {
                            $('.sticky').css('position', 'fixed');
                            $('.sticky').css('marginTop', '50px');
                            $('.sticky').css({'box-shadow': '4px 4px 10px 6px rgb(0 0 0 / 23%)'});
                            $('.sticky').css('marginLeft', '-6px');
                        } else {
                            $('.sticky').css('position', 'relative');
                            $('.sticky').css('marginTop', '0px');
                            $('.sticky').css({'box-shadow': '0px 0px 0px 0px rgb(0 0 0 / 0%)'});
                            $('.sticky').css('marginLeft', '0px');
                        }
                    });
                </script>`;

        $("#periodos").html(
          colunas +
            scriptsHover +
            `<script>$('#switch1, #switch2, #switch3, #switch4').change(function () {
                    atualizar();
                });</script>` +
            stickyDatas
        );
      },

      beforeSend: function () {
        $(".info-box-number").html(
          '<div class="preloader"><i class="fa fa-refresh fa-spin"></i></div>'
        );
        $(".preloader").css({ display: "block" });
      },
      complete: function () {
        $(".preloader").css({ display: "none" });
      },
      error: function () {
        $(".preloader").css({ display: "none" });
        toastr.clear();
        toastr.error("Houve um erro ao atualizar");
        return;
      },
    });
  });
}

function atualizar() {
  // var valor = $('#data').val();
  // if (valor == 'CUSTOM_DATE')
  //     $('.datadiv').removeClass('hide');
  // else {
  $(".datadiv").addClass("hide");
  carregar_dados();
  salvarFiltro(
    "COMPARACAO",
    $("#datainicial1").val(),
    $("#datafinal1").val(),
    $("#datainicial2").val(),
    $("#datafinal2").val(),
    $("#datainicial3").val(),
    $("#datafinal3").val(),
    $("#datainicial4").val(),
    $("#datafinal4").val()
  );
  // }
}

pegarFiltro(function (
  filtro,
  data1,
  data2,
  data3 = "",
  data4 = "",
  data5 = "",
  data6 = "",
  data7 = "",
  data8 = ""
) {
  $("#data").val(filtro);
  $("#datainicial1").val(data1);
  $("#datafinal1").val(data2);

  $("#datainicial2").val(data3);
  $("#datafinal2").val(data4);
  $("#datainicial3").val(data5);
  $("#datafinal3").val(data6);
  $("#datainicial4").val(data7);
  $("#datafinal4").val(data8);

  // if (filtro == 'CUSTOM_DATE'){
  //     $('.datadiv').removeClass('hide');
  //     // carregar_dados();
  // }
});

$("#switch1, #switch2, #switch3, #switch4").change(function () {
  atualizar();
});

$("#datapersonalizada").click(function () {
  salvarFiltro(
    "COMPARACAO",
    $("#datainicial1").val(),
    $("#datafinal1").val(),
    $("#datainicial2").val(),
    $("#datafinal2").val(),
    $("#datainicial3").val(),
    $("#datafinal3").val(),
    $("#datainicial4").val(),
    $("#datafinal4").val()
  );
  carregar_dados();
});

/* Filtros */
// Função para formatar a data no formato YYYY-MM-DD
function formatDate(date) {
  const _date = typeof date === "string" ? date + "T00:00:00" : date;

  let d = new Date(_date),
    month = "" + (d.getMonth() + 1),
    day = "" + d.getDate(),
    year = d.getFullYear();

  if (month.length < 2) month = "0" + month;
  if (day.length < 2) day = "0" + day;

  return [day, month, year].join("/");
}

// Função para subtrair dias de uma data
function subtrairDias(data, dias) {
  let resultado = new Date(data);
  resultado.setDate(resultado.getDate() - dias);
  return resultado;
}

// Limpar campos
function limparDatas() {
  $("#datainicial1").val("");
  $("#datafinal1").val("");
  $("#datainicial2").val("");
  $("#datafinal2").val("");
  $("#datainicial3").val("");
  $("#datafinal3").val("");
  $("#datainicial4").val("");
  $("#datafinal4").val("");
}

$("#selectFiltro").change(function () {
  limparDatas();
  const filtroSelecionado = $(this).val();
  const dias = parseInt($("#qtdUltimosDias").val());
  const filtroSelecionadoDiaSemana = $("#selectFiltroDiaSemana").val();

  switch (filtroSelecionado) {
    case "ultimosDiasESubs":
      $("#selectFiltro option:selected").text(
        dias === 1
          ? `Último [${dias}] dia e anteriores`
          : `Últimos [${dias}] dias e anteriores`
      );
      break;
    case "ultimas1DiaSemana4MesesESubs":
    case "ultimas2DiaSemana4MesesESubs":
    case "ultimas3DiaSemana4MesesESubs":
    case "ultimas4DiaSemana4MesesESubs":
      const ultimosSelecionados =
        filtroSelecionado === "ultimas1DiaSemana4MesesESubs"
          ? "1"
          : filtroSelecionado === "ultimas2DiaSemana4MesesESubs"
          ? "2"
          : filtroSelecionado === "ultimas3DiaSemana4MesesESubs"
          ? "3"
          : "4";

      const diaSemanaSelecionado = $(
        "#selectFiltroDiaSemana option:selected"
      ).text();

      $("#selectFiltro option:selected").text(
        filtroSelecionadoDiaSemana === "sabado" ||
          filtroSelecionadoDiaSemana === "domingo"
          ? `Últimos ${ultimosSelecionados}ºs [${diaSemanaSelecionado}] dos últimos 4 meses`
          : `Últimas ${ultimosSelecionados}ªs [${diaSemanaSelecionado}] dos últimos 4 meses`
      );
      break;

    default:
      break;
  }

  atualizarDatas(filtroSelecionado, dias);
});

// Evento onchange do input number
$("#qtdUltimosDias").change(function () {
  const filtroSelecionado = $("#selectFiltro").val();
  const dias = parseInt($(this).val());
  atualizarDatas(filtroSelecionado, dias);

  $("#selectFiltro option:selected").text(
    dias === 1
      ? `Último [${dias}] dia e anteriores`
      : `Últimos [${dias}] dias e anteriores`
  );
});

// Evento onchange do input number
$("#selectFiltroDiaSemana").change(function () {
  const filtroSelecionado = $("#selectFiltro").val();
  const filtroSelecionadoDiaSemana = $("#selectFiltroDiaSemana").val();
  atualizarDatas(filtroSelecionado, 0);

  const ultimosSelecionados =
    filtroSelecionado === "ultimas1DiaSemana4MesesESubs"
      ? "1"
      : filtroSelecionado === "ultimas2DiaSemana4MesesESubs"
      ? "2"
      : filtroSelecionado === "ultimas3DiaSemana4MesesESubs"
      ? "3"
      : "4";

  const diaSemanaSelecionado = $(
    "#selectFiltroDiaSemana option:selected"
  ).text();

  $("#selectFiltro option:selected").text(
    filtroSelecionadoDiaSemana === "sabado" ||
      filtroSelecionadoDiaSemana === "domingo"
      ? `Últimos ${ultimosSelecionados}ºs [${diaSemanaSelecionado}] dos últimos 4 meses`
      : `Últimas ${ultimosSelecionados}ªs [${diaSemanaSelecionado}] dos últimos 4 meses`
  );
});

function pegaDataDoDiaDaSemana(ano, mes, diaSemana = 1, numeroSemana = 0) {
  const primeiroDia = new Date(ano, mes, 1);
  const diaDaSemana = primeiroDia.getDay();
  // (0 = Domingo, 1 = Segunda, 2 = Terça, 3 = Quarta, 4 = Quinta, 5 = Sexta, 6 = Sábado, 7 = Domingo)
  const diasParaDiaSemana = (diaSemana - diaDaSemana + 7) % 7;

  let resultadoPadrao = new Date(ano, mes, 1 + diasParaDiaSemana);

  switch (numeroSemana) {
    case 2:
      let segundoDiaSemana = new Date(resultadoPadrao);
      segundoDiaSemana.setDate(resultadoPadrao.getDate() + 7); // Adiciona 7 dias
      return segundoDiaSemana;

    case 3:
      let terceiroDiaSemana = new Date(resultadoPadrao);
      terceiroDiaSemana.setDate(resultadoPadrao.getDate() + 14); // Adiciona 14 dias
      return terceiroDiaSemana;

    case 4:
      let quartoDiaSemana = new Date(resultadoPadrao);
      quartoDiaSemana.setDate(resultadoPadrao.getDate() + 21); // Adiciona 21 dias
      return quartoDiaSemana;

    case 1:
    case 0:
    default:
      return resultadoPadrao;
  }
}

function ultimosDiasDaSemana(numeroSemana = 1) {
  const hoje = new Date();
  const anoAtual = hoje.getFullYear();
  const mesAtual = hoje.getMonth() + 1; // Mês começa de 0

  const filtroSelecionadoDiaSemana = $("#selectFiltroDiaSemana").val();
  const diaSemanaNumero =
    filtroSelecionadoDiaSemana === "domingo"
      ? 0
      : filtroSelecionadoDiaSemana === "segunda"
      ? 1
      : filtroSelecionadoDiaSemana === "terca"
      ? 2
      : filtroSelecionadoDiaSemana === "quarta"
      ? 3
      : filtroSelecionadoDiaSemana === "quinta"
      ? 4
      : filtroSelecionadoDiaSemana === "sexta"
      ? 5
      : filtroSelecionadoDiaSemana === "sabado"
      ? 6
      : 7;

  // Data da primeira segunda-feira do mês atual
  const primeiroDiaSemanaAtual = pegaDataDoDiaDaSemana(
    anoAtual,
    mesAtual - 1,
    diaSemanaNumero,
    numeroSemana
  );
  $("#datainicial1").val(
    formatDate(primeiroDiaSemanaAtual.toISOString().split("T")[0])
  );
  $("#datafinal1").val(
    formatDate(primeiroDiaSemanaAtual.toISOString().split("T")[0])
  );

  // Preenche as primeiras segundas e terças dos meses anteriores
  for (var i = 1; i <= 4; i++) {
    const mesSubsequente = mesAtual - 1 - i;
    const anoSubsequente = anoAtual;

    if (mesSubsequente < 0) {
      mesSubsequente += 12;
      anoSubsequente -= 1;
    }

    // Preenche a data da primeira segunda-feira
    const primeiroDiaSemana = pegaDataDoDiaDaSemana(
      anoSubsequente,
      mesSubsequente,
      diaSemanaNumero,
      numeroSemana
    );
    $("#datainicial" + (i + 1)).val(
      formatDate(primeiroDiaSemana.toISOString().split("T")[0])
    );
    $("#datafinal" + (i + 1)).val(
      formatDate(primeiroDiaSemana.toISOString().split("T")[0])
    );
  }
}

function preencherFinsDeSemana() {
  // Função para encontrar o último sábado a partir de uma data
  function ultimoSabado(data) {
    const diaDaSemana = data.getDay(); // 0 = domingo, 6 = sábado
    const sabado = new Date(data);
    sabado.setDate(data.getDate() - (diaDaSemana === 6 ? 0 : diaDaSemana + 1)); // Volta até o último sábado
    return sabado;
  }

  // Função para encontrar o domingo correspondente a um sábado
  function domingoCorrespondente(sabado) {
    const domingo = new Date(sabado);
    domingo.setDate(sabado.getDate() + 1); // Domingo é o dia seguinte ao sábado
    return domingo;
  }

  const hoje = new Date();
  const ultimoSabadoAtual = ultimoSabado(hoje);

  for (var i = 1; i <= 4; i++) {
    const sabado = new Date(ultimoSabadoAtual);
    sabado.setDate(ultimoSabadoAtual.getDate() - (i - 1) * 7); // Calcula os sábados anteriores
    const domingo = domingoCorrespondente(sabado); // Calcula o domingo correspondente

    // Preenche os inputs de acordo com os fins de semana
    $("#datainicial" + i).val(formatDate(sabado.toISOString().split("T")[0]));
    $("#datafinal" + i).val(formatDate(domingo.toISOString().split("T")[0]));
  }
}

function preencherSemanasUteis() {
  // Função para obter a segunda-feira de uma determinada data
  function obterSegunda(data) {
    const diaDaSemana = data.getDay(); // 0 = domingo, 1 = segunda, ..., 6 = sábado
    const diasParaSegunda = diaDaSemana === 0 ? 6 : diaDaSemana - 1; // Ajusta para segunda-feira
    const segunda = new Date(data);
    segunda.setDate(data.getDate() - diasParaSegunda);
    return segunda;
  }

  // Função para obter a sexta-feira correspondente a uma segunda-feira
  function obterSexta(segunda) {
    let sexta = new Date(segunda);
    sexta.setDate(segunda.getDate() + 4); // Sexta-feira é 4 dias depois da segunda-feira
    return sexta;
  }

  const hoje = new Date();
  const ultimaSegunda = obterSegunda(hoje);

  for (var i = 0; i < 4; i++) {
    let segunda = new Date(ultimaSegunda);
    segunda.setDate(ultimaSegunda.getDate() - i * 7); // Calcula as segundas anteriores
    const sexta = obterSexta(segunda); // Calcula a sexta correspondente

    // Preenche os inputs de acordo com as semanas
    $("#datainicial" + (i + 1)).val(
      formatDate(segunda.toISOString().split("T")[0])
    );
    $("#datafinal" + (i + 1)).val(
      formatDate(sexta.toISOString().split("T")[0])
    );
  }
}

function preencherSemanasDiasUteisCadaMes(semanaSelecionada = 1) {
  // Função para obter a primeira segunda-feira de um determinado mês e ano
  function primeiraSegundaDoMes(ano, mes) {
    const primeiroDia = new Date(ano, mes, 1);
    const diaDaSemana = primeiroDia.getDay();
    let diasParaSegunda = (1 - diaDaSemana) % 7; // 1

    switch (semanaSelecionada) {
      case 2:
        diasParaSegunda = (1 - diaDaSemana + 7) % 7;
        break;

      case 3:
        diasParaSegunda = (1 - diaDaSemana + 14) % 7;
        break;

      case 4:
        diasParaSegunda = (1 - diaDaSemana + 21) % 7;
        break;

      case 1:
        diasParaSegunda = (1 - diaDaSemana) % 7;
      default:
        break;
    }

    const primeiraSegunda = new Date(ano, mes, 1 + diasParaSegunda);
    return primeiraSegunda;
  }

  // Função para obter a segunda segunda-feira do mês
  function segundaSegundaDoMes(ano, mes) {
    const primeiraSegunda = primeiraSegundaDoMes(ano, mes);
    const segundaSegunda = new Date(primeiraSegunda);

    switch (semanaSelecionada) {
      case 2:
        segundaSegunda.setDate(primeiraSegunda.getDate() + 7); // Pega a segunda segunda-feira
        break;

      case 3:
        segundaSegunda.setDate(primeiraSegunda.getDate() + 14); // Pega a terceira segunda-feira
        break;

      case 4:
        segundaSegunda.setDate(primeiraSegunda.getDate() + 21); // Pega a quarta segunda-feira
        break;

      case 1:
        segundaSegunda.setDate(primeiraSegunda.getDate()); // Pega a primeira segunda-feira
      default:
        break;
    }

    return segundaSegunda;
  }

  // Função para obter a sexta-feira correspondente a uma segunda-feira
  function obterSexta(segunda) {
    const sexta = new Date(segunda);
    sexta.setDate(segunda.getDate() + 4); // Sexta-feira é 4 dias depois da segunda-feira
    return sexta;
  }

  // Função para preencher a segunda semana útil de um mês
  function preencherSegundaSemanaUtil(ano, mes, index) {
    const segundaSegunda = segundaSegundaDoMes(ano, mes);
    const sexta = obterSexta(segundaSegunda);

    // Preenche os inputs de acordo com o mês
    $("#datainicial" + index).val(
      formatDate(segundaSegunda.toISOString().split("T")[0])
    );
    $("#datafinal" + index).val(formatDate(sexta.toISOString().split("T")[0]));
  }

  const hoje = new Date();
  const anoAtual = hoje.getFullYear();
  const mesAtual = hoje.getMonth();

  // Preencher mês atual
  preencherSegundaSemanaUtil(anoAtual, mesAtual, 1);

  // Preencher os últimos 3 meses
  for (var i = 1; i <= 3; i++) {
    const mesAnterior = mesAtual - i;
    const anoAnterior = anoAtual;

    if (mesAnterior < 0) {
      mesAnterior += 12;
      anoAnterior -= 1;
    }

    preencherSegundaSemanaUtil(anoAnterior, mesAnterior, i + 1);
  }
}

function preencherFinaisDeSemanaCadaMes(semanaSelecionada = 1) {
  // Função para obter o primeiro sábado de um determinado mês e ano
  function primeiroSabadoDoMes(ano, mes) {
    const primeiroDia = new Date(ano, mes, 1);
    const diaDaSemana = primeiroDia.getDay();
    let diasParaSabado = (6 - diaDaSemana + 7) % 7; // 6 representa sábado

    switch (semanaSelecionada) {
      case 2:
        diasParaSabado = (6 - diaDaSemana + 7) % 7; // 1 representa segunda-feira
        break;

      case 3:
        diasParaSabado = (6 - diaDaSemana + 14) % 7; // 1 representa segunda-feira
        break;

      case 4:
        diasParaSabado = (6 - diaDaSemana + 21) % 7; // 1 representa segunda-feira
        break;

      case 1:
        diasParaSabado = (6 - diaDaSemana) % 7; // 1 representa segunda-feira
      default:
        break;
    }

    const primeiroSabado = new Date(ano, mes, 1 + diasParaSabado);
    return primeiroSabado;
  }

  // Função para obter o segundo final de semana (sábado e domingo)
  function finalDeSemanaUltimosMeses(ano, mes) {
    const primeiroSabado = primeiroSabadoDoMes(ano, mes);
    let segundoSabado = new Date(primeiroSabado);
    segundoSabado.setDate(primeiroSabado.getDate() + 7); // Pega o segundo sábado
    let segundoDomingo = new Date(segundoSabado);
    segundoDomingo.setDate(segundoSabado.getDate() + 1); // Pega o domingo seguinte

    switch (semanaSelecionada) {
      case 2:
        segundoSabado.setDate(primeiroSabado.getDate() + 7); // Pega a segunda segunda-feira
        segundoDomingo.setDate(primeiroSabado.getDate() + 8); // Pega a segunda segunda-feira

        break;
      case 3:
        segundoSabado.setDate(primeiroSabado.getDate() + 14); // Pega a terceira segunda-feira
        segundoDomingo.setDate(primeiroSabado.getDate() + 15); // Pega a terceira segunda-feira

        break;
      case 4:
        segundoSabado.setDate(primeiroSabado.getDate() + 21); // Pega a quarta segunda-feira
        segundoDomingo.setDate(primeiroSabado.getDate() + 22); // Pega a quarta segunda-feira

        break;

      case 1:
        segundoSabado.setDate(primeiroSabado.getDate()); // Pega a primeira segunda-feira
        segundoDomingo.setDate(primeiroSabado.getDate() + 1); // Pega a primeira segunda-feira

      default:
        break;
    }

    return {
      sabado: segundoSabado,
      domingo: segundoDomingo,
    };
  }

  // Função para preencher o segundo final de semana de um mês
  function preencherSegundoFinalDeSemana(ano, mes, index) {
    const finalDeSemana = finalDeSemanaUltimosMeses(ano, mes);

    // Preenche os inputs de acordo com o mês
    $("#datainicial" + index).val(
      formatDate(finalDeSemana.sabado.toISOString().split("T")[0])
    );
    $("#datafinal" + index).val(
      formatDate(finalDeSemana.domingo.toISOString().split("T")[0])
    );
  }

  const hoje = new Date();
  const anoAtual = hoje.getFullYear();
  const mesAtual = hoje.getMonth();

  // Preencher mês atual
  preencherSegundoFinalDeSemana(anoAtual, mesAtual, 1);

  // Preencher os últimos 3 meses
  for (var i = 1; i <= 3; i++) {
    const mesAnterior = mesAtual - i;
    const anoAnterior = anoAtual;

    if (mesAnterior < 0) {
      mesAnterior += 12;
      anoAnterior -= 1;
    }

    preencherSegundoFinalDeSemana(anoAnterior, mesAnterior, i + 1);
  }
}

// ATUALIZAR DATAS
function atualizarDatas(tipo, dias) {
  // Função para obter o primeiro dia do mês
  function primeiroDiaDoMes(ano, mes) {
    return new Date(ano, mes, 1);
  }

  // Função para obter o último dia do mês
  function ultimoDiaDoMes(ano, mes) {
    return new Date(ano, mes + 1, 0); // O dia 0 volta para o último dia do mês anterior
  }

  // CONSTANTS
  const hoje = new Date();
  let ontem = new Date(hoje);
  ontem.setDate(hoje.getDate() - 1);
  const anoAtual = hoje.getFullYear();
  const mesAtual = hoje.getMonth() + 1; // Mês começa de 0

  switch (tipo) {
    case "personalizado":
      $("#selectFiltroDiaSemanaContainer").hide();
      $("#qtdUltimosDiasContainer").hide();
      break;

    case "ultimosDiasESubs":
      $("#selectFiltroDiaSemanaContainer").hide();
      $("#qtdUltimosDiasContainer").show();
      if (!isNaN(dias) && dias > 0) {
        // Calcula o primeiro período (hoje - dias)
        const dataFinal1 = subtrairDias(hoje, dias);
        const dataInicial1 = hoje;

        // Preenche os campos de Data Inicial 1 e Data Final 1
        $("#datainicial1").val(formatDate(dataFinal1));
        $("#datafinal1").val(formatDate(dataInicial1));

        // Calcula o segundo período (final do período anterior - dias)
        const dataInicial2 = subtrairDias(dataFinal1, 1);
        const dataFinal2 = subtrairDias(dataInicial2, dias);

        $("#datainicial2").val(formatDate(dataFinal2));
        $("#datafinal2").val(formatDate(dataInicial2));

        // Calcula o terceiro período (final do segundo período - dias)
        const dataInicial3 = subtrairDias(dataFinal2, 1);
        const dataFinal3 = subtrairDias(dataInicial3, dias);

        $("#datainicial3").val(formatDate(dataFinal3));
        $("#datafinal3").val(formatDate(dataInicial3));

        // Calcula o quarto período (final do terceiro período - dias)
        const dataInicial4 = subtrairDias(dataFinal3, 1);
        const dataFinal4 = subtrairDias(dataInicial4, dias);

        $("#datainicial4").val(formatDate(dataFinal4));
        $("#datafinal4").val(formatDate(dataInicial4));
      } else {
        alert("Por favor, insira um número válido de dias.");
      }

      break;

    case "esteMesESubs":
      $("#selectFiltroDiaSemanaContainer").hide();
      $("#qtdUltimosDiasContainer").hide();

      // Loop para preencher os meses subsequentes
      for (let i = 1; i <= 4; i++) {
        const mesSubsequente = mesAtual - i; // Mês subsequente
        // Preenche as datas iniciais e finais dos meses subsequentes
        $("#datainicial" + i).val(
          formatDate(primeiroDiaDoMes(anoAtual, mesSubsequente))
        );
        $("#datafinal" + i).val(
          formatDate(ultimoDiaDoMes(anoAtual, mesSubsequente))
        );
      }

      break;

    case "esteMesAteHojeESubs":
      $("#selectFiltroDiaSemanaContainer").hide();
      $("#qtdUltimosDiasContainer").hide();
      // Loop para preencher os meses subsequentes
      for (let i = 1; i <= 4; i++) {
        const mesSubsequente = mesAtual - i; // Mês subsequente
        const diaHoje = new Date(hoje).getDate();
        const diaMesLoop = new Date(
          ultimoDiaDoMes(anoAtual, mesSubsequente)
        ).getDate();

        // Monta a data do loop com o último dia de hoje
        let d = new Date(ultimoDiaDoMes(anoAtual, mesSubsequente)),
          month = "" + (d.getMonth() + 1),
          year = d.getFullYear();
        if (month.length < 2) month = "0" + month;
        const diaFormatado = [
          year,
          month,
          `${diaHoje}`.length < 2 ? "0" + diaHoje : diaHoje,
        ].join("-");

        // Preenche as datas iniciais e finais dos meses subsequentes
        $("#datainicial" + i).val(
          formatDate(primeiroDiaDoMes(anoAtual, mesSubsequente))
        );
        $("#datafinal" + i).val(
          formatDate(
            diaHoje <= diaMesLoop
              ? diaFormatado
              : ultimoDiaDoMes(anoAtual, mesSubsequente)
          )
        );
      }

      break;

    case "esteMesAteOntemESubs":
      $("#selectFiltroDiaSemanaContainer").hide();
      $("#qtdUltimosDiasContainer").hide();
      // Loop para preencher os meses subsequentes
      for (let i = 1; i <= 4; i++) {
        const mesSubsequente = mesAtual - i; // Mês subsequente

        const diaOntem = new Date(ontem).getDate();
        const diaMesLoop = new Date(
          ultimoDiaDoMes(anoAtual, mesSubsequente)
        ).getDate();

        // Monta a data do loop com o último dia de hoje
        let d = new Date(ultimoDiaDoMes(anoAtual, mesSubsequente)),
          month = "" + (d.getMonth() + 1),
          year = d.getFullYear();
        if (month.length < 2) month = "0" + month;
        const diaFormatado = [
          year,
          month,
          `${diaOntem}`.length < 2 ? "0" + diaOntem : diaOntem,
        ].join("-");

        // Preenche as datas iniciais e finais dos meses subsequentes
        $("#datainicial" + i).val(
          formatDate(primeiroDiaDoMes(anoAtual, mesSubsequente))
        );
        $("#datafinal" + i).val(
          formatDate(
            // i === 1 ? ontem : ultimoDiaDoMes(anoAtual, mesSubsequente)
            diaOntem <= diaMesLoop
              ? diaFormatado
              : ultimoDiaDoMes(anoAtual, mesSubsequente)
          )
        );
      }

      break;

    case "mesPassadoESubs":
      $("#selectFiltroDiaSemanaContainer").hide();
      $("#qtdUltimosDiasContainer").hide();

      // Loop para preencher os meses subsequentes
      for (let i = 1; i <= 4; i++) {
        const mesSubsequente = mesAtual - 1 - i; // Mês subsequente
        // Preenche as datas iniciais e finais dos meses subsequentes
        $("#datainicial" + i).val(
          formatDate(primeiroDiaDoMes(anoAtual, mesSubsequente))
        );
        $("#datafinal" + i).val(
          formatDate(ultimoDiaDoMes(anoAtual, mesSubsequente))
        );
      }

      break;

    case "ultimas1DiaSemana4MesesESubs":
      $("#selectFiltroDiaSemanaContainer").show();
      $("#qtdUltimosDiasContainer").hide();
      ultimosDiasDaSemana(1);
      break;

    case "ultimas2DiaSemana4MesesESubs":
      $("#selectFiltroDiaSemanaContainer").show();
      $("#qtdUltimosDiasContainer").hide();
      ultimosDiasDaSemana(2);
      break;

    case "ultimas3DiaSemana4MesesESubs":
      $("#selectFiltroDiaSemanaContainer").show();
      $("#qtdUltimosDiasContainer").hide();
      ultimosDiasDaSemana(3);
      break;

    case "ultimas4DiaSemana4MesesESubs":
      $("#selectFiltroDiaSemanaContainer").show();
      $("#qtdUltimosDiasContainer").hide();
      ultimosDiasDaSemana(4);
      break;

    case "ultimosFinsDeSemana":
      $("#selectFiltroDiaSemanaContainer").hide();
      $("#qtdUltimosDiasContainer").hide();
      preencherFinsDeSemana();
      break;

    case "ultimas1FimDeSemana4MesesESubs":
      $("#selectFiltroDiaSemanaContainer").hide();
      $("#qtdUltimosDiasContainer").hide();
      preencherFinaisDeSemanaCadaMes(1);
      break;

    case "ultimas2FimDeSemana4MesesESubs":
      $("#selectFiltroDiaSemanaContainer").hide();
      $("#qtdUltimosDiasContainer").hide();
      preencherFinaisDeSemanaCadaMes(2);
      break;

    case "ultimas3FimDeSemana4MesesESubs":
      $("#selectFiltroDiaSemanaContainer").hide();
      $("#qtdUltimosDiasContainer").hide();
      preencherFinaisDeSemanaCadaMes(3);
      break;

    case "ultimas4FimDeSemana4MesesESubs":
      $("#selectFiltroDiaSemanaContainer").hide();
      $("#qtdUltimosDiasContainer").hide();
      preencherFinaisDeSemanaCadaMes(4);
      break;

    case "ultimasSemanasDiasUteis":
      $("#selectFiltroDiaSemanaContainer").hide();
      $("#qtdUltimosDiasContainer").hide();
      preencherSemanasUteis();
      break;

    case "ultimas1SemanaDiasUteis4MesesESubs":
      $("#selectFiltroDiaSemanaContainer").hide();
      $("#qtdUltimosDiasContainer").hide();
      preencherSemanasDiasUteisCadaMes(1);
      break;

    case "ultimas2SemanaDiasUteis4MesesESubs":
      $("#selectFiltroDiaSemanaContainer").hide();
      $("#qtdUltimosDiasContainer").hide();
      preencherSemanasDiasUteisCadaMes(2);
      break;

    case "ultimas3SemanaDiasUteis4MesesESubs":
      $("#selectFiltroDiaSemanaContainer").hide();
      $("#qtdUltimosDiasContainer").hide();
      preencherSemanasDiasUteisCadaMes(3);
      break;

    case "ultimas4SemanaDiasUteis4MesesESubs":
      $("#selectFiltroDiaSemanaContainer").hide();
      $("#qtdUltimosDiasContainer").hide();
      preencherSemanasDiasUteisCadaMes(4);
      break;

    default:
      $("#selectFiltroDiaSemanaContainer").hide();
      $("#qtdUltimosDiasContainer").hide();
      break;
  }
}
