<?php 
header("Content-type: text/javascript");
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

if (session_status() == PHP_SESSION_NONE) {
  require_once(__DIR__ . "/../classes/Sistema.php");
	set_sistema(Sistema::WIN7);
	$sistema = new Sistema();
	
	if(!$sistema->sessao->logado()) {
		echo "window.location.href = './';";
		exit;
	}

	$sistema->indicacoes->mascara_dinheiro !== 'brasil' ? $identificador = $sistema->indicacoes->text_cpf_cnpj_alternativo : $identificador = 'CPF/CNPJ';

}
?>

$('.datepicker').datepicker({
	format: 'dd/mm/yyyy',
	endDate: '0d',
	autoclose: true,
	language: 'pt-BR'
});

$('.datepicker').mask('00/00/0000');

var historicoIndicadores = [[0,-1,[[ 4, 'desc' ]],0,25,""]];
var historicoIndex = 0;

var listaFechamentos = [];
var delecaoFechamentos = [];
var modificacoesFeitas = false;
var dadosIndicadoSalvos = false;

$('#modal-sistema-indicado').on('shown.bs.modal', function (e) {
	dadosIndicadoSalvos = false;
	carregarFechamentos();
})

function salvarAlteracoesIndicado(){
	if(modificacoesFeitas == true){
		var formData = new FormData(document.getElementById('formSistema'));
		var jsonFechamentos = JSON.stringify(listaFechamentos);
		var jsonDelecao = JSON.stringify(delecaoFechamentos);
		formData.append("id", idIndicadoModal);
		formData.append("fechamentos", jsonFechamentos);
		formData.append("delecao", jsonDelecao);
		jQuery.ajax({
			type: "POST",
			url: "action/salvar_modal_indicacao",
			data: formData,
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); $('#modal-sistema-indicado').modal(); return;}
				$('#modal-confirmacao').modal('hide');
				atualizar_linhas(JSON.parse(data));
				toastr.clear(); toastr.success("Usuário salvo com sucesso."); return;
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao salvar."); $('#modal-sistema-indicado').modal(); return;
			},
			cache: false,
	        contentType: false,
	        processData: false
		});
	}
}

var reabrirModalIndicadoFlag = false;

$('#modal-confirmacao').on('hidden.bs.modal', function (e) {
	if(reabrirModalIndicadoFlag == true){
		$('#modal-sistema-indicado').modal();
	}
})

function reabrirModalIndicado(){
	reabrirModalIndicadoFlag = true;
	$('#modal-confirmacao').modal('hide');
}

$('#modal-sistema-indicado').on('hidden.bs.modal', function () {
    if(modificacoesFeitas == true){
    	var formData = new FormData(document.getElementById('formSistema'));
	    if(dadosIndicadoSalvos == true){
	    	var jsonFechamentos = JSON.stringify(listaFechamentos);
	    	var jsonDelecao = JSON.stringify(delecaoFechamentos);
			formData.append("id", idIndicadoModal);
			formData.append("fechamentos", jsonFechamentos);
			formData.append("delecao", jsonDelecao);
			jQuery.ajax({
				type: "POST",
				url: "action/salvar_modal_indicacao",
				data: formData,
				success: function(data){
					$('.preloader').css({display:"none"});
					if(data == '-1') {window.location.href = "./"; return;}
					if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); $('#modal-sistema-indicado').modal(); return;}
					fechar_modal_indicado();
					atualizar_linhas(JSON.parse(data));
					toastr.clear(); toastr.success("Usuário salvo com sucesso."); return;
				},
				beforeSend: function(){
					$('.preloader').css({display:"block"});
				},
				complete: function(){
					$('.preloader').css({display:"none"});
				},
				error: function(){
					$('.preloader').css({display:"none"});
					toastr.clear(); toastr.error("Houve um erro ao salvar."); $('#modal-sistema-indicado').modal(); return;
				},
				cache: false,
		        contentType: false,
		        processData: false
			});
		}
		else{
			reabrirModalIndicadoFlag = false;
			$('#modal-confirmacao').modal();
		}
	}
})

$.fn.dataTable.moment( 'DD/MM/YYYY HH:mm:ss');
$('#tabelaIndicacoes').html('<table id="tbIndicacoes" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>');
$('#tbIndicacoes').DataTable({
	"data": [],
	"order": [[ 4, 'desc' ]],
	"columns": [{"title": "Nome", "class": "center"}, {"title": "Status", "class": "center"},{"title": "Indicado por", "class": "center"}, {"title": "Dia do Registro", "class": "center"}, {"title": "Valor Fechado", "class": "center"}, {"title": "<?php echo $sistema->indicacoes->usa_pontos == "1" ? "Pontos" : "Saldo"; ?>", "class": "center"},{"title": "Opções", "class": "center"}, {"title": "Pesquisa"}],
	"lengthMenu": [[25, 50, 100, -1], ["25","50","100", "Mostrar Tudo"]],
	responsive: true,
	"columnDefs": [{"targets": 6, "orderable": false}]
});

function modal_editar(id){
	if($('.dtr-bs-modal').hasClass("in")){
		$('.dtr-bs-modal').one('hidden.bs.modal', function () {
			modal_editar_2(id);
		});
		$('.dtr-bs-modal').modal('hide');
	}
	else{
		modal_editar_2(id);
	}
}

function modal_editar_2(id){
	$(document).ready(function(){
		jQuery.ajax({
			type: "POST",
			url: "action/abrir_modal_indicacao",
			data: {'id' : id},
			success: function(data){
				listaFechamentos = [];
				delecaoFechamentos = [];
				modificacoesFeitas = false;
				dadosIndicadoSalvos = false;
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				$('#modal-sistema-conteudo-indicado').html(data);
				$('#modal-sistema-indicado').modal();
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao editar."); return;
			}
		});
	});
}

function fechar_modal_indicado(){
	$('#modal-sistema-indicado').modal('hide');
}

function fechar_modal(){
	$('#modal-sistema').modal('hide');
}

function carregar_dados(index = -2){
	if(index == -2){
		index = historicoIndicadores[historicoIndex];
	}
	if(index[0] == 0){
		carregar_indicados(index);
	}
	else if(index[0] == 1){
		carregar_ganhos(index);
	}
	else if(index[0] == 2){
		carregar_excel_indicador(index[1]);
	}
}

function carregar_excel_indicador(index){
	if($('.dtr-bs-modal').hasClass("in")){
		$('.dtr-bs-modal').one('hidden.bs.modal', function () {
			carregar_excel_indicador_2(index);
		});
		$('.dtr-bs-modal').modal('hide');
	}
	else{
		carregar_excel_indicador_2(index);
	}
}

function carregar_excel_indicador_2(index){
	$(document).ready(function() {
		var dados = jQuery('#formIndicacoes').serialize()+"&id="+index;
		jQuery.ajax({
			type: "POST",
			url: "action/baixar_historico_indicador_validar",
			data: dados,
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				window.location.href = "./action/baixar_historico_indicador";
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao baixar."); return;
			}
		});
	});
}

function ver_historico(id){
	var table = $('#tbIndicacoes').DataTable();
	var dados = historicoIndicadores[historicoIndex];
	historicoIndicadores[historicoIndex] = [dados[0],dados[1],table.order(),table.page(),table.page.len(),table.search()];
	historicoIndex++;
	if(historicoIndex < historicoIndicadores.length){
		historicoIndicadores = historicoIndicadores.slice(0,historicoIndex);
	}
	historicoIndicadores.push([1, id, [6, 'desc'],0,table.page.len(),""]);
	atualizar_historico();
	carregar_dados([1, id, [6, 'desc'],0,table.page.len(),""]);
}

function baixar_historico(id){
	carregar_dados([2, id]);
}

function carregar_ganhos(index){
	if($('.dtr-bs-modal').hasClass("in")){
		$('.dtr-bs-modal').one('hidden.bs.modal', function () {
			carregar_ganhos_2(index);
		});
		$('.dtr-bs-modal').modal('hide');
	}
	else{
		carregar_ganhos_2(index);
	}
}

function carregar_ganhos_2(index){
	$(document).ready(function() {
		var dados = jQuery('#formIndicacoes').serialize()+"&id="+index[1];
		jQuery.ajax({
			type: "POST",
			url: "action/atualizar_indicacoes_ganhos",
			data: dados,
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				var json = JSON.parse(data);
				var table_data = [];
				for (var i=1; i < json.length; i++){
					var date = Date.parse(json[i].data).toString('dd/MM/yyyy HH:mm:ss');
					var date2 = Date.parse(json[i].dataregistro).toString('dd/MM/yyyy HH:mm:ss');
					var editar = "<div class='btn-group'><a href= 'javascript:void(0);' onclick='modal_editar("+json[i].id+");' class='btn btn-default text-orange' title='Clique para editar o usuário.'><i class='fa fa-edit'></i></a>";
					var sub_str = "";
					var avancado_str = ""
					if(json[i].sub == "1"){
						sub_str = "<li><a href='javascript:void(0);' onclick='ver_indicados("+json[i].id+");'>Visualizar Indicados</a></li>";
					}
					if(json[i].tipo == "Indicador"){
						avancado_str = "<li><a href='javascript:void(0);' onclick='ver_historico("+json[i].id+");'>Visualizar Histórico</a></li><li><a href='javascript:void(0);' onclick='baixar_historico("+json[i].id+");'>Baixar Histórico</a></li>";
					}
					if(sub_str != "" || avancado_str != ""){
						editar += "<button type='button' class='btn btn-default dropdown-toggle' title='Clique para visualizar informações avançadas do usuário.' data-toggle='dropdown' aria-expanded='false'><span class='caret'></span><span class='sr-only'>Exibir Opções</span></button><ul class='dropdown-menu' role='menu'>"+sub_str+avancado_str+"</ul>";
					}
					editar += '</div>';
					table_data[i-1] = ["",json[i].nome, json[i].valorfechado, json[i].porcentagem, json[i].comissao, json[i].motivo, date, editar, json[i].cpf, date2, json[i].telefone, json[i].email, json[i].pesquisa];
				}
				$(".tipopesquisa").html("Histórico de Fechamentos");
				$(".tipopesquisa2").html("Visualize os ganhos do indicador");
				$(".nomeIndicado").html("<b>Histórico de "+json[0]+"</b>");
				$(document).ready(function() {
					$.fn.dataTable.moment( 'DD/MM/YYYY HH:mm:ss');
					$('#tabelaIndicacoes').html('<table id="tbIndicacoes" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>');
					$('#tbIndicacoes').DataTable({
						"data": table_data,
						"order": index[2],
						"pageLength": index[4],
						"displayStart": index[3] * index[4],
						"search": {
							"search": index[5]
						},
						"order": [[ 6, 'desc' ]],
						"columns": [{},{"title": "Nome do Responsável"}, {"title": "Valor Fechado"},{"title": "%"}, {"title": "Mudança de Saldo"},{"title": "Motivo"},{"title": "Data da Alteração"},{"title": "Opções", "className": "table-buttons"}, {"title": "<?php echo $identificador; ?>"}, {"title": "Dia do Registro"},{"title": "Telefone"}, {"title": "Email"}],
						"lengthMenu": [[25, 50, 100, -1], ["25","50","100", "todas"]],
						responsive: {
						    details: {
						    	type: 'column',
						        display: $.fn.dataTable.Responsive.display.modal( {
						            header: function ( row ) {
						                return '<span style="margin-right: 10px"><b>Dados da Entrada</b></span>';
						            }
						        } ),
						        renderer: function ( api, rowIdx, columns ) {
						        	text = "";
						        	text += columns[6].data + "<br>";
						        	for(i = 0;i < columns.length;i++){
						        		column = columns[i];
						        		if(i == 6) { continue; }
						        		if(i > 0) text += "<br>";
						        		text += "<b>" + column.title + ": </b>" + column.data;
						        	}
						        	return text;
						        }
						    }
						},
						"deferRender": true,
						"columnDefs": [ {"targets": [2 ,4], "type": "numeric-comma-real"}, {"targets": 7, "orderable": false}, {className: 'control', orderable: false, targets: 0, width: "5%"}]
					});
				});
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao atualizar"); return;
			}
		});
	});
}

function carregar_indicados(index){
	if($('.dtr-bs-modal').hasClass("in")){
		$('.dtr-bs-modal').one('hidden.bs.modal', function () {
			carregar_indicados_2(index);
		});
		$('.dtr-bs-modal').modal('hide');
	}
	else{
		carregar_indicados_2(index);
	}
}

function carregar_indicados_2(index){
	$(document).ready(function() {
		var dados = jQuery('#formIndicacoes').serialize()+"&id="+index[1];
		jQuery.ajax({
			type: "POST",
			url: "action/atualizar_indicacoes",
			data: dados,
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") { toastr.clear(); toastr.error(data.substring(2)); return;}
				var json = JSON.parse(data);
				var table_data = [];
				for (var i=1; i < json.length; i++){

					var date = Date.parse(json[i].data).toString('dd/MM/yyyy HH:mm:ss');

					var editar = "<div class='btn-group'><a href= 'javascript:void(0);' onclick='modal_editar("+json[i].id+");' class='btn btn-default text-orange' title='Clique para editar o usuário.'><i class='fa fa-edit'></i></a>";
					var sub_str = "";
					var avancado_str = ""
					if(json[i].sub == "1"){
						sub_str = "<li><a href='javascript:void(0);' onclick='ver_indicados("+json[i].id+");'>Visualizar Indicados</a></li>";
					}
					if(json[i].tipo == "Indicador"){
						avancado_str = "<li><a href='javascript:void(0);' onclick='ver_historico("+json[i].id+");'>Visualizar Histórico</a></li><li><a href='javascript:void(0);' onclick='baixar_historico("+json[i].id+");'>Baixar Histórico</a></li>";
					}
					if(sub_str != "" || avancado_str != ""){
						editar += "<button type='button' class='btn btn-default dropdown-toggle' title='Clique para visualizar informações avançadas do usuário.' data-toggle='dropdown' aria-expanded='false'><span class='caret'></span><span class='sr-only'>Exibir Opções</span></button><ul class='dropdown-menu' role='menu'>"+sub_str+avancado_str+"</ul>";
					}
					editar += '</div>';
					table_data[i-1] = ["",json[i].nome, json[i].status, json[i].indicadopor, date, json[i].fechamentos, json[i].saldo,editar,json[i].telefone, json[i].email, json[i].cpf, json[i].pesquisa, json[i].id];
				}
				$(".tipopesquisa").html("Indicações");
				$(".tipopesquisa2").html("Visualize os usuários do sistema de indicações");
				$(".nomeIndicado").html("<b>"+json[0]['nome']+"</b>");
				$(document).ready(function() {
					$.fn.dataTable.moment( 'DD/MM/YYYY HH:mm:ss');
					$('#tabelaIndicacoes').html('<table id="tbIndicacoes" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>');
					$('#tbIndicacoes').DataTable({
						"data": table_data,
						"order": index[2],
						"pageLength": index[4],
						"displayStart": index[3] * index[4],
						"search": {
							"search": index[5]
						},
						"columns": [{},{"title": "Nome"}, {"title": "Status"},{"title": "Indicado por"}, {"title": "Dia do Registro"}, {"title": "Fechamentos"}, {"title": "<?php echo $sistema->indicacoes->usa_pontos == "1" ? "Pontos" : "Saldo"; ?>"},{"title": "Opções", "className": "table-buttons"}, {"title": "Telefone"}, {"title": "Email"}, {"title": "<?php echo $identificador; ?>"}],
						"lengthMenu": [[25, 50, 100, -1], ["25","50","100", "todas"]],
						responsive: {
						    details: {
						    	type: 'column',
						        display: $.fn.dataTable.Responsive.display.modal( {
						            header: function ( row ) {
						                return '<span style="margin-right: 10px"><b>Dados do Indicado(r)</b></span>';
						            }
						        } ),
						        renderer: function ( api, rowIdx, columns ) {
						        	text = "";
						        	text += columns[6].data + "<br>";
						        	for(i = 0;i < columns.length;i++){
						        		column = columns[i];
						        		if(i == 6) { continue; }
						        		if(i > 0) text += "<br>";
						        		text += "<b>" + column.title + ": </b>" + column.data;
						        	}
						        	
						        	return text;
						        }
						    }
						},
						"deferRender": true,
						"columnDefs": [{"targets": 7, "orderable": false}, {"targets": [6], "type": "numeric-comma-real"}, {className: 'control', orderable: false, targets: 0, width: "5%"}],
						"createdRow": function ( row, data, index ) {
							$(row).addClass("id"+data[12]);
							var current = $('td', row).eq(2);
							if(current.text() == "Fechado"){
								current.css('color','green');
							}
							else if(current.text() == "Perdeu"){
								current.css('color','red');
							}
							else if(current.text() == "Novo"){
								current.css('color','blue');
							}
						}
					});
				});
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao atualizar"); return;
			}
		});
	});
}

function atualizar_linhas(json){
	var dados = historicoIndicadores[historicoIndex];
	if(dados[0] != 0)
		return;
	var table = $('#tbIndicacoes').DataTable();
	for (var i=0; i < json.length; i++){
		var registro = json[i];
		var tableRow = table.row(".id"+registro.id);
		var rowData = tableRow.data();
		if (rowData == null){
			continue;
		}
		if(registro.hasOwnProperty('status')){
			var cell = $('td', tableRow.node()).eq(2);
			if(registro.status == "Fechado"){
				cell.css('color','green');
			}
			else if(registro.status == "Perdeu"){
				cell.css('color','red');
			}
			else if(registro.status == "Novo"){
				cell.css('color','blue');
			}
			else{
				cell.css('color','#333');
			}
			rowData[2] = registro.status;
		} 
		if(registro.hasOwnProperty('fechamentos')) rowData[5] = registro.fechamentos;
		if(registro.hasOwnProperty('saldo')) rowData[6] = registro.saldo;
		if(registro.hasOwnProperty('nome')) rowData[1] = registro.nome;
		if(registro.hasOwnProperty('telefone')) rowData[8] = registro.telefone;
		if(registro.hasOwnProperty('email')) rowData[9] = registro.email;
		tableRow.data(rowData);
		tableRow.invalidate();
	}
	table.draw(false);
}

function atualizar(){
	var valor = $('#data').val();
	if(valor == "CUSTOM_DATE")
		$('.datadiv').removeClass("hide");
	else{
		$('.datadiv').addClass("hide");
		carregar_dados(historicoIndicadores[historicoIndex]);
	}
}

function voltar_historico(){
	if($.active > 0) return;
	if(historicoIndex == 0) return;
	var table = $('#tbIndicacoes').DataTable();
	var dados = historicoIndicadores[historicoIndex];
	historicoIndicadores[historicoIndex] = [dados[0],dados[1],table.order(),table.page(),table.page.len(),table.search()];
	historicoIndex--;
	carregar_dados(historicoIndicadores[historicoIndex]);
	atualizar_historico()
}

function avancar_historico(){
	if($.active > 0) return;
	if(historicoIndex == historicoIndicadores.length - 1) return;
	var table = $('#tbIndicacoes').DataTable();
	var dados = historicoIndicadores[historicoIndex];
	historicoIndicadores[historicoIndex] = [dados[0],dados[1],table.order(),table.page(),table.page.len(),table.search()];
	historicoIndex++;
	carregar_dados(historicoIndicadores[historicoIndex]);
	atualizar_historico()
}

function home_historico(){
	if($.active > 0) return;
	if(historicoIndex == 0) return;
	var table = $('#tbIndicacoes').DataTable();
	var dados = historicoIndicadores[historicoIndex];
	historicoIndicadores[historicoIndex] = [dados[0],dados[1],table.order(),table.page(),table.page.len(),table.search()];
	historicoIndex = 0;
	carregar_dados(historicoIndicadores[historicoIndex]);
	atualizar_historico()
}

function ver_indicados(id){
	var table = $('#tbIndicacoes').DataTable();
	var dados = historicoIndicadores[historicoIndex];
	historicoIndicadores[historicoIndex] = [dados[0],dados[1],table.order(),table.page(),table.page.len(),table.search()];
	historicoIndex++;
	if(historicoIndex < historicoIndicadores.length){
		historicoIndicadores = historicoIndicadores.slice(0,historicoIndex);
	}
	historicoIndicadores.push([0,id,table.order(),0,table.page.len(),""]);
	atualizar_historico();
	carregar_dados([0,id,table.order(),0,table.page.len(),""]);
}

function atualizar_historico(){
	if(historicoIndex > 0){
		$(".botao-voltar").removeClass("disabled");
		$(".botao-voltar").addClass("text-green");
	}
	else{
		$(".botao-voltar").removeClass("text-green");
		$(".botao-voltar").addClass("disabled");
	}
	if(historicoIndex < historicoIndicadores.length - 1){
		$(".botao-avancar").removeClass("disabled");
		$(".botao-avancar").addClass("text-green");
	}
	else{
		$(".botao-avancar").removeClass("text-green");
		$(".botao-avancar").addClass("disabled");
	}
	if(historicoIndicadores.length > 0 & historicoIndex > 0){
		$(".botao-home").removeClass("disabled");
		$(".botao-home").addClass("text-blue");
	}
	else{
		$(".botao-home").removeClass("text-blue");
		$(".botao-home").addClass("disabled");
	}
}

function fechar_modal(){
	$('#modal-sistema').modal('hide');
}

$(document).ready(function(){
	carregar_dados(historicoIndicadores[historicoIndex]);
});

$('#data, #switch').change(function(){ atualizar(); });
$('#datapersonalizada').click(function(){
	carregar_dados(historicoIndicadores[historicoIndex]);
});