const LIGACOES_INDEX = function () {
    let table;
    let carregarTotais = 1;
    let permitirLeads  = false;
    let urlContato     = '';
    let currentTr      = null;
    let currentRow     = null;

    const abrirModalNovoContato = function () {
        let telefone    = $(this).data('origem');
        let id          = $(this).data('id');
        let dataLigacao = $(this).data('dataLigacao');
        let fonte       = $(this).data('fonte');
        let modal       = $('.dtr-bs-modal');

        if (modal.hasClass('in')) {
            modal.one('hidden.bs.modal', function () {
                carregarModalNovoContato(telefone, id, dataLigacao, fonte);
            });
            modal.modal('hide');
        } else {
            carregarModalNovoContato(telefone, id, dataLigacao, fonte);
        }
    };

    const carregarModalNovoContato = function (telefone, id, dataLigacao, fonte) {
        $(document).ready(function () {
            $.ajax({
                type       : 'POST',
                url        : 'action/abrir_modal_nova_ligacao',
                data       : {
                    'telefone'    : telefone,
                    'id'          : id,
                    'dataligacao' : dataLigacao,
                    'fonte'       : fonte,
                },
                success    : function (data) {
                    $('.preloader').css({display : 'none'});

                    if (data === '-1') {
                        window.location.href = './';
                        return;
                    }

                    if (data.substring(0, 2) === '-2') {
                        toastr.clear();
                        toastr.error(data.substring(2));
                        return;
                    }

                    $('#modal-sistema-conteudo').html(data);
                    $('#modal-sistema').modal();
                },
                beforeSend : function () {
                    $('.preloader').css({display : 'block'});
                },
                complete   : function () {
                    $('.preloader').css({display : 'none'});
                },
                error      : function () {
                    $('.preloader').css({display : 'none'});
                    toastr.clear();
                    toastr.error('Houve um erro ao abrir modal.');
                },
            });
        });
    };

    const abrirModalVerContato = function () {
        let telefone = $(this).data('origem');
        let id       = $(this).data('id');
        let modal    = $('.dtr-bs-modal');

        if (modal.hasClass('in')) {
            modal.one('hidden.bs.modal', function () {
                carregarModalVerContato(telefone, id);
            });
            modal.modal('hide');
        } else {
            carregarModalVerContato(telefone, id);
        }
    };

    function carregarModalVerContato(telefone, id) {
        $(document).ready(function () {
            jQuery.ajax({
                type       : 'POST',
                url        : 'action/abrir_modal_ligacao_contato',
                data       : {
                    'telefone' : telefone,
                    'id'       : id,
                },
                success    : function (data) {
                    $('.preloader').css({display : 'none'});
                    if (data === '-1') {
                        window.location.href = './';
                        return;
                    }
                    if (data.substring(0, 2) === '-2') {
                        toastr.clear();
                        toastr.error(data.substring(2));
                        return;
                    }
                    $('#modal-sistema-conteudo').html(data);
                    $('#modal-sistema').modal();
                },
                beforeSend : function () {
                    $('.preloader').css({display : 'block'});
                },
                complete   : function () {
                    $('.preloader').css({display : 'none'});
                },
                error      : function () {
                    $('.preloader').css({display : 'none'});
                    toastr.clear();
                    toastr.error('Houve um erro ao abrir modal.');
                },
            });
        });
    }

    const abrirModalVerLigacao = function () {
        let id    = $(this).data('id');
        let modal = $('.dtr-bs-modal');

        if (modal.hasClass('in')) {
            modal.one('hidden.bs.modal', function () {
                carregarModalVerLigacao(id);
            });
            modal.modal('hide');
        } else {
            carregarModalVerLigacao(id);
        }
    };

    const carregarModalVerLigacao = function (id) {
        $(document).ready(function () {
            jQuery.ajax({
                type       : 'POST',
                url        : 'action/abrir_modal_ligacao',
                data       : {
                    'id' : id,
                },
                success    : function (data) {
                    $('.preloader').css({display : 'none'});
                    if (data === '-1') {
                        window.location.href = './';
                        return;
                    }
                    if (data.substring(0, 2) === '-2') {
                        toastr.clear();
                        toastr.error(data.substring(2));
                        return;
                    }
                    $('#modal-sistema-conteudo').html(data);
                    $('#modal-sistema').modal();
                },
                beforeSend : function () {
                    $('.preloader').css({display : 'block'});
                },
                complete   : function () {
                    $('.preloader').css({display : 'none'});
                },
                error      : function () {
                    $('.preloader').css({display : 'none'});
                    toastr.clear();
                    toastr.error('Houve um erro ao abrir modal.');
                },
            });
        });
    };

    const carregarConteudoSubligacoes = function (subligacoes) {
        let rowData = '\
            <div class=\'row\' style=\'white-space: normal;\'>\
                <div class=\'col-xs-12\'>\
                    <b>Mais ligações da mesma origem: </b>\
                    <br>\
                </div>\
    	';
        for (let c = subligacoes.length - 1; c >= 0; c--) {
            let ligacaoAtual = subligacoes[c];
            rowData += '\
                <div class=\'col-xs-12\'>\
                    <b>→</b> <b>Dia da Ligação:</b> ' + ligacaoAtual.data + ' | <b>Custo</b>: ' + ligacaoAtual.custo +
                ' (<a href=\'javascript:void(0);\' class=\'text-blue botao-ver-ligacao\' data-id=\'' + ligacaoAtual.id +
                '\' title=\'Clique para ver os detalhes desta ligação.\'>Ver Detalhes</a>)\
                </div>';
        }

        rowData += '</div>';
        currentRow.child(rowData).show();
        currentTr.addClass('shown');
    };

    const visualizarLinha = function () {
        let id     = $(this).data('id');
        let source = $(this).data('source');
        let tr     = $(this).closest('tr');
        let row    = table.row(tr);
        currentRow = row;
        currentTr  = tr;

        if (row.child.isShown()) {
            row.child.hide();
            tr.removeClass('shown');
        } else {
            carregarSubligacoes(id, source);
        }
    };

    const carregarSubligacoes = function (id, source) {
        let data     = {};
        let formData = $('#formLigacoes').serializeArray();
        $.each(formData, function (key, val) {
            data[val.name] = val.value;
        });
        data['id']     = id;
        data['source'] = source;

        $(document).ready(function () {
            $.ajax({
                type       : 'POST',
                url        : 'action/atualizar_subligacoes',
                data       : data,
                success    : function (data) {
                    $('.preloader').css({display : 'none'});

                    if (data === '-1') {
                        window.location.href = './';
                        return;
                    }

                    if (typeof data === 'string' && data.substring(0, 2) === '-2') {
                        toastr.clear();
                        toastr.error(data.substring(2));
                        return;
                    }

                    carregarConteudoSubligacoes(data);
                },
                beforeSend : function () {
                    $('.preloader').css({display : 'block'});
                },
                complete   : function () {
                    $('.preloader').css({display : 'none'});
                },
                error      : function () {
                    $('.preloader').css({display : 'none'});
                    toastr.clear();
                    toastr.error('Houve um erro ao carregar as ligações.');
                },
            });
        });
    };

    const handleTable = function () {
        table = $('#tbLigacoes').serverTable({
            'ajax'       : {
                'url'     : 'action/atualizar_ligacoes',
                'type'    : 'POST',
                'data'    : function (data) {
                    if (SystemUtils.isFilterUpdate) {
                        carregarTotais             = 1;
                        SystemUtils.isFilterUpdate = false;
                    }

                    if (carregarTotais) {
                        $('.info-box-number').html('<div class="preloader"><i class="fa fa-refresh fa-spin"></i></div>');
                        $('.preloader').css({display : 'block'});
                    } else {
                        $('.preloader:not(.filtros)').css({display : 'block'});
                    }

                    let formData = $('#formLigacoes').serializeArray();
                    $.each(formData, function (key, val) {
                        data[val.name] = val.value;
                    });
                    data['carregarTotais'] = carregarTotais;
                },
                'dataSrc' : function (response) {
                    permitirLeads = response.permitirLeads;
                    urlContato    = response.urlContato;

                    $('.preloader').css({display : 'none'});

                    if (carregarTotais === 1) {
                        carregarTotais = 0;
                        $('#totalligacoes').html(response.total);
                        $('#totalgasto').html(response.valor);
                    }

                    return response.data;
                },
            },
            'columns'    : [
                {
                    'name'      : 'placeholder',
                    'data'      : null,
                    'orderable' : false,
                    'class'     : 'control',
                    'render'    : function () {
                        return '';
                    },
                },
                {
                    'name'      : 'source',
                    'title'     : 'Origem',
                    'orderable' : false,
                    'filter'    : 'text',
                    'render'    : function (data, type, row) {
                        if (row[13] > 1) {
                            return '<a class=\'open-details\' data-id=\'' + row[7] + '\' data-source=\''
                                + data + '\' href=\'javascript:void(0)\'>↪</a>' + data;
                        }

                        return data;
                    },
                },
                {
                    'name'      : 'destination',
                    'title'     : 'Destino Final',
                    'orderable' : false,
                    'filter'    : 'text',
                },
                {
                    'name'      : 'category',
                    'title'     : 'Fonte',
                    'orderable' : false,
                    'filter'    : 'text',
                },
                {
                    'name'        : 'start_time',
                    'title'       : 'Dia da Ligação',
                    'filter'      : 'text',
                    'filterClass' : 'mascara-data',
                    'render'      : function (data) {
                        return moment(data, 'YYYY-MM-DD HH:mm:ss').format('DD/MM/YYYY HH:mm:ss');
                    },
                },
                {
                    'name'      : 'real_cost',
                    'title'     : 'Custo',
                    'orderable' : false,
                },
                {
                    'name'      : 'real_talking_duration',
                    'title'     : 'Tempo de Conversa',
                    'orderable' : false,
                    'filter'    : 'text',
                },
                {
                    'name'      : 'id',
                    'title'     : 'Opções',
                    'class'     : 'table-buttons',
                    'orderable' : false,
                    'render'    : function (data, type, row) {
                        let html = '<div class=\'btn-group\'>';

                        if (permitirLeads && row[11] === true) {
                            html += '<a href= \'javascript:void(0);\' class=\'btn btn-default text-orange botao-editar-contato\' ' +
                                'title=\'Clique editar o contato.\' data-id=\'' + data + '\' data-origem=\'' + row[1] +
                                '\'><i class=\'fa fa-edit\'></i></a>';
                        } else if (permitirLeads && row[11] === false) {
                            html += '<a href= \'javascript:void(0);\' class=\'btn btn-default text-green botao-novo-contato\' ' +
                                'title=\'Clique para adicionar como um contato.\' data-origem="' + row[1] + '" data-fonte="' +
                                row[3] + '" data-id="' + data + '" data-data-ligacao="' + row[4] + '"><i class=\'fa fa-plus\'></i></a>';
                        }

                        html += '<a href= \'javascript:void(0);\' class=\'btn btn-default text-blue botao-ver-ligacao\' ' +
                            'title=\'Clique para ver os detalhes desta ligação.\' data-id="' + data + '"><i class=\'fa fa-list\'></i></a>';

                        if (row[1].length > 3) {
                            html += '<a href="tel:0' + row[1].replace(/[`~!@#$%^&*()_ |+\-=?;:'",.<>\{\}\[\]\\\/]/gi, '') +
                                '" class="btn btn-default text-blue" title="Clique para ligar"><i class="fa fa-phone"></i></a>';
                        }

                        const telefoneFormatado = row[1].replace(/[`~!@#$%^&*()_ |+\-=?;:'",.<>\{\}\[\]\\\/]/gi, '');
                        const telefoneNormal    = row[1];

                        const urlTelefoneFormatado = urlContato.replace('#TELEFONE#', telefoneFormatado);
                        const urlTelefoneNormal    = urlContato.replace('#TELEFONE#', telefoneNormal);

                        if (row[1].indexOf('(') !== -1) {
                            html += '<a href="' + urlTelefoneFormatado + '" class="btn btn-default text-light-gold" target="_blank"' +
                                ' title="Enviar mensagem para esse número"><i class="fa fa-whatsapp"></i></a>';
                        } else {
                            html += '<a href="' + urlTelefoneNormal + '" class="btn btn-default text-light-gold" target="_blank" ' +
                                'title="Enviar mensagem para esse número"><i class="fa fa-whatsapp"></i></a>';
                        }

                        html += '</div>';

                        return html;
                    },
                },
                {
                    'name'      : 'answered',
                    'title'     : 'Atendida',
                    'orderable' : false,
                    'filter'    : [
                        {
                            'text'  : 'Atendida',
                            'value' : '1',
                        },
                        {
                            'text'  : 'Não Atendida',
                            'value' : '0',
                        },
                    ],
                    'render'    : function (data) {
                        return data === 1 ? 'Atendida' : 'Não Atendida';
                    },
                },
                {
                    'name'      : 'real_ringing_duration',
                    'title'     : 'Tempo de Espera',
                    'orderable' : false,
                    'filter'    : 'text',
                },
                {
                    'name'      : 'real_total_duration',
                    'title'     : 'Duração Total',
                    'orderable' : false,
                    'filter'    : 'text',
                },
                {
                    'name'    : 'adicionado',
                    'title'   : 'Adicionado',
                    'visible' : false,
                },
                {
                    'name'    : 'valido',
                    'title'   : 'Válido',
                    'visible' : false,
                },
                {
                    'name'    : 'call_quantity',
                    'title'   : 'Quantidade de Ligações',
                    'visible' : false,
                },
            ],
            'order'      : [],
            'createdRow' : function (row, data) {
                $(row).addClass('id' + data[7]);

                if (data[11] === true) {
                    $(row).css('background-color', '#bafdd7');
                }

                let atendida = $('td', row).eq(8);

                if (data[8] === 1) {
                    atendida.css('color', 'green');
                } else {
                    atendida.css('color', 'red');
                }
            },
            responsive   : {
                details : {
                    type     : 'column',
                    display  : $.fn.dataTable.Responsive.display.modal({
                        header : function () {
                            return '<span style="margin-right: 10px"><b>Dados da Ligação</b></span>';
                        },
                    }),
                    renderer : function (api, rowIdx, columns) {
                        let text = '';
                        text += columns[6].data + '<br>';
                        for (let i = 0; i < columns.length; i++) {
                            let column = columns[i];
                            if (i === 6 || i > 9) {
                                continue;
                            }
                            if (i > 0) text += '<br>';
                            text += '<b>' + column.title + ': </b>' + column.data;
                        }
                        return text;
                    },
                },
            },
        });
    };

    const atualizarFiltro = function () {
        let valor = $('#data').val();

        if (valor === 'CUSTOM_DATE')
            $('.datadiv').removeClass('hide');
        else {
            $('.datadiv').addClass('hide');
            carregarTotais = 1;
            table.ajax.reload();
            salvarFiltro(valor, '', '');
        }
    };

    const handleFiltro = function () {
        $('#data, #switch').change(atualizarFiltro);
        $('#datapersonalizada').click(function () {
            salvarFiltro($('#data').val(), $('#datainicial').val(), $('#datafinal').val());
            carregarTotais = 1;
            table.ajax.reload();
        });
    };

    const equalizeHeights = function (selector) {
        let maxHeight = 0;

        $(selector).each(function () {
            $(this).css('height', 'auto'); // resetar antes
            var height = $(this).outerHeight();
            if (height > maxHeight) maxHeight = height;
        });

        $(selector).each(function () {
            $(this).css('height', maxHeight);
            $(this).show();
        });
    }

    const handleButtons = function () {
        $(document).on('click', '.botao-novo-contato', abrirModalNovoContato);
        $(document).on('click', '.botao-editar-contato', abrirModalVerContato);
        $(document).on('click', '.botao-ver-ligacao', abrirModalVerLigacao);
        $(document).on('click', '.open-details', visualizarLinha);

        $('#modal-sistema').on('shown.bs.modal', function () {
            equalizeHeights('.caixas-segmento');
        });
    };

    return {
        init : function () {
            handleTable();
            handleFiltro();
            handleButtons();
        },

        recarregar : function () {
            table.ajax.reload();
        },
    };
}();

$(function () {
    LIGACOES_INDEX.init();
});

// as funções abaixo estão assim públicas para compatibilidade com o código já existente no sistema
function fechar_modal() {
    $('#modal-sistema').modal('hide');
}

function mudar_icone_adicionado() {
    LIGACOES_INDEX.recarregar();
}