$('.datepicker').datepicker({
	format: 'dd/mm/yyyy',
	endDate: '0d',
	autoclose: true,
	language: 'pt-BR'
});

$('.datepicker').mask('00/00/0000');

$.fn.dataTable.moment( 'DD/MM/YYYY HH:mm:ss');
$('#tabelaPalavras').html('<table id="tbPalavras" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>');
$('#tbPalavras').dataTable({
	"data": [],
	"order": [[ 2, 'desc' ]],
	"columns": [{"title": "Palavras-chave"},{"title": "Qnt. Anúncios"},{"title": "Acessos ao site"},{"title": "% Acessos / Anúncios"},{ "title": "% em primeira Posição"},{ "title": "% entre os 4 primeiros"},{ "title": "Custo Por Clique"},{ "title": "Custo Total"}],
	"lengthMenu": [[25, 50, 100, -1], ["25","50","100", "todas"]],
	responsive: true
});

var ultimosDados = null;

function carregar_dados(){
	$(document).ready(function() {
		var dados = jQuery('#formPalavras').serialize();
		jQuery.ajax({
			type: "POST",
			url: "action/atualizar_palavras",
			data: dados,
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				ultimosDados = data;
				var json = JSON.parse(data);
				var table_data = [];
				var dados;
				var colunas;
				var consultoria = json[0] == "1";
				for (var i=1; i < json.length; i++){
					dados = json[i];
					if(consultoria)
						table_data[i-1] = ["",dados.keyword, dados.impressions, dados.clicks, dados.ctr, dados.imprAbsTop+'%', dados.imprTop+'%', dados.avgCPC, dados.cost];
					else
						table_data[i-1] = ["",dados.keyword, dados.impressions, dados.clicks, dados.ctr, dados.imprAbsTop+'%', dados.imprTop+'%'];
				}
				if(consultoria)
					colunas = [
						{},{ "title": "Palavras-chave"},{ "title": "Qnt. Anúncios"},{ "title": "Acessos ao site"},{ "title": "% Acessos / Anúncios"},{ "title": "% em primeira Posição"},{ "title": "% entre os 4 primeiros"},{ "title": "Custo Por Clique"},{ "title": "Custo Total"}
					];
				else
					colunas = [
						{},{ "title": "Palavras-chave"},{ "title": "Qnt. Anúncios"},{ "title": "Acessos ao site"},{ "title": "% Acessos / Anúncios"},{ "title": "% em primeira Posição"},{ "title": "% entre os 4 primeiros"}
					];
				$(document).ready(function() {
					$.fn.dataTable.moment( 'DD/MM/YYYY HH:mm:ss');
					$('#tabelaPalavras').html('<table id="tbPalavras" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>');
					if(json.length >= 2){
						$("#tbPalavras").append(
							$('<tfoot style="display: table-header-group;" />').append(`<tr>${colunas.map((i) => "<th></th>").join("")}</tr>`)
						);
						$('#tbPalavras tfoot tr th').each(function (index) {
							$(this).html('<input type="text" style="width: 100%" class="form-control" placeholder="" />');
						});
					}
					$('#tbPalavras').dataTable({
						"data": table_data,
						"order": [[ 3, 'desc' ]],
						"columns": colunas,
						"language": {
							"decimal": ",",
    					"thousands": "."
						},
						"columnDefs": [{className: 'control', orderable: false, targets: 0, width: "5%"}],
						"lengthMenu": [[25, 50, 100, -1], ["25","50","100", "todas"]],
						initComplete: function () {
							// Apply the search
							//this.api()
							//	.columns([4,7])
							//	.every(function () {
							//		var column = this;
              //      var select = $('<select class="form-control"><option value=""></option></select>')
              //          .appendTo($(column.footer()).empty())
              //          .on('change', function () {
              //              var val = $.fn.dataTable.util.escapeRegex($(this).val());
              //              column.search(val ? '^' + val + '$' : '', true, false).draw();
              //          });
              //      column
              //          .data()
              //          .unique()
              //          .sort()
              //          .each(function (d, j) {
              //              select.append('<option value="' + d + '">' + d + '</option>');
              //          });
							//		var that = this;
							//		$('input', this.footer()).on('keyup change clear', function () {
							//			if (that.search() !== this.value) {
							//				that.search(this.value).draw();
							//			}
							//		});
							//		
							//	});
							this.api()
								.columns([0,1,2,3,4,5,6,7,8,9,10])
								.every(function () {
									var that = this;
									$('input', this.footer()).on('keyup change clear', function () {
										if (that.search() !== this.value) {
											that.search(this.value).draw();
										}
									});
								});
						},
						responsive: {
						    details: {
						    	type: 'column',
						        display: $.fn.dataTable.Responsive.display.modal( {
						            header: function ( row ) {
						                return '<span style="margin-right: 10px"><b>Dados das Palavras-chave</b></span>';
						            }
						        } ),
						        renderer: function ( api, rowIdx, columns ) {
						        	text = "";
						        	for(i = 0;i < columns.length;i++){
						        		column = columns[i];
						        		if(i > 0) text += "<br>";
						        		text += "<b>" + column.title + ": </b>" + column.data;
						        	}
						        	return text;
						        }
						    }
						},
						"deferRender": true
					});
				});
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao atualizar"); return;
			}
		});
	});
}

function atualizar(){
	var valor = $('#data').val();
	if(valor == "CUSTOM_DATE")
		$('.datadiv').removeClass("hide");
	else{
		$('.datadiv').addClass("hide");
		carregar_dados();
		salvarFiltro(valor,'','');
	}
}

function isJsonString(str) {
    try {
        JSON.parse(str);
    } catch (e) {
        return false;
    }
    return true;
}

function carregar_excel(){
	if(ultimosDados == null || isJsonString(ultimosDados) == false){
		$('.preloader').css({display:"none"});
		toastr.clear(); toastr.error("Não há dados para baixar."); return;
		return;
	}
	if($('.dtr-bs-modal').hasClass("in")){
		$('.dtr-bs-modal').one('hidden.bs.modal', function () {
			carregar_excel_2();
		});
		$('.dtr-bs-modal').modal('hide');
	}
	else{
		carregar_excel_2();
	}
}

function carregar_excel_2(){
	$(document).ready(function() {
		var formData = new FormData(document.getElementById('formPalavras'));
		formData.append("json", ultimosDados);
		jQuery.ajax({
			type: "POST",
			url: "action/baixar_palavras_validar",
			data: formData,
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				window.location.href = "./action/baixar_palavras";
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao baixar."); return;
			},
			cache: false,
	        contentType: false,
	        processData: false
		});
	});
}

pegarFiltro(function(filtro,data1,data2){
	$('#data').val(filtro);
	$('#datainicial').val(data1);
	$('#datafinal').val(data2);
	if(filtro == "CUSTOM_DATE")
		$('.datadiv').removeClass("hide");
	carregar_dados();
});

$('#data, #switch, #grupo').change(function(){ atualizar(); });
$('#datapersonalizada').click(function(){
	salvarFiltro($('#data').val(),$('#datainicial').val(),$('#datafinal').val());
	carregar_dados();
});