<?php
/*
 * Este arquivo é responsável por montar a modal que serve para editar o contato especificado.
 */
 
require_once(__DIR__ . "/../classes/Sistema.php"); 
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if($sistema->usuario->permissao_leads == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}
if($sistema->usuario->permissao_3cx == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

try{
	$sistema->iniciar_bd_leads();

	/* Fazemos aqui a consulta dos dados do lead especificado */
	$dados = $sistema->bd_leads->executar("SELECT * FROM TBL_LEADS WHERE NU_TELEFONE1 = :telefone AND ID_CLIENTE_FK = :id2 AND TXT_LEADTIPO = 'Win7 Fone'", array(':telefone' => $_POST['telefone'], "id2" => $sistema->usuario->id), Banco_Dados::FETCH);

	if($sistema->bd_leads->quantidade() == 0){ // Nenhum dado foi encontrado, ID é inválida
		echo "-2Telefone inválido!";
		exit;
	}
	
	/* Criamos variáveis que guardam todos os dados do lead */
	$_POST['id'] = $dados['ID_LEAD'];
	$nome = $dados['TXT_NOME'];
	$telefone1 = $dados['NU_TELEFONE1'];
	$telefone2 = $dados['NU_TELEFONE2'];
	$email = $dados['TXT_EMAIL'];
	$status = $dados['TXT_SITUACAO'];
	$qualidade = $dados['TXT_QUALI'];
	$anotacoes = $dados['TXT_ANOTACOES'];
	$mensagem = $dados['TXT_MENSAGEM'];
	$identificadorfonte = $dados['TXT_IDENTIFICADOR'];
	
	// Consulta os campos extras
	$campos_extras = $sistema->bd_leads->executar("SELECT * FROM TBL_LEADS_CAMPOS WHERE NU_ID_LEAD = :id", array(':id' => $_POST['id']), Banco_Dados::FETCH_ALL);
	$dados_extras = array();
	foreach($campos_extras as $campo){
		$ordem = (intval($campo['NU_ORDEM'])-1) * 2;
		$dados_extras[$ordem] = $campo['TXT_NOME'];
		$dados_extras[$ordem+1] = $campo['TXT_CONTEUDO'];
	}
	
	$fechado = number_format(floatval($dados['TXT_PRECO_FECHADO']/100),2,',','.');
	$combinado = number_format(floatval($dados['TXT_PRECO']/100),2,',','.');
	
	// Calcula-se a última data de alteração do lead
	$data_alteracao = $dados['DT_ANOTACOES_DATA'];
	if(Utilitarios::data_padrao_valida($data_alteracao)){
		$data_alteracao = strtotime($data_alteracao);
		$data_alteracao = date('d/m/Y H:i:s', $data_alteracao);
	}
	else{
		$data_alteracao = "";
	}
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>
<script>
var maskBehavior = function (val) {
	return val.replace(/\D/g, '').length === 11 ? '(00) 00000-0000' : '(00) 0000-00009';
},
options = {onKeyPress: function(val, e, field, options) {
	field.mask(maskBehavior.apply({}, arguments), options);}
};
function atualizar_status(){
	var current = $('#status').val();
	if(current == "Fechado")
		$('#status').css('color','green');
	else if(current == "Perdeu" || current == "Não é Cliente")
		$('#status').css('color','red');
	else if(current == "Novo")
		$('#status').css('color','blue');
	else
		$('#status').css('color','#555');
}

$(document).ready(function(){
	atualizar_status();
	$('#status').change(atualizar_status);
	$('#formContato').submit(function(){
		var dados = jQuery( this ).serialize() + "&id=<?php echo $_POST['id']; ?>";
		jQuery.ajax({
			type: "POST",
			url: "action/salvar_modal_contato",
			data: dados,
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				fechar_modal();
				toastr.clear(); toastr.success("Contato salvo com sucesso."); return;
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao salvar."); return;
			}
		});
		return false;
	});
	$('.dinheiro').mask('000.000.000.000.000,00', {reverse: true});
	$('#telefone1').mask(maskBehavior, options);
	$('#telefone2').mask(maskBehavior, options);
});
</script>

<form action="" method="POST" id="formContato">
	<div class="modal-header">
		<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
		<span aria-hidden="true">&times;</span></button>
		<h4 class="modal-title"><b>Editar Contato:</b> <?php echo $nome; ?></h4>
	</div>
	<div class="modal-body">
		<div class="row">
			<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
				<label>Nome:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-user"></i></div>
					<input type="text" class="form-control pull-right"  id="nome" name="nome" alt="Nome" value="<?php echo $nome;?>" <?php if($sistema->usuario->permissao_leads == Usuario::PERM_LEITURA){echo "readonly"; } ?> required/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
				<label>Email:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-envelope"></i></div>
					<input type="text" class="form-control pull-right"  id="email" name="email" alt="Email" value="<?php echo $email;?>" <?php if($sistema->usuario->permissao_leads == Usuario::PERM_LEITURA){echo "readonly"; } ?> />
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
				<label>Status:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-check-circle"></i></div>
					<select name="status" id="status" class="form-control pull-right" <?php if($sistema->usuario->permissao_leads == Usuario::PERM_LEITURA){echo "disabled"; } ?>>
						<?php $sistema->layout->select_status($status); ?>
					</select>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-2"><div class="form-group">
				<label>Qualidade:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-thumbs-o-up"></i></div>
					<select name="qualidade" id="qualidade" class="form-control pull-right" <?php if($sistema->usuario->permissao_leads == Usuario::PERM_LEITURA){echo "disabled"; } ?>>
						<?php $sistema->layout->select_qualidade($qualidade); ?>
					</select>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
				<label>Telefone 1:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-phone"></i></div>
					<input type="text" class="form-control pull-right"  id="telefone1" name="telefone1" alt="Telefone 1" value="<?php echo $telefone1;?>" <?php if($sistema->usuario->permissao_leads == Usuario::PERM_LEITURA){echo "readonly"; } ?>/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
				<label>Telefone 2:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-phone"></i></div>
					<input type="text" class="form-control pull-right"  id="telefone2" name="telefone2" alt="Telefone 2" value="<?php echo $telefone2;?>" <?php if($sistema->usuario->permissao_leads == Usuario::PERM_LEITURA){echo "readonly"; } ?>/>
				</div>
			</div></div>
			
			<div class="col-xs-12 col-sm-6 col-md-2"><div class="form-group">
				<label>Valor Fechado:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-dollar"></i></div>
					<input type="text" class="form-control pull-right dinheiro"  id="valorfechado" name="valorfechado" alt="Valor Fechado" value="<?php echo $fechado;?>" <?php if($sistema->usuario->permissao_leads == Usuario::PERM_LEITURA){echo "readonly"; } ?> required/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-2"><div class="form-group">
				<label>Valor Orçado:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-dollar"></i></div>
					<input type="text" class="form-control pull-right dinheiro"  id="valorcombinado" name="valorcombinado" alt="Valor Combinado" value="<?php echo $combinado;?>" <?php if($sistema->usuario->permissao_leads == Usuario::PERM_LEITURA){echo "readonly"; } ?> required/>
				</div>
			</div></div>
		</div>
		<?php if(count($dados_extras) > 0){?>
		<div class="row"><?php 
			$max = count($dados_extras);
			for($i = 0; $i < $max; $i += 2){
				$campo = $dados_extras[$i];
				$valor = $dados_extras[$i+1];
				if($valor == " ") $valor = "Não preenchido";
				$indice = ($i / 2) + 1;?>
			<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
				<label><?php echo $campo; ?>:</label>
				<input type="text" class="form-control"  id="campo<?php echo $indice; ?>" name="campo<?php echo $indice; ?>" value="<?php echo $valor;?>" <?php if($sistema->usuario->permissao_leads == Usuario::PERM_LEITURA){echo "readonly"; } ?> />
			</div></div>
			<?php } ?>
		</div><?php } ?>
		<div class="row">
			<div class="col-xs-12 col-sm-6"><div class="form-group">
				<label>Mensagem:</label>
				<textarea name="mensagem" id="mensagem" class="form-control" rows="5" readonly><?php echo $mensagem; ?></textarea>
			</div></div>
			<div class="col-xs-12 col-sm-6"><div class="form-group">
				<label>Anotações:</label>
				<textarea name="anotacoes" id="anotacoes" class="form-control" rows="5" <?php if($sistema->usuario->permissao_leads == Usuario::PERM_LEITURA){echo "disabled"; } ?>><?php echo $anotacoes; ?></textarea>
			</div></div>
		</div>
		<div class="row">
			<div class="col-xs-12 col-sm-6 col-md-6">
				<div class="form-group">
					<label>Identificador/fonte:</label>
					<div class="input-group">
						<div class="input-group-addon"><i class="fa fa-info-circle"></i></div>
						<input type="text" class="form-control pull-right" id="identificadorfonte" name="identificadorfonte" alt="Telefone 1" value="<?php echo $identificadorfonte; ?>" readonly />
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="modal-footer">
		<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Fechar</button>
		<?php if($sistema->usuario->permissao_leads == Usuario::PERM_ESCRITA){ ?><button type="submit" name="action" class="btn btn-primary">Salvar Contato</button><?php } ?>
	</div>
	<div class="overlay preloader">
		<i class="fa fa-refresh fa-spin"></i>
	</div>
</form>