<?php
/*
 * Este arquivo é responsável por montar a modal que serve para editar o cliente especificado.
 */
 
require_once(__DIR__ . "/../classes/Sistema.php"); 
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso ao drive
if($sistema->usuario->permissao_drive == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

try{
	/* Fazemos aqui a consulta dos dados do usuário especificado */
	$cliente = $sistema->drive->obter_usuario($_POST['id']);

	if($cliente == -1){ // Nenhum dado foi encontrado, ID é inválida
		echo "-2ID inválida!";
		exit;
	}
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>
<script>
$(document).ready(function(){
	$('#formArquivo').submit(function(){
		var dados = jQuery( this ).serialize() + "&id=<?php echo $_POST['id']; ?>";
		jQuery.ajax({
			type: "POST",
			url: "action/salvar_modal_usuario_arquivos",
			data: dados,
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				fechar_modal();
				atualizar_linha(JSON.parse(data));
				toastr.clear(); toastr.success("Dados salvos com sucesso."); return;
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao salvar."); return;
			}
		});
		return false;
	});
});
</script>

<form action="" method="POST" id="formArquivo">
	<div class="modal-header">
		<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
		<span aria-hidden="true">&times;</span></button>
		<h4 class="modal-title"><b>Editar Cliente:</b> <?php echo $cliente['nome']; ?></h4>
	</div>
	<div class="modal-body">
		<div class="row">
			<div class="col-xs-12 col-sm-6 col-md-8"><div class="form-group">
				<label>Nome:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-user"></i></div>
					<input type="text" class="form-control pull-right"  id="nome" name="nome" alt="Nome" value="<?php echo $cliente['nome'];?>" required/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
				<label>Login:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-user"></i></div>
					<input type="text" class="form-control pull-right"  id="login" name="login" alt="Login" maxlength="64" value="<?php echo $cliente['login'];?>" required/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-8"><div class="form-group">
				<label>Link:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-link"></i></div>
					<input type="text" class="form-control pull-right" id="link" name="link" alt="Link" value="<?php echo $cliente['link'];?>" required/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
				<label>Senha:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-lock"></i></div>
					<input type="text" class="form-control pull-right" id="senha" name="senha" alt="Senha" maxlength="64"/>
				</div>
			</div></div>
		</div>
	</div>
	<div class="modal-footer">
		<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Fechar</button>
		<button type="submit" name="action" class="btn btn-primary">Salvar Cliente</button>
	</div>
	<div class="overlay preloader">
		<i class="fa fa-refresh fa-spin"></i>
	</div>
</form>