<?php
/*
 * Este arquivo é responsável por atualizar a página de "Dados Gerais" do sistema.
 * Para isso, ele faz uma pesquisa dos dados gerais do adwords usando a API, retornando
 * ao final um JSON contendo esses dados.
 */

use Win7\Ads\Entity\CustomerFilter;
use Win7\Ads\Repository\CampaignRepository;
use Win7\App;

require_once(__DIR__ . "/../classes/Sistema.php");
require_once(__DIR__ . "/../classes/Sistema_Win7Fone.php");
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às campanhas do google
if ($sistema->usuario->permissao_google == Usuario::PERM_NENHUMA) {
    echo "-2Permissão insuficiente para ver esta página!";
    exit;
}
if ($sistema->usuario->permissao_dados_gerais == Usuario::PERM_NENHUMA) {
    echo "-2Permissão insuficiente para ver esta página!";
    exit;
}

// Validamos aqui se o filtro de pesquisa está correto
if (!Filtro::validar($_POST['data'], $_POST['datainicial'], $_POST['datafinal'])) {
    echo "-2Filtro de pesquisa inválido";
    exit;
}

/* Esvazia-se as datas customizadas caso o filtro não seja personalizado */
if ($_POST['data'] != "CUSTOM_DATE") {
    $_POST['datainicial'] = "";
    $_POST['datafinal']   = "";
}

try {
    /* Obtém a quantidade de formulários preenchidos */
    $sistema->iniciar_bd_leads();
    // Montamos o filtro SQL de data
    $filtro = Filtro::filtrar_data($_POST['data'], "DT_ATUAL", $_POST['datainicial'], $_POST['datafinal']);
    // Retorna a quantidade de dias entre as datas
    $filtrar_data_qtd_dias = Filtro::filtrar_data_qtd_dias($_POST['data'], "DT_ATUAL", $_POST['datainicial'],
        $_POST['datafinal']);

    $id_usuario = $sistema->usuario->id;
    if (empty($filtro)) {
        $sql = "SELECT
			(SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = $id_usuario AND TXT_LEADTIPO = :form AND NU_LIXEIRA = 0) as forms,
			(SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = $id_usuario AND TXT_LEADTIPO = :whatsapp AND NU_LIXEIRA = 0) as whatsapp,
			(SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = $id_usuario AND TXT_LEADTIPO = :linkclique AND NU_LIXEIRA = 0) as linkclique";

        $sql_link_clique_dados = "SELECT TXT_NOME,TXT_LEAD_CLIQUE_IDENTIFICADOR FROM TBL_LEADS WHERE ID_CLIENTE_FK = $id_usuario AND TXT_LEADTIPO = :linkclique AND NU_LIXEIRA = 0";
    } else {
        $sql = "SELECT
			(SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = $id_usuario AND TXT_LEADTIPO = :form AND $filtro AND NU_LIXEIRA = 0) as forms,
			(SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = $id_usuario AND TXT_LEADTIPO = :whatsapp AND $filtro AND NU_LIXEIRA = 0) as whatsapp,
			(SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = $id_usuario AND TXT_LEADTIPO = :linkclique AND $filtro AND NU_LIXEIRA = 0) as linkclique";

        $sql_link_clique_dados = "SELECT TXT_NOME,TXT_LEAD_CLIQUE_IDENTIFICADOR FROM TBL_LEADS WHERE ID_CLIENTE_FK = $id_usuario AND TXT_LEADTIPO = :linkclique AND $filtro AND NU_LIXEIRA = 0";
    }
    $quant_ligacoes   = "0";
    $quant_forms      = "0";
    $quant_whatsapp   = "0";
    $quant_linkclique = "0";
    $linkclique_dados = [];
    $quantidade       = $sistema->bd_leads->executar($sql,
        [":form" => "Formulário", ":whatsapp" => "WhatsApp", ":linkclique" => "Link Clique"], Banco_Dados::FETCH);

    $linkcliquedados = $sistema->bd_leads->executar($sql_link_clique_dados, [":linkclique" => "Link Clique"],
        Banco_Dados::FETCH_ALL);

    foreach ($linkcliquedados as $row) {
        if (count(explode("outro|#|", $row['TXT_LEAD_CLIQUE_IDENTIFICADOR'])) > 1) {
            array_push($linkclique_dados, [
                "nome"               => $row['TXT_NOME'],
                "identificador"      => explode("|#|", $row['TXT_LEAD_CLIQUE_IDENTIFICADOR'])[0],
                "identificadorperso" => explode("|#|", $row['TXT_LEAD_CLIQUE_IDENTIFICADOR'])[1],
            ]);
        } else {
            array_push($linkclique_dados, [
                "nome"               => $row['TXT_NOME'],
                "identificador"      => $row['TXT_LEAD_CLIQUE_IDENTIFICADOR'],
                "identificadorperso" => '',
            ]);
        }
    }

    $listaCliques           = [
        'waze',
        'uber',
        'maps',
        'instagram',
        'facebook',
        'linkedin',
        'novenove',
        'ubereats',
        'ifood',
        'rappi',
        'loggi',
        'outro',
    ];
    $listaCliquesQuantidade = [];

    for ($i = 0; $i < count($listaCliques); $i++) {

        if ($listaCliques[$i] != 'outro') {
            array_push($listaCliquesQuantidade, [
                $listaCliques[$i] => array_count_values(array_column($linkclique_dados,
                    'identificador'))[$listaCliques[$i]],
            ]);
        } else {
            $outros["outro"] = [];
            foreach ([
                         $listaCliques[$i] => array_count_values(array_column($linkclique_dados, 'identificadorperso')),
                     ]["outro"] as $key => $value) {
                if ($key != "") {
                    array_push($outros["outro"], [$key => $value]);
                }
            }
            array_push($listaCliquesQuantidade, $outros);
        }
    }

    if ($sistema->usuario->permissao_leads <= Usuario::PERM_ESCRITA) {
        $quant_forms = $quantidade["forms"];
    }
    if ($sistema->usuario->permissao_whatsapp <= Usuario::PERM_ESCRITA) {
        $quant_whatsapp = $quantidade["whatsapp"];
    }
    if ($sistema->usuario->permissao_linkclique <= Usuario::PERM_ESCRITA) {
        $quant_linkclique = $quantidade["linkclique"];
    }
    if ($sistema->usuario->permissao_linkclique <= Usuario::PERM_ESCRITA) {
        $linkclique_dados = $quantidade["linkclique"] == '0' ? 0 : $listaCliquesQuantidade;
    }

    try {
        if ($sistema->usuario->permissao_3cx <= Usuario::PERM_ESCRITA) {
            $sistema_win7fone = new Sistema_Win7Fone($sistema->usuario->id, $sistema->bd);
            $quant            = $sistema_win7fone->contar_ligacoes($_POST['data'], $_POST['datainicial'],
                $_POST['datafinal'], $sistema->usuario->agrupar_ligacoes,
                $sistema->usuario->mostrar_total_real_ligacoes)[0];
            $quant_ligacoes   = $quant;
        }
    } catch (Exception $e) {
        $quant_ligacoes = 0;
    }

    $total_leads = intval($quant_ligacoes) + intval($quant_forms) + intval($quant_whatsapp);

    if ($sistema->usuario->tem_adwords()) {
        App::initialize();
        $rows = App::getContainer()
            ->get(CampaignRepository::class)
            ->getCustomerMetrics($sistema->get_filtro_ads());

        if (!empty($rows) & count($rows) > 0) {
            $impressoes    = 0;
            $cliques       = 0;
            $conversoes    = 0;
            $invalidos     = 0;
            $ctr           = 0.0;
            $taxaconversao = 0.0;
            $custo         = 0;
            // $cpc           = 0;
            $total_rows    = count($rows);

            foreach ($rows as $row) {
                $metrics       = $row['metrics'];
                $impressoes    += (int)$metrics['impressions'];
                $cliques       += (int)$metrics['clicks'];
                $conversoes    += (int)$metrics['conversions'];
                $invalidos     += (int)$metrics['invalidClicks'];
                // $ctr           += (float)$metrics['ctr'];
                $taxaconversao += (float)$metrics['conversionsFromInteractionsRate'];

                if ($sistema->usuario->consultoria) {
                    $custo += (int)$metrics['costMicros'];
                    // $cpc   += (int)$metrics['averageCpc'];
                }
            }

            $impressoesStr = number_format($impressoes, 0, ',', '.');
            $cliquesStr    = number_format($cliques, 0, ',', '.');
            $conversoes    = number_format($conversoes, 0, ',', '.');
            $taxaconversao = number_format($taxaconversao * 100 / $total_rows, 2, '.', ',') . "%";
            // $ctr           = number_format($ctr * 100 / $total_rows, 2, '.', ',') . "%";
            $ctr          = number_format(($cliques / $impressoes) * 100, 2, '.', ',') . "%";
            $invalidos    = number_format($invalidos, 0, ',', '.');

            $resultado = [
                "impressoes"    => $impressoesStr,
                "cliques"       => $cliquesStr,
                "invalidos"     => $invalidos,
                "taxaconversao" => $taxaconversao,
                "ctr"           => $ctr,
                "datainicial"   => $_POST['datainicial'],
                "datafinal"     => $_POST['datafinal'],
                "medialeads"    => number_format($total_leads / $filtrar_data_qtd_dias, 1),
            ];

            if ($sistema->usuario->permissao_leads <= Usuario::PERM_ESCRITA) {
                $resultado["forms"] = $quant_forms;
            }
            if ($sistema->usuario->permissao_whatsapp <= Usuario::PERM_ESCRITA) {
                $resultado["whatsapp"] = $quant_whatsapp;
            }
            if ($sistema->usuario->permissao_3cx <= Usuario::PERM_ESCRITA) {
                $resultado["ligacoes"] = $quant_ligacoes;
            }
            if ($sistema->usuario->permissao_linkclique <= Usuario::PERM_ESCRITA) {
                $resultado["linkclique"] = $quant_linkclique;
            }
            if ($sistema->usuario->permissao_linkclique <= Usuario::PERM_ESCRITA) {
                $resultado["linkcliquedados"] = $linkclique_dados;
            }

            $resultado["cliqueslead"]    = $total_leads == 0 ? 0 : number_format(floatval($cliques) / floatval($total_leads),
                1);
            $resultado["impressoeslead"] = $total_leads == 0 ? 0 : number_format(floatval($impressoes) / floatval($total_leads),
                1);
            $resultado["totalcontatos"]  = $total_leads;
            $resultado["taxaconversao"]  = number_format(floatval($total_leads) * 100 / floatval($cliques),
                    2) . "%";

            if ($sistema->usuario->consultoria) {
                $custo_original     = $custo;
                $custo              = Sistema_Adwords::formatar_valor($custo, $sistema->usuario->moeda);
                // $cpc                = Sistema_Adwords::formatar_valor($cpc / $total_rows, $sistema->usuario->moeda);
                $resultado["custo"] = $custo;
                $resultado["cpc"]   = "R$ ".number_format(round(round($custo_original / 1000000, 2) / $cliques, 2), 2, ',', '.');

                $custo_por_lead         = $total_leads == 0 ? 0 : Sistema_Adwords::calcular_custo_lead($custo_original,
                    $total_leads, $sistema->usuario->moeda);
                $custo_maximo           = floatval($sistema->usuario->limite_custo_lead) / 100;
                $resultado["custolead"] = $custo_por_lead[1];
            }
        } else {
            $resultado = [
                "impressoes"    => 0,
                "cliques"       => 0,
                //"conversoes" => 0,
                "taxaconversao" => 0,
                "ctr"           => 0,
                "invalidos"     => 0,
                // "posicaomedia" => 0,
                "datainicial"   => $_POST['datainicial'],
                "datafinal"     => $_POST['datafinal'],
                "medialeads"    => 0,
            ];

            if ($sistema->usuario->permissao_leads <= Usuario::PERM_ESCRITA) {
                $resultado["forms"] = $quant_forms;
            }
            if ($sistema->usuario->permissao_whatsapp <= Usuario::PERM_ESCRITA) {
                $resultado["whatsapp"] = $quant_whatsapp;
            }
            if ($sistema->usuario->permissao_3cx <= Usuario::PERM_ESCRITA) {
                $resultado["ligacoes"] = $quant_ligacoes;
            }
            if ($sistema->usuario->permissao_linkclique <= Usuario::PERM_ESCRITA) {
                $resultado["linkclique"] = $quant_linkclique;
            }
            if ($sistema->usuario->permissao_linkclique <= Usuario::PERM_ESCRITA) {
                $resultado["linkcliquedados"] = $linkclique_dados;
            }

            $resultado["cliqueslead"]    = 0;
            $resultado["impressoeslead"] = 0;
            $resultado["totalcontatos"]  = $total_leads;

            if ($sistema->usuario->consultoria) {
                $resultado["custo"]     = $sistema->moeda_vazia($sistema->usuario->moeda);
                $resultado["cpc"]       = $sistema->moeda_vazia($sistema->usuario->moeda);
                $resultado["custolead"] = $sistema->moeda_vazia($sistema->usuario->moeda);
            }
        }
    } else { // O cliente não possui adwords configurado, então montamos um JSON com valores padrão
        $resultado = [
            "impressoes"    => 0,
            "cliques"       => 0,
            //"conversoes" => 0,
            "taxaconversao" => 0,
            "ctr"           => 0,
            "invalidos"     => 0,
            // "posicaomedia" => 0,
            "datainicial"   => $_POST['datainicial'],
            "datafinal"     => $_POST['datafinal'],
            "medialeads"    => 0,
        ];

        if ($sistema->usuario->permissao_leads <= Usuario::PERM_ESCRITA) {
            $resultado["forms"] = $quant_forms;
        }
        if ($sistema->usuario->permissao_whatsapp <= Usuario::PERM_ESCRITA) {
            $resultado["whatsapp"] = $quant_whatsapp;
        }
        if ($sistema->usuario->permissao_3cx <= Usuario::PERM_ESCRITA) {
            $resultado["ligacoes"] = $quant_ligacoes;
        }
        if ($sistema->usuario->permissao_linkclique <= Usuario::PERM_ESCRITA) {
            $resultado["linkclique"] = $quant_linkclique;
        }
        if ($sistema->usuario->permissao_linkclique <= Usuario::PERM_ESCRITA) {
            $resultado["linkcliquedados"] = $linkclique_dados;
        }

        $resultado["cliqueslead"]    = 0;
        $resultado["impressoeslead"] = 0;
        $resultado["totalcontatos"]  = $total_leads;

        if ($sistema->usuario->consultoria) {
            $resultado["custo"]     = $sistema->moeda_vazia($sistema->usuario->moeda, $sistema->usuario->moeda);
            $resultado["cpc"]       = $sistema->moeda_vazia($sistema->usuario->moeda, $sistema->usuario->moeda);
            $resultado["custolead"] = $sistema->moeda_vazia($sistema->usuario->moeda);
        }
    }

    echo json_encode_alt($resultado);
} catch (Throwable $e) {
    $sistema->adwords->tratar_excecao($e);
}
