<?php
/*
 * Este arquivo é responsável por atualizar a página de "Indicações" do sistema.
 * Para isso, ele faz uma pesquisa de todas as indicações do período,
 * emitindo um JSON ao final.
 */

require_once(__DIR__ . "/../classes/Sistema.php"); 
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if($sistema->usuario->permissao_indicacoes == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

// Validamos aqui se o filtro de pesquisa está correto
if(!Filtro::validar($_POST['data'], $_POST['datainicial'], $_POST['datafinal'])){
	echo "-2Filtro de pesquisa inválido";
	exit;
}

// Verifica se a ID é um número
if($_POST['id'] != "-1" & !ctype_digit($_POST['id'])){
	echo "-2ID inválida!";
	exit;
}

// Verifica se a ID
if($_POST['id'] != "-1" & intval($_POST['id']) < 1){
	echo "-2ID inválida!";
	exit;
}

try {
	// Faz a pesquisa dos usuários
	$resultado = $sistema->indicacoes->obter_lista_indicacoes($_POST['id'], $_POST['data'], $_POST['datainicial'], $_POST['datafinal']);
	$dados = $resultado[1]; // Obtém o título a ser exibido na página
	$rows = array();
	$rows[] = array();
	$rows[0]['nome'] = $resultado[0];
	
	/* Organiza todos os dados para enviar por json. */
	$total = 0;
	foreach($dados as $row){
		$total += intval($row['TXT_SALDO']); // Adiciona o saldo da indicação no saldo total
		
		if($row['NU_TIPO'] == '0' & !empty($row['NU_CPF_IND'])){ // O cliente foi indicado?
			$tipo = "Indicado";
			$dado = $sistema->indicacoes->obter_usuario_por_cpf($row['NU_CPF_IND']);
			$indicador_por = $dado['TXT_NOME'];
		}
		else if($row['NU_TIPO'] == '1'){ // O cliente é um indicador?
			$tipo = "Indicador";
			if(empty($row['NU_CPF_IND']))
				$indicador_por = "Win7";
			else{
				$dado = $sistema->indicacoes->obter_usuario_por_cpf($row['NU_CPF_IND']);
				$indicador_por = $dado['TXT_NOME'];
			}
		}
		else{
			$tipo = "Indicado";
			$indicador_por = "Win7";
		}
		$nome = $row['TXT_NOME'];
		$cpf_cnpj = Mascara::mascara_cpf_cnpj($row['NU_CPF']);
		
		if($sistema->indicacoes->tipo ==  Sistema_Indicacoes::FACULDADES){
			$pesquisa = $row['TXT_NOME'] . " " . $row['NU_CPF'] . " " . $cpf_cnpj . " " . $row['TXT_UNIDADE'] . " " . $row['TXT_CIDADE'] . " " . $row['TXT_BAIRRO'] . " " . $row['TXT_CURSO']. " " . $row['TXT_EMAIL'] . " " . $row['TEL_CEL'];
			if($row["NU_TIPO"] == "1"){ // É um indicador, não um indicado
				$tipo_captador = $sistema->indicacoes->funcionario_faculdade();
				$tipo_captador = $tipo_captador[intval($row['NU_TIPO_FUNC'])];
				$pesquisa .= " " . $tipo_captador;
			}
		}
		else
			$pesquisa = $row['TXT_NOME'] . " " . $row['NU_CPF'] . " " . $cpf_e . " " . $row['TXT_EMAIL'] . " " . $row['TEL_CEL'];
			$fechamentos = $row['NU_FECHAMENTOS'];
			$possui_indicados = $sistema->indicacoes->possui_indicados($row['NU_CPF']) ? "1" : "0";
			
			$saldo = $sistema->indicacoes->usa_pontos == "1" 
				? number_format(intval($row['TXT_SALDO']),0,',','.') 
				: (
						$sistema->indicacoes->mascara_dinheiro === 'eua'
						? Mascara::converter_para_dolar($row['TXT_SALDO'])
						: Mascara::converter_para_real($row['TXT_SALDO'])
					);

		// Montamos a array com os dados dessa indicação específica
		$rows[] = array(
			'id' => $row['NU_ID'],
			'nome' => $nome,
			'data' => $row['DT_PREENCHIMENTO'],
			'status' => $row['TXT_STATUS'],
			'cpf' => $cpf_cnpj,
			'tipo' => $tipo,
			'indicadopor' => $indicador_por,
			'saldo' => $saldo,
			'sub' => $possui_indicados,
			'pesquisa' => $pesquisa,
			'fechamentos' => $fechamentos,
			'telefone' => $row['TEL_CEL'],
			'email' => $row['TXT_EMAIL']
		);
	}
	
	$rows[0]['quantidade'] = count($rows)-1; // Calculamos a quantidade total de indicações
	$rows[0]['saldo'] = Mascara::converter_para_real($total); // Convertemos o valor do saldo total para reais
	
	echo json_encode_alt($rows);
}
catch (Exception $e) {
	echo "-2Houve um erro com o servidor";
	exit;
}
?>