<?php
/*
 * Este arquivo é responsável por atualizar a página "Win7 Fone" do sistema.
 * Para isso, ele faz uma pesquisa de todas as ligações do período,
 * emitindo um JSON ao final.
 */
 
require_once(__DIR__ . "/../classes/Sistema.php"); 
require_once(__DIR__ . "/../classes/Sistema_Win7Fone.php"); 
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if($sistema->usuario->permissao_3cx == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

// Validamos aqui se o filtro de pesquisa está correto
if(!Filtro::validar($_POST['data'], $_POST['datainicial'], $_POST['datafinal'])){
	echo "-2Filtro de pesquisa inválido";
	exit;
}

/* Esvazia-se as datas customizadas caso o filtro não seja personalizado */
if($_POST['data'] != "CUSTOM_DATE"){
	$_POST['datainicial'] = "";
	$_POST['datafinal'] = "";
}

try{
	$grafico = !empty($_POST['grafico']);
	$sistema_win7fone = new Sistema_Win7Fone($sistema->usuario->id, $sistema->bd);
	$json = $sistema_win7fone->obter_ligacoes($_POST['data'],$_POST['datainicial'], $_POST['datafinal'], $grafico, true, $sistema->usuario->agrupar_ligacoes, $sistema->usuario->mostrar_total_real_ligacoes);
	echo $json;
}
catch(EcxServerException $e){
	echo "-2".$e->getMessage();
	exit;
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>