<?php
/*
 * Este arquivo é responsável por atualizar a página de "Palavras-chave" do sistema.
 * Para isso, ele faz uma pesquisa de todos as palavras-chave do grupo de anúncios configurado, e monta um
 * JSON contendo tal informação.
 */

use Win7\Ads\Repository\CampaignRepository;
use Win7\Ads\Repository\KeywordViewRepository;
use Win7\App;

require_once(__DIR__ . "/../classes/Sistema.php");
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às campanhas do google
if ($sistema->usuario->permissao_google == Usuario::PERM_NENHUMA) {
    echo "-2Permissão insuficiente para ver esta página!";
    exit;
}

// Validamos aqui se o filtro de pesquisa está correto
if (!Filtro::validar($_POST['data'], $_POST['datainicial'], $_POST['datafinal'])) {
    echo "-2Filtro de pesquisa inválido";
    exit;
}

/* Esvazia-se as datas customizadas caso o filtro não seja personalizado */
if ($_POST['data'] != "CUSTOM_DATE") {
    $_POST['datainicial'] = "";
    $_POST['datafinal']   = "";
}

try {
    if ($sistema->usuario->tem_adwords()) { // Verificamos se o cliente possui adwords configurado
        $_SESSION['palavras'] = $_POST['grupo'];

        // Separa o id do grupo do id da campanha
        // $idGrupo_idCampanha[0] -> Id do Grupo
        // $idGrupo_idCampanha[1] -> Id da Campanha
        $idGrupo_idCampanha = explode("|%|", $_POST['grupo']);

        $idGrupo    = isset($idGrupo_idCampanha[0]) && $idGrupo_idCampanha[0] !== 'todos' ?
            $idGrupo_idCampanha[0] : null;
        $idCampanha = $idGrupo_idCampanha[1] ?? null;

        App::initialize();
        $rows = App::getContainer()
            ->get(KeywordViewRepository::class)
            ->getNegativeList($sistema->get_filtro_ads(), $idGrupo);

        // Montamos aqui a array que será enviada por meio de JSON
        $resultado = [];

        foreach ($rows as $row) {
            $keyword   = $row['adGroupCriterion']['keyword']['text'];
            $matchType = $row['adGroupCriterion']['keyword']['matchType'];
            $metrics   = $row['metrics'];
            $campaign  = $row['campaign'];
            $adGroup   = $row['adGroup'];

            // Removemos aqui os "+" das palavras-chave
            $keyword = str_replace("+", "", $keyword);

            if ($keyword == "Content") {
                continue;
            }

            $linha = [
                "negativeKeyword"      => $keyword,
                "matchType"            => ucfirst(strtolower($matchType)),
                "campaign"             => $campaign['name'] . " → " . $adGroup['name'],
                "negativeKeywordNivel" => 'Grupo de anúncio',
            ];

            $resultado[] = $linha;
        }

        $rows = App::getContainer()
            ->get(CampaignRepository::class)
            ->getNegativeKeywordList($sistema->get_filtro_ads(), $idCampanha);

        foreach ($rows as $row) {
            $keyword   = $row['campaignCriterion']['keyword']['text'];
            $matchType = $row['campaignCriterion']['keyword']['matchType'];
            $campaign  = $row['campaign'];

            // Removemos aqui os "+" das palavras-chave
            $keyword = str_replace("+", "", $keyword);

            if ($keyword == "Content") {
                continue;
            }

            $linha = [
                "negativeKeyword"      => $keyword,
                "matchType"            => ucfirst(strtolower($matchType)),
                "campaign"             => $campaign['name'],
                "negativeKeywordNivel" => 'Campanha',
            ];

            $resultado[] = $linha;
        }

        // Adicionamos ao resultado uma flag que indicará se o cliente é de consultoria
        array_unshift($resultado, $sistema->usuario->consultoria);
        echo json_encode_alt($resultado);
    } else { // O adwords do cliente não está configurado, então retornamos um resultado vazio
        echo json_encode_alt([$sistema->usuario->consultoria]);
        exit;
    }
} catch (Exception $e) {
    $sistema->adwords->tratar_excecao($e);
}
?>