<?php
/*
 * Este arquivo é responsável por montar um arquivo excel contendo todos os leads do nosso cliente,
 * considerando um determinado período.
 */

require_once(__DIR__ . "/../classes/Sistema.php");
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true);

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;
use PhpOffice\PhpSpreadsheet\IOFactory;

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if ($sistema->usuario->permissao_leads == Usuario::PERM_NENHUMA) $sistema->redirecionar("../home");

// Validamos aqui se o filtro de pesquisa está correto
if (!Filtro::validar($_POST['data'], $_POST['datainicial'], $_POST['datafinal'])) {
	$_SESSION['erro-baixar-contatos'] = 0;
	$sistema->redirecionar("../baixar-contatos");
}

try {
	$sistema->iniciar_bd_leads();

	$filtro = Filtro::filtrar_data($_POST['data'], "DT_ATUAL", $_POST['datainicial'], $_POST['datafinal']); // Montamos o filtro SQL de data

	$sql = empty($filtro) ?
		"SELECT ID_LEAD, TXT_NOME, TXT_EMAIL, NU_TELEFONE1, TXT_MENSAGEM, DT_ATUAL, TXT_LEADTIPO, TXT_SITUACAO, TXT_DADOS_EXTRAS, TXT_ANOTACOES, TXT_PRECO, TXT_PRECO_FECHADO, TXT_IDENTIFICADOR FROM TBL_LEADS WHERE ID_CLIENTE_FK = :id AND NU_LIXEIRA = '0' ORDER BY DT_ATUAL DESC" :
		"SELECT ID_LEAD, TXT_NOME, TXT_EMAIL, NU_TELEFONE1, TXT_MENSAGEM, DT_ATUAL, TXT_LEADTIPO, TXT_SITUACAO, TXT_DADOS_EXTRAS, TXT_ANOTACOES, TXT_PRECO, TXT_PRECO_FECHADO, TXT_IDENTIFICADOR FROM TBL_LEADS WHERE " . $filtro . " AND ID_CLIENTE_FK = :id AND NU_LIXEIRA = '0' ORDER BY DT_ATUAL DESC";

	// Fazemos aqui a consulta dos contatos
	$dados = $sistema->bd_leads->executar($sql, array(":id" => $sistema->usuario->id), Banco_Dados::FETCH_ALL);

	if ($sistema->bd_leads->quantidade() > 5250) {
		$_SESSION['erro-baixar-contatos'] = 2;
		$sistema->redirecionar("../baixar-contatos");
	}

	// Inicializa o excel
	$arquivo = $sistema->usuario->nome . ' - Contatos Recebidos - ' . trim(Filtro::texto($_POST['data']));

	$spreadsheet = new Spreadsheet();

	$spreadsheet->getProperties()
		->setCreator('Agência Win7')
		->setLastModifiedBy('Agência Win7')
		->setTitle('Relatório de Contatos')
		->setSubject('Relatório de Contatos')
		->setDescription('Relatório de Contatos gerado pelo Sistema Win7')
		->setKeywords('sistemawin7');

	// Configura as colunas fixas do excel
	$sheet = $spreadsheet->setActiveSheetIndex(0);
	$sheet->setCellValue('A1', 'Nome');
	$sheet->getStyle("A1")->getFont()->setBold(true);
	$sheet->getColumnDimension('A')->setWidth("50");

	$indice_letra = 2;
	if (isset($_POST['email'])) {
		$letra = Coordinate::stringFromColumnIndex($indice_letra);
		$indice_letra++;
		$sheet->setCellValue($letra . '1', 'Email');
		$sheet->getStyle($letra . '1')->getFont()->setBold(true);
		$sheet->getColumnDimension($letra)->setWidth("40");
	}
	if (isset($_POST['telefone'])) {
		$letra = Coordinate::stringFromColumnIndex($indice_letra);
		$indice_letra++;
		$sheet->setCellValue($letra . '1', 'Telefone');
		$sheet->getStyle($letra . '1')->getFont()->setBold(true);
		$sheet->getColumnDimension($letra)->setWidth("20");
	}
	if (isset($_POST['datacontato'])) {
		$letra = Coordinate::stringFromColumnIndex($indice_letra);
		$indice_letra++;
		$sheet->setCellValue($letra . '1', 'Data do Contato');
		$sheet->getStyle($letra . '1')->getFont()->setBold(true);
		$sheet->getColumnDimension($letra)->setWidth("20");
	}
	if (isset($_POST['mensagem'])) {
		$letra = Coordinate::stringFromColumnIndex($indice_letra);
		$indice_letra++;
		$sheet->setCellValue($letra . '1', 'Mensagem');
		$sheet->getStyle($letra . '1')->getFont()->setBold(true);
		$sheet->getColumnDimension($letra)->setWidth("50");
	}
	if (isset($_POST['status'])) {
		$letra = Coordinate::stringFromColumnIndex($indice_letra);
		$indice_letra++;
		$sheet->setCellValue($letra . '1', 'Status');
		$sheet->getStyle($letra . '1')->getFont()->setBold(true);
		$sheet->getColumnDimension($letra)->setWidth("20");
	}
	if (isset($_POST['leadtipo'])) {
		$letra = Coordinate::stringFromColumnIndex($indice_letra);
		$indice_letra++;
		$sheet->setCellValue($letra . '1', 'leadtipo');
		$sheet->getStyle($letra . '1')->getFont()->setBold(true);
		$sheet->getColumnDimension($letra)->setWidth("20");
	}
	if (isset($_POST['anotacoes'])) {
		$letra = Coordinate::stringFromColumnIndex($indice_letra);
		$indice_letra++;
		$sheet->setCellValue($letra . '1', 'Anotações');
		$sheet->getStyle($letra . '1')->getFont()->setBold(true);
		$sheet->getColumnDimension($letra)->setWidth("50");
	}
	if (isset($_POST['precoorcado'])) {
		$letra = Coordinate::stringFromColumnIndex($indice_letra);
		$indice_letra++;
		$sheet->setCellValue($letra . '1', 'Preço Orçado');
		$sheet->getStyle($letra . '1')->getFont()->setBold(true);
		$sheet->getColumnDimension($letra)->setWidth("16");
	}
	if (isset($_POST['precofechado'])) {
		$letra = Coordinate::stringFromColumnIndex($indice_letra);
		$indice_letra++;
		$sheet->setCellValue($letra . '1', 'Preço Fechado');
		$sheet->getStyle($letra . '1')->getFont()->setBold(true);
		$sheet->getColumnDimension($letra)->setWidth("16");
	}
	if (isset($_POST['identificador'])) {
		$letra = Coordinate::stringFromColumnIndex($indice_letra);
		$indice_letra++;
		$sheet->setCellValue($letra . '1', 'Identificador');
		$sheet->getStyle($letra . '1')->getFont()->setBold(true);
		$sheet->getColumnDimension($letra)->setWidth("40");
	}

	if (isset($_POST['campos'])) {
		$campos_extras = array();

		foreach ($dados as $row) {
			$campos = $sistema->bd_leads->executar("SELECT * FROM TBL_LEADS_CAMPOS WHERE NU_ID_LEAD = :id", array(
				':id' => $row['ID_LEAD'],
			), Banco_Dados::FETCH_ALL);

			$dados_extras = array();
			foreach ($campos as $campo) {
				$ordem = (intval($campo['NU_ORDEM']) - 1) * 2;
				$dados_extras[$ordem] = $campo['TXT_NOME'];
				$dados_extras[$ordem + 1] = $campo['TXT_CONTEUDO'];
			}

			$max = count($dados_extras);
			for ($i = 0; $i < $max; $i += 2) {
				$campo = $dados_extras[$i];
				if (!in_array($campo, $campos_extras)) {
					$campos_extras[] = $campo;
				}
			}
		}

		$column_index = $indice_letra;

		foreach ($campos_extras as $campo) {
			$letter = Coordinate::stringFromColumnIndex($column_index);
			$next_letter = Coordinate::stringFromColumnIndex($column_index + 1);
			$sheet->setCellValue($letter . '1', $campo);
			$sheet->getStyle($letter . '1')->getFont()->setBold(true);
			$sheet->getColumnDimension($letter)->setWidth("30");
			$column_index++;
		}
	}

	// Adiciona todos os contatos ao excel
	$i = 2;
	foreach ($dados as $row) {
		$data_alteracao = $row['DT_ATUAL'];
		$data_alteracao = strtotime($data_alteracao);
		$data_alteracao = date('d/m/Y H:i:s', $data_alteracao);

		$indice_letra = 2;

		$sheet->setCellValue('A' . $i, $row['TXT_NOME']);
		if (isset($_POST['email'])) {
			$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra) . $i, $row['TXT_EMAIL']);
			$indice_letra++;
		}
		if (isset($_POST['telefone'])) {
			$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra) . $i, $row['NU_TELEFONE1']);
			$indice_letra++;
		}
		if (isset($_POST['datacontato'])) {
			$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra) . $i, $data_alteracao);
			$indice_letra++;
		}
		if (isset($_POST['mensagem'])) {
			$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra) . $i, $row['TXT_MENSAGEM']);
			//$sheet->getStyle(Coordinate::stringFromColumnIndex($indice_letra).$i)->getAlignment()->setWrapText(true);
			$indice_letra++;
		}
		if (isset($_POST['status'])) {
			$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra) . $i, $row['TXT_SITUACAO']);
			$indice_letra++;
		}
		if (isset($_POST['leadtipo'])) {
			$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra) . $i, $row['TXT_LEADTIPO']);
			$indice_letra++;
		}
		if (isset($_POST['anotacoes'])) {
			$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra) . $i, $row['TXT_ANOTACOES']);
			$indice_letra++;
		}
		if (isset($_POST['precoorcado'])) {
			$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra) . $i, number_format(substr_replace($row['TXT_PRECO'], '.', -2, 0), 2, ",", "."));
			$indice_letra++;
		}
		if (isset($_POST['precofechado'])) {
			$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra) . $i, number_format(substr_replace($row['TXT_PRECO_FECHADO'], '.', -2, 0), 2, ",", "."));
			$indice_letra++;
		}
		if (isset($_POST['identificador'])) {
			$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra) . $i, $row['TXT_IDENTIFICADOR']);
			$indice_letra++;
		}
		if (isset($_POST['campos'])) {
			$campos = $sistema->bd_leads->executar("SELECT * FROM TBL_LEADS_CAMPOS WHERE NU_ID_LEAD = :id", array(
				':id' => $row['ID_LEAD'],
			), Banco_Dados::FETCH_ALL);

			$dados_extras = array();
			foreach ($campos as $campo) {
				$ordem = (intval($campo['NU_ORDEM']) - 1) * 2;
				$dados_extras[$ordem] = $campo['TXT_NOME'];
				$dados_extras[$ordem + 1] = $campo['TXT_CONTEUDO'];
			}

			$campos = array();
			$max = count($dados_extras);
			for ($i2 = 0; $i2 < $max; $i2 += 2) {
				$campo = $dados_extras[$i2];
				$valor = $dados_extras[$i2 + 1];
				$campos[$campo] = $valor;
			}

			$campo_index = $indice_letra;
			foreach ($campos_extras as $campo) {
				if (array_key_exists($campo, $campos)) {
					$letter = Coordinate::stringFromColumnIndex($campo_index);
					$sheet->setCellValue($letter . $i, $campos[$campo]);
				} else {
					$letter = Coordinate::stringFromColumnIndex($campo_index);
					$sheet->setCellValue($letter . $i, " ");
				}
				$campo_index++;
			}
		}
		$i++;
	}

	// Configura as colunas para assumirem largura automática
	//foreach(range('A','G') as $columnID) {
	//    $excel->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
	//}

	$sistema->logs->adicionar_log_geracao_relatorio_contato();

	// Cria os headers
	header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	header('Content-Disposition: attachment;filename="' . $arquivo . '.xlsx"');
	header('Cache-Control: max-age=1');
	header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
	header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Cache-Control: cache, must-revalidate');
	header('Pragma: public');

	$spreadsheet->getActiveSheet()->setTitle('Relatório de Contatos');

	// Envia o excel para o usuário
	$writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
	$writer->save('php://output');
	exit;
} catch (Exception $e) {
	$_SESSION['erro-baixar-contatos'] = 1;
	$sistema->redirecionar("../baixar-contatos");
}
