<?php 
/*
 * Este arquivo é responsável por montar um arquivo excel contendo todos as indicações do nosso cliente,
 * considerando um determinado período.
 */
 
require_once(__DIR__ . "/../classes/Sistema.php"); 
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;
use PhpOffice\PhpSpreadsheet\IOFactory;

// Busca e muda os dados de indentificação do cliente
$sistema->indicacoes->mascara_dinheiro !== 'brasil' ? $indentificador = $sistema->indicacoes->text_cpf_cnpj_alternativo : $indentificador = 'CPF/CNPJ';
 
// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if($sistema->usuario->permissao_indicacoes == Usuario::PERM_NENHUMA) $sistema->redirecionar("../home");

// Validamos aqui se o filtro de pesquisa está correto
if(!Filtro::validar($_POST['data'], $_POST['datainicial'], $_POST['datafinal'])){
	$_SESSION['erro-baixar-indicacoes'] = 0;
	$sistema->redirecionar("../baixar-indicacoes");
}

try{
	$dados = $sistema->indicacoes->obter_lista_indicacoes("-1", $_POST['data'], $_POST['datainicial'], $_POST['datafinal']);

	$total = $sistema->bd->quantidade();

	if($total > 750){
		$_SESSION['erro-baixar-indicacoes'] = 2;
		$sistema->redirecionar("../baixar-indicacoes");
	}

	// Inicializa o excel
	$arquivo = $sistema->usuario->nome . ' - Indicações - '.trim(Filtro::texto($_POST['data']));
	
	$spreadsheet = new Spreadsheet();

	$spreadsheet->getProperties()
	    ->setCreator('Agência Win7')
	    ->setLastModifiedBy('Agência Win7')
	    ->setTitle('Relatório de Indicações')
	    ->setSubject('Relatório de Indicações')
	    ->setDescription('Relatório de Indicações gerado pelo Sistema Win7')
	    ->setKeywords('sistemawin7');

	// Configura as colunas fixas do excel
	$sheet = $spreadsheet->setActiveSheetIndex(0);
	$sheet->setCellValue('A1', 'Nome');
	$sheet->getStyle("A1")->getFont()->setBold(true);
	$sheet->getColumnDimension('A')->setWidth("30");

	$sheet->setCellValue('B1', 'Tipo');
	$sheet->getStyle("B1")->getFont()->setBold(true);
	$sheet->getColumnDimension('B')->setWidth("10");

	$sheet->setCellValue('C1', 'Indicado por');
	$sheet->getStyle("C1")->getFont()->setBold(true);
	$sheet->getColumnDimension('C')->setWidth("30");

	$indice_letra = 3;

	if (isset($_POST['email'])){
		$letra = Coordinate::stringFromColumnIndex($indice_letra);
		$indice_letra++;
		$sheet->setCellValue($letra.'1', 'Email');
		$sheet->getStyle($letra.'1')->getFont()->setBold(true);
		$sheet->getColumnDimension($letra)->setWidth("40");
	}

	if (isset($_POST['telefone'])){
		$letra = Coordinate::stringFromColumnIndex($indice_letra);
		$indice_letra++;
		$sheet->setCellValue($letra.'1', 'Telefone');
		$sheet->getStyle($letra.'1')->getFont()->setBold(true);
		$sheet->getColumnDimension($letra)->setWidth("20");
	}

	if (isset($_POST['dataregistro'])){
		$letra = Coordinate::stringFromColumnIndex($indice_letra);
		$indice_letra++;
		$sheet->setCellValue($letra.'1', 'Data de Registro');
		$sheet->getStyle($letra.'1')->getFont()->setBold(true);
		$sheet->getColumnDimension($letra)->setWidth("20");
	}

	if (isset($_POST['status'])){
		$letra = Coordinate::stringFromColumnIndex($indice_letra);
		$indice_letra++;
		$sheet->setCellValue($letra.'1', 'Status');
		$sheet->getStyle($letra.'1')->getFont()->setBold(true);
		$sheet->getColumnDimension($letra)->setWidth("10");
	}

	if (isset($_POST['qualidade'])){
		$letra = Coordinate::stringFromColumnIndex($indice_letra);
		$indice_letra++;
		$sheet->setCellValue($letra.'1', 'Qualidade');
		$sheet->getStyle($letra.'1')->getFont()->setBold(true);
		$sheet->getColumnDimension($letra)->setWidth("10");
	}

	if (isset($_POST['valorfechado'])){
		$letra = Coordinate::stringFromColumnIndex($indice_letra);
		$indice_letra++;
		$sheet->setCellValue($letra.'1', 'Fechamentos');
		$sheet->getStyle($letra.'1')->getFont()->setBold(true);
		$sheet->getColumnDimension($letra)->setWidth("20");
	}

	if (isset($_POST['saldo'])){
		$letra = Coordinate::stringFromColumnIndex($indice_letra);
		$indice_letra++;
		$sheet->setCellValue($letra.'1', 'Saldo');
		$sheet->getStyle($letra.'1')->getFont()->setBold(true);
		$sheet->getColumnDimension($letra)->setWidth("20");
	}

	if (isset($_POST['cpf'])){
		$letra = Coordinate::stringFromColumnIndex($indice_letra);
		$indice_letra++;
		$sheet->setCellValue($letra.'1', $indentificador);
		$sheet->getStyle($letra.'1')->getFont()->setBold(true);
		$sheet->getColumnDimension($letra)->setWidth("20");
	}

	if($sistema->indicacoes->tipo == Sistema_Indicacoes::FACULDADES) {
		if (isset($_POST['dataprova'])){
			$letra = Coordinate::stringFromColumnIndex($indice_letra);
			$indice_letra++;
			$sheet->setCellValue($letra.'1', 'Data da Prova');
			$sheet->getStyle($letra.'1')->getFont()->setBold(true);
			$sheet->getColumnDimension($letra)->setWidth("20");
		}
		if (isset($_POST['unidade'])){
			$letra = Coordinate::stringFromColumnIndex($indice_letra);
			$indice_letra++;
			$sheet->setCellValue($letra.'1', 'Unidade');
			$sheet->getStyle($letra.'1')->getFont()->setBold(true);
			$sheet->getColumnDimension($letra)->setWidth("20");
		}
		if (isset($_POST['curso'])){
			$letra = Coordinate::stringFromColumnIndex($indice_letra);
			$indice_letra++;
			$sheet->setCellValue($letra.'1', 'Curso');
			$sheet->getStyle($letra.'1')->getFont()->setBold(true);
			$sheet->getColumnDimension($letra)->setWidth("20");
		}
		if (isset($_POST['cidade'])){
			$letra = Coordinate::stringFromColumnIndex($indice_letra);
			$indice_letra++;
			$sheet->setCellValue($letra.'1', 'Cidade');
			$sheet->getStyle($letra.'1')->getFont()->setBold(true);
			$sheet->getColumnDimension($letra)->setWidth("20");
		}
		if (isset($_POST['bairro'])){
			$letra = Coordinate::stringFromColumnIndex($indice_letra);
			$indice_letra++;
			$sheet->setCellValue($letra.'1', 'Bairro');
			$sheet->getStyle($letra.'1')->getFont()->setBold(true);
			$sheet->getColumnDimension($letra)->setWidth("20");
		}
		if (isset($_POST['tipocaptador'])){
			$letra = Coordinate::stringFromColumnIndex($indice_letra);
			$indice_letra++;
			$sheet->setCellValue($letra.'1', 'Tipo de Captador');
			$sheet->getStyle($letra.'1')->getFont()->setBold(true);
			$sheet->getColumnDimension($letra)->setWidth("20");
		}
	}

	$count = 2;
	for ($i=0; $i < $total;$i++){
		$row = $dados[1][$i];

		$data_cadastro = $row['DT_PREENCHIMENTO'];
		$data_cadastro = strtotime($data_cadastro);
		$data_cadastro = date('d/m/Y H:i:s', $data_cadastro);

		$fechado = $row['NU_FECHAMENTOS'];
		$combinado = 'R$ ' . number_format(floatval($row['VALOR_COMBINADO']/100),2,',','.');
		$saldo = $sistema->indicacoes->usa_pontos == "1" ? (number_format(intval($row['TXT_SALDO']),0,',','.'). " pontos") : ('R$ ' . number_format(floatval($row['TXT_SALDO']/100),2,',','.'));
		$cpf = Mascara::mascara_cpf_cnpj($row['NU_CPF']);

		if($row["NU_TIPO"] == "1"){
			$tipo_captador = $sistema->indicacoes->funcionario_faculdade();
			$tipo_captador = $tipo_captador[intval($row['NU_TIPO_FUNC'])];
		}
		else{
			$tipo_captador = "Não é captador";
		}

		if($row['NU_TIPO'] == '0' & !empty($row['NU_CPF_IND'])){ // O cliente foi indicado?
			$tipo = "Indicado";
			$dado = $sistema->indicacoes->obter_usuario_por_cpf($row['NU_CPF_IND']);
			$indicador_por = $dado['TXT_NOME'];
		}
		else if($row['NU_TIPO'] == '1'){ // O cliente é um indicador?
			$tipo = "Indicador";
			if(empty($row['NU_CPF_IND'])){
				$indicador_por = "Win7";
			}
			else{
				$dado = $sistema->indicacoes->obter_usuario_por_cpf($row['NU_CPF_IND']);
				$indicador_por = $dado['TXT_NOME'];
			}
		}

		$indice_letra = 3;

		$sheet->setCellValue('A'.$count, $row['TXT_NOME']);
		$sheet->setCellValue('B'.$count, $tipo);
		$sheet->setCellValue('C'.$count, $indicador_por);
		if (isset($_POST['email'])) {$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra).$count, $row['TXT_EMAIL']); $indice_letra++; }
		if (isset($_POST['telefone'])) {$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra).$count, $row['TEL_CEL']); $indice_letra++; }
		if (isset($_POST['dataregistro'])) {$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra).$count, $data_cadastro); $indice_letra++; }
		if (isset($_POST['status'])) {$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra).$count, $row['TXT_STATUS']); $indice_letra++; }
		if (isset($_POST['valorfechado'])) {$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra).$count, $fechado); $indice_letra++; }
		if (isset($_POST['saldo'])) {$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra).$count, $saldo); $indice_letra++; }
		if (isset($_POST['cpf'])) {$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra).$count, $cpf); $indice_letra++; }

		if($sistema->indicacoes->tipo == Sistema_Indicacoes::FACULDADES) {
			if (isset($_POST['dataprova'])) {$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra).$count, $row['TXT_DATA_PROVA']); $indice_letra++; }
			if (isset($_POST['unidade'])) {$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra).$count, $row['TXT_UNIDADE']); $indice_letra++; }
			if (isset($_POST['curso'])) {$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra).$count, $row['TXT_CURSO']); $indice_letra++; }
			if (isset($_POST['cidade'])) {$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra).$count, $row['TXT_CIDADE']); $indice_letra++; }
			if (isset($_POST['bairro'])) {$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra).$count, $row['TXT_BAIRRO']); $indice_letra++; }
			if (isset($_POST['tipocaptador'])) {$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra).$count, $tipo_captador); $indice_letra++; }
		}

		$count++;
	}

	$sistema->logs->adicionar_log_geracao_relatorio_indicacoes();

	// Cria os headers
	header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	header('Content-Disposition: attachment;filename="'.$arquivo.'.xlsx"');
	header('Cache-Control: max-age=1');
	header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
	header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
	header ('Cache-Control: cache, must-revalidate');
	header ('Pragma: public');

	$spreadsheet->getActiveSheet()->setTitle('Relatório de Indicações');

	// Envia o excel para o usuário
	$writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
	$writer->save('php://output');
	exit;
}
catch(Exception $e){
	$_SESSION['erro-baixar-indicacoes'] = "Houve um erro com o servidor";
	redirecionar("../baixar-indicacoes");
}
?>