<?php 
require_once(__DIR__ . "/../classes/Sistema.php"); 
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;
use PhpOffice\PhpSpreadsheet\IOFactory;

// Redireciona o cliente para a home caso ele não tenha permissão de acesso
if($sistema->usuario->permissao_google == Usuario::PERM_NENHUMA) $sistema->redirecionar("../home");

try{
	$json = json_decode($_SESSION['excel-grupos']);

	$total = count($json);

	if($total > 750){
		$_SESSION['erro-baixar-grupos'] = 2;
		$sistema->redirecionar("../grupos");
	}

	// Inicializa o excel
	$arquivo = $sistema->usuario->nome . ' - Grupos de Anúncios';
	
	$spreadsheet = new Spreadsheet();

	$spreadsheet->getProperties()
	    ->setCreator('Agência Win7')
	    ->setLastModifiedBy('Agência Win7')
	    ->setTitle('Relatório de Grupos de Anúncios')
	    ->setSubject('Relatório de Grupos de Anúncios')
	    ->setDescription('Relatório de Grupos de Anúncios gerado pelo Sistema Win7')
	    ->setKeywords('sistemawin7');

	// Configura as colunas fixas do excel
	$sheet = $spreadsheet->setActiveSheetIndex(0);
	$sheet->setCellValue('A1', 'Nome do Grupo');
	$sheet->getStyle("A1")->getFont()->setBold(true);
	$sheet->getColumnDimension('A')->setWidth("30");

	$sheet->setCellValue('B1', 'Qnt. Anúncios');
	$sheet->getStyle("B1")->getFont()->setBold(true);
	$sheet->getColumnDimension('B')->setWidth("30");

	$sheet->setCellValue('C1', 'Acessos ao Site');
	$sheet->getStyle("C1")->getFont()->setBold(true);
	$sheet->getColumnDimension('C')->setWidth("30");

	// $sheet->setCellValue('D1', 'Contatos Recebidos');
	// $sheet->getStyle("D1")->getFont()->setBold(true);
	// $sheet->getColumnDimension('D')->setWidth("30");

	// $sheet->setCellValue('E1', '% Contatos / Acessos');
	// $sheet->getStyle("E1")->getFont()->setBold(true);
	// $sheet->getColumnDimension('E')->setWidth("30");
	
	$sheet->setCellValue('D1', '% em primeira Posição');
	$sheet->getStyle("D1")->getFont()->setBold(true);
	$sheet->getColumnDimension('D')->setWidth("30");

	$sheet->setCellValue('E1', '% entre os 4 primeiros');
	$sheet->getStyle("E1")->getFont()->setBold(true);
	$sheet->getColumnDimension('E')->setWidth("30");

	$sheet->setCellValue('F1', '% Acessos / Anúncios');
	$sheet->getStyle("F1")->getFont()->setBold(true);
	$sheet->getColumnDimension('F')->setWidth("30");

	// $sheet->setCellValue('G1', 'Posição Média');
	// $sheet->getStyle("G1")->getFont()->setBold(true);
	// $sheet->getColumnDimension('G')->setWidth("30");

	if($json[0] == true){
		$sheet->setCellValue('G1', 'Custo Por Clique');
		$sheet->getStyle("G1")->getFont()->setBold(true);
		$sheet->getColumnDimension('G')->setWidth("30");

		$sheet->setCellValue('H1', 'Custo Total');
		$sheet->getStyle("H1")->getFont()->setBold(true);
		$sheet->getColumnDimension('H')->setWidth("30");
	}

	$count = 2;
	for ($i=1; $i < $total;$i++){
		$row = $json[$i];

		$sheet->setCellValue('A'.$count, $row->adGroup);
		$sheet->setCellValue('B'.$count, $row->impressions);
		$sheet->setCellValue('C'.$count, $row->clicks);
		$sheet->setCellValue('D'.$count, $row->imprAbsTop."%");
		$sheet->setCellValue('E'.$count, $row->imprTop."%");
		$sheet->setCellValue('F'.$count, $row->ctr);
		// $sheet->setCellValue('G'.$count, $row->avgPosition);

		if($json[0] == true) {
			$sheet->setCellValue('G'.$count, $row->avgCPC);
			$sheet->setCellValue('H'.$count, $row->cost);
		}

		$count++;
	}

	$sistema->logs->adicionar_log_geracao_relatorio_grupos();

	// Cria os headers
	header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	header('Content-Disposition: attachment;filename="'.$arquivo.'.xlsx"');
	header('Cache-Control: max-age=1');
	header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
	header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
	header ('Cache-Control: cache, must-revalidate');
	header ('Pragma: public');

	$spreadsheet->getActiveSheet()->setTitle('Relatório de Grupos de Anúncios');

	// Envia o excel para o usuário
	$writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
	$writer->save('php://output');
	exit;
}
catch(Exception $e){
	$_SESSION['erro-baixar-grupos'] = "Houve um erro com o servidor";
	redirecionar("../grupos");
}
?>