<?php
require_once(__DIR__ . "/../classes/Sistema.php"); 
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true);

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;
use PhpOffice\PhpSpreadsheet\IOFactory;

// Busca e muda os dados de indentificação do cliente
$sistema->indicacoes->mascara_dinheiro !== 'brasil' ? $indentificador = 'Identificação' : $indentificador = 'CPF/CNPJ';

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if($sistema->usuario->permissao_indicacoes == Usuario::PERM_NENHUMA) $sistema->redirecionar("../home");

if(empty($_SESSION['excel-indicador'])){
	echo "Ação inválida";
	exit;
}

// Validamos aqui se o filtro de pesquisa está correto
if(!Filtro::validar($_SESSION['excel-indicador']['data'], $_SESSION['excel-indicador']['datainicial'], $_SESSION['excel-indicador']['datafinal'])){
	echo "Filtro de pesquisa inválido";
	exit;
}

if(!ctype_digit($_SESSION['excel-indicador']['id'])){
	echo "ID inválida!";
	exit;
}

try {
	$rows = $sistema->indicacoes->obter_historico($_SESSION['excel-indicador']['id'], $_SESSION['excel-indicador']['data'], $_SESSION['excel-indicador']['datainicial'],$_SESSION['excel-indicador']['datafinal']);

	if ($rows == -1){
		echo "ID inválida!";
		exit;
	}
	
	// Inicializa o excel
	$arquivo = $rows[0].' - Histórico - '.trim(Filtro::texto($_SESSION['excel-indicador']['data']));
	
	$spreadsheet = new Spreadsheet();

	$spreadsheet->getProperties()
	    ->setCreator('Agência Win7')
	    ->setLastModifiedBy('Agência Win7')
	    ->setTitle('Relatório de Indicações')
	    ->setSubject('Relatório de Indicações')
	    ->setDescription('Relatório de Indicações gerado pelo Sistema Win7')
	    ->setKeywords('sistemawin7');

	// Configura as colunas fixas do excel
	$sheet = $spreadsheet->setActiveSheetIndex(0);
	$sheet->setCellValue('A1', 'Nome do Beneficiado');
	$sheet->getStyle("A1")->getFont()->setBold(true);
	$sheet->getColumnDimension('A')->setWidth("30");

	$sheet->setCellValue('B1', 'Nome do Indicado Fechado');
	$sheet->getStyle("B1")->getFont()->setBold(true);
	$sheet->getColumnDimension('B')->setWidth("30");

	$sheet->setCellValue('C1', 'Data da Alteração');
	$sheet->getStyle("C1")->getFont()->setBold(true);
	$sheet->getColumnDimension('C')->setWidth("20");

	$sheet->setCellValue('D1', $indentificador.' do Indicado');
	$sheet->getStyle("D1")->getFont()->setBold(true);
	$sheet->getColumnDimension('D')->setWidth("20");

	$sheet->setCellValue('E1', 'Valor Fechado');
	$sheet->getStyle("E1")->getFont()->setBold(true);
	$sheet->getColumnDimension('E')->setWidth("20");

	$sheet->setCellValue('F1', 'Porcentagem');
	$sheet->getStyle("F1")->getFont()->setBold(true);
	$sheet->getColumnDimension('F')->setWidth("15");

	$sheet->setCellValue('G1', 'Mudança de Saldo');
	$sheet->getStyle("G1")->getFont()->setBold(true);
	$sheet->getColumnDimension('G')->setWidth("20");

	$sheet->setCellValue('H1', 'Motivo');
	$sheet->getStyle("H1")->getFont()->setBold(true);
	$sheet->getColumnDimension('H')->setWidth("20");

	$total = count($rows);
	$count = 2;
	for ($i=1; $i < $total;$i++){
		$registro = $rows[$i];

		$sheet->setCellValue('A'.$count, $registro['nome-beneficiado']);
		$sheet->setCellValue('B'.$count, $registro['nome']);
		$sheet->setCellValue('C'.$count, date('d/m/Y H:i:s', strtotime($registro['data'])));
		$sheet->setCellValue('D'.$count, $registro['cpf']);
		$sheet->setCellValue('E'.$count, $registro['valorfechado']);
		$sheet->setCellValue('F'.$count, $registro['porcentagem']);
		$sheet->setCellValue('G'.$count, $registro['comissao']);
		$sheet->setCellValue('H'.$count, $registro['motivo']);

		$count++;
	}

	$sistema->logs->adicionar_log_geracao_relatorio_ganhos();
	
	// Cria os headers
	header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	header('Content-Disposition: attachment;filename="'.$arquivo.'.xlsx"');
	header('Cache-Control: max-age=1');
	header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
	header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
	header ('Cache-Control: cache, must-revalidate');
	header ('Pragma: public');

	$spreadsheet->getActiveSheet()->setTitle('Relatório de Indicações');

	// Envia o excel para o usuário
	$writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
	$writer->save('php://output');
	exit;
}
catch (Exception $e) {
	echo "Houve um erro com o servidor";
	exit;
}
?>