<?php
require_once(__DIR__ . "/../classes/Sistema.php"); 
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if($sistema->usuario->permissao_indicacoes == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

// Validamos aqui se o filtro de pesquisa está correto
if(!Filtro::validar($_POST['data'], $_POST['datainicial'], $_POST['datafinal'])){
	echo "-2Filtro de pesquisa inválido";
	exit;
}

if(!ctype_digit($_POST['id'])){
	echo "-2ID inválida!";
	exit;
}

try {
	$sistema->indicacoes->obter_usuario($_POST['id']);
	
	if($sistema->bd->quantidade() == 0){ // Os dados não foram encontrados, então a ID é inválida
		echo "-2ID inválida!";
		exit;
	}
	
	$_SESSION['excel-indicador'] = $_POST;
}
catch (Exception $e) {
	echo "-2Houve um erro com o servidor";
	exit;
}
?>