<?php
/*
 * Este arquivo é responsável por fazer o login do cliente.
 */
require_once(__DIR__ . "/../classes/Sistema.php");
set_sistema(Sistema::WIN7);
$sistema = new Sistema();
$sistema->sessao->renovar_sessao(); // Renovamos a sessão por segurança
if($sistema->sessao->logado()) $sistema->redirecionar("../home"); // Caso o cliente já esteja logado, enviamos ele para a home

try{
	// Faz-se aqui a tentativa de login, guardando o resultado da operação
	$usuario = $_POST['usuario'];
	$senha = trim($_POST['senha']);
	$resultado = $sistema->sessao->logar($usuario, $senha);
}
catch(Exception $e){
	$_SESSION['errologin'] = 1;
	$sistema->redirecionar("../");
}

if($resultado != -1){ // Caso o login tenha falhado, redirecionamos o usuário para a tela de login
	$_SESSION['errologin'] = $resultado;
	$sistema->redirecionar("../");
}
else{ // Caso o login tenha ocorrido com sucesso, redirecionamos o usuário para a home
	$sistema->redirecionar("../home");
}
?>