<?php

/*
 * Este arquivo é responsável por salvar os dados de uma indicação, inclusive aplicando as comissões.
 */
ignore_user_abort(true);
set_time_limit(0);
require_once(__DIR__ . "/../classes/Sistema.php");
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de alterar indicações
if($sistema->usuario->permissao_indicacoes != Usuario::PERM_ESCRITA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

// Verifica se o status é válido
if(!in_array($_POST['status'], $sistema->layout->status_cliente)){
	echo "-2Status inválido!";
	exit;
}

try{
	// Obtém os dados do usuário no banco de dados
	$usuario = $sistema->indicacoes->obter_usuario($_POST['id']);

	if($sistema->bd->quantidade() == 0){ // Os dados não foram encontrados, então a ID é inválida
		echo "-2ID inválida!";
		exit;
	}
	
	// Obtém od dados principais preenchidos
	date_default_timezone_set('America/Sao_Paulo');
	$data_alteracao = date('Y-m-d H:i:s', time());
	$anotacoes = $_POST['anotacoes'];
	$status = $_POST['status'];
	$fechamentos = !empty($_POST['fechamentos']) ? json_decode($_POST['fechamentos']) : array();
	$delecoes = !empty($_POST['delecao']) ? json_decode($_POST['delecao']) : array();

	if(!is_array($fechamentos) || !is_array($delecoes)){
		echo "-2Fechamentos Inválidos!";
		exit;
	}

	$alteracoes = "";
	$params = array(
		":anotacoes" => $anotacoes,
		":dataanotacoes" => $data_alteracao,
		":status" => $status,
		":id" => $_POST['id'],
		":id2" => $sistema->usuario->id
	);

	if($sistema->indicacoes->comissao_multipla == "1"){
		if($sistema->indicacoes->produto_editavel($usuario) == true){
			$produto = $sistema->indicacoes->obter_comissao_valida($_POST['produto']);

			if($sistema->bd->quantidade() > 0){
				$alteracoes .= " , ID_COMISSAO = :idcomissao";
				$params[':idcomissao'] = $_POST['produto'];
			}
		}
		if($status == "Fechado"){
			$alteracoes .= " , NU_JA_FECHOU = '1'";
		}
	}

	if($sistema->usuario->super_adm_indicacoes == true){
		if(isset($_POST['nome']) && !empty($_POST['nome'])) { $alteracoes .= " , TXT_NOME = :nome"; $params[':nome'] = $_POST['nome'];}
		if(isset($_POST['email']) && !empty($_POST['email'])) { $alteracoes .= " , TXT_EMAIL = :email"; $params[':email'] = $_POST['email'];}
		if(isset($_POST['telefone']) && !empty($_POST['telefone'])) { $alteracoes .= " , NU_TELEFONE = :telefone"; $params[':telefone'] = $_POST['telefone'];}
	}

	$sql = 'UPDATE TBL_INDICACOES SET TXT_STATUS = :status, TXT_ANOTACOES = :anotacoes, DT_ALTERACAO = :dataanotacoes '.$alteracoes.' WHERE NU_ID = :id AND NU_CLIENTE = :id2';

	/* Salvamos aqui os valores que não dependem de detecção de comissões */
	$sistema->bd->executar($sql, $params);

	/* Avalia todas as comissões devidas e salva os dados de fechamento no banco */
	$atualizacao = $sistema->indicacoes->avaliar_comissoes($_POST['id'], $fechamentos, $delecoes);
	echo json_encode_alt($atualizacao);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>