<?php 
/*
 * Este arquivo cria um novo contato baseado nas informações inseridas.
 */

require_once(__DIR__ . "/../classes/Sistema.php"); 
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if($sistema->usuario->permissao_leads != Usuario::PERM_ESCRITA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

/* Verifica-se se a qualidade especificada está dentro das qualidades possíveis */
if(!in_array($_POST['qualidade'],$sistema->layout->qualidades_cliente)){ 
	echo "-2Dados inválidos!";
	exit;
}

/* Verifica-se se o status especificado está dentro dos status possíveis */
if(!in_array($_POST['status'],$sistema->layout->status_cliente)){
	echo "-2Dados inválidos!";
	exit;
}

if(empty($_POST['nome'])){
	echo "-2Nome inválido!";
	exit;
}

try{
	$sistema->iniciar_bd_leads();

	// Obtém todos os dados que serão salvos no banco de dados
	$nome = $_POST['nome'];
	$telefone1 = $_POST['telefone1'];
	$telefone2 = $_POST['telefone2'];
	$email = $_POST['email'];
	$qualidade = $_POST['qualidade'];
	$status = $_POST['status'];
	$anotacoes = $_POST['anotacoes'];
	$mensagem = $_POST['mensagem'];
	$valor_combinado = preg_replace('/[^0-9]+/','',strip_tags($_POST['valorcombinado']));
	$valor_fechado = preg_replace('/[^0-9]+/','',strip_tags($_POST['valorfechado']));
	$timestamp = time();
	date_default_timezone_set('America/Sao_Paulo');
	$data_alteracao = date('Y-m-d H:i:s', $timestamp);
	$dia = date('Y-m-d');
	$hora = date('H:i');
	$login = $sistema->usuario->login;
	
	// Agora, cria-se o novo contato no banco
	$sql = 'INSERT INTO TBL_LEADS (NU_TELEFONE1, NU_TELEFONE2, TXT_EMAIL, TXT_SITUACAO, TXT_QUALI, TXT_ANOTACOES, TXT_PRECO_FECHADO, TXT_PRECO, DT_ANOTACOES_DATA, ID_CLIENTE_FK, TXT_LEADTIPO, TXT_MENSAGEM, TXT_NOME, DT_DATA_MSG, DT_HORA_MSG, TXT_LEAD_CLIENTE) VALUES (:telefone1, :telefone2, :email, :status, :qualidade, :anotacoes, :fechado, :combinado, :dataanotacoes, :id, :tipo, :mensagem, :nome, :data, :hora, :login)';
	
	$params = array(
		":telefone1" => $telefone1,
		":telefone2" => $telefone2,
		":email" => $email,
		":status" => $status,
		":qualidade" => $qualidade,
		":anotacoes" => $anotacoes,
		":fechado" => $valor_fechado,
		":combinado" => $valor_combinado,
		":dataanotacoes" => $data_alteracao,
		":id" => $sistema->usuario->id,
		":tipo" => "Personalizado",
		":mensagem" => $mensagem,
		":nome" => $nome,
		":data" => $dia,
		":hora" => $hora,
		":login" => $login
	);

	$sistema->bd_leads->executar($sql, $params);

	$ultima_id = $sistema->bd_leads->ultima_id();

	$dados = array(
		'TXT_NOME' => $_POST['nome'],
		'ID_LEAD' => $ultima_id
	);
	$sistema->logs->adicionar_log_novo_contato($dados);

	$linha = $sistema->bd_leads->executar("SELECT * FROM TBL_LEADS WHERE ID_LEAD = :id AND ID_CLIENTE_FK = :id2", array(':id' => $ultima_id, "id2" => $sistema->usuario->id), Banco_Dados::FETCH);

	$resultado = array();
	$resultado[] = array(
		'id' => $linha['ID_LEAD'],
		'nome' => $linha['TXT_NOME'],
		'email' => $linha['TXT_EMAIL'],
		'telefone' => $linha['NU_TELEFONE1'],
		'data' => $linha['DT_ATUAL'],
		'status' => $linha['TXT_SITUACAO'],
		'tipo' => $linha['TXT_LEADTIPO'],
		'identificador' => $linha['TXT_IDENTIFICADOR'] == null ? "" : $linha['TXT_IDENTIFICADOR'],
		'qualidade' => empty($linha['TXT_QUALI']) ? "--" : $linha['TXT_QUALI'],
		'valorfechado' => number_format(floatval($linha['TXT_PRECO_FECHADO']/100),2,',','.'),
		'valororcado' => number_format(floatval($linha['TXT_PRECO']/100),2,',','.')
	);

	echo json_encode_alt($resultado);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>