<?php 
require_once(__DIR__ . "/../classes/Sistema.php"); 
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

if($sistema->usuario->permissao_indicacoes != Usuario::PERM_ESCRITA || $sistema->indicacoes->usa_pontos != "1") {echo "-2Permissão insuficiente para ver esta página!"; exit;}

/* Verifica se o tamanho do arquivo é no máximo 512kb */
if ($_FILES["imagem"]["size"] < 1024 * 512 ) {
    if ($_FILES["imagem"]["error"] > 0 || $_FILES["imagem"]["size"] == 0) {
        echo "-2Por favor, selecione uma imagem válida."; exit;
    }
    else
    {
        $extensao = pathinfo($_FILES["imagem"]["name"])['extension'];
        if($extensao != "png" && $extensao != "jpeg" && $extensao != "jpg"){
            echo "-2Por favor, selecione uma imagem válida."; exit;
        }
        $codigo = Utilitarios::gerar_token(15);
        $nome_arquivo = $codigo.$_FILES["imagem"]["name"];
        $folder_path = __DIR__ . "/../indicador/arquivos/";
        if (!file_exists($folder_path)) {
            mkdir($folder_path);
        }
        move_uploaded_file($_FILES["imagem"]["tmp_name"], $folder_path.$nome_arquivo);
    } 
}
else {
    echo "-2O tamanho máximo da imagem é 512kb."; exit;
}

try{
    $estoque_infinito = $_POST['estoqueinfinito'] == "Sim" ? "1" : "0";
    $resgate_normal = $_POST['resgatenormal'] == "Sim" ? "1" : "0";
    $estoque = $estoque_infinito == "1" ? "0" : $_POST['estoque'];

    $sql = "INSERT INTO TBL_INDICACOES_PRODUTOS (TXT_NOME, NU_ESTOQUE, NU_PONTOS, TXT_DESCRICAO, TXT_IMAGEM, ID_CLIENTE_FK, NU_TROCAS, NU_ESTOQUE_INFINITO, NU_RESGATE_NORMAL) VALUES (:nome, :estoque, :pontos, :descricao, :imagem, :id, :trocas, :estoqueinfinito, :resgatenormal)";
    $params = array(
        ':nome' => $_POST['nome'],
        ':estoque' => $estoque,
        ':estoqueinfinito' => $estoque_infinito,
        ':pontos' => $_POST['pontos'],
        ':descricao' => $_POST['descricao'],
        ':imagem' => $nome_arquivo,
        ':id' => $sistema->usuario->id,
        ':resgatenormal' => $resgate_normal,
        ':trocas' => 0
    );
    $sistema->bd->executar($sql, $params);
    $id = $sistema->bd->ultima_id();

    $dados = array(
        'TXT_NOME' => $_POST['nome'],
        'NU_ID' => $id
    );
    $sistema->logs->adicionar_log_novo_premio($dados);

    $rows = array();
    $rows[] = $sistema->indicacoes->obter_premio($id);

    echo json_encode_alt($rows);
}
catch(Exception $e){
    echo "-2Houve um erro com o servidor";
    exit;
}
?>
