<?php

use Win7\Ads\Repository\CampaignRepository;
use Win7\App;

require_once(__DIR__ . "/../classes/Sistema.php");
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às campanhas do google
if ($sistema->usuario->permissao_google == Usuario::PERM_NENHUMA || $sistema->usuario->permissao_pausar_campanhas == Usuario::PERM_NENHUMA) {
    echo "-2Permissão insuficiente!";
    exit;
}

try {
    if ($sistema->usuario->tem_adwords()) { // Verificamos de o adwords do cliente está configurado
        App::initialize();
        $resultado = App::getContainer()->get(CampaignRepository::class)->pauseCampaign(
            $sistema->get_filtro_ads(),
            $_POST['id']
        );
    } else { // Nesse caso, o cliente não tem adwords configurado, retornamos então um resultado vazio
        echo "-2Permissão insuficiente!";
        exit;
    }
} catch (Exception $e) {
    $sistema->adwords->tratar_excecao($e);
}
?>