<?php 
require_once(__DIR__ . "/../classes/Sistema.php"); 
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

if($sistema->usuario->permissao_indicacoes != Usuario::PERM_ESCRITA || $sistema->indicacoes->usa_pontos != "1") {echo "-2Permissão insuficiente para ver esta página!"; exit;}

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
    echo "-2ID inválida!";
    exit;
}

try{
    $sql = "SELECT * FROM TBL_INDICACOES_PRODUTOS WHERE NU_ID = :id AND ID_CLIENTE_FK = :id2 AND NU_DELETADO = 0";
    $params = array(
        ':id' => $_POST['id'],
        ':id2' => $sistema->usuario->id
    );
    $premio = $sistema->bd->executar($sql, $params, Banco_Dados::FETCH);

    if($sistema->bd->quantidade() == 0){ // Nenhum dado foi encontrado, ID é inválida
        echo "-2ID inválida!";
        exit;
    }

    $imagem = __DIR__ . "/../indicador/arquivos/" . $premio['TXT_IMAGEM'];
    $nome_antigo = $premio['TXT_NOME'];
}
catch(Exception $e){
    echo "-2Houve um erro com o servidor";
    exit;
}

/* Verifica se o tamanho do arquivo é no máximo 512kb */
if ($_FILES["imagem"]["size"] < 1024 * 512 ) {
    if ($_FILES["imagem"]["error"] > 0 || $_FILES["imagem"]["size"] == 0) {
        $nome_arquivo = "";
    }
    else
    {
        $extensao = pathinfo($_FILES["imagem"]["name"])['extension'];
        if($extensao != "png" && $extensao != "jpeg" && $extensao != "jpg"){
            echo "-2Por favor, selecione uma imagem válida."; exit;
        }
        $codigo = Utilitarios::gerar_token(15);
        $nome_arquivo = $codigo.$_FILES["imagem"]["name"];
        $folder_path = __DIR__ . "/../indicador/arquivos/";
        if (!file_exists($folder_path)) {
            mkdir($folder_path);
        }
        move_uploaded_file($_FILES["imagem"]["tmp_name"], $folder_path.$nome_arquivo);
    } 
}
else {
    echo "-2O tamanho máximo da imagem é 512kb."; exit;
}

try{
    $estoque_infinito = $_POST['estoqueinfinito'] == "Sim" ? "1" : "0";
    $resgate_normal = $_POST['resgatenormal'] == "Sim" ? "1" : "0";
    $estoque = $estoque_infinito == "1" ? "0" : $_POST['estoque'];
    if(!empty($nome_arquivo)){
        if (file_exists($imagem)) {
            unlink($imagem);
        }
        $sql = "UPDATE TBL_INDICACOES_PRODUTOS SET TXT_NOME = :nome, NU_ESTOQUE = :estoque, NU_PONTOS = :pontos, TXT_DESCRICAO = :descricao, TXT_IMAGEM = :imagem, NU_ESTOQUE_INFINITO = :estoqueinfinito, NU_RESGATE_NORMAL = :resgatenormal WHERE ID_CLIENTE_FK = :id AND NU_ID = :id2";
        $params = array(
            ':nome' => $_POST['nome'],
            ':estoque' => $estoque,
            ':estoqueinfinito' => $estoque_infinito,
            ':pontos' => $_POST['pontos'],
            ':descricao' => $_POST['descricao'],
            ':imagem' => $nome_arquivo,
            ':resgatenormal' => $resgate_normal,
            ':id' => $sistema->usuario->id,
            ':id2' => $_POST['id']
        );
    }
    else{
        $sql = "UPDATE TBL_INDICACOES_PRODUTOS SET TXT_NOME = :nome, NU_ESTOQUE = :estoque, NU_PONTOS = :pontos, TXT_DESCRICAO = :descricao, NU_ESTOQUE_INFINITO = :estoqueinfinito, NU_RESGATE_NORMAL = :resgatenormal WHERE ID_CLIENTE_FK = :id AND NU_ID = :id2";
        $params = array(
            ':nome' => $_POST['nome'],
            ':estoque' => $estoque,
            ':estoqueinfinito' => $estoque_infinito,
            ':pontos' => $_POST['pontos'],
            ':descricao' => $_POST['descricao'],
            ':resgatenormal' => $resgate_normal,
            ':id' => $sistema->usuario->id,
            ':id2' => $_POST['id']
        );
    }

    $sistema->bd->executar($sql, $params);

    $rows = array();
    $rows[] = $sistema->indicacoes->obter_premio($_POST['id']);

    $sistema->logs->adicionar_log_alteracao_premio($rows[0], $nome_antigo);

    echo json_encode_alt($rows);
}
catch(Exception $e){
    echo "-2Houve um erro com o servidor";
    exit;
}
?>
