<?php
require_once(__DIR__ . "/../classes/Sistema.php"); 
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso ao drive
if($sistema->usuario->permissao_drive == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

try{
	$usuario = $sistema->drive->obter_usuario($_POST['id']);

	if($usuario == -1){
		echo "-2ID Inválida!";
		exit;
	}

	$sistema->drive->deletar_usuario($_POST['id']);

	$dados = array(
		'TXT_NOME' => $usuario['nome'],
		'NU_ID' => $usuario['id']
	);

	$sistema->logs->adicionar_log_delecao_usuario_arquivos($dados);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>