<?php
/*
 * Este arquivo cria o modal que tem como objetivo a criação do registro de um novo
 * cliente na agência.
 */

require_once(__DIR__ . "/../../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

try{
	// Faz a consulta dos seguimentos salvos
	$todosSeguimentos = $sistema->obter_seguimentos();
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}

?>

<form name="formSeguimentos" action="" method="POST" id="formSeguimentos">
	<div class="modal-header">
		<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
			<span aria-hidden="true">&times;</span></button>
		<h4 class="modal-title"><b>Adicionar Seguimento</b></h4>
	</div>
	<div class="modal-body">
		<div class="nav-tabs-custom">
			<div class="tab-content">
				<div class="tab-pane active" id="tab_1">
					<div class="row">
						
						<div class="col-xs-12 col-sm-6 col-md-6">
							<div class="form-group">
								<label>Seguimentos atuais p/ pesquisa:</label>
								<div class="input-group" style="width: 100%;">
									<!-- <div class="input-group-addon"><i class="fa fa-edit"></i></div> -->
									<select name="slqServico" for="slct" class="js-example-basic-multiple">
										<?php 
											foreach ($todosSeguimentos as $seguimento) {
												echo '<option value="'.$seguimento['ID'].'">'.$seguimento['TXT_SEGUIMENTO'].'</option>';
											}
										?>
									</select>
								</div>
							</div>
						</div>

						<div class="col-xs-12 col-sm-6 col-md-6">
							<div class="form-group">
								<label>Novo seguimento:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-user"></i></div>
									<input type="text" class="form-control pull-right" id="seguimento" name="seguimento" alt="Seguimento" required />
								</div>
							</div>
						</div>
						
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="modal-footer">
		<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Fechar</button>
		<button type="submit" name="action" class="btn btn-primary">Adicionar Seguimento</button>
	</div>
	<div class="overlay preloader">
		<i class="fa fa-refresh fa-spin"></i>
	</div>
</form>

<script>
	function salvarDados() {

		if ($('#seguimento').val() == '') {
			toastr.clear();
			toastr.error("Campo Novo Seguimento vazio");
			return false;
		}

		var dados = jQuery('#formSeguimentos').serialize() + "&id=<?php echo $_POST['id']; ?>";
		$(document).ready(function() {
			jQuery.ajax({
				type: "POST",
				url: "action/salvar_modal_adicionar_seguimento",
				data: dados,
				success: function(data) {
					$('.preloader').css({
						display: "none"
					});
					if (data == '-1') {
						window.location.href = "./";
						return;
					}
					if (data.substring(0, 2) == "-2") {
						toastr.clear();
						toastr.error(data.substring(2));
						return;
					}
					fechar_modal();
					adicionar_linhas(JSON.parse(data));
					toastr.clear();
					toastr.success("Seguimento adicionado com sucesso.");
					return;
				},
				beforeSend: function() {
					$('.preloader').css({
						display: "block"
					});
				},
				complete: function() {
					$('.preloader').css({
						display: "none"
					});
				},
				error: function() {
					$('.preloader').css({
						display: "none"
					});
					toastr.clear();
					toastr.error("Houve um erro ao salvar.");
					return;
				}
			});
		});
	}
	$(document).ready(function() {
		$('#formSeguimentos').submit(function() {
			salvarDados();
			return false;
		})
	});
</script>

<script type="text/javascript">
	$(document).ready(function() {
		$('.js-example-basic-multiple').select2({
			placeholder: "Selecione:"
		});
	});
</script>