<?php
/*
 * Este arquivo cria a modal que possibilita a edição dos dados de
 * um cliente da agência.
 */

require_once(__DIR__ . "/../../classes/Sistema.php"); 
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

if(!$sistema->usuario->super_adm_adm) {
	echo "-2Permissão Insuficiente";
	exit;
}

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

try{
	// Faz a consulta dos dados gerais do cliente
	$dados_adm = $sistema->bd->executar("SELECT * FROM TBL_ADM WHERE ID_ADM = :ID", array(":ID" => $_POST['id']), Banco_Dados::FETCH);
	
	if($sistema->bd->quantidade() == 0){
		echo "-2ID inválida!";
		exit;
	}

	$nome = $dados_adm['TXT_NOME'];
	$email = $dados_adm['TXT_EMAIL'];
	$whatsapp = $dados_adm['TXT_WHATSAPP'];
	$data_alteracao = $dados_adm['DT_ULTIMO_LOGIN'];
	if(Utilitarios::data_padrao_valida($data_alteracao)){
		$data_alteracao = strtotime($data_alteracao);
		$data_alteracao = date('d/m/Y H:i:s', $data_alteracao);
	}
	else{
		$data_alteracao = "Nunca";
	}
	$login = $dados_adm['TXT_LOGIN'];
	$superadm = $dados_adm['NU_SUPER_ADM'] == "0" ? "" : "checked='checked'";
	$perm_clientes = $dados_adm['NU_PERM_SISTEMA_CLIENTES'] == "0" ? "" : "checked='checked'";
	$perm_email = $dados_adm['NU_PERM_SISTEMA_EMAIL'] == "0" ? "" : "checked='checked'";
	$perm_indicacoes_adm = $dados_adm['NU_PERM_INDICACOES_GERAL'] == "0" ? "" : "checked='checked'";
	$perm_resultados_gerais = $dados_adm['NU_PERM_RESULTADOS_GERAIS'] == "0" ? "" : "checked='checked'";
	$perm_todos_contatos = $dados_adm['NU_PERM_TODOS_CONTATOS'] == "0" ? "" : "checked='checked'";
	$perm_log = $dados_adm['NU_PERM_LOG_USUARIOS'] == "0" ? "" : "checked='checked'";
	$perm_win7fone = $dados_adm['NU_PERM_WIN7FONE'] == "0" ? "" : "checked='checked'";
	$perm_adwords = $dados_adm['NU_PERM_ADWORDS'] == "0" ? "" : "checked='checked'";
	$perm_contatos = $dados_adm['NU_PERM_CONTATOS'];
	$perm_indicacoes = $dados_adm['NU_PERM_INDICACOES'];
	$perm_arquivos = $dados_adm['NU_PERM_ARQUIVOS'] == "0" ? "" : "checked='checked'";
	$perm_gsuite = $dados_adm['NU_PERM_GSUITE'] == "0" ? "" : "checked='checked'";
	$perm_comparacao = $dados_adm['NU_PERM_COMPARACAO'] == "0" ? "" : "checked='checked'";
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>

<script>
function salvarDados(){
	var dados = jQuery('#formDados').serialize()+"&id=<?php echo $_POST['id'];?>";
	$(document).ready(function(){
		jQuery.ajax({
			type: "POST",
			url: "action/salvar_modal_admin",
			data: dados,
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				fechar_modal();
				atualizar_linhas(JSON.parse(data));
				toastr.clear(); toastr.success("Dados salvos com sucesso."); return;
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao salvar."); return;
			}
		});
	});
}
$(document).ready(function(){
	$('#formDados').submit(function(){
		salvarDados();
		return false;
	})
});
</script>

<form name="formDados" action="" method="POST" id="formDados">
	<div class="modal-header">
		<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
		<span aria-hidden="true">&times;</span></button>
		<h4 class="modal-title"><b>Editar administrador:</b> <?php echo $nome;?></h4>
		<h6><b>Último Acesso:</b> <?php echo $data_alteracao;?></h6>
	</div>
	<div class="modal-body">
		<div class="nav-tabs-custom">
			<ul class="nav nav-tabs">
				<li class="active"><a href="#tab_1" data-toggle="tab">Geral</a></li>
				<li><a href="#tab_2" data-toggle="tab">Permissões</a></li>
			</ul>
			<div class="tab-content">
				<div class="tab-pane active" id="tab_1">
					<div class="row">
						<div class="col-xs-12"><div class="form-group">
							<div class="checkbox">
								<label>
									<input type="checkbox" name="superadm" id="superadm" value="Sim" <?php echo $superadm;?>>
									É Super Administrador&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
								</label>
							</div>
						</div></div>
					</div>
					<div class="row">
						<div class="col-xs-12 col-sm-6"><div class="form-group">
							<label>Nome:</label>
							<div class="input-group">
								<div class="input-group-addon"><i class="fa fa-user"></i></div>
								<input type="text" class="form-control pull-right"  id="nome" name="nome" alt="Nome" value="<?php echo $nome;?>" required/>
							</div>
						</div></div>
						<div class="col-xs-12 col-sm-6"><div class="form-group">
							<label>Email:</label>
							<div class="input-group">
								<div class="input-group-addon"><i class="fa fa-envelope"></i></div>
								<input type="text" class="form-control pull-right"  id="email" name="email" alt="Email" value="<?php echo $email;?>" required/>
							</div>
						</div></div>
						<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
							<label>WhatsApp Business:</label>
							<div class="input-group">
								<div class="input-group-addon"><i class="fa fa-whatsapp"></i></div>
								<input type="text" class="form-control pull-right"  id="whatsapp" name="whatsapp" alt="WhatsApp" value="<?php echo $whatsapp;?>" />
							</div>
						</div></div>
						<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
							<label>Login:</label>
							<div class="input-group">
								<div class="input-group-addon"><i class="fa fa-user"></i></div>
								<input type="text" class="form-control pull-right"  id="login" name="login" alt="Login" value="<?php echo $login;?>" required />
							</div>
						</div></div>
						<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
							<label>Senha:</label>
							<div class="input-group">
								<div class="input-group-addon"><i class="fa fa-lock"></i></div>
								<input type="text" class="form-control pull-right"  id="senha" name="senha" alt="Senha" />
							</div>
						</div></div>
					</div>
				</div>
				<div class="tab-pane" id="tab_2">
					<div class="row">
						<div class="col-xs-12"><div class="form-group">
							<div class="checkbox">
								<label>
									<input type="checkbox" name="permclientes" id="permclientes" value="Sim" <?php echo $perm_clientes;?>>
									Sistema de Clientes&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
								</label>
								<label>
									<input type="checkbox" name="permemail" id="permemail" value="Sim" <?php echo $perm_email;?>>
									Sistema de Envio de E-mail&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
								</label>
								<label>
									<input type="checkbox" name="permindicacoes1" id="permindicacoes1" value="Sim" <?php echo $perm_indicacoes_adm;?>>
									Tela Geral do Sistema de Indicações&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
								</label>
								<label>
									<input type="checkbox" name="permresultados" id="permresultados" value="Sim" <?php echo $perm_resultados_gerais;?>>
									Resultados Gerais&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
								</label>
								<label>
									<input type="checkbox" name="permgsuite" id="permgsuite" value="Sim" <?php echo $perm_gsuite;?>>
									Agendamentos do G Suite&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
								</label>
								<label>
									<input type="checkbox" name="permtodoscontatos" id="permtodoscontatos" value="Sim" <?php echo $perm_todos_contatos;?>>
									Todos os Contatos&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
								</label>
								<label>
									<input type="checkbox" name="permlog" id="permlog" value="Sim" <?php echo $perm_log;?>>
									Log de Usuários&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
								</label>
								<label>
									<input type="checkbox" name="permwin7fone" id="permwin7fone" value="Sim" <?php echo $perm_win7fone;?>>
									Win7 Fone&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
								</label>
								<label>
									<input type="checkbox" name="permadwords" id="permadwords" value="Sim" <?php echo $perm_adwords;?>>
									Adwords&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
								</label>
								<label>
									<input type="checkbox" name="permarquivos" id="permarquivos" value="Sim" <?php echo $perm_arquivos;?>>
									Sistema de Arquivos&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
								</label>
								<label>
									<input type="checkbox" name="comparacao" id="comparacao" value="Sim" <?php echo $perm_comparacao;?>>
									Comparação dos dados gerais&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
								</label>
							</div>
						</div></div>
					</div>
					<div class="row">
						<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
							<label>Contatos:</label>
							<div class="input-group">
								<div class="input-group-addon"><i class="fa fa-users"></i></div>
								<select name="permcontatos" id="permcontatos" class="form-control pull-right">
									<option value="0" <?php if($perm_contatos == "0") { echo " selected";}?>>Permitir Leitura</option>
									<option value="1" <?php if($perm_contatos == "1") { echo " selected"; }?>>Permitir Modificação</option>
									<option value="2" <?php if($perm_contatos == "2") { echo " selected";}?>>Não Permitir</option>
								</select>
							</div>
						</div></div>
						<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
							<label>Indicações:</label>
							<div class="input-group">
								<div class="input-group-addon"><i class="fa fa-smile-o"></i></div>
								<select name="permindicacoes2" id="permindicacoes2" class="form-control pull-right">
									<option value="0" <?php if($perm_indicacoes == "0") { echo " selected";}?>>Permitir Leitura</option>
									<option value="1" <?php if($perm_indicacoes == "1") { echo " selected"; }?>>Permitir Modificação</option>
									<option value="2" <?php if($perm_indicacoes == "2") { echo " selected";}?>>Não Permitir</option>
								</select>
							</div>
						</div></div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="modal-footer">
		<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Fechar</button>
		<button type="submit" name="action" class="btn btn-primary">Salvar Alterações</button>
	</div>
	<div class="overlay preloader">
		<i class="fa fa-refresh fa-spin"></i>
	</div>
</form>

<script>
var maskBehavior = function (val) {
	return val.replace(/\D/g, '').length === 11 ? '(00) 00000-0000' : '(00) 0000-00009';
},
options = {onKeyPress: function(val, e, field, options) {
	field.mask(maskBehavior.apply({}, arguments), options);}
};
$(document).ready(function(){
	$('#whatsapp').mask(maskBehavior, options);
});
</script>