<?php
/*
 * Este arquivo é responsável por montar a modal de
 * confirmação de saque do sistema de indicações.
 */
 
require_once(__DIR__ . "/../../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

if(!$sistema->usuario->super_adm_adm) {
	echo "-2Permissão Insuficiente";
	exit;
}

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

try{
	/* Verificamos se o cliente existe e obtemos seu nome/id */
	$dados = $sistema->bd->executar("SELECT * FROM TBL_ADM WHERE ID_ADM = :id", array(':id' => $_POST['id']), Banco_Dados::FETCH);

	if($sistema->bd->quantidade() == 0){ // Nenhum dado foi encontrado no banco, então a ID é inválida
		echo "-2ID inválida!";
		exit;
	}
	
	$nome = $dados['TXT_NOME'];
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>
<div class="modal-header">
	<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
	<span aria-hidden="true">&times;</span></button>
	<h4 class="modal-title"><b>Confirmação</b></h4>
</div>

<div class="modal-body">
	Tem certeza de que deseja deletar o(a) administrador(a) <b><?php echo $nome;?></b>? <br><br> <span class="text-red">Esta ação <b>NÃO PODE SER DESFEITA</b>.</span>
</div>
<div class="modal-footer">
	<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Não</button>
	<a class="btn btn-primary" href="javascript:void(0);" onclick="salvar_deletar_administrador();">Sim</a>
</div>
<div class="overlay preloader">
	<i class="fa fa-refresh fa-spin"></i>
</div>

<script>
function salvar_deletar_administrador(){
	var dados = "id=<?php echo $_POST['id']; ?>";
	jQuery.ajax({
		type: "POST",
		url: "action/salvar_modal_admin_deletar",
		data: dados,
		success: function(data){
			$('.preloader').css({display:"none"});
			if(data == '-1') {window.location.href = "./"; return;}
			if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
			fechar_modal_confirmacao();
			remover_administrador(<?php echo $_POST['id']; ?>);
			toastr.clear(); toastr.success("Administrador deletado com sucesso."); return;
		},
		beforeSend: function(){
			$('.preloader').css({display:"block"});
		},
		complete: function(){
			$('.preloader').css({display:"none"});
		},
		error: function(){
			$('.preloader').css({display:"none"});
			toastr.clear(); toastr.error("Houve um erro ao deletar administrador."); return;
		}
	});
}
</script>