<?php
/*
 * Este arquivo cria a modal que possibilita a edição dos dados de
 * um cliente da agência.
 */

require_once(__DIR__ . "/../../classes/Sistema.php"); 
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

try{
	// Faz a consulta dos dados gerais do cliente
	$dados_cliente = $sistema->obter_cliente($_POST['id']);
	
	if($sistema->bd->quantidade() == 0){
		echo "-2ID inválida!";
		exit;
	}

	$id_crypto = Sistema::criptografar($_POST['id']);

	// Obtém os principais dados do cliente
	$nome_inicial = $dados_cliente['TXT_NOME'];
	$cliente_ativo = $dados_cliente['NU_CLIENTE_ATIVO'] == "0" ? "" : "checked='checked'";
	$cliente_importante = $dados_cliente['NU_CLIENTE_IMPORTANTE'] == "0" ? "" : "checked='checked'";

}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>

<script>
function salvarDados(){

	var dados = jQuery('#formDados').serialize()+"&id=<?php echo $_POST['id'];?>";
	$(document).ready(function(){
		jQuery.ajax({
			type: "POST",
			url: "action/salvar_modal_cliente_dados_bi",
			data: dados,
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				fechar_modal();
				atualizar_linhas(JSON.parse(data));
				toastr.clear(); toastr.success("Dados salvos com sucesso."); return;
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao salvar."); return;
			}
		});
	});
}

$(document).ready(function(){
	$('#formDados').submit(function(){
		salvarDados();
		return false;
	})
});

</script>


<form name="formDados" action="" method="POST" id="formDados">
	<div class="modal-header">
		<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
		<span aria-hidden="true">&times;</span></button>
		<h4 class="modal-title"><b>Editar cliente:</b> <?php echo $dados_cliente['TXT_NOME'];?></h4>
	</div>
	<div class="modal-body">
		<div class="row">
			<div class="col-xs-12"><div class="form-group">
				<div class="checkbox">
					<label>
						<input type="checkbox" name="clienteativo" id="clienteativo" value="Sim" <?php echo $cliente_ativo;?>>
						Ativo&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
					</label>
					<label>
						<input type="checkbox" name="clienteimportante" id="clienteimportante" value="Sim" <?php echo $cliente_importante;?>>
						Importante&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
					</label>
				</div>
			</div></div>
		</div>
	</div>
	<div class="modal-footer">
		<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Fechar</button>
		<button type="submit" name="action" class="btn btn-primary">Salvar Alterações</button>
	</div>
	<div class="overlay preloader">
		<i class="fa fa-refresh fa-spin"></i>
	</div>
</form>
