<?php
/*
 * Este arquivo cria o modal que permite a edição das configurações do
 * sistema de indicações de um cliente da agência
 */
 
require_once(__DIR__ . "/../../classes/Sistema.php"); 
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

try{
	// Procura no banco os dados extras sobre o cliente
	$dados = $sistema->bd->executar("SELECT * FROM TBL_CLI_GDRIVE WHERE ID_FK = :id", array(':id' => $_POST['id']), Banco_Dados::FETCH);

	// Se o sistema de indicações já foi criado, então carrega os dados existentes
	if($sistema->bd->quantidade() > 0){
		$ativado = $dados['NU_ATIVADO'] == 0 ? "" : "checked='checked'";
		$dominio = $dados['TXT_HOST'];
		$sessao = $dados['TXT_SESSION'];
		$nome = $dados['TXT_NOME'];
		$email = $dados['TXT_EMAIL'];
		$favicon = $dados['TXT_FAVICON'];
		$logo = $dados['TXT_LOGO'];
		$contato = $dados['TXT_CONTATO'];
		$telefone = $dados['TXT_TELEFONE'];
		$cor1 = $dados['TXT_COR1'];
		$cor2 = $dados['TXT_COR2'];
		$cor3 = $dados['TXT_COR3'];
		$cor4 = $dados['TXT_COR4'];
		$cor5 = $dados['TXT_COR5'];
		$nome_sistema = $dados['TXT_NOME_SISTEMA'];
	}
	else{
		$nome_inicial = $sistema->obter_cliente($_POST['id']);
		$nome_inicial = $nome_inicial["TXT_NOME"];
		$ativado = "";
		$dominio = "";
		$sessao = "";
		$nome = $nome_inicial;
		$email = "";
		$favicon = "http://win7.com.br/favicon.png";
		$logo = "http://win7.com.br/logo.png";
		$contato = "";
		$telefone = "";
		$cor1 = "#9e9d24";
		$cor2 = "#000000";
		$cor3 = "#000000";
		$cor4 = "#ffffff";
		$cor5 = "#ffffff";
		$nome_sistema = "Sistema de Arquivos";
	}
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>
<script>
function salvarSistema(){
	var dados = jQuery('#formSistema').serialize()+"&id=<?php echo $_POST['id'];?>";
	$(document).ready(function(){
		jQuery.ajax({
			type: "POST",
			url: "action/salvar_modal_cliente_gdrive",
			data: dados,
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				fechar_modal();
				toastr.clear(); toastr.success("Dados salvos com sucesso."); return;
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao salvar."); return;
			}
		});
	});
}
$(document).ready(function(){
	$('#formSistema').submit(function(){
		salvarSistema();
		return false;
	})
});
</script>

<form action="" method="POST" id="formSistema">
	<div class="modal-header">
		<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
		<span aria-hidden="true">&times;</span></button>
		<h4 class="modal-title"><b>Sistema de Arquivos:</b> <?php echo $nome; ?></h4>
	</div>
	<div class="modal-body">
		<div class="row">
			<div class="col-xs-12"><div class="form-group">
				<div class="checkbox">
					<label>
						<input type="checkbox" name="ativado" id="ativado" value="Sim" <?php echo $ativado;?> >
						Ativar o sistema&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
					</label>
				</div>
			</div></div>
		</div>
		<div class="row">
			<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
				<label>Dominio:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-bookmark"></i></div>
					<input type="text" class="form-control pull-right"  id="dominio" name="dominio" alt="Domínio" value="<?php echo $dominio;?>" required/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
				<label>Sessão:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-lock"></i></div>
					<input type="text" class="form-control pull-right"  id="sessao" name="sessao" alt="Sessão" value="<?php echo $sessao;?>" required/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
				<label>Nome de Exibição:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-user"></i></div>
					<input type="text" class="form-control pull-right"  id="nome" name="nome" alt="Nome" value="<?php echo $nome;?>" required/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
				<label>Nome do Sistema:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-user"></i></div>
					<input type="text" class="form-control pull-right"  id="nome-sistema" name="nome-sistema" alt="Nome do Sistema" value="<?php echo $nome_sistema;?>" required/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
				<label>Telefone:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-phone"></i></div>
					<input type="text" class="form-control pull-right"  id="telefone" name="telefone" alt="Telefone" value="<?php echo $telefone;?>" required/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
				<label>Cor 1 (Botões, etc):</label>
				<div class="input-group">
					<div class="input-group-addon cor1dado caixacor"></div>
					<input type="text" class="form-control pull-right mudarcor"  id="cor1" name="cor1" alt="Cor 1" value="<?php echo $cor1;?>" required/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
				<label>Cor 2 (Cabeçalho):</label>
				<div class="input-group">
					<div class="input-group-addon cor2dado caixacor"></div>
					<input type="text" class="form-control pull-right mudarcor"  id="cor2" name="cor2" alt="Cor 2" value="<?php echo $cor2;?>" required/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
				<label>Cor 3 (Rodapé):</label>
				<div class="input-group">
					<div class="input-group-addon cor3dado caixacor"></div>
					<input type="text" class="form-control pull-right mudarcor"  id="cor3" name="cor3" alt="Cor 3" value="<?php echo $cor3;?>" required/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
				<label>Cor 4 (Texto Cab.):</label>
				<div class="input-group">
					<div class="input-group-addon cor4dado caixacor"></div>
					<input type="text" class="form-control pull-right mudarcor"  id="cor4" name="cor4" alt="Cor 4" value="<?php echo $cor4;?>" required/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
				<label>Cor 5 (Texto Rod.):</label>
				<div class="input-group">
					<div class="input-group-addon cor5dado caixacor"></div>
					<input type="text" class="form-control pull-right mudarcor"  id="cor5" name="cor5" alt="Cor 5" value="<?php echo $cor5;?>" required/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-6"><div class="form-group">
				<label>Email de avisos:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-envelope"></i></div>
					<input type="text" class="form-control pull-right"  id="email" name="email" alt="Email" value="<?php echo $email;?>" required/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
				<label>Favicon (PNG 32x32):</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-star"></i></div>
					<input type="text" class="form-control pull-right"  id="favicon" name="favicon" alt="Favicon" value="<?php echo $favicon;?>" required/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
				<label>Logo (210x84):</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-trademark"></i></div>
					<input type="text" class="form-control pull-right"  id="logo" name="logo" alt="Logo" value="<?php echo $logo;?>" required/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
				<label>Outro Contato:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-user"></i></div>
					<input type="text" class="form-control pull-right"  id="contato" name="contato" alt="Contato" value="<?php echo $contato;?>" />
				</div>
			</div></div>
		</div>
	</div>
	<div class="modal-footer">
		<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Fechar</button>
		<button type="submit" name="action" class="btn btn-primary">Salvar Sistema</button>
	</div>
	<div class="overlay preloader">
		<i class="fa fa-refresh fa-spin"></i>
	</div>
</form>

<script>
function atualizar_cor(elem){
	var value = elem.val();
	var id = elem.attr('id');
	var isOk  = /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(value);
	if(isOk){
		$("."+id+"dado").css("background-color",value);
		elem.addClass("valid");
		elem.removeClass("invalid");
	}
	else{
		$("."+id+"dado").css("background-color","white");
		elem.addClass("invalid");
		elem.removeClass("valid");
	}
}
$(".mudarcor").on('input', function() {
	atualizar_cor($(this));
});
$(document).ready(function(){
	atualizar_cor($('#cor1'));
	atualizar_cor($('#cor2'));
	atualizar_cor($('#cor3'));
	atualizar_cor($('#cor4'));
	atualizar_cor($('#cor5'));
});
</script>