<?php
/*
 * Este arquivo cria o modal que permite a edição das configurações do
 * sistema de indicações de um cliente da agência
 */

require_once(__DIR__ . "/../../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso
if ($sistema->usuario->permissao_indicacoes_geral == Usuario::PERM_NENHUMA) {
	echo "-2Permissão insuficiente para ver esta página!";
	exit;
}

if (!ctype_digit($_POST['id'])) { // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

try {
	// Procura no banco os dados extras sobre o cliente
	$dados = $sistema->bd->executar("SELECT * FROM TBL_CLI_DADOS WHERE ID_FK = :id", array(':id' => $_POST['id']), Banco_Dados::FETCH);

	// Se o sistema de indicações já foi criado, então carrega os dados existentes
	if ($sistema->bd->quantidade() > 0) {
		$ativado = $dados['NU_ATIVADO'] == 0 ? "" : "checked='checked'";
		$dominio = $dados['TXT_HOST'];
		$sessao = $dados['TXT_SESSION'];
		$cor1 = $dados['TXT_COR1'];
		$cor2 = $dados['TXT_COR2'];
		$cor3 = $dados['TXT_COR3'];
		$cor4 = $dados['TXT_COR4'];
		$cor5 = $dados['TXT_COR5'];
		$nome = $dados['TXT_NOME'];
		$comissao_fidelidade = $dados['NU_COMISSAO_FIDELIDADE'];
		$comissao_cadastro = $dados['NU_COMISSAO_CADASTRO'];
		$coeficiente_ajuste = $dados['TXT_AJUSTE'];
		$email = $dados['TXT_EMAIL'];
		$favicon = $dados['TXT_FAVICON'];
		$simbolo_dinheiro = $dados['TXT_DINHEIRO_SIMBOLO'];
		$mascara_dinheiro = $dados['TXT_DINHEIRO_MASCARA'];
		$text_cpfcnpj_alternativo = $dados['TXT_CPFCNPJ_ALTERNATIVO'];
		$link_site_menu = $dados['TXT_LINK_SITE_MENU'];
		$link_site_menu_label = $dados['TXT_LABEL_SITE_MENU'];
		$logo = $dados['TXT_LOGO'];
		$contato = $dados['TXT_CONTATO'];
		$telefone = $dados['TXT_TELEFONE'];
		$bonus = $dados['TXT_BONUS'];
		$img_social = $dados['TXT_IMAGEM_SOCIAL'];
		$numero_whatsapp_contato_rodape = $dados['NU_WHATSAPP_RODAPE'];
		$administrador = $dados['NU_SUPERADM'] == 0 ? "" : "checked='checked'";
		$tipo_sistema = $dados['TXT_TIPO_SISTEMA_INDICACAO'];
		$vocab = $dados['TXT_VOCAB'];
		$adicionar_contato = $dados['NU_ADICIONAR_CONTATO'] == 0 ? "" : "checked='checked'";
		$comissao_fixa = $dados['NU_COMISSAO_FIXA'] == 0 ? "" : "checked='checked'";
		$ativar_termos = $dados['NU_ATIVAR_TERMOS'] == 0 ? "" : "checked='checked'";
		$downlines = $dados['NU_DOWNLINES'] == 0 ? "" : "checked='checked'";
		$upline = $dados['NU_UPLINE'] == 0 ? "" : "checked='checked'";
		$link_termos = $dados['TXT_LINK_TERMOS'];
		$comissao_agencia = $dados['NU_COMISSAO_AGENCIA'];
		$proibir_cpf = $dados['NU_PROIBIR_CPF'] == 0 ? "" : "checked='checked'";
		$distribuir_comissao = $dados['NU_DISTRIBUIR_COMISSOES'] == 0 ? "" : "checked='checked'";
		$permitir_cnpj1 = $dados['NU_PERM_CNPJ_INDICADO'] == 0 ? "" : "checked='checked'";
		$permitir_cnpj2 = $dados['NU_PERM_CNPJ_INDICADOR'] == 0 ? "" : "checked='checked'";
		$permitir_transferencia = $dados['NU_PERM_TRANSFERENCIAS'] == 0 ? "" : "checked='checked'";
		$ativar_inscricoes = $dados['NU_PERMITIR_INSCRICOES'] == 0 ? "" : "checked='checked'";
		$flag_pontos = $dados['NU_FLAG_PONTOS'] == 0 ? "" : "checked='checked'";
		$comissao_multipla = $dados['NU_COMISSAO_MULTIPLA'] == 0 ? "" : "checked='checked'";
		$possui_comissao_multipla = $dados['NU_COMISSAO_MULTIPLA'] == 1;
		$ativar_recorrencia = $dados['NU_PERM_RECORRENCIA'] == 0 ? "" : "checked='checked'";
		$ativar_fidelidade = $dados['NU_PERM_FIDELIDADE'] == 0 ? "" : "checked='checked'";
		$cadastro_indicado = $dados['NU_PERM_CADASTRO_INDICADO'] == 0 ? "" : "checked='checked'";

		// Carrega os dados de vocabulário
		$dados = $sistema->bd->executar("SELECT * FROM TBL_INDICACOES_VOCAB WHERE ID_CLIENTE = :id ", array(':id' => $_POST['id']), Banco_Dados::FETCH_ALL);
		$vocab = array();
		foreach ($dados as $row) {
			$vocab[intval($row['NU_ORDEM'])] = $row['TXT_CONTEUDO'];
		}
	} else {
		$nome_inicial = $sistema->obter_cliente($_POST['id']);
		$nome_inicial = $nome_inicial["TXT_NOME"];
		$comissao_agencia = "0.10";
		$ativado = "checked='checked'";
		$dominio = "";
		$sessao = "";
		$img_social = "https://subdominio.win7.com.br/logo-social/logoSocial.png";
		$comissao_fidelidade = "0.00";
		$comissao_cadastro = "0.00";
		$cor1 = "#9e9d24";
		$cor2 = "#000000";
		$cor3 = "#000000";
		$cor4 = "#ffffff";
		$cor5 = "#ffffff";
		$nome = $nome_inicial;
		$coeficiente_ajuste = "0.1";
		$email = "";
		$favicon = "https://subdominio.win7.com.br/icon/favicon.png";
		$link_site_menu = "";
		$simbolo_dinheiro = "";
		$mascara_dinheiro = "";
		$text_cpfcnpj_alternativo = "";
		$link_site_menu_label = "ACESSE NOSSA LOJA E GANHE MAIS PONTOS!";
		$logo = "https://subdominio.win7.com.br/logo/logo.png";
		$contato = "";
		$telefone = $telefone_inicial;
		$bonus = "0.10";
		$administrador = "checked='checked'";
		$tipo_sistema = 0;
		$adicionar_contato = "";
		$cadastro_indicado = "";
		$link_termos = "";
		$proibir_cpf = "";
		$distribuir_comissao = "";
		$comissao_fixa = "";
		$downlines = "checked='checked'";
		$upline = "checked='checked'";
		$permitir_cnpj1 = "checked='checked'";
		$permitir_cnpj2 = "checked='checked'";
		$permitir_transferencia = "checked='checked'";
		$ativar_inscricoes = "checked='checked'";
		$ativar_recorrencia = "";
		$ativar_fidelidade = "";
		$comissao_multipla = "";
		$possui_comissao_multipla = false;
		$flag_pontos = "";
		$vocab = array();
		$vocab[0] = 'Link para novo indicado';
		$vocab[1] = 'Adicionar manualmente';
		$vocab[2] = '<h5>Promoção #NOME-CLIENTE#</h5><p>Indique clientes e receba comissões para cada pessoa que fechar negócio conosco!</p>';
		$vocab[3] = '<h5>Dúvidas?</h5><ul><li>Tel: #TELEFONE#</li><li><a href="http://#SITE#">#SITE#</a></li></ul>';
		$vocab[4] = 'Indicados que fecharam negócio:';
		$vocab[5] = 'Saldo disponível em dinheiro:';
		$vocab[6] = 'Envie o link a seguir às pessoas que você quer indicar. Desta forma, elas poderão preencher um formulário e serão validadas como suas indicações.';
		$vocab[7] = 'Envie o link a seguir às pessoas que você deseja indicar para que virem indicadores também.';
		$vocab[8] = '<p>Para adicionar um indicado à sua lista, preencha os dados requeridos abaixo. Entraremos em contato com a pessoa por email assim que possível.</p>';
		$vocab[9] = '<p style="color: #000;">Sua conta foi registrada com sucesso!</p><p style="color: #000;"> Clique no link a seguir para ativá-la, e então poderá acompanhar todos seus indicados de perto!</p><p style="color: #000;"></p><a style="color: white;font-size: 16px;background-color: green;padding: 10px 24px 10px 24px;box-sizing: border-box;text-decoration: none;display: inline-block;border-radius: 46px;box-shadow: 0px 6px 10px 3px #d4d4d4;" href="#LINK#">Ativar sua conta</a>';
		$vocab[10] = '<p style="color: #000;">Informamos que foi feito um novo cadastro de indicado para sua conta:</p><p style="color: #000;">Nome: #NOME-INDICADO#<br>E-mail: #EMAIL-INDICADO#<br>Telefone: #TELEFONE-INDICADO#</p><p style="color: #000;">Para acompanhar o processo de fechamento do negócio com seu novo indicado logue na sua conta.</p> <a style="color: white;font-size: 16px;background-color: green;padding: 10px 24px 10px 24px;box-sizing: border-box;text-decoration: none;display: inline-block;border-radius: 46px;box-shadow: 0px 6px 10px 3px #d4d4d4;" href="http://#DOMINIO#/">Clique aqui para acessar sua conta!</a>';
		$vocab[11] = '<p style="color: #000;">Olá #NOME-INDICADO#,</p><p style="color: #000;"> Agradecemos pelo seu interesse, em breve uma pessoa de nossa equipe entrará em contato.</p>';
		$vocab[12] = '<p style="color: #000;">Olá, #NOME-INDICADOR# !</p><p style="color: #000;">Informamos que o seu indicado(a), #NOME-INDICADO#, teve o valor fechado mudado e, portanto, o seu bônus mudou de #BONUS-ANTIGO# para #BONUS-NOVO#.</p><p style="color: #000;"> Para mais informações, logue na sua conta:</p> <a href="http://#DOMINIO#/" style="color: white;font-size: 16px;background-color: green;padding: 10px 24px 10px 24px;box-sizing: border-box;text-decoration: none;display: inline-block;border-radius: 46px;box-shadow: 0px 6px 10px 3px #d4d4d4;">Clique aqui para acessar sua conta</a><br><p style="color: #000;">Lamentamos quaisquer inconvenientes.</p>';
		$vocab[13] = '<p style="color: #000;">Olá, #NOME-INDICADOR# !</p><p style="color: #000;">Informamos que o seu indicado(a), #NOME-INDICADO#, teve seu negócio cancelado. Por esse motivo, removemos o bônus de #BONUS-ANTIGO# que o(a) senhor(a) havia recebido. </p><p style="color: #000;">Para mais informações, logue na sua conta:</p> <a href="http://#DOMINIO#/" style="color: white;font-size: 16px;background-color: green;padding: 10px 24px 10px 24px;box-sizing: border-box;text-decoration: none;display: inline-block;border-radius: 46px;box-shadow: 0px 6px 10px 3px #d4d4d4;">Clique aqui para acessar sua conta</a><br><p style="color: #000;">Lamentamos quaisquer inconvenientes.</p>';
		$vocab[14] = '<p style="color: #000;">Olá, #NOME-INDICADOR# !</p><p style="color: #000;">Informamos que o seu indicado(a), #NOME-INDICADO#, fechou negócio conosco. Por esse motivo, você acaba de ganhar um bônus de #BONUS-GANHO#.</p><p style="color: #000;"> Para resgatar por prêmios, logue agora na sua conta:</p> <a href="http://#DOMINIO#/" style="color: white;font-size: 16px;background-color: green;padding: 10px 24px 10px 24px;box-sizing: border-box;text-decoration: none;display: inline-block;border-radius: 46px;box-shadow: 0px 6px 10px 3px #d4d4d4;">Clique aqui para acessar sua conta</a><p style="color: #000;">Agradecemos pela sua indicação!</p>';
		$vocab[15] = '<p style="color: #000;">Olá, #NOME-INDICADO#</p><p style="color:#000;">Você sabia que pode ganhar bônus, e resgatar os melhores prêmios, indicando pessoas a realizar serviço conosco? Para se tornar um indicador e começar a ganhar, basta se registrar em nosso Clube de Vantagens!</p><a href="http://#DOMINIO#/" style="color: white;font-size: 16px;background-color: green;padding: 10px 24px 10px 24px;box-sizing: border-box;text-decoration: none;display: inline-block;border-radius: 46px;box-shadow: 0px 6px 10px 3px #d4d4d4;">Clique aqui para se registrar</a><br><p style="color:#000;">Ao se registrar, você terá acesso a um sistema, no qual você poderá acompanhar de perto a quantidade de bônus conquistados por você, além de poder conferir o estado da negociação com as pessoas que você também indicar.</p><p style="color:#000;">Caso tenha alguma dúvida, basta ligar para #TELEFONE# e teremos prazer em atendê-lo!</p>';
		$vocab[16] = 'Eu Li e concordo com os <a class="blue-text" href="#LINK-TERMOS#" target="_blank">Termos de Uso</a>';
		$vocab[17] = 'Cadastro de Promoção';
		$vocab[18] = 'Promoção #NOME-CLIENTE#';
		$vocab[19] = 'Seja um indicador #NOME-CLIENTE#';
		$vocab[20] = 'Faça sua inscrição - #NOME-CLIENTE#';
		$vocab[21] = 'Seu amigo acabou de te indicar. Aproveite agora esta oportunidade para faturar.';
		$vocab[22] = 'Seu amigo acabou de te indicar. Aproveite agora esta oportunidade.';
		$vocab[23] = 'As inscrições estão temporariamente encerradas. Para mais informações, favor entrar em contato através do telefone #TELEFONE#.';
		$vocab[24] = 'Você foi indicado por #NOME-INDICADOR# para se tornar indicador no nosso sistema.<br><br>';
		$vocab[25] = 'Faça seu cadastro preenchendo os campos abaixo.<br>Logo após enviar seus dados, é necessário ativar sua conta através de um link que será enviado ao seu email.';
		$vocab[26] = '<tr valign="top" style="font-size:16px; color: #000; font-family: Tahoma, sans-serif;"><td style="padding-bottom: 0px; text-align: center;"><p style="color: #000;">Olá, #NOME-INDICADOR# !</p><p style="color: #000;">Informamos que o seu indicado(a), #NOME-INDICADO#, fechou negócio conosco. Por esse motivo, você acaba de ganhar um bônus de #BONUS-GANHO#.</p></td></tr>#DADOS-PRODUTOS#<tr valign="top" style="font-size:16px; color: #000; font-family: Tahoma, sans-serif;"><td style="padding-bottom:20px; text-align: center;"><p style="color: #000;"><a style="color: white;font-size: 16px;background-color: green;padding: 10px 24px 10px 24px;box-sizing: border-box;text-decoration: none;display: inline-block;border-radius: 46px;box-shadow: 0px 6px 10px 3px #d4d4d4;" href="http://#DOMINIO#/">Acessar minha conta</a><br><br>Agradecemos pela sua indicação!</p></td></tr>';
		$vocab[27] = '<tr valign="top" style="font-size:16px; color: #000; font-family: Tahoma, sans-serif;"><td style="padding-bottom: 0px; text-align: center;"><p style="color: #000;">Olá, #NOME-INDICADO# !</p><p style="color: #000;">Informamos que você acaba de ganhar #BONUS-GANHO# que você já pode trocar por prêmios!</p></td></tr>#DADOS-PRODUTOS#<tr valign="top" style="font-size:16px; color: #000; font-family: Tahoma, sans-serif;"><td style="padding-bottom:20px; text-align: center;"><p style="color: #000;"><a style="color: white;font-size: 16px;background-color: green;padding: 10px 24px 10px 24px;box-sizing: border-box;text-decoration: none;display: inline-block;border-radius: 46px;box-shadow: 0px 6px 10px 3px #d4d4d4;" href="http://#DOMINIO#/">Clique aqui e escolha seu prêmio agora!</a><br><br>Agradecemos pela sua preferência!</p></td></tr>';
		$vocab[28] = '<tr valign="top" style="font-size:16px; color: #000; font-family: Tahoma, sans-serif;"><td style="padding-bottom: 0px; text-align: center;"><p style="color: #000;">Olá, #NOME-INDICADO# !</p><p style="color: #000;">Informamos que o você acaba de ganhar #BONUS-GANHO# devido a uma indicação que seu amigo fez.</p></td></tr>#DADOS-PRODUTOS#<tr valign="top" style="font-size:16px; color: #000; font-family: Tahoma, sans-serif;"><td style="padding-bottom:20px; text-align: center;"><p style="color: #000;"><a style="color: white;font-size: 16px;background-color: green;padding: 10px 24px 10px 24px;box-sizing: border-box;text-decoration: none;display: inline-block;border-radius: 46px;box-shadow: 0px 6px 10px 3px #d4d4d4;" href="http://#DOMINIO#/">Acessar minha conta</a><br><br>Agradecemos pela sua indicação!</p></td></tr>';
		$vocab[29] = 'Saldo de cadastro disponível';
		$vocab[30] = 'Link para novo indicador';
	}

	$comissoes = $sistema->bd->executar("SELECT * FROM TBL_INDICACOES_COMISSOES WHERE ID_CLIENTE_FK = :id AND NU_DELETADO = 0", array(':id' => $_POST['id']), Banco_Dados::FETCH_ALL);
} catch (Exception $e) {
	echo "-2Houve um erro com o servidor";
	exit;
}
?>
<form action="" method="POST" id="formSistema">
	<div class="modal-header">
		<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
			<span aria-hidden="true">&times;</span></button>
		<h4 class="modal-title"><b>Sistema de Indicações:</b> <?php echo $nome; ?></h4>
	</div>
	<div class="modal-body">
		<div class="nav-tabs-custom">
			<ul class="nav nav-tabs">
				<li class="active"><a href="#tab_1" data-toggle="tab">Opções Básicas</a></li>
				<li><a href="#tab_2" data-toggle="tab">Opções Avançadas</a></li>
				<li><a href="#tab_3" data-toggle="tab">Comissionamento</a></li>
				<li><a href="#tab_4" data-toggle="tab">Textos</a></li>
				<li><a href="#tab_5" data-toggle="tab">Textos de E-mail</a></li>
				<li><a href="#tab_6" data-toggle="tab">Menu do Cliente</a></li>
			</ul>
			<div class="tab-content">
				<div class="tab-pane active" id="tab_1">
					<div class="row">
						<div class="col-xs-12">
							<div class="form-group">
								<div class="checkbox">
									<label>
										<input type="checkbox" name="ativado" id="ativado" value="Sim" <?php echo $ativado; ?>>
										Ativar o sistema&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="administrador" id="administrador" value="Sim" <?php echo $administrador; ?>>
										Super Administrador&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="ativar-inscricoes" id="ativar-inscricoes" value="Sim" <?php echo $ativar_inscricoes; ?>>
										Permitir Novas Inscrições&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-xs-12 col-sm-6 col-md-3">
							<div class="form-group">
								<label>Dominio:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-bookmark"></i></div>
									<input type="text" class="form-control pull-right" id="dominio" name="dominio" alt="Domínio" value="<?php echo $dominio; ?>" required />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-3">
							<div class="form-group">
								<label>Sessão:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-lock"></i></div>
									<input type="text" class="form-control pull-right" id="sessao" name="sessao" alt="Sessão" value="<?php echo $sessao; ?>" required />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-3">
							<div class="form-group">
								<label>Nome de Exibição:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-user"></i></div>
									<input type="text" class="form-control pull-right" id="nome" name="nome" alt="Nome" value="<?php echo $nome; ?>" required />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-3">
							<div class="form-group">
								<label>Telefone:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-phone"></i></div>
									<input type="text" class="form-control pull-right" id="telefone" name="telefone" alt="Telefone" value="<?php echo $telefone; ?>" required />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-3">
							<div class="form-group">
								<label>Cor 1 (Botões, etc):</label>
								<div class="input-group">
									<div class="input-group-addon cor1dado caixacor"></div>
									<input type="text" class="form-control pull-right mudarcor" id="cor1" name="cor1" alt="Cor 1" value="<?php echo $cor1; ?>" required />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-3">
							<div class="form-group">
								<label>Cor 2 (Cabeçalho):</label>
								<div class="input-group">
									<div class="input-group-addon cor2dado caixacor"></div>
									<input type="text" class="form-control pull-right mudarcor" id="cor2" name="cor2" alt="Cor 2" value="<?php echo $cor2; ?>" required />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-3">
							<div class="form-group">
								<label>Cor 3 (Rodapé):</label>
								<div class="input-group">
									<div class="input-group-addon cor3dado caixacor"></div>
									<input type="text" class="form-control pull-right mudarcor" id="cor3" name="cor3" alt="Cor 3" value="<?php echo $cor3; ?>" required />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-3">
							<div class="form-group">
								<label>Cor 4 (Texto Cab.):</label>
								<div class="input-group">
									<div class="input-group-addon cor4dado caixacor"></div>
									<input type="text" class="form-control pull-right mudarcor" id="cor4" name="cor4" alt="Cor 4" value="<?php echo $cor4; ?>" required />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-3">
							<div class="form-group">
								<label>Cor 5 (Texto Rod.):</label>
								<div class="input-group">
									<div class="input-group-addon cor5dado caixacor"></div>
									<input type="text" class="form-control pull-right mudarcor" id="cor5" name="cor5" alt="Cor 5" value="<?php echo $cor5; ?>" required />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-5">
							<div class="form-group">
								<label>Email de avisos:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-envelope"></i></div>
									<input type="text" class="form-control pull-right" id="email" name="email" alt="Email" value="<?php echo $email; ?>" required />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Favicon (PNG 32x32):</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-star"></i></div>
									<input type="text" class="form-control pull-right" id="favicon" name="favicon" alt="Favicon" value="<?php echo $favicon; ?>" required />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Logo (210x84):</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-trademark"></i></div>
									<input type="text" class="form-control pull-right" id="logo" name="logo" alt="Logo" value="<?php echo $logo; ?>" required />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Imagem Social (200x200):</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-facebook"></i></div>
									<input type="text" class="form-control pull-right" id="imagem-social" name="imagem-social" alt="Imagem Social" value="<?php echo $img_social; ?>" required />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Outro Contato:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-user"></i></div>
									<input type="text" class="form-control pull-right" id="contato" name="contato" alt="Contato" value="<?php echo $contato; ?>" />
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="tab-pane" id="tab_2">
					<div class="row">
						<div class="col-xs-12">
							<div class="form-group">
								<div class="checkbox">
									<label>
										<input type="checkbox" name="downlines" id="downlines" value="Sim" <?php echo $downlines; ?>>
										Mostrar "Downlines"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="upline" id="upline" value="Sim" <?php echo $upline; ?>>
										Mostrar "Upline"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="adicionar-contato" id="adicionar-contato" value="Sim" <?php echo $adicionar_contato; ?>>
										Adicionar Indicados nos Contatos&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="ativar-termos" id="ativar-termos" value="Sim" <?php echo $ativar_termos; ?>>
										Ativar Termos de Uso&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="permitir-cnpj1" id="permitir-cnpj1" value="Sim" <?php echo $permitir_cnpj1; ?>>
										Permitir CNPJ para indicados&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="permitir-cnpj2" id="permitir-cnpj2" value="Sim" <?php echo $permitir_cnpj2; ?>>
										Permitir CNPJ para indicadores&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="permitir-transferencia" id="permitir-transferencia" value="Sim" <?php echo $permitir_transferencia; ?>>
										Permitir Transferências&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="proibir-cpf" id="proibir-cpf" value="Sim" <?php echo $proibir_cpf; ?>>
										Proibir CPFs duplicados nos contatos&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="distribuir-comissao" id="distribuir-comissao" value="Sim" <?php echo $distribuir_comissao; ?>>
										Distribuir comissões não recebidas para a Win7&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="cadastro-indicado" id="cadastro-indicado" value="Sim" <?php echo $cadastro_indicado; ?>>
										Desabilitar cadastro de indicado&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Tipo do Sistema:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-smile-o"></i></div>
									<select name="tiposistema" id="tiposistema" class="form-control pull-right">
										<?php $sistema->layout->select_sistema($tipo_sistema); ?>
									</select>
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-6">
							<div class="form-group">
								<label>Termos de Uso:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-file-text"></i></div>
									<input type="text" class="form-control pull-right" id="termos-uso" name="termos-uso" alt="Termos de Uso" value="<?php echo $link_termos; ?>" />
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="tab-pane" id="tab_3">
					<div class="row">
						<div class="col-xs-12">
							<div class="form-group">
								<div class="checkbox">
									<label>
										<input type="checkbox" name="comissaomultipla" id="comissaomultipla" value="Sim" <?php echo $comissao_multipla; ?>>
										Ativar Múltiplas Comissões&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="comissaofixa" id="comissaofixa" value="Sim" <?php echo $comissao_fixa; ?>>
										Fixar comissão dos indicadores&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="flag-pontos" id="flag-pontos" value="Sim" <?php echo $flag_pontos; ?>>
										Trocar Dinheiro por Pontos&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
									<label>
										<input type="checkbox" name="ativarrecorrencia" id="ativarrecorrencia" value="Sim" <?php echo $ativar_recorrencia; ?>>
										Ativar Recorrência&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
									</label>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-xs-12 col-sm-6 col-md-3">
							<div class="form-group">
								<label>Bônus de Cadastro:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-dollar"></i></div>
									<input type="text" class="form-control pull-right" id="comissao-cadastro" name="comissao-cadastro" alt="Bônus por Cadastro" value="<?php echo $comissao_cadastro; ?>" required />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-3 bonus-unico" <?php if ($possui_comissao_multipla == true) { ?> style="display: none;" <?php } ?>>
							<div class="form-group">
								<label>Bônus (Ex: 0.10, 0.05):</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-dollar"></i></div>
									<input type="text" class="form-control pull-right" id="bonus" name="bonus" alt="Bônus" value="<?php echo $bonus; ?>" required />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-3 bonus-unico" <?php if ($possui_comissao_multipla == true) { ?> style="display: none;" <?php } ?>>
							<div class="form-group">
								<label>Comissão da Win7 (Ex: 0.10):</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-dollar"></i></div>
									<input type="text" class="form-control pull-right" id="comissao-agencia" name="comissao-agencia" alt="Comissão da Agência" value="<?php echo $comissao_agencia; ?>" required />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-3 bonus-unico" <?php if ($possui_comissao_multipla == true) { ?> style="display: none;" <?php } ?>>
							<div class="form-group">
								<label>Comissão de Fidelidade:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-dollar"></i></div>
									<input type="text" class="form-control pull-right" id="comissao-fidelidade" name="comissao-fidelidade" alt="Comissão de Fidelidade" value="<?php echo $comissao_fidelidade; ?>" required />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-3">
							<div class="form-group">
								<label>Coeficiente (Ex: 0.10):</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-dollar"></i></div>
									<input type="text" class="form-control pull-right" id="coeficiente-ajuste" name="coeficiente-ajuste" alt="Coeficiente de Ajuste" value="<?php echo $coeficiente_ajuste; ?>" required />
								</div>
							</div>
						</div>
					</div>
					<div class="bonus-multiplo" <?php if ($possui_comissao_multipla == false) { ?> style="display: none;" <?php } ?>>
						<div class="row">
							<div class="col-xs-12">
								<div class="form-group">
									<input id="qtdComissoes" name="qtdComissoes" type="hidden" value="<?php echo count($comissoes); ?>">
									<a href="javascript:void(0);" onClick='adicionarComissao()' class="btn btn-primary">Adicionar Comissão</a>
								</div>
							</div>
						</div>
					</div>
					<div class="bonus-multiplo" id="bonus-multiplo" <?php if ($possui_comissao_multipla == false) { ?> style="display: none;" <?php } ?>>
						<?php
						$counter = 1;
						foreach ($comissoes as $comissao_atual) {
							$id_comissao = $comissao_atual['NU_ID'];
							$comissao_fixa_atual = $comissao_atual['NU_COMISSAO_FIXA'] == "1" ? "checked='checked'" : "";
							$bonus_atual = $comissao_atual['TXT_BONUS'];
							$comissao_agencia_atual = $comissao_atual['NU_COMISSAO_AGENCIA'];
							$coeficiente_ajuste_atual = $comissao_atual['TXT_AJUSTE'];
							$nome_atual = $comissao_atual['TXT_NOME'];
							$comissao_fidelidade_atual = $comissao_atual['NU_COMISSAO_FIDELIDADE'];
							$comissao_cadastro_atual = $comissao_atual['NU_COMISSAO_CADASTRO'];
						?>
							<input id="idComissao<?php echo $counter; ?>" name="idComissao<?php echo $counter; ?>" type="hidden" value="<?php echo $id_comissao; ?>">
							<div class="panel panel-default">
								<div class="panel-heading">Comissão <?php echo $counter; ?> <a href="javascript:void(0);" onClick="recriarComissoes(<?php echo $counter; ?>)" title="Clique para deletar" class="pull-right"><i class="fa fa-trash-o text-red"></i></a></div>
								<div class="panel-body">
									<div class="row">
										<div class="col-xs-12">
											<div class="form-group">
												<div class="checkbox">
													<label>
														<input type="checkbox" name="comissaofixa<?php echo $counter; ?>" id="comissaofixa<?php echo $counter; ?>" value="Sim" <?php echo $comissao_fixa_atual; ?>>
														Fixar comissão dos indicadores&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
													</label>
												</div>
											</div>
										</div>
										<div class="col-xs-12 col-sm-6 col-md-4">
											<div class="form-group">
												<label>Nome do Produto:</label>
												<div class="input-group">
													<div class="input-group-addon"><i class="fa fa-user"></i></div>
													<input type="text" class="form-control pull-right" id="nomeComissao<?php echo $counter; ?>" name="nomeComissao<?php echo $counter; ?>" alt="Nome" value="<?php echo $nome_atual; ?>" maxlength="30" required />
												</div>
											</div>
										</div>
										<div class="col-xs-12 col-sm-6 col-md-4">
											<div class="form-group">
												<label>Bônus (Ex: 0.10, 0.05):</label>
												<div class="input-group">
													<div class="input-group-addon"><i class="fa fa-dollar"></i></div>
													<input type="text" class="form-control pull-right" id="bonus<?php echo $counter; ?>" name="bonus<?php echo $counter; ?>" alt="Bônus" value="<?php echo $bonus_atual; ?>" required />
												</div>
											</div>
										</div>
										<div class="col-xs-12 col-sm-6 col-md-4">
											<div class="form-group">
												<label>Comissão da Win7 (Ex: 0.10):</label>
												<div class="input-group">
													<div class="input-group-addon"><i class="fa fa-dollar"></i></div>
													<input type="text" class="form-control pull-right" id="comissao-agencia<?php echo $counter; ?>" name="comissao-agencia<?php echo $counter; ?>" alt="Comissão da Agência" value="<?php echo $comissao_agencia_atual; ?>" required />
												</div>
											</div>
										</div>
										<div class="col-xs-12 col-sm-6 col-md-4">
											<div class="form-group">
												<label>Fidelidade:</label>
												<div class="input-group">
													<div class="input-group-addon"><i class="fa fa-dollar"></i></div>
													<input type="text" class="form-control pull-right" id="comissao-fidelidade<?php echo $counter; ?>" name="comissao-fidelidade<?php echo $counter; ?>" alt="Comissão de Fidelidade" value="<?php echo $comissao_fidelidade_atual; ?>" required />
												</div>
											</div>
										</div>
										<div class="col-xs-12 col-sm-6 col-md-4">
											<div class="form-group">
												<label>Coeficiente (Ex: 0.10):</label>
												<div class="input-group">
													<div class="input-group-addon"><i class="fa fa-dollar"></i></div>
													<input type="text" class="form-control pull-right" id="coeficiente-ajuste<?php echo $counter; ?>" name="coeficiente-ajuste<?php echo $counter; ?>" alt="Coeficiente de Ajuste" value="<?php echo $coeficiente_ajuste_atual; ?>" required />
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						<?php
							$counter++;
						} ?>
					</div>
				</div>
				<div class="tab-pane" id="tab_4">
					<div class="row">
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Título da Área de Copiar Links:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-file-text"></i></div>
									<input type="text" class="form-control pull-right" id="texto1" name="texto1" value="<?php echo $vocab[0]; ?>" />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Título da Área de Adicionar Indicado:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-file-text"></i></div>
									<input type="text" class="form-control pull-right" id="texto2" name="texto2" value="<?php echo $vocab[1]; ?>" />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Título da Área de Adicionar Indicador:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-file-text"></i></div>
									<input type="text" class="form-control pull-right" id="texto2" name="texto31" value="<?php echo $vocab[30]; ?>" />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Título da Área de Indicados Fechados:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-file-text"></i></div>
									<input type="text" class="form-control pull-right" id="texto5" name="texto5" value="<?php echo $vocab[4]; ?>" />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Título da Área de Saldo Disponível:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-file-text"></i></div>
									<input type="text" class="form-control pull-right" id="texto6" name="texto6" value="<?php echo $vocab[5]; ?>" />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Título de Saldo de Cadastro Disponível:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-file-text"></i></div>
									<input type="text" class="form-control pull-right" id="texto30" name="texto30" value="<?php echo $vocab[29]; ?>" />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Título da Tela de Cadastro 1:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-file-text"></i></div>
									<input type="text" class="form-control pull-right" id="texto18" name="texto18" value="<?php echo $vocab[17]; ?>" />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Título da Tela de Cadastro 2:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-file-text"></i></div>
									<input type="text" class="form-control pull-right" id="texto19" name="texto19" value="<?php echo $vocab[18]; ?>" />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Título da Tela de Cadastro 3:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-file-text"></i></div>
									<input type="text" class="form-control pull-right" id="texto20" name="texto20" value="<?php echo $vocab[19]; ?>" />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Título da Tela de Cadastro 4:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-file-text"></i></div>
									<input type="text" class="form-control pull-right" id="texto21" name="texto21" value="<?php echo $vocab[20]; ?>" />
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Texto do Rodapé:</label>
								<textarea name="texto3" id="texto3" class="form-control" rows="3"><?php echo $vocab[2]; ?></textarea>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Texto do Rodapé 2:</label>
								<textarea name="texto4" id="texto4" class="form-control" rows="3"><?php echo $vocab[3]; ?></textarea>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Descrição da Área de Copiar Links:</label>
								<textarea name="texto7" id="texto7" class="form-control" rows="3"><?php echo $vocab[6]; ?></textarea>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Descrição da Área de Copiar Links 2:</label>
								<textarea name="texto8" id="texto8" class="form-control" rows="3"><?php echo $vocab[7]; ?></textarea>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Descrição da Área de Adicionar Indicado:</label>
								<textarea name="texto9" id="texto9" class="form-control" rows="3"><?php echo $vocab[8]; ?></textarea>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Concordar com Termos de Uso:</label>
								<textarea name="texto17" id="texto17" class="form-control" rows="3"><?php echo $vocab[16]; ?></textarea>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Descrição - Redes Sociais:</label>
								<textarea name="texto22" id="texto22" class="form-control" rows="3"><?php echo $vocab[21]; ?></textarea>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Descrição - Redes Sociais 2:</label>
								<textarea name="texto23" id="texto23" class="form-control" rows="3"><?php echo $vocab[22]; ?></textarea>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Descrição - Inscrições Encerradas:</label>
								<textarea name="texto24" id="texto24" class="form-control" rows="3"><?php echo $vocab[23]; ?></textarea>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Descrição da Tela de Cadastro:</label>
								<textarea name="texto25" id="texto25" class="form-control" rows="3"><?php echo $vocab[24]; ?></textarea>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Descrição da Tela de Cadastro 2:</label>
								<textarea name="texto26" id="texto26" class="form-control" rows="3"><?php echo $vocab[25]; ?></textarea>
							</div>
						</div>
					</div>
				</div>
				<div class="tab-pane" id="tab_5">
					<div class="row">
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Email - Negócio Fechado (Pontos):</label>
								<textarea name="texto27" id="texto27" class="form-control" rows="3"><?php echo $vocab[26]; ?></textarea>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Email - Fidelidade (Pontos):</label>
								<textarea name="texto28" id="texto28" class="form-control" rows="3"><?php echo $vocab[27]; ?></textarea>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Email - Níveis (Pontos):</label>
								<textarea name="texto29" id="texto29" class="form-control" rows="3"><?php echo $vocab[28]; ?></textarea>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Email de Ativação da Conta:</label>
								<textarea name="texto10" id="texto10" class="form-control" rows="3"><?php echo $vocab[9]; ?></textarea>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Email de Novo Indicado:</label>
								<textarea name="texto11" id="texto11" class="form-control" rows="3"><?php echo $vocab[10]; ?></textarea>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Email Recebido pelo Indicado:</label>
								<textarea name="texto12" id="texto12" class="form-control" rows="3"><?php echo $vocab[11]; ?></textarea>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Email - Valor Fechado Mudou:</label>
								<textarea name="texto13" id="texto13" class="form-control" rows="3"><?php echo $vocab[12]; ?></textarea>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Email - Negócio Foi Cancelado:</label>
								<textarea name="texto14" id="texto14" class="form-control" rows="3"><?php echo $vocab[13]; ?></textarea>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Email - Negócio Fechado:</label>
								<textarea name="texto15" id="texto15" class="form-control" rows="3"><?php echo $vocab[14]; ?></textarea>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="form-group">
								<label>Email - Convertendo Indicado:</label>
								<textarea name="texto16" id="texto16" class="form-control" rows="3"><?php echo $vocab[15]; ?></textarea>
							</div>
						</div>
					</div>
				</div>
				<div class="tab-pane" id="tab_6">
					<div class="row">
						<div class="col-xs-12 col-sm-6 col-md-6">
							<div class="form-group">
								<label>Texto do botão no menu:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-font"></i></div>
									<input type="text" class="form-control pull-right" id="txtSiteMenuLabel" name="txtSiteMenuLabel" alt="Link do site no menu" maxlength="50" placeholder="Digite o texto: Max 50 letras" value="<?php echo $link_site_menu_label; ?>" />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-6">
							<div class="form-group">
								<label>Link do site no menu:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-external-link-square"></i></div>
									<input type="text" class="form-control pull-right" id="txtSiteMenu" name="txtSiteMenu" alt="Link do site no menu" placeholder="Cole o link com o https://" value="<?php echo $link_site_menu; ?>" />
								</div>
							</div>
						</div>

						<?php

							switch ($simbolo_dinheiro) {
								case 'R$':
									$selected_rs = 'selected';
									break;
								
								case 'US$':
									$selected_usr = 'selected';
									break;
								
								case '$':
									$selected_s = 'selected';
									break;
								
								default:
									$selected_simbolo_default = 'selected';
									break;
							}

							switch ($mascara_dinheiro) {
								case 'brasil':
									$selected_brasil = 'selected';
									break;
								
								case 'eua':
									$selected_eua = 'selected';
									break;
								
								default:
									$selected_mask_default = 'selected';
									break;
							}

						?>

						<div class="col-xs-12 col-sm-6 col-md-6">
							<div class="form-group">
								<label>Símbolo monetário:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-money"></i></div>
									<select class="form-control pull-right" id="slqDinheiroSimbolo" name="slqDinheiroSimbolo">
										<option value="R$" <?php echo $selected_simbolo_default; ?> disabled>Selecione:</option>
										<option value="R$" <?php echo $selected_rs; ?> >R$</option>
										<option value="US$" <?php echo $selected_usr; ?> >US$</option>
										<option value="$" <?php echo $selected_s; ?> >$</option>
									</select>
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-6">
							<div class="form-group">
								<label>Máscara do Telefone:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-phone"></i></div>
									<select class="form-control pull-right" id="slqDinheiroMascara" name="slqDinheiroMascara">
										<option value="brasil" <?php echo $selected_mask_default; ?> disabled>Selecione:</option>
										<option value="brasil" <?php echo $selected_brasil; ?> >Brasil • (00) ?0000-0000</option>
										<option value="eua" <?php echo $selected_eua; ?> >EUA • (000) 000-0000</option>
									</select>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-xs-12 col-sm-6 col-md-6">
							<div class="form-group">
								<label>Texto alternativo ao CPF/CNPJ:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-font"></i></div>
									<input type="text" class="form-control pull-right" id="txtCpfCnpjAlternativo" name="txtCpfCnpjAlternativo" alt="Texto do CPF/CNPJ" placeholder="Digite o texto alternativo:" value="<?php echo $text_cpfcnpj_alternativo; ?>" />
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6 col-md-6">
							<div class="form-group">
								<label>WhatsApp p/ link rodapé:</label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-whatsapp"></i></div>
									<input type="text" class="form-control pull-right numeroWhatsApp" id="txtNumeroWhatsAppLinkRodape" name="txtNumeroWhatsAppLinkRodape" alt="Número do WhatsApp para o contato do rodapé" placeholder="Digite o número:" value="<?php echo $numero_whatsapp_contato_rodape; ?>" />
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Fechar</button>
				<button type="submit" name="action" class="btn btn-primary">Salvar Sistema</button>
			</div>
			<div class="overlay preloader">
				<i class="fa fa-refresh fa-spin"></i>
			</div>
</form>

<script>
	function atualizar_cor(elem) {
		var value = elem.val();
		var id = elem.attr('id');
		var isOk = /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(value);
		if (isOk) {
			$("." + id + "dado").css("background-color", value);
			elem.addClass("valid");
			elem.removeClass("invalid");
		} else {
			$("." + id + "dado").css("background-color", "white");
			elem.addClass("invalid");
			elem.removeClass("valid");
		}
	}
	$(".mudarcor").on('input', function() {
		atualizar_cor($(this));
	});
	$(document).ready(function() {
		atualizar_cor($('#cor1'));
		atualizar_cor($('#cor2'));
		atualizar_cor($('#cor3'));
		atualizar_cor($('#cor4'));
		atualizar_cor($('#cor5'));
	});

	$("#comissaomultipla").change(function() {
		if (this.checked) {
			$(".bonus-unico").hide();
			$(".bonus-multiplo").show();
		} else {
			$(".bonus-unico").show();
			$(".bonus-multiplo").hide();
		}
	});

	var contadorComissoes = document.getElementById('qtdComissoes').value;

	function adicionarComissao() {
		contadorComissoes++;
		document.getElementById('qtdComissoes').value = contadorComissoes;
		$("#bonus-multiplo").append(stringComissoes(contadorComissoes, "-1"));
	}

	function recriarComissoes(index) {
		var strHTML = "";
		var counter = 0;
		for (var i = 1; i <= contadorComissoes; i++) {
			if (i == index) {
				continue;
			}
			counter++;
			var id = document.getElementById('idComissao' + i).value;
			var comissaoFixa = document.getElementById('comissaofixa' + i).checked == true ? "checked='checked'" : "";
			var nome = document.getElementById('nomeComissao' + i).value;
			var bonus = document.getElementById('bonus' + i).value;
			var comissaoAgencia = document.getElementById('comissao-agencia' + i).value;
			var coeficiente = document.getElementById('coeficiente-ajuste' + i).value;
			var fidelidade = document.getElementById('comissao-fidelidade' + i).value;

			strHTML += stringComissoes(counter, id, nome, bonus, comissaoAgencia, coeficiente, comissaoFixa, fidelidade);
		}
		contadorComissoes--;
		document.getElementById('qtdComissoes').value = contadorComissoes;
		document.getElementById('bonus-multiplo').innerHTML = strHTML;
	}

	function stringComissoes(numero, id, nome = "Exemplo", bonus = "0.10", comissaoAgencia = "0.10", coeficiente = "0.1", comissaoFixa = "", fidelidade = "0.00") {
		return '\
	<input id="idComissao' + numero + '" name="idComissao' + numero + '" type="hidden" value="' + id + '"> \
	<div class="panel panel-default"><div class="panel-heading">Comissão ' + numero + '<a href="javascript:void(0);" onClick="recriarComissoes(' + numero + ')" title="Clique para deletar" class="pull-right"><i class="fa fa-trash-o text-red"></i></a></div><div class="panel-body"><div class="row"> \
		<div class="col-xs-12"><div class="form-group">\
			<div class="checkbox">\
				<label>\
					<input type="checkbox" name="comissaofixa' + numero + '" id="comissaofixa' + numero + '" value="Sim" ' + comissaoFixa + '>\
					Fixar comissão dos indicadores&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\
				</label>\
			</div>\
		</div></div>\
		<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">\
			<label>Nome do Produto:</label>\
			<div class="input-group">\
				<div class="input-group-addon"><i class="fa fa-user"></i></div>\
				<input type="text" class="form-control pull-right"  id="nomeComissao' + numero + '" name="nomeComissao' + numero + '" alt="Nome" value="' + nome + '" maxlength="30" required />\
			</div>\
		</div></div>\
		<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">\
			<label>Bônus (Ex: 0.10, 0.05):</label>\
			<div class="input-group">\
				<div class="input-group-addon"><i class="fa fa-dollar"></i></div>\
				<input type="text" class="form-control pull-right"  id="bonus' + numero + '" name="bonus' + numero + '" alt="Bônus" value="' + bonus + '" required />\
			</div>\
		</div></div>\
		<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">\
			<label>Comissão da Win7 (Ex: 0.10):</label>\
			<div class="input-group">\
				<div class="input-group-addon"><i class="fa fa-dollar"></i></div>\
				<input type="text" class="form-control pull-right"  id="comissao-agencia' + numero + '" name="comissao-agencia' + numero + '" alt="Comissão da Agência" value="' + comissaoAgencia + '" required />\
			</div>\
		</div></div>\
		<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">\
			<label>Fidelidade:</label>\
			<div class="input-group">\
				<div class="input-group-addon"><i class="fa fa-dollar"></i></div>\
				<input type="text" class="form-control pull-right"  id="comissao-fidelidade' + numero + '" name="comissao-fidelidade' + numero + '" alt="Comissão de Fidelidade" value="' + fidelidade + '" required />\
			</div>\
		</div></div>\
		<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">\
			<label>Coeficiente (Ex: 0.10):</label>\
			<div class="input-group">\
				<div class="input-group-addon"><i class="fa fa-dollar"></i></div>\
				<input type="text" class="form-control pull-right"  id="coeficiente-ajuste' + numero + '" name="coeficiente-ajuste' + numero + '" alt="Coeficiente de Ajuste" value="' + coeficiente + '" required />\
			</div>\
		</div></div>\
	</div></div></div>';
	}

	function salvarSistema() {
		var dados = jQuery('#formSistema').serialize() + "&id=<?php echo $_POST['id']; ?>";
		$(document).ready(function() {
			jQuery.ajax({
				type: "POST",
				url: "action/salvar_modal_cliente_indicacoes",
				data: dados,
				success: function(data) {
					console.log(data);
					$('.preloader').css({
						display: "none"
					});
					if (data == '-1') {
						window.location.href = "./";
						return;
					}
					if (data.substring(0, 2) == "-2") {
						toastr.clear();
						toastr.error(data.substring(2));
						return;
					}
					fechar_modal();
					atualizar_indicacoes(JSON.parse(data));
					toastr.clear();
					toastr.success("Dados salvos com sucesso.");
					return;
				},
				beforeSend: function() {
					$('.preloader').css({
						display: "block"
					});
				},
				complete: function() {
					$('.preloader').css({
						display: "none"
					});
				},
				error: function() {
					$('.preloader').css({
						display: "none"
					});
					toastr.clear();
					toastr.error("Houve um erro ao salvar.");
					return;
				}
			});
		});
	}

	$(document).ready(function() {
		$('#formSistema').submit(function() {
			if (document.getElementById('comissaomultipla').checked && contadorComissoes <= 0) {
				toastr.clear();
				toastr.error("Não há comissões adicionadas!");
				return false;
			}
			salvarSistema();
			return false;
		})
	});
</script>

<script>
	var maskList = $.masksSort($.masksLoad("../js/country-masks/data/phone-codes.json"), ['#'], /[0-9]|#/, "mask");
	var maskOpts = {
		inputmask: {
			definitions: {
				'#': {
					validator: "[0-9]",
					cardinality: 1
				}
			},
			//clearIncomplete: true,
			showMaskOnHover: false,
			autoUnmask: true
		},
		match: /[0-9]/,
		replace: '#',
		list: maskList,
		listKey: "mask"
	};

	$('.numeroWhatsApp').inputmasks(maskOpts);
</script>