<?php
/*
 * Este arquivo é responsável por montar a modal que serve para confirmar o envio de um contato para a lixeira.
 */
 
require_once(__DIR__ . "/../../classes/Sistema.php"); 
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso
if($sistema->usuario->permissao_envio_email == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

try{
	$email = $sistema->obter_email($_POST['id']);

	if($sistema->bd->quantidade() == 0){ // Nenhum dado foi encontrado no banco, então a ID é inválida
		echo "-2ID inválida!";
		exit;
	}

	$status = $email['NU_STATUS'];
	$erro = $email['TXT_ERRO'];
	$arquivo = $email['TXT_ARQUIVO'];

	if(($status != 2 && $status != 3) || empty($erro)){
		echo "-2Não há nenhum erro para visualizar!";
		exit;
	}
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>
<div class="modal-header">
	<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
	<span aria-hidden="true">&times;</span></button>
	<h4 class="modal-title"><b>Visualizar Erro</b></h4>
</div>

<div class="modal-body">
	<b>O seguinte erro ocorreu ao enviar o e-mail:</b><br><?php echo $erro; ?><br><br><b>Arquivo no qual o email foi gerado:</b><br><?php echo $arquivo; ?>
</div>
<div class="modal-footer">
	<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Fechar</button>
</div>
<div class="overlay preloader">
	<i class="fa fa-refresh fa-spin"></i>
</div>